/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motionseries.model;

import edu.colorado.phet.scalacommon.math.Vector2D;
import scala.Product;
import scala.Product$class;
import scala.Serializable;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RampSegmentState
implements Product,
Serializable {
    private final Vector2D startPoint;
    private final Vector2D endPoint;
    private Vector2D getUnitVector;
    private double angle;
    private double length;
    public volatile int bitmap$0;

    public Vector2D startPoint() {
        return this.startPoint;
    }

    public Vector2D endPoint() {
        return this.endPoint;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector2D getUnitVector() {
        if ((this.bitmap$0 & 1) != 0) return this.getUnitVector;
        RampSegmentState rampSegmentState = this;
        synchronized (rampSegmentState) {
            if ((this.bitmap$0 & 1) == 0) {
                this.getUnitVector = this.endPoint().$minus(this.startPoint()).normalize();
                this.bitmap$0 |= 1;
            }
            return this.getUnitVector;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double angle() {
        if ((this.bitmap$0 & 2) != 0) return this.angle;
        RampSegmentState rampSegmentState = this;
        synchronized (rampSegmentState) {
            if ((this.bitmap$0 & 2) == 0) {
                this.angle = this.endPoint().$minus(this.startPoint()).angle();
                this.bitmap$0 |= 2;
            }
            return this.angle;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double length() {
        if ((this.bitmap$0 & 4) != 0) return this.length;
        RampSegmentState rampSegmentState = this;
        synchronized (rampSegmentState) {
            if ((this.bitmap$0 & 4) == 0) {
                this.length = this.endPoint().$minus(this.startPoint()).magnitude();
                this.bitmap$0 |= 4;
            }
            return this.length;
        }
    }

    public RampSegmentState setStartPoint(Vector2D newStartPoint) {
        return this.copy(newStartPoint, this.copy$default$2());
    }

    public RampSegmentState setEndPoint(Vector2D newEndPoint) {
        Vector2D x$3 = newEndPoint;
        Vector2D x$4 = this.copy$default$1();
        return this.copy(x$4, x$3);
    }

    public RampSegmentState setAngle(double angle) {
        Vector2D x$1 = new Vector2D(angle).$times(this.length());
        Vector2D x$2 = this.copy$default$1();
        return this.copy(x$2, x$1);
    }

    public Vector2D copy$default$2() {
        return this.endPoint();
    }

    public Vector2D copy$default$1() {
        return this.startPoint();
    }

    public RampSegmentState copy(Vector2D startPoint, Vector2D endPoint) {
        return new RampSegmentState(startPoint, endPoint);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        Vector2D vector2D;
        Vector2D endPoint$1;
        if (this == object) return true;
        Object object2 = object;
        if (!(object2 instanceof RampSegmentState)) return false;
        RampSegmentState rampSegmentState = (RampSegmentState)object2;
        Vector2D vector2D2 = rampSegmentState.startPoint();
        Vector2D startPoint$1 = vector2D2;
        if (!this.gd1$1(startPoint$1, endPoint$1 = (vector2D = rampSegmentState.endPoint()))) return false;
        boolean bl = ((RampSegmentState)object).canEqual(this);
        if (!bl) return false;
        return true;
    }

    @Override
    public String productPrefix() {
        return "RampSegmentState";
    }

    @Override
    public int productArity() {
        return 2;
    }

    @Override
    public Object productElement(int n) {
        Vector2D vector2D;
        int n2 = n;
        switch (n2) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(n)).toString());
            }
            case 0: {
                vector2D = this.startPoint();
                break;
            }
            case 1: {
                vector2D = this.endPoint();
            }
        }
        return vector2D;
    }

    @Override
    public boolean canEqual(Object object) {
        return object instanceof RampSegmentState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean gd1$1(Vector2D vector2D, Vector2D vector2D2) {
        Vector2D vector2D3 = vector2D;
        Vector2D vector2D4 = this.startPoint();
        if (vector2D3 == null) {
            if (vector2D4 != null) {
                return false;
            }
        } else if (!((Object)vector2D3).equals(vector2D4)) return false;
        Vector2D vector2D5 = vector2D2;
        Vector2D vector2D6 = this.endPoint();
        if (vector2D5 == null) {
            if (vector2D6 == null) return true;
            return false;
        } else {
            if (!((Object)vector2D5).equals(vector2D6)) return false;
            return true;
        }
    }

    public RampSegmentState(Vector2D startPoint, Vector2D endPoint) {
        this.startPoint = startPoint;
        this.endPoint = endPoint;
        Product$class.$init$(this);
    }
}

