/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motionseries.model;

import edu.colorado.phet.common.motion.charts.ChartCursor;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.motionseries.MotionSeriesDefaults$;
import edu.colorado.phet.motionseries.charts.MutableDouble;
import edu.colorado.phet.motionseries.graphics.ObjectSelectionModel;
import edu.colorado.phet.motionseries.graphics.RampSurfaceModel;
import edu.colorado.phet.motionseries.model.CoordinateFrameModel;
import edu.colorado.phet.motionseries.model.MotionSeriesModel$;
import edu.colorado.phet.motionseries.model.MotionSeriesObject;
import edu.colorado.phet.motionseries.model.MotionSeriesObjectType;
import edu.colorado.phet.motionseries.model.MotionStrategyMemento;
import edu.colorado.phet.motionseries.model.MutableMotionSeriesObjectType;
import edu.colorado.phet.motionseries.model.PositionMapper;
import edu.colorado.phet.motionseries.model.RampSegment;
import edu.colorado.phet.motionseries.model.RampState;
import edu.colorado.phet.motionseries.model.RecordedState;
import edu.colorado.phet.motionseries.model.SurfaceFrictionStrategy;
import edu.colorado.phet.motionseries.sims.rampforcesandmotionbasics.RampForcesAndMotionBasicsSettings$;
import edu.colorado.phet.motionseries.util.MutableRange;
import edu.colorado.phet.motionseries.util.Range;
import edu.colorado.phet.motionseries.util.ScalaMutableBoolean;
import edu.colorado.phet.recordandplayback.model.DataPoint;
import edu.colorado.phet.recordandplayback.model.RecordAndPlaybackModel;
import edu.colorado.phet.scalacommon.math.Vector2D;
import edu.colorado.phet.scalacommon.util.Observable$class;
import java.awt.geom.Point2D;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MotionSeriesModel
extends RecordAndPlaybackModel<RecordedState>
implements ObjectSelectionModel,
RampSurfaceModel {
    private final double defaultPosition;
    private final double initialAngle;
    private final ScalaMutableBoolean _walls;
    private final ScalaMutableBoolean _frictionless;
    private final ScalaMutableBoolean _wallsBounce;
    private MotionSeriesObjectType _objectType;
    private final ArrayBuffer<Function0<BoxedUnit>> resetListeners;
    private final SurfaceFrictionStrategy surfaceFrictionStrategy;
    private final ChartCursor chartCursor;
    private final ArrayBuffer<Function0<BoxedUnit>> stepListeners;
    private final ArrayBuffer<Function0<BoxedUnit>> recordListeners;
    private final RampSegment leftRampSegment;
    private final RampSegment rightRampSegment;
    private final CoordinateFrameModel coordinateFrameModel;
    private final MutableRange wallRange;
    private final Function0<Object> surfaceFriction;
    private final double defaultManPosition;
    private final PositionMapper positionMapper;
    private final MotionSeriesObject leftWall;
    private final MotionSeriesObject rightWall;
    private final MotionSeriesObject leftWallRightEdge;
    private final MotionSeriesObject rightWallLeftEdge;
    private final MotionSeriesObject manMotionSeriesObject;
    private final MotionSeriesObject motionSeriesObject;
    private final ArrayBuffer<Function0<BoxedUnit>> edu$colorado$phet$scalacommon$util$Observable$$listeners;

    private ScalaMutableBoolean _walls() {
        return this._walls;
    }

    private ScalaMutableBoolean _frictionless() {
        return this._frictionless;
    }

    private ScalaMutableBoolean _wallsBounce() {
        return this._wallsBounce;
    }

    private MotionSeriesObjectType _objectType() {
        return this._objectType;
    }

    private void _objectType_$eq(MotionSeriesObjectType motionSeriesObjectType) {
        this._objectType = motionSeriesObjectType;
    }

    private ArrayBuffer<Function0<BoxedUnit>> resetListeners() {
        return this.resetListeners;
    }

    public SurfaceFrictionStrategy surfaceFrictionStrategy() {
        return this.surfaceFrictionStrategy;
    }

    public ChartCursor chartCursor() {
        return this.chartCursor;
    }

    public ArrayBuffer<Function0<BoxedUnit>> stepListeners() {
        return this.stepListeners;
    }

    public ArrayBuffer<Function0<BoxedUnit>> recordListeners() {
        return this.recordListeners;
    }

    public RampSegment leftRampSegment() {
        return this.leftRampSegment;
    }

    public RampSegment rightRampSegment() {
        return this.rightRampSegment;
    }

    public CoordinateFrameModel coordinateFrameModel() {
        return this.coordinateFrameModel;
    }

    public MutableRange wallRange() {
        return this.wallRange;
    }

    public Range _wallRange() {
        return new Range(-this.leftRampSegment().length() + MotionSeriesDefaults$.MODULE$.wall().width() / (double)2, this.rightRampSegment().length() - MotionSeriesDefaults$.MODULE$.wall().width() / (double)2);
    }

    public void updateWallRange() {
        this.wallRange().set(this._wallRange());
    }

    public Function0<Object> surfaceFriction() {
        return this.surfaceFriction;
    }

    public double defaultManPosition() {
        return this.defaultManPosition;
    }

    public PositionMapper positionMapper() {
        return this.positionMapper;
    }

    public MotionSeriesObject leftWall() {
        return this.leftWall;
    }

    public MotionSeriesObject rightWall() {
        return this.rightWall;
    }

    public MotionSeriesObject leftWallRightEdge() {
        return this.leftWallRightEdge;
    }

    public MotionSeriesObject rightWallLeftEdge() {
        return this.rightWallLeftEdge;
    }

    public MotionSeriesObject manMotionSeriesObject() {
        return this.manMotionSeriesObject;
    }

    public double thermalEnergyStrategy(double x) {
        return x;
    }

    public MotionSeriesObject motionSeriesObject() {
        return this.motionSeriesObject;
    }

    public void stepRecord() {
        this.stepRecord(MotionSeriesDefaults$.MODULE$.DT_DEFAULT());
    }

    @Override
    public RecordedState step(double simulationTimeChange) {
        this.stepRecord();
        MotionStrategyMemento mode = this.motionSeriesObject().motionStrategy().getMemento();
        return new RecordedState(new RampState(this.rampAngle()), this.selectedObject().state(), this.motionSeriesObject().state(), this.manMotionSeriesObject().state(), this.motionSeriesObject().parallelAppliedForce(), this.walls().booleanValue(), mode, this.getTime(), this.frictionless(), Predef$.MODULE$.Boolean2boolean(this.wallsBounce().value()));
    }

    public void resume() {
        if (this.isPlayback()) {
            this.clearHistoryRemainder();
            this.setRecord(true);
        }
        this.setPaused(false);
    }

    @Override
    public boolean isRecordingFull() {
        return this.getTime() > MotionSeriesDefaults$.MODULE$.MAX_RECORD_TIME();
    }

    @Override
    public void addRecordedPoint(DataPoint<RecordedState> point) {
        if (point.getTime() <= MotionSeriesDefaults$.MODULE$.MAX_RECORD_TIME()) {
            super.addRecordedPoint(point);
        }
    }

    public boolean motionSeriesObjectInModelViewportRange() {
        return this.motionSeriesObject().position2D().x() < MotionSeriesDefaults$.MODULE$.MIN_X() || this.motionSeriesObject().position2D().x() > MotionSeriesDefaults$.MODULE$.MAX_X();
    }

    public void returnMotionSeriesObject() {
        this.motionSeriesObject().attach();
        this.motionSeriesObject().position_$eq(this.defaultPosition);
        this.motionSeriesObject().parallelAppliedForce_$eq(0.0);
        this.motionSeriesObject().velocity_$eq(0.0);
    }

    public void resetObject() {
        this.returnMotionSeriesObject();
        this.motionSeriesObject().crashEnergy_$eq(0.0);
        this.motionSeriesObject().thermalEnergy_$eq(0.0);
        this.motionSeriesObject().velocity_$eq(0.0);
        this.motionSeriesObject().frictionForce().value_$eq(new Vector2D(0.0, 0.0));
    }

    public ArrayBuffer<Function0<BoxedUnit>> addResetListener(Function0<BoxedUnit> listener) {
        return this.resetListeners().$plus$eq((Object)listener);
    }

    @Override
    public void resetAll() {
        super.resetAll();
        if (this.resetListeners() != null) {
            this.clearHistory();
            this.selectedObject_$eq((MotionSeriesObjectType)MotionSeriesDefaults$.MODULE$.objectTypes().apply(0));
            this._frictionless().reset();
            this.walls().reset();
            this.resetObject();
            this.manMotionSeriesObject().position_$eq(this.defaultManPosition());
            this.rightRampSegment().setAngle(this.initialAngle);
            this.resetListeners().foreach(new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Function0<BoxedUnit> function0) {
                    function0.apply$mcV$sp();
                }
            });
            this.wallsBounce().reset();
            this.updateSegmentLengths();
            this.updateWallRange();
            this.notifyListeners();
        }
    }

    @Override
    public void setPlaybackState(RecordedState state2) {
        this.rampAngle_$eq(state2.rampState().angle());
        this.frictionless_$eq(state2.frictionless());
        this.selectedObject_$eq(state2.selectedObject().toObject());
        this.motionSeriesObject().motionStrategy_$eq(state2.motionStrategyMemento().getMotionStrategy(this.motionSeriesObject()));
        this.motionSeriesObject().state_$eq(state2.motionSeriesObjectState());
        this.motionSeriesObject().parallelAppliedForce_$eq(state2.appliedForce());
        this.manMotionSeriesObject().state_$eq(state2.manState());
        this.walls_$eq(state2.walls());
        this.chartCursor().setTime(state2.time());
        this.stepListeners().foreach(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Function0<BoxedUnit> function0) {
                function0.apply$mcV$sp();
            }
        });
        this.wallsBounce_$eq(state2.wallsBouncy());
    }

    @Override
    public MotionSeriesObjectType selectedObject() {
        return this._objectType();
    }

    @Override
    public void selectedObject_$eq(MotionSeriesObjectType obj) {
        MotionSeriesObjectType motionSeriesObjectType = this._objectType();
        MotionSeriesObjectType motionSeriesObjectType2 = obj;
        if (motionSeriesObjectType == null ? motionSeriesObjectType2 != null : !((Object)motionSeriesObjectType).equals(motionSeriesObjectType2)) {
            this._objectType_$eq(obj);
            this.updateDueToObjectTypeChange();
        }
    }

    private void updateDueToObjectTypeChange() {
        this.motionSeriesObject().mass_$eq(this._objectType().mass());
        this.motionSeriesObject().width_$eq(this._objectType().width());
        this.motionSeriesObject().height_$eq(this._objectType().height());
        this.motionSeriesObject().staticFriction_$eq(this._objectType().staticFriction());
        this.motionSeriesObject().kineticFriction_$eq(this._objectType().kineticFriction());
        MotionSeriesObjectType motionSeriesObjectType = this._objectType();
        if (motionSeriesObjectType instanceof MutableMotionSeriesObjectType) {
            MutableMotionSeriesObjectType mutableMotionSeriesObjectType;
            MutableMotionSeriesObjectType o$1 = mutableMotionSeriesObjectType = (MutableMotionSeriesObjectType)motionSeriesObjectType;
            o$1.addListenerByName((Function0<BoxedUnit>)((Object)new Serializable(this, o$1){
                public static final long serialVersionUID;
                private final MotionSeriesModel $outer;
                private final MutableMotionSeriesObjectType o$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.motionSeriesObject().height_$eq(this.o$1.height());
                    this.$outer.motionSeriesObject().mass_$eq(this.o$1.mass());
                    this.$outer.motionSeriesObject().width_$eq(this.o$1.width());
                    this.$outer.motionSeriesObject().staticFriction_$eq(this.o$1.staticFriction());
                    this.$outer.motionSeriesObject().kineticFriction_$eq(this.o$1.kineticFriction());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.o$1 = mutableMotionSeriesObjectType;
                }
            }));
        }
        this.motionSeriesObject().position_$eq(MathUtil.clamp(MotionSeriesDefaults$.MODULE$.MIN_X() + this.motionSeriesObject().width() / (double)2, this.motionSeriesObject().position(), MotionSeriesDefaults$.MODULE$.MAX_X() - this.motionSeriesObject().width() / (double)2));
        if (this.motionSeriesObject().isCrashed()) {
            this.resetObject();
        }
        this.notifyListeners();
    }

    public ScalaMutableBoolean wallsBounce() {
        return this._wallsBounce();
    }

    public void wallsBounce_$eq(boolean b) {
        this._wallsBounce().set(Predef$.MODULE$.boolean2Boolean(b));
        this.notifyListeners();
    }

    @Override
    public boolean frictionless() {
        return this._frictionless().booleanValue();
    }

    public void frictionless_$eq(boolean b) {
        this._frictionless().set(Predef$.MODULE$.boolean2Boolean(b));
        this.notifyListeners();
    }

    public ScalaMutableBoolean walls() {
        return this._walls();
    }

    public void walls_$eq(boolean b) {
        if (b != this._walls().booleanValue()) {
            this._walls().set(Predef$.MODULE$.boolean2Boolean(b));
            this.updateSegmentLengths();
            this.notifyListeners();
        }
    }

    public void updateSegmentLengths() {
        int seg0Length = this.leftRampSegment().angle() > 0.0 || (Boolean)this._walls().get() != false ? MotionSeriesDefaults$.MODULE$.DEFAULT_RAMP_LENGTH() : MotionSeriesDefaults$.MODULE$.FAR_DISTANCE();
        int seg1Length = this.rightRampSegment().angle() > 0.0 || (Boolean)this._walls().get() != false ? MotionSeriesDefaults$.MODULE$.DEFAULT_RAMP_LENGTH() : MotionSeriesDefaults$.MODULE$.FAR_DISTANCE();
        this.setSegmentLengths(seg0Length, seg1Length);
    }

    public void setSegmentLengths(double seg0Length, double seg1Length) {
        this.leftRampSegment().startPoint_$eq(new Vector2D(this.leftRampSegment().angle()).$times(-seg0Length));
        this.leftRampSegment().endPoint_$eq(new Vector2D(0.0, 0.0));
        this.rightRampSegment().startPoint_$eq(new Vector2D(0.0, 0.0));
        this.rightRampSegment().endPoint_$eq(new Vector2D(this.rightRampSegment().angle()).$times(seg1Length));
    }

    public void rampAngle_$eq(double angle) {
        this.rightRampSegment().setAngle(angle);
    }

    public double rampAngle() {
        return this.rightRampSegment().angle();
    }

    public final Vector2D edu$colorado$phet$motionseries$model$MotionSeriesModel$$toPosition2D(double particleLocation) {
        return particleLocation <= 0.0 ? this.leftRampSegment().unitVector().$times(-1.0).$times(BoxesRunTime.unboxToDouble(Predef$.MODULE$.doubleWrapper(particleLocation).abs())).$plus(this.leftRampSegment().endPoint()) : this.rightRampSegment().unitVector().$times(BoxesRunTime.unboxToDouble(Predef$.MODULE$.doubleWrapper(particleLocation).abs())).$plus(this.rightRampSegment().startPoint());
    }

    public RampSegment rampSegmentAccessor(double particleLocation) {
        return particleLocation <= 0.0 ? this.leftRampSegment() : this.rightRampSegment();
    }

    public void stepRecord(double dt) {
        this.motionSeriesObject().stepInTime(dt);
        this.notifyListeners();
        this.recordListeners().foreach(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Function0<BoxedUnit> function0) {
                function0.apply$mcV$sp();
            }
        });
    }

    @Override
    public void stepMode(double dt) {
        super.stepMode(dt);
        if (!this.isPlayback()) {
            this.stepListeners().foreach(new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Function0<BoxedUnit> function0) {
                    function0.apply$mcV$sp();
                }
            });
        }
    }

    public MotionSeriesModel(double defaultPosition, double initialAngle) {
        this.defaultPosition = defaultPosition;
        this.initialAngle = initialAngle;
        super(1000);
        Observable$class.$init$(this);
        this._walls = new ScalaMutableBoolean(true);
        this._frictionless = new ScalaMutableBoolean(RampForcesAndMotionBasicsSettings$.MODULE$.FRICTIONLESS_DEFAULT());
        this._wallsBounce = new ScalaMutableBoolean(false);
        this._objectType = (MotionSeriesObjectType)MotionSeriesDefaults$.MODULE$.objectTypes().apply(0);
        this.resetListeners = new ArrayBuffer();
        this.surfaceFrictionStrategy = new $anon$2(this);
        this.chartCursor = new ChartCursor();
        this.stepListeners = new ArrayBuffer();
        this.recordListeners = new ArrayBuffer();
        this.leftRampSegment = new RampSegment(new Point2D.Double(-MotionSeriesDefaults$.MODULE$.DEFAULT_RAMP_LENGTH(), 0.0), new Point2D.Double(0.0, 0.0));
        this.rightRampSegment = new RampSegment(new Point2D.Double(0.0, 0.0), new Point2D.Double((double)MotionSeriesDefaults$.MODULE$.DEFAULT_RAMP_LENGTH() * Math.cos(initialAngle), (double)MotionSeriesDefaults$.MODULE$.DEFAULT_RAMP_LENGTH() * Math.sin(initialAngle)));
        this.rightRampSegment().addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final MotionSeriesModel $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.positionMapper().notifyListeners();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.leftRampSegment().addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final MotionSeriesModel $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.positionMapper().notifyListeners();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.rightRampSegment().addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final MotionSeriesModel $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.updateSegmentLengths();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.coordinateFrameModel = new CoordinateFrameModel(this.rightRampSegment());
        this.wallRange = new MutableRange(this._wallRange());
        this.leftRampSegment().addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final MotionSeriesModel $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.updateWallRange();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.rightRampSegment().addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final MotionSeriesModel $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.updateWallRange();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.updateWallRange();
        this.surfaceFriction = new $anonfun$6(this);
        this.defaultManPosition = defaultPosition - 1.0;
        this.positionMapper = new $anon$1(this);
        this.leftWall = new MotionSeriesObject(this, -10.0, MotionSeriesDefaults$.MODULE$.wall().width(), MotionSeriesDefaults$.MODULE$.wall().height());
        this.rightWall = new MotionSeriesObject(this, 10.0, MotionSeriesDefaults$.MODULE$.wall().width(), MotionSeriesDefaults$.MODULE$.wall().height());
        this.leftWallRightEdge = new MotionSeriesObject(this, (double)-10 + MotionSeriesDefaults$.MODULE$.wall().width() / (double)2, MotionSeriesDefaults$.MODULE$.SPRING_WIDTH(), MotionSeriesDefaults$.MODULE$.SPRING_HEIGHT());
        this.rightWallLeftEdge = new MotionSeriesObject(this, (double)10 - MotionSeriesDefaults$.MODULE$.wall().width() / (double)2, MotionSeriesDefaults$.MODULE$.SPRING_WIDTH(), MotionSeriesDefaults$.MODULE$.SPRING_HEIGHT());
        this.manMotionSeriesObject = new MotionSeriesObject(this, this.defaultManPosition(), 1.0, 3.0);
        this.motionSeriesObject = new MotionSeriesObject(new MutableDouble(defaultPosition), new MutableDouble(), new MutableDouble(), new MutableDouble(this._objectType().mass()), new MutableDouble(this._objectType().staticFriction()), new MutableDouble(this._objectType().kineticFriction()), this._objectType().height(), this._objectType().width(), this.positionMapper(), new $anonfun$8(this), this._wallsBounce(), this.walls(), this.wallRange(), new $anonfun$7(this), this.surfaceFriction(), this.surfaceFrictionStrategy(), true);
        this.updateDueToObjectTypeChange();
        this.motionSeriesObject().stepInTime(0.0);
    }
}

