/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motionseries.model;

import edu.colorado.phet.motionseries.model.AirborneMemento;
import edu.colorado.phet.motionseries.model.Crashed;
import edu.colorado.phet.motionseries.model.MotionSeriesObject;
import edu.colorado.phet.motionseries.model.MotionStrategy;
import edu.colorado.phet.scalacommon.math.Vector2D;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public class Airborne
extends MotionStrategy {
    private Vector2D _position2D;
    private Vector2D _velocity2D;
    private final double _angle;
    private final MotionSeriesObject motionSeriesObject;

    private Vector2D _position2D() {
        return this._position2D;
    }

    private void _position2D_$eq(Vector2D vector2D) {
        this._position2D = vector2D;
    }

    private Vector2D _velocity2D() {
        return this._velocity2D;
    }

    private void _velocity2D_$eq(Vector2D vector2D) {
        this._velocity2D = vector2D;
    }

    public boolean isCrashed() {
        return false;
    }

    public double getAngle() {
        return this._angle;
    }

    public Vector2D velocity2D() {
        return this._velocity2D();
    }

    public void stepInTime(double dt) {
        double originalEnergy = this.motionSeriesObject.getTotalEnergy();
        this.updateForces();
        Vector2D accel = this.motionSeriesObject.totalForce().value().$div(this.motionSeriesObject.mass());
        this._velocity2D_$eq(this._velocity2D().$plus(accel.$times(dt)));
        this._position2D_$eq(this._position2D().$plus(this._velocity2D().$times(dt)));
        this.motionSeriesObject.time_$eq(this.motionSeriesObject.time() + dt);
        if (this._position2D().y() <= this.motionSeriesObject.airborneFloor()) {
            this.motionSeriesObject.motionStrategy_$eq(new Crashed(new Vector2D(this._position2D().x(), this.motionSeriesObject.airborneFloor()), this._angle, this.motionSeriesObject));
            this.motionSeriesObject.crashListeners().foreach(new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Function0<BoxedUnit> function0) {
                    function0.apply$mcV$sp();
                }
            });
            double newEnergy = this.motionSeriesObject.getTotalEnergy();
            double energyDifference = this.motionSeriesObject.getTotalEnergy() - originalEnergy;
            if (this.motionSeriesObject.getTotalEnergy() < originalEnergy) {
                this.motionSeriesObject.thermalEnergy_$eq(this.motionSeriesObject.thermalEnergy() + BoxesRunTime.unboxToDouble(Predef$.MODULE$.doubleWrapper(energyDifference).abs()));
            } else if (this.motionSeriesObject.getTotalEnergy() >= originalEnergy) {
                Predef$.MODULE$.println("energy gained on crash");
            }
        } else {
            this.motionSeriesObject.velocity_$eq(this._velocity2D().magnitude());
            double dy = (this.motionSeriesObject.getTotalEnergy() - originalEnergy) / this.motionSeriesObject.mass() / this.motionSeriesObject.gravity();
            this._position2D_$eq(new Vector2D(this._position2D().x(), this._position2D().y() + dy));
        }
        this.motionSeriesObject._position2D().value_$eq(this._position2D());
    }

    public AirborneMemento getMemento() {
        return new AirborneMemento(this._position2D(), this.velocity2D(), this.getAngle());
    }

    public Airborne(Vector2D _position2D, Vector2D _velocity2D, double _angle, MotionSeriesObject motionSeriesObject) {
        this._position2D = _position2D;
        this._velocity2D = _velocity2D;
        this._angle = _angle;
        this.motionSeriesObject = motionSeriesObject;
        super(motionSeriesObject);
    }
}

