/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motionseries.javastage.stage;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.motionseries.javastage.stage.Stage;
import edu.colorado.phet.motionseries.javastage.stage.StageContainer;
import edu.colorado.phet.motionseries.javastage.stage.StageNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class PlayArea
extends PhetPCanvas
implements StageContainer {
    private Stage stage;
    private PText utilityStageNode = new PText("Utility node");
    private PhetPPath stageContainerDebugRegion;
    private PhetPPath stageBoundsDebugRegion;
    private ModelViewTransform2D transform;
    private ArrayList<StageCanvasComponentAdapter> listeners = new ArrayList();

    public PlayArea(double d, double d2, Rectangle2D rectangle2D) {
        this.stage = new Stage(d, d2);
        this.transform = new ModelViewTransform2D(rectangle2D, new Rectangle2D.Double(0.0, 0.0, d, d2));
        this.utilityStageNode.setVisible(false);
        this.utilityStageNode.setPickable(false);
        this.addStageNode(this.utilityStageNode);
        this.stageContainerDebugRegion = new PhetPPath(this.getContainerBounds(), (Stroke)new BasicStroke(6.0f, 0, 0, 1.0f, new float[]{20.0f, 8.0f}, 0.0f), (Paint)Color.blue);
        this.stageBoundsDebugRegion = new PhetPPath(this.getStageInScreenCoordinates(), (Stroke)new BasicStroke(4.0f, 0, 0, 1.0f, new float[]{17.0f, 5.0f}, 0.0f), (Paint)Color.red);
        this.addContainerBoundsChangeListener(new StageContainer.Listener(){

            public void stageContainerBoundsChanged() {
                PlayArea.this.updateDebugRegions();
            }
        });
    }

    public PlayArea(double d, Rectangle2D rectangle2D) {
        this(d, rectangle2D.getHeight() / rectangle2D.getWidth() * d, rectangle2D);
    }

    public Rectangle2D getContainerBounds() {
        return this.getScreenBounds();
    }

    public void addContainerBoundsChangeListener(StageContainer.Listener listener) {
        StageCanvasComponentAdapter stageCanvasComponentAdapter = new StageCanvasComponentAdapter(listener);
        this.addComponentListener(stageCanvasComponentAdapter);
        this.listeners.add(stageCanvasComponentAdapter);
    }

    public Rectangle2D getScreenBounds() {
        return new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    public void addScreenNode(PNode pNode) {
        this.getLayer().addChild(pNode);
    }

    public void removeScreenNode(PNode pNode) {
        this.getLayer().removeChild(pNode);
    }

    public Rectangle2D getStageInScreenCoordinates() {
        return this.stageToScreen(new Rectangle2D.Double(0.0, 0.0, this.stage.getWidth(), this.stage.getHeight()));
    }

    public Rectangle2D stageToScreen(Rectangle2D rectangle2D) {
        return this.utilityStageNode.localToGlobal(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight()));
    }

    public void addStageNode(PNode pNode) {
        this.addScreenNode(new StageNode(this.stage, this, pNode));
    }

    public void removeStageNode(PNode pNode) {
        this.removeScreenNode(new StageNode(this.stage, this, pNode));
    }

    public void updateDebugRegions() {
        this.stageBoundsDebugRegion.setPathTo(this.getStageInScreenCoordinates());
        this.stageContainerDebugRegion.setPathTo(this.getContainerBounds());
    }

    public ModelViewTransform2D getModelStageTransform() {
        return this.transform;
    }

    public Stage getStage() {
        return this.stage;
    }

    private static class StageCanvasComponentAdapter
    extends ComponentAdapter {
        private StageContainer.Listener listener;

        private StageCanvasComponentAdapter(StageContainer.Listener listener) {
            this.listener = listener;
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.listener.stageContainerBoundsChanged();
        }
    }
}

