/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motionseries.graphics;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.motionseries.graphics.RotationModel;
import edu.colorado.phet.scalacommon.Predef$;
import edu.colorado.phet.scalacommon.math.Vector2D;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;

public class RotationHandler
extends PBasicInputEventHandler {
    private final ModelViewTransform2D transform;
    private final PNode node;
    private final RotationModel rotatable;
    private final double min;
    private final double max;
    private double relativeAngle;

    public ModelViewTransform2D transform() {
        return this.transform;
    }

    public PNode node() {
        return this.node;
    }

    public RotationModel rotatable() {
        return this.rotatable;
    }

    private double relativeAngle() {
        return this.relativeAngle;
    }

    private void relativeAngle_$eq(double d) {
        this.relativeAngle = d;
    }

    public void mousePressed(PInputEvent event) {
        double pointerAngle = Predef$.MODULE$.pointToVector2D(this.toModelPoint(event)).$minus(this.pivot()).angle();
        double modelAngle = this.rotatable().angle();
        this.relativeAngle_$eq(modelAngle - pointerAngle);
    }

    public void mouseDragged(PInputEvent event) {
        double pointerAngle = Predef$.MODULE$.pointToVector2D(this.toModelPoint(event)).$minus(this.pivot()).angle();
        double proposedAngle = pointerAngle + this.relativeAngle();
        double angle = this.getSnapAngle(proposedAngle > this.max ? this.max : (proposedAngle < this.min ? this.min : proposedAngle));
        this.rotatable().angle_$eq(angle);
    }

    public double getSnapAngle(double proposedAngle) {
        return proposedAngle;
    }

    public Vector2D pivot() {
        return this.rotatable().pivot();
    }

    public Point2D toModelPoint(PInputEvent event) {
        return this.transform().viewToModel(event.getPositionRelativeTo(this.node().getParent()));
    }

    public RotationHandler(ModelViewTransform2D transform, PNode node, RotationModel rotatable, double min, double max) {
        this.transform = transform;
        this.node = node;
        this.rotatable = rotatable;
        this.min = min;
        this.max = max;
        this.relativeAngle = 0.0;
    }
}

