/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motionseries.graphics;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.motionseries.MotionSeriesResources$;
import edu.colorado.phet.motionseries.graphics.RampHeightIndicator$;
import edu.colorado.phet.motionseries.graphics.Rotatable;
import edu.colorado.phet.scalacommon.math.Vector2D;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.BoxedUnit;

public class RampHeightIndicator
extends PNode {
    private final Rotatable rampSegment;
    private final ModelViewTransform2D transform;
    private final PhetPPath line;
    private final PText readout;

    public PhetPPath line() {
        return this.line;
    }

    public PText readout() {
        return this.readout;
    }

    public void update() {
        this.line().setPathTo(this.transform.createTransformedShape(new Line2D.Double(edu.colorado.phet.scalacommon.Predef$.MODULE$.vector2DToPoint(new Vector2D(this.rampSegment.endPoint().x(), 0.0)), edu.colorado.phet.scalacommon.Predef$.MODULE$.vector2DToPoint(this.rampSegment.endPoint()))));
        this.readout().setOffset(this.line().getFullBounds().getMaxX() + (double)10, this.line().getFullBounds().getCenterY());
        String rampHeight = new DecimalFormat(MotionSeriesResources$.MODULE$.toMyRichString("0.0").literal()).format(this.rampSegment.endPoint().y());
        this.readout().setText(MotionSeriesResources$.MODULE$.toMyRichString("ramp.height-indicator").messageformat(Predef$.MODULE$.wrapRefArray(new Object[]{rampHeight})));
    }

    public RampHeightIndicator(Rotatable rampSegment, ModelViewTransform2D transform) {
        this.rampSegment = rampSegment;
        this.transform = transform;
        this.line = new PhetPPath(new BasicStroke(2.0f), (Paint)Color.black);
        this.addChild(this.line());
        this.readout = new $anon$1(this);
        this.addChild(this.readout());
        rampSegment.addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final RampHeightIndicator $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.update();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.update();
        this.setPickable(false);
        this.setChildrenPickable(false);
    }
}

