/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motionseries.graphics;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.motionseries.MotionSeriesResources$;
import edu.colorado.phet.motionseries.graphics.MotionSeriesObjectNode;
import edu.colorado.phet.motionseries.model.MotionSeriesObject;
import java.awt.image.BufferedImage;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public class PusherNode
extends MotionSeriesObjectNode {
    private final MotionSeriesObject targetObject;
    private final MotionSeriesObject manObject;

    public void doUpdate() {
        if (this.targetObject.appliedForce().magnitude() > 0.0) {
            double dx = 2.2 * (double)(this.targetObject.appliedForce().apply().x() > 0.0 ? -1 : 1);
            this.manObject.position_$eq(this.targetObject.position() + dx);
            int leanAmount = MathUtil.clamp(1, (int)(Math.abs(this.targetObject.appliedForce().apply().x()) * 13.0 / 50.0) + 1, 14);
            String textStr = ((Object)BoxesRunTime.boxToInteger(leanAmount)).toString();
            while (textStr.length() < 2) {
                textStr = new StringBuilder().append((Object)MotionSeriesResources$.MODULE$.toMyRichString("0").literal()).append((Object)textStr).toString();
            }
            BufferedImage im = MotionSeriesResources$.MODULE$.getImage(new StringBuilder().append((Object)MotionSeriesResources$.MODULE$.toMyRichString("pusher-leaner-png/pusher-leaning-2_00").literal()).append((Object)textStr).append((Object)MotionSeriesResources$.MODULE$.toMyRichString(".png").literal()).toString());
            BufferedImage realIm = dx > 0.0 ? BufferedImageUtils.flipX(im) : im;
            this.setImages(realIm, realIm);
            super.update();
        } else {
            BufferedImage image = MotionSeriesResources$.MODULE$.getImage(MotionSeriesResources$.MODULE$.toMyRichString("standing-man.png").literal());
            this.setImages(image, image);
            super.update();
        }
    }

    public PusherNode(ModelViewTransform2D transform, MotionSeriesObject targetObject, MotionSeriesObject manObject) {
        this.targetObject = targetObject;
        this.manObject = manObject;
        super(manObject, transform, MotionSeriesResources$.MODULE$.toMyRichString("standing-man.png").literal());
        targetObject.position2DProperty().addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final PusherNode $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.doUpdate();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        targetObject.appliedForce().addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final PusherNode $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.doUpdate();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.setPickable(false);
        this.setChildrenPickable(false);
    }
}

