/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motionseries.graphics;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.scalacommon.Predef$;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.geom.Point2D;

public class AxisNode
extends PNode {
    private final ModelViewTransform2D transform;
    private final ArrowNode axisNode;
    private final ArrowNode hitNode;
    private final PText text;

    public ModelViewTransform2D transform() {
        return this.transform;
    }

    private ArrowNode axisNode() {
        return this.axisNode;
    }

    public ArrowNode hitNode() {
        return this.hitNode;
    }

    public PText text() {
        return this.text;
    }

    public void updateTextNodeLocation() {
        Point2D viewDst = this.axisNode().getTipLocation();
        this.text().setOffset(Predef$.MODULE$.pointToVector2D(viewDst).x() - this.text().getFullBounds().getWidth() * 1.5, Predef$.MODULE$.pointToVector2D(viewDst).y());
    }

    public void setTipAndTailLocations(Point2D tip, Point2D tail) {
        this.axisNode().setTipAndTailLocations(tip, tail);
        this.hitNode().setTipAndTailLocations(tip, tail);
    }

    public AxisNode(ModelViewTransform2D transform, double x0, double y0, double x1, double y1, String label) {
        this.transform = transform;
        this.axisNode = new ArrowNode(transform.modelToViewDouble(x0, y0), transform.modelToViewDouble(x1, y1), 5.0, 5.0, 2.0);
        this.axisNode().setStroke(null);
        this.axisNode().setPaint(Color.black);
        this.hitNode = new ArrowNode(transform.modelToViewDouble(x0, y0), transform.modelToViewDouble(x1, y1), 20.0, 20.0, 20.0, 1.0, true);
        this.hitNode().setStroke(null);
        this.hitNode().setPaint(new Color(0, 0, 0, 0));
        this.axisNode().setPickable(false);
        this.axisNode().setChildrenPickable(false);
        this.addChild(this.hitNode());
        this.addChild(this.axisNode());
        this.text = new PText(label);
        this.text().setFont(new PhetFont(16, true));
        this.addChild(this.text());
        this.updateTextNodeLocation();
    }
}

