/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motionseries;

import edu.colorado.phet.common.motion.charts.ChartCursor;
import edu.colorado.phet.common.motion.charts.TemporalChart;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.audio.PhetAudioClip;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.motionseries.MotionSeriesResources$;
import edu.colorado.phet.motionseries.model.AdjustableCoordinateModel;
import edu.colorado.phet.motionseries.model.FreeBodyDiagramModel;
import edu.colorado.phet.motionseries.model.MotionSeriesModel;
import edu.colorado.phet.motionseries.model.VectorViewModel;
import edu.colorado.phet.motionseries.util.ScalaMutableBoolean;
import edu.colorado.phet.scalacommon.ScalaClock;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.runtime.BoxedUnit;

public class MotionSeriesModule
extends Module {
    private final ScalaClock clock;
    private final ScalaMutableBoolean audioEnabled;
    private final MotionSeriesModel motionSeriesModel;
    private final FreeBodyDiagramModel fbdModel;
    private final AdjustableCoordinateModel coordinateSystemModel;
    private final VectorViewModel vectorViewModel;
    private long edu$colorado$phet$motionseries$MotionSeriesModule$$lastTickTime;
    private int edu$colorado$phet$motionseries$MotionSeriesModule$$clockTickIndex;

    public ScalaClock clock() {
        return this.clock;
    }

    public ScalaMutableBoolean audioEnabled() {
        return this.audioEnabled;
    }

    public MotionSeriesModel createMotionSeriesModel(double defaultObjectPosition, double initialAngle) {
        return new MotionSeriesModel(defaultObjectPosition, initialAngle);
    }

    public MotionSeriesModel motionSeriesModel() {
        return this.motionSeriesModel;
    }

    public final void edu$colorado$phet$motionseries$MotionSeriesModule$$updateCursorVisibility(MotionSeriesModel model) {
        model.chartCursor().setVisible(this.motionSeriesModel().isPlayback() && this.motionSeriesModel().getNumRecordedPoints() > 0);
    }

    public FreeBodyDiagramModel fbdModel() {
        return this.fbdModel;
    }

    public AdjustableCoordinateModel coordinateSystemModel() {
        return this.coordinateSystemModel;
    }

    public VectorViewModel vectorViewModel() {
        return this.vectorViewModel;
    }

    public final long edu$colorado$phet$motionseries$MotionSeriesModule$$lastTickTime() {
        return this.edu$colorado$phet$motionseries$MotionSeriesModule$$lastTickTime;
    }

    public final void edu$colorado$phet$motionseries$MotionSeriesModule$$lastTickTime_$eq(long l) {
        this.edu$colorado$phet$motionseries$MotionSeriesModule$$lastTickTime = l;
    }

    public final int edu$colorado$phet$motionseries$MotionSeriesModule$$clockTickIndex() {
        return this.edu$colorado$phet$motionseries$MotionSeriesModule$$clockTickIndex;
    }

    public final void edu$colorado$phet$motionseries$MotionSeriesModule$$clockTickIndex_$eq(int n) {
        this.edu$colorado$phet$motionseries$MotionSeriesModule$$clockTickIndex = n;
    }

    public void play(PhetAudioClip audioClip) {
        if (this.audioEnabled().booleanValue()) {
            audioClip.play();
        }
    }

    public void resetPauseValue() {
        this.motionSeriesModel().setPaused(true);
    }

    public void resetRampModule() {
        this.audioEnabled().reset();
        this.motionSeriesModel().resetAll();
        this.fbdModel().resetAll();
        this.coordinateSystemModel().resetAll();
        this.vectorViewModel().resetAll();
        this.resetPauseValue();
        this.resetAll();
    }

    public void resetAll() {
    }

    public void deactivate() {
        this.fbdModel().windowed_$eq(false);
        if (this.fbdModel().popupDialogOnly()) {
            this.fbdModel().visible_$eq(false);
        }
        super.deactivate();
    }

    public boolean gravityAndNormalForceShownByDefault() {
        return true;
    }

    public MotionSeriesModule(PhetFrame frame, ScalaClock clock, String name, double defaultObjectPosition, double initialAngle, boolean fbdPopupOnly) {
        this.clock = clock;
        super(name, clock);
        this.audioEnabled = new ScalaMutableBoolean(true);
        TemporalChart.SEC_TEXT = "";
        this.motionSeriesModel = this.createMotionSeriesModel(defaultObjectPosition, initialAngle);
        this.motionSeriesModel().addObserver(new SimpleObserver(this){
            private final MotionSeriesModule $outer;

            public void update() {
                this.$outer.edu$colorado$phet$motionseries$MotionSeriesModule$$updateCursorVisibility(this.$outer.motionSeriesModel());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.edu$colorado$phet$motionseries$MotionSeriesModule$$updateCursorVisibility(this.motionSeriesModel());
        this.motionSeriesModel().chartCursor().addListener(new ChartCursor.Adapter(this){
            private final MotionSeriesModule $outer;

            public void positionChanged() {
                this.$outer.motionSeriesModel().setTime(this.$outer.motionSeriesModel().chartCursor().getTime());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.fbdModel = new FreeBodyDiagramModel(fbdPopupOnly);
        this.coordinateSystemModel = new AdjustableCoordinateModel();
        this.vectorViewModel = new VectorViewModel(this.gravityAndNormalForceShownByDefault());
        this.coordinateSystemModel().addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final MotionSeriesModule $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (this.$outer.coordinateSystemModel().fixed()) {
                    this.$outer.motionSeriesModel().coordinateFrameModel().proposedAngle_$eq(0.0);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.edu$colorado$phet$motionseries$MotionSeriesModule$$lastTickTime = System.currentTimeMillis();
        this.edu$colorado$phet$motionseries$MotionSeriesModule$$clockTickIndex = 0;
        clock.addClockListener((Function1<Object, BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final MotionSeriesModule $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(double dt) {
                this.apply$mcVD$sp(dt);
            }

            public void apply$mcVD$sp(double v1) {
                long t = System.currentTimeMillis();
                long delta = t - this.$outer.edu$colorado$phet$motionseries$MotionSeriesModule$$lastTickTime();
                long paintAndInputTime = System.currentTimeMillis() - this.$outer.edu$colorado$phet$motionseries$MotionSeriesModule$$lastTickTime();
                long startTime = System.currentTimeMillis();
                this.$outer.motionSeriesModel().stepInTime(v1);
                long modelTime = System.currentTimeMillis() - startTime;
                long elapsed = paintAndInputTime + modelTime;
                this.$outer.edu$colorado$phet$motionseries$MotionSeriesModule$$lastTickTime_$eq(t);
                this.$outer.edu$colorado$phet$motionseries$MotionSeriesModule$$clockTickIndex_$eq(this.$outer.edu$colorado$phet$motionseries$MotionSeriesModule$$clockTickIndex() + 1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.motionSeriesModel().motionSeriesObject().addWallCrashListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final MotionSeriesModule $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.play(MotionSeriesResources$.MODULE$.crashSound());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.motionSeriesModel().motionSeriesObject().addBounceListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final MotionSeriesModule $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.play(MotionSeriesResources$.MODULE$.bounceSound());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.motionSeriesModel().motionSeriesObject().crashListeners().$plus$eq(new Serializable(this){
            public static final long serialVersionUID;
            private final MotionSeriesModule $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.play(MotionSeriesResources$.MODULE$.crashSound());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.resetPauseValue();
    }
}

