/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.test.help;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.phetcommon.model.clock.TimingStrategy;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.help.GlassPaneCanvas;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class TestGlassPaneCanvas
extends PhetApplication {
    private static final int CLOCK_RATE = 25;
    private static final double MODEL_RATE = 1.0;
    private static final Cursor HAND_CURSOR = new Cursor(12);

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                try {
                    return new TestGlassPaneCanvas(phetApplicationConfig);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "piccolo-phet");
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }

    public TestGlassPaneCanvas(PhetApplicationConfig phetApplicationConfig) throws InterruptedException {
        super(phetApplicationConfig);
        TestModule testModule = new TestModule("Module 1", new Color(255, 208, 252));
        this.addModule(testModule);
        TestModule testModule2 = new TestModule("Module 2", new Color(208, 255, 252));
        this.addModule(testModule2);
        EventListener eventListener = new EventListener();
        JMenu jMenu = new JMenu("Test");
        this.getPhetFrame().addMenu(jMenu);
        for (int i = 0; i < 20; ++i) {
            JMenuItem jMenuItem = new JMenuItem("item" + i);
            jMenuItem.setName("item" + i);
            jMenuItem.addActionListener(eventListener);
            jMenu.add(jMenuItem);
        }
    }

    public static class EventListener
    implements ActionListener,
    ItemListener,
    ChangeListener {
        public void actionPerformed(ActionEvent actionEvent) {
            this.showMessage(this.getName(actionEvent) + " actionPerformed");
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() instanceof JSlider && ((JSlider)changeEvent.getSource()).getValueIsAdjusting()) {
                return;
            }
            this.showMessage(this.getName(changeEvent) + " stateChanged");
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                this.showMessage(this.getName(itemEvent) + " " + itemEvent.getItem() + " selected");
            }
        }

        private String getName(EventObject eventObject) {
            String string = "?";
            if (eventObject.getSource() instanceof JComponent) {
                string = ((JComponent)eventObject.getSource()).getName();
            }
            return string;
        }

        private void showMessage(String string) {
            JOptionPane.showMessageDialog(PhetApplication.getInstance().getPhetFrame(), string);
        }
    }

    private static class TestModule
    extends PiccoloModule {
        public TestModule(String string, Color color) {
            super(string, new TestClock(), true);
            AbstractButton abstractButton;
            EventListener eventListener = new EventListener();
            PhetPCanvas phetPCanvas = new PhetPCanvas();
            this.setSimulationPanel(phetPCanvas);
            phetPCanvas.setBackground(color);
            JButton jButton = new JButton("button0");
            jButton.setName("button0");
            jButton.setOpaque(false);
            jButton.addActionListener(eventListener);
            PSwing pSwing = new PSwing(jButton);
            pSwing.addInputEventListener(new CursorHandler());
            pSwing.setOffset(100.0, 200.0);
            phetPCanvas.getLayer().addChild(pSwing);
            PPath pPath = new PPath();
            pPath.setPathToRectangle(0.0f, 0.0f, 50.0f, 50.0f);
            pPath.setPaint(Color.RED);
            pPath.setOffset(400.0, 300.0);
            pPath.addInputEventListener(new CursorHandler());
            pPath.addInputEventListener(new PDragEventHandler());
            phetPCanvas.getLayer().addChild(pPath);
            HTMLNode hTMLNode = new HTMLNode("To access a pop-up menu,<br>click anywhere on the canvas<br>with the right mouse button</html>");
            hTMLNode.setFont(new PhetFont(0, 18));
            hTMLNode.setOffset(300.0, 100.0);
            phetPCanvas.getLayer().addChild(hTMLNode);
            final JPopupMenu jPopupMenu = new JPopupMenu();
            for (int i = 0; i < 5; ++i) {
                abstractButton = new JMenuItem("popup" + i);
                abstractButton.setName("popup" + i);
                abstractButton.addActionListener(eventListener);
                jPopupMenu.add((JMenuItem)abstractButton);
            }
            phetPCanvas.addMouseListener(new MouseInputAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 3) {
                        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            ControlPanel controlPanel = new ControlPanel();
            this.setControlPanel(controlPanel);
            abstractButton = new JButton("button1");
            abstractButton.setName("button1");
            abstractButton.setCursor(HAND_CURSOR);
            abstractButton.addActionListener(eventListener);
            JCheckBox jCheckBox = new JCheckBox("checkBox1");
            jCheckBox.setName("checkBox1");
            jCheckBox.addActionListener(eventListener);
            JSlider jSlider = new JSlider();
            jSlider.setName("slider1");
            jSlider.addChangeListener(eventListener);
            Object[] objectArray = new Object[]{"choice1", "choice2", "choice3", "choice4"};
            JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
            jComboBox.setName("comboBox");
            jComboBox.addItemListener(eventListener);
            JPanel jPanel = new JPanel();
            jPanel.setBorder(new TitledBorder("title"));
            Serializable serializable = new BoxLayout(jPanel, 1);
            jPanel.setLayout((LayoutManager)((Object)serializable));
            JComponent jComponent = new JButton("button2");
            jComponent.setName("button2");
            jComponent.setCursor(HAND_CURSOR);
            jComponent.addActionListener(eventListener);
            JCheckBox jCheckBox2 = new JCheckBox("checkBox2");
            jCheckBox2.setName("checkBox2");
            jCheckBox2.addActionListener(eventListener);
            JSlider jSlider2 = new JSlider();
            jSlider2.setName("slider2");
            jSlider2.addChangeListener(eventListener);
            jPanel.add(jComponent);
            jPanel.add(jCheckBox2);
            jPanel.add(jSlider2);
            controlPanel.addControl(abstractButton);
            controlPanel.addControl(jCheckBox);
            controlPanel.addControlFullWidth(jSlider);
            controlPanel.addControl(jComboBox);
            controlPanel.addControlFullWidth(jPanel);
            serializable = PhetApplication.getInstance().getPhetFrame();
            jComponent = new MyGlassPane((JFrame)serializable);
            this.setHelpPane(jComponent);
        }

        public boolean hasHelp() {
            return true;
        }

        private class MyGlassPane
        extends GlassPaneCanvas {
            public MyGlassPane(JFrame jFrame) {
                super(jFrame);
                Timer timer = new Timer(500, new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        MyGlassPane.this.getLayer().removeAllChildren();
                        MyGlassPane.this.markComponents(MyGlassPane.this.getParentFrame().getLayeredPane());
                    }
                });
                timer.start();
            }

            private void markComponents(Container container) {
                for (int i = 0; i < container.getComponentCount(); ++i) {
                    PPath pPath;
                    Point point;
                    Component component = container.getComponent(i);
                    if (!component.isVisible()) continue;
                    if (component instanceof AbstractButton) {
                        point = SwingUtilities.convertPoint(component.getParent(), component.getLocation(), this);
                        pPath = new PPath(new Ellipse2D.Double(-5.0, -5.0, 10.0, 10.0));
                        pPath.setPaint(Color.RED);
                        pPath.setOffset(point);
                        this.getLayer().addChild(pPath);
                        continue;
                    }
                    if (component instanceof JCheckBox) {
                        point = SwingUtilities.convertPoint(component.getParent(), component.getLocation(), this);
                        pPath = new PPath(new Ellipse2D.Double(-5.0, -5.0, 10.0, 10.0));
                        pPath.setPaint(Color.BLUE);
                        pPath.setOffset(point);
                        this.getLayer().addChild(pPath);
                        continue;
                    }
                    if (component instanceof JSlider) {
                        point = SwingUtilities.convertPoint(component.getParent(), component.getLocation(), this);
                        pPath = new PPath(new Ellipse2D.Double(-5.0, -5.0, 10.0, 10.0));
                        pPath.setPaint(Color.GREEN);
                        pPath.setOffset(point);
                        this.getLayer().addChild(pPath);
                        continue;
                    }
                    if (!(component instanceof Container)) continue;
                    this.markComponents((Container)component);
                }
            }
        }
    }

    private static class TestClock
    extends SwingClock {
        public TestClock() {
            super(40, new TimingStrategy.Constant(1.0));
        }
    }
}

