/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import javax.swing.ImageIcon;

public class BufferedImageUtils {
    public static BufferedImage rescaleYMaintainAspectRatio(BufferedImage bufferedImage, int n) {
        if (bufferedImage.getHeight() == n) {
            return bufferedImage;
        }
        double d = bufferedImage.getHeight();
        double d2 = (double)n / d;
        return BufferedImageUtils.rescaleFractional(bufferedImage, d2, d2);
    }

    public static BufferedImage rescaleXMaintainAspectRatio(BufferedImage bufferedImage, int n) {
        if (bufferedImage.getWidth() == n) {
            return bufferedImage;
        }
        double d = bufferedImage.getWidth();
        double d2 = (double)n / d;
        return BufferedImageUtils.rescaleFractional(bufferedImage, d2, d2);
    }

    public static BufferedImage rescaleFractional(BufferedImage bufferedImage, double d, double d2) {
        int n = (int)((double)bufferedImage.getWidth() * d);
        int n2 = (int)((double)bufferedImage.getHeight() * d2);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d2);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.drawRenderedImage(bufferedImage, affineTransform);
        return bufferedImage2;
    }

    public static BufferedImage flipY(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        AffineTransform affineTransform = BufferedImageUtils.createTransformFlipY(bufferedImage);
        graphics2D.drawRenderedImage(bufferedImage, affineTransform);
        return bufferedImage2;
    }

    public static BufferedImage flipX(BufferedImage bufferedImage) {
        int n = bufferedImage.getType();
        if (bufferedImage.getType() == 0) {
            n = 2;
        }
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        AffineTransform affineTransform = BufferedImageUtils.createTransformFlipX(bufferedImage);
        graphics2D.drawRenderedImage(bufferedImage, affineTransform);
        return bufferedImage2;
    }

    private static AffineTransform createTransformFlipY(BufferedImage bufferedImage) {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0, -1.0);
        affineTransform.translate(0.0, -bufferedImage.getHeight());
        return affineTransform;
    }

    private static AffineTransform createTransformFlipX(BufferedImage bufferedImage) {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(-1.0, 1.0);
        affineTransform.translate(-bufferedImage.getWidth(), 0.0);
        return affineTransform;
    }

    public static BufferedImage getRotatedImage(BufferedImage bufferedImage, double d) {
        d = (d % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = bufferedImage.getWidth();
        double d6 = bufferedImage.getHeight();
        if (d >= 0.0 && d <= 1.5707963267948966) {
            d2 = d6 * Math.sin(d);
            d3 = 0.0;
        }
        if (d > 1.5707963267948966 && d <= Math.PI) {
            d4 = d - 1.5707963267948966;
            d2 = d5 * Math.sin(d4) + d6 * Math.cos(d4);
            d3 = d6 * Math.sin(d4);
        }
        if (d > Math.PI && d <= 4.71238898038469) {
            d4 = d - Math.PI;
            d2 = d5 * Math.cos(d4);
            d3 = d5 * Math.sin(d4) + d6 * Math.cos(d4);
        }
        if (d > 4.71238898038469 && d <= Math.PI * 2) {
            d4 = Math.PI * 2 - d;
            d2 = 0.0;
            d3 = d5 * Math.sin(d4);
        }
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d2, d3);
        affineTransform.rotate(d);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
        return bufferedImage2;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        return colorModel.hasAlpha();
    }

    public static int getTransparency(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().getTransparency();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        int n = 1;
        if (colorModel != null) {
            n = colorModel.getTransparency();
        }
        return n;
    }

    public static BufferedImage toBufferedImage(Image image) {
        int n;
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bufferedImage = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            n = BufferedImageUtils.getTransparency(image);
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            bufferedImage = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null), n);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        if (bufferedImage == null) {
            n = BufferedImageUtils.hasAlpha(image) ? 1 : 0;
            int n2 = 1;
            if (n != 0) {
                n2 = 2;
            }
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n2);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage multiScale(BufferedImage bufferedImage, double d) {
        int n = (int)((double)bufferedImage.getWidth() * d);
        int n2 = (int)((double)bufferedImage.getHeight() * d);
        if (d < 1.0) {
            return BufferedImageUtils.getScaledInstance(bufferedImage, n, n2, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
        }
        if (d == 1.0) {
            return bufferedImage;
        }
        return BufferedImageUtils.rescaleXMaintainAspectRatio(bufferedImage, n);
    }

    public static BufferedImage multiScaleToHeight(BufferedImage bufferedImage, int n) {
        return BufferedImageUtils.multiScale(bufferedImage, (double)n / (double)bufferedImage.getHeight());
    }

    public static BufferedImage getScaledInstance(BufferedImage bufferedImage, int n, int n2, Object object, boolean bl) {
        int n3;
        int n4;
        int n5 = BufferedImageUtils.hasAlpha(bufferedImage) ? 2 : 1;
        BufferedImage bufferedImage2 = bufferedImage;
        if (bl) {
            n4 = bufferedImage.getWidth();
            n3 = bufferedImage.getHeight();
        } else {
            n4 = n;
            n3 = n2;
        }
        do {
            if (bl && n4 > n && (n4 /= 2) < n) {
                n4 = n;
            }
            if (bl && n3 > n2 && (n3 /= 2) < n2) {
                n3 = n2;
            }
            BufferedImage bufferedImage3 = new BufferedImage(n4, n3, n5);
            Graphics2D graphics2D = bufferedImage3.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
            graphics2D.drawImage(bufferedImage2, 0, 0, n4, n3, null);
            graphics2D.dispose();
            bufferedImage2 = bufferedImage3;
        } while (n4 > n || n3 > n2);
        return bufferedImage2;
    }
}

