/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class ServerAddress {
    final String _host;
    final int _port;
    InetSocketAddress _addr;
    InetAddress[] _all;

    public ServerAddress() throws UnknownHostException {
        this(ServerAddress.defaultHost(), ServerAddress.defaultPort());
    }

    public ServerAddress(String host) throws UnknownHostException {
        this(host, ServerAddress.defaultPort());
    }

    public ServerAddress(String host, int port) throws UnknownHostException {
        int idx;
        if (host == null) {
            host = ServerAddress.defaultHost();
        }
        if ((host = host.trim()).length() == 0) {
            host = ServerAddress.defaultHost();
        }
        if ((idx = host.indexOf(":")) > 0) {
            if (port != ServerAddress.defaultPort()) {
                throw new IllegalArgumentException("can't specify port in construct and via host");
            }
            port = Integer.parseInt(host.substring(idx + 1));
            host = host.substring(0, idx).trim();
        }
        this._host = host;
        this._port = port;
        this._all = ServerAddress._getAddress(this._host);
        this._addr = new InetSocketAddress(this._all[0], this._port);
    }

    public boolean equals(Object other) {
        if (other instanceof ServerAddress) {
            ServerAddress a = (ServerAddress)other;
            return a._port == this._port && a._host.equals(this._host);
        }
        if (other instanceof InetSocketAddress) {
            return this._addr.equals(other);
        }
        return false;
    }

    public int hashCode() {
        return this._host.hashCode() + this._port;
    }

    public InetSocketAddress getSocketAddress() {
        return this._addr;
    }

    public String toString() {
        return this._host + ":" + this._port;
    }

    private static InetAddress[] _getAddress(String host) throws UnknownHostException {
        if (host.toLowerCase().equals("localhost")) {
            return new InetAddress[]{InetAddress.getLocalHost()};
        }
        return InetAddress.getAllByName(host);
    }

    public static String defaultHost() {
        return "127.0.0.1";
    }

    public static int defaultPort() {
        return 27017;
    }

    boolean updateInetAddr() throws UnknownHostException {
        InetSocketAddress oldaddr = this._addr;
        this._all = ServerAddress._getAddress(this._host);
        this._addr = new InetSocketAddress(this._all[0], this._port);
        return !this._addr.equals(oldaddr);
    }
}

