/*
 * Decompiled with CFR 0.152.
 */
class ZeroMatrixOperator
extends Operator {
    public ZeroMatrixOperator() {
        this.opType = "zero";
        this.nArgs = 1;
        this.argType = 1;
        this.isSingle = true;
        this.arguments = new String[1];
        this.arguments[0] = "n";
        this.name = "zero matrix";
        this.description = "Creates a zero matrix of the given size, n x n.";
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock) {
        Object object;
        Variable variable;
        try {
            variable = (Variable)formulaBlock;
        }
        catch (Exception exception) {
            object = (VariableSet)formulaBlock;
            if (((VariableSet)object).countElements() == this.nArgs) {
                variable = ((VariableSet)object).getElement(0);
            }
            System.out.println(this.opType + " cannot operate on " + object);
            return new Variable("NaN", Double.NaN);
        }
        double[][] dArray = variable.getMatrixValue();
        object = new double[][]{{Double.NaN}};
        if (dArray.length == 1 && dArray[0].length == 1) {
            int n = (int)dArray[0][0];
            object = new double[n][n];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    object[i][j] = 0.0;
                }
            }
        } else {
            System.out.println(this.opType + " requires a scalar argument");
        }
        return new Variable("r", (double[][])object);
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock, FormulaBlock formulaBlock2) {
        return new Variable("NaN", Double.NaN);
    }
}

