/*
 * Decompiled with CFR 0.152.
 */
public class ViewPoint {
    private Vector position;
    private Vector direction;
    private Vector up;
    private Vector side;
    private double zoom;
    private int projectionType;
    public static final int PERSPECTIVE = 0;
    public static final int ISOMETRIC = 1;
    public static final int LENS = 2;

    public ViewPoint(Vector vector, Vector vector2, Vector vector3) {
        this.position = vector;
        this.direction = vector2;
        this.up = vector3;
        this.zoom = vector2.norm();
        this.updateAxes();
        this.projectionType = 0;
    }

    public ViewPoint(Vector vector, Vector vector2, Vector vector3, int n) {
        this.position = vector;
        this.direction = vector2;
        this.up = vector3;
        this.zoom = vector2.norm();
        this.updateAxes();
        this.projectionType = n == 1 || n == 0 || n == 2 ? n : 0;
    }

    public void setProjectionType(int n) {
        this.projectionType = n;
    }

    public int getProjectionType() {
        return this.projectionType;
    }

    public void shiftViewPoint(double d, double d2) {
        Vector vector = this.direction.unit().times(d2);
        this.position = this.position.plus(vector);
        Quaternion quaternion = new Quaternion(this.direction, -d);
        this.direction = this.direction.rotate(quaternion);
        this.up = this.up.rotate(quaternion);
        this.side = this.side.rotate(quaternion);
    }

    public void rotateViewPoint(double d, double d2, Vector vector) {
        Vector vector2 = this.side.times(-d2).plus(this.up.times(d));
        double d3 = Math.sqrt(d * d + d2 * d2);
        Quaternion quaternion = new Quaternion(vector2, d3);
        this.position = this.position.minus(vector).rotate(quaternion).plus(vector);
        this.direction = this.direction.rotate(quaternion);
        this.up = this.up.rotate(quaternion);
        this.side = this.side.rotate(quaternion);
    }

    private void updateAxes() {
        this.side = this.direction.cross(this.up).norm() > 0.01 ? this.direction.cross(this.up).unit() : (this.direction.cross(new Vector(0.0, 0.0, 1.0)).norm() > 0.01 ? this.direction.cross(new Vector(0.0, 0.0, 1.0)).unit() : this.direction.cross(new Vector(0.0, 1.0, 0.0)).unit());
        this.up = this.direction.cross(this.side).unit().times(-1.0);
    }

    public Vector getPosition() {
        return this.position;
    }

    public void setPosition(Vector vector) {
        this.position = vector;
    }

    public Vector getDirection() {
        return this.direction;
    }

    public void setDirection(Vector vector) {
        this.direction = vector;
        this.zoom = this.direction.norm();
        this.updateAxes();
    }

    public Vector getUp() {
        return this.up;
    }

    public void setUp(Vector vector) {
        this.up = vector;
        this.updateAxes();
    }

    public double getZoom() {
        return this.zoom;
    }

    public Vector getSide() {
        return this.side;
    }

    public void aimAtCenter(Structure structure) {
        Vector vector = structure.getCenter();
        if (vector == null) {
            structure.calculateCenter();
            vector = structure.getCenter();
        }
        this.direction = vector.minus(this.position).unit().times(this.getZoom());
        this.updateAxes();
    }

    public static ViewPoint resetViewPoint(Structure structure) throws Exception {
        double d = 50.0;
        if (structure.countAllAtoms() > 100) {
            d = 12.0 * Math.pow(structure.countAllAtoms(), 0.3333333333333333);
        }
        Vector vector = new Vector(0.0, 0.0, d);
        Vector vector2 = new Vector(0.0, 1.0, 0.0);
        Vector vector3 = structure.getCenter();
        vector = vector.plus(vector3);
        Vector vector4 = vector3.minus(vector).unit().times(10.0);
        return new ViewPoint(vector, vector4, vector2);
    }

    public static ViewPoint resetViewPoint(Structure structure, ViewPoint viewPoint) throws Exception {
        double d = 50.0;
        if (structure.countAllAtoms() > 100) {
            d = 15.0 * Math.pow(structure.countAllAtoms(), 0.3333333333333333);
        }
        Vector vector = new Vector(0.0, 0.0, d);
        Vector vector2 = new Vector(0.0, 1.0, 0.0);
        Vector vector3 = structure.getCenter();
        vector = vector.plus(vector3);
        Vector vector4 = vector3.minus(vector).unit().times(10.0);
        int n = viewPoint.getProjectionType();
        ViewPoint viewPoint2 = new ViewPoint(vector, vector4, vector2, n);
        return viewPoint2;
    }
}

