/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.util.Arrays;

public class View {
    public static final Color darkBlue = new Color(0, 0, 128, 255);
    public static final Color darkRed = new Color(128, 0, 0, 255);
    public static final Color darkGreen = new Color(0, 128, 0, 255);
    public static final Color blue = new Color(0, 0, 255, 255);
    public static final Color red = new Color(255, 0, 0, 255);
    public static final Color green = new Color(0, 255, 0, 255);
    public static final Color gold = new Color(255, 193, 37, 255);
    public static final Color yellow = new Color(255, 255, 0, 255);
    public static final Color steel = new Color(35, 107, 142, 255);
    public static final Color transBlue = new Color(0, 0, 128, 128);
    public static final Color transRed = new Color(128, 0, 0, 128);
    public static final Color transGreen = new Color(0, 128, 0, 128);
    public static final Color transLightBlue = new Color(0, 0, 255, 128);
    public static final Color transLightRed = new Color(255, 0, 0, 128);
    public static final Color transLightGreen = new Color(0, 255, 0, 128);
    public static final Color transYellow = new Color(255, 255, 0, 128);
    public static final Color black = new Color(0, 0, 0, 255);
    public static final Color darkGray = new Color(63, 63, 63, 255);
    public static final Color gray = new Color(127, 127, 127, 255);
    public static final Color lightGray = new Color(191, 191, 191, 255);
    public static final Color white = new Color(255, 255, 255, 255);
    public static final Color transWhite = new Color(255, 255, 255, 128);
    public static final Color transBlack = new Color(0, 0, 0, 128);
    public static final Color transGold = new Color(245, 195, 50, 150);
    public static Color bg = new Color(128, 128, 128, 255);
    public static Color picked = new Color(0, 0, 0, 255);
    public static Color unpicked = new Color(50, 50, 50, 100);
    public static Color hiddenPicked = new Color(0, 0, 0, 42);
    public static Color hiddenUnpicked = new Color(50, 50, 50, 6);
    public static Color transparent = new Color(0, 0, 0, 0);
    public static int STROKE_WIDTH = 4;
    public static double displayRadiusMultiplier = 0.5;
    private Projection[] projections;
    private Vector originProjection;
    private Vector[] cellProjections;
    private Vector[] axisProjections;
    private int visibleAtoms;
    private boolean isReady = false;
    private int width;
    private int height;

    public View(Structure structure, ViewPoint viewPoint, int n, int n2) {
        this.width = n;
        this.height = n2;
        try {
            this.calculateProjections(structure, viewPoint);
        }
        catch (Exception exception) {
            this.axisProjections = null;
            this.cellProjections = null;
            this.projections = null;
            this.visibleAtoms = 0;
        }
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void setReady(boolean bl) {
        this.isReady = bl;
    }

    public Shape getAtomicShape(int n) {
        return this.projections[n].getAtomicShape(this.width, this.height);
    }

    public boolean isVisible(int n) {
        return this.projections[n].isVisible();
    }

    public Line2D getCellAxisLine(int n) {
        if (this.originProjection.element(0) > 0.0 && this.cellProjections[n].element(0) > 0.0) {
            double d = this.originProjection.element(1) * 100.0 + (double)(this.width / 2);
            double d2 = -this.originProjection.element(2) * 100.0 + (double)(this.height / 2);
            double d3 = this.cellProjections[n].element(1) * 100.0 + (double)(this.width / 2);
            double d4 = -this.cellProjections[n].element(2) * 100.0 + (double)(this.height / 2);
            return new Line2D.Double(d, d2, d3, d4);
        }
        return new Line2D.Double(-100.0, -100.0, -100.0, -100.0);
    }

    public Line2D getUnitAxisLine(int n) {
        if (this.originProjection.element(0) > 0.0 && this.cellProjections[n].element(0) > 0.0) {
            double d = this.originProjection.element(1) * 100.0 + (double)(this.width / 2);
            double d2 = -this.originProjection.element(2) * 100.0 + (double)(this.height / 2);
            double d3 = this.axisProjections[n].element(1) * 100.0 + (double)(this.width / 2);
            double d4 = -this.axisProjections[n].element(2) * 100.0 + (double)(this.height / 2);
            return new Line2D.Double(d, d2, d3, d4);
        }
        return new Line2D.Double(-100.0, -100.0, -100.0, -100.0);
    }

    public void updateProjections(Structure structure, ViewPoint viewPoint) throws Exception {
        int n;
        Atom[] atomArray = structure.getAllAtoms();
        this.visibleAtoms = 0;
        if (atomArray.length != this.projections.length) {
            throw new Exception();
        }
        for (n = 0; n < atomArray.length; ++n) {
            Vector vector = View.projection(atomArray[n], structure, viewPoint);
            this.projections[n].setX(vector.element(1));
            this.projections[n].setY(vector.element(2));
            this.projections[n].setDepth(vector.element(3));
            this.projections[n].setRadius(vector.element(0));
            if (atomArray[n].isHidden()) {
                this.projections[n].setColor(transparent);
                if (atomArray[n].isPicked()) {
                    this.projections[n].setLineColor(hiddenPicked);
                } else {
                    this.projections[n].setLineColor(hiddenUnpicked);
                }
            } else {
                this.projections[n].setColor(atomArray[n].getColor());
                if (atomArray[n].isPicked()) {
                    this.projections[n].setLineColor(picked);
                } else {
                    this.projections[n].setLineColor(unpicked);
                }
            }
            if (!this.projections[n].isVisible()) continue;
            ++this.visibleAtoms;
        }
        Arrays.sort(this.projections);
        this.originProjection = View.projection(new Vector(0.0, 0.0, 0.0), structure, viewPoint);
        for (n = 0; n < 3; ++n) {
            this.cellProjections[n] = View.projection(structure.getCell()[n], structure, viewPoint);
        }
        this.axisProjections[0] = View.projection(new Vector(1.0, 0.0, 0.0), structure, viewPoint);
        this.axisProjections[1] = View.projection(new Vector(0.0, 1.0, 0.0), structure, viewPoint);
        this.axisProjections[2] = View.projection(new Vector(0.0, 0.0, 1.0), structure, viewPoint);
    }

    private void calculateProjections(Structure structure, ViewPoint viewPoint) {
        int n;
        Atom[] atomArray = structure.getAllAtoms();
        this.projections = new Projection[atomArray.length];
        this.visibleAtoms = 0;
        for (n = 0; n < atomArray.length; ++n) {
            Vector vector = View.projection(atomArray[n], structure, viewPoint);
            this.projections[n] = new Projection(n);
            this.projections[n].setX(vector.element(1));
            this.projections[n].setY(vector.element(2));
            this.projections[n].setDepth(vector.element(3));
            this.projections[n].setRadius(vector.element(0));
            this.projections[n].setColor(atomArray[n].getColor());
            if (atomArray[n].isHidden()) {
                this.projections[n].setColor(transparent);
                if (atomArray[n].isPicked()) {
                    this.projections[n].setLineColor(hiddenPicked);
                } else {
                    this.projections[n].setLineColor(hiddenUnpicked);
                }
            } else {
                this.projections[n].setColor(atomArray[n].getColor());
                if (atomArray[n].isPicked()) {
                    this.projections[n].setLineColor(picked);
                } else {
                    this.projections[n].setLineColor(unpicked);
                }
            }
            if (!this.projections[n].isVisible()) continue;
            ++this.visibleAtoms;
        }
        Arrays.sort(this.projections);
        this.cellProjections = new Vector[3];
        this.axisProjections = new Vector[3];
        this.originProjection = View.projection(new Vector(0.0, 0.0, 0.0), structure, viewPoint);
        for (n = 0; n < 3; ++n) {
            this.cellProjections[n] = View.projection(structure.getCell()[n], structure, viewPoint);
        }
        this.axisProjections[0] = View.projection(new Vector(1.0, 0.0, 0.0), structure, viewPoint);
        this.axisProjections[1] = View.projection(new Vector(0.0, 1.0, 0.0), structure, viewPoint);
        this.axisProjections[2] = View.projection(new Vector(0.0, 0.0, 1.0), structure, viewPoint);
    }

    public static Vector projection(Atom atom, Structure structure, ViewPoint viewPoint) {
        Vector vector = View.projection(atom.getCoordinates(), structure, viewPoint);
        vector.setElement(0, vector.element(0) * atom.getRadius());
        return vector;
    }

    public static Vector projection(Vector vector, Structure structure, ViewPoint viewPoint) {
        Vector vector2 = vector.minus(viewPoint.getPosition());
        double[] dArray = new double[4];
        dArray[3] = vector2.norm();
        if (viewPoint.getProjectionType() == 0) {
            double d = vector2.projectionOnVector(viewPoint.getDirection()).norm();
            dArray[0] = vector2.dot(viewPoint.getDirection()) > 0.0 ? viewPoint.getZoom() / d : -1.0;
            vector2 = vector2.times(dArray[0]).minus(viewPoint.getDirection());
            dArray[1] = vector2.dot(viewPoint.getSide());
            dArray[2] = vector2.dot(viewPoint.getUp());
            return new Vector(dArray);
        }
        if (viewPoint.getProjectionType() == 1) {
            double d = structure.getCenter().minus(viewPoint.getPosition()).norm();
            dArray[3] = vector2.dot(viewPoint.getDirection());
            dArray[0] = vector2.dot(viewPoint.getDirection()) > 0.0 ? viewPoint.getZoom() / d : -1.0;
            vector2 = vector2.times(dArray[0]).projectionOnPlane(viewPoint.getDirection());
            dArray[1] = vector2.dot(viewPoint.getSide());
            dArray[2] = vector2.dot(viewPoint.getUp());
            return new Vector(dArray);
        }
        if (viewPoint.getProjectionType() == 2) {
            double d = vector2.norm();
            dArray[0] = vector2.dot(viewPoint.getDirection()) > 0.0 ? viewPoint.getZoom() / d : -1.0;
            vector2 = vector2.unit();
            Vector vector3 = viewPoint.getDirection().unit();
            Vector vector4 = vector2.projectionOnPlane(vector3).unit();
            double d2 = Math.acos(vector2.dot(vector3));
            double d3 = 0.0;
            double d4 = 0.0;
            if (d2 != 0.0) {
                d3 = vector4.dot(viewPoint.getSide());
                d4 = vector4.dot(viewPoint.getUp());
            }
            dArray[1] = d3 * d2 * viewPoint.getZoom();
            dArray[2] = d4 * d2 * viewPoint.getZoom();
            return new Vector(dArray);
        }
        return null;
    }

    public Projection[] getProjections() {
        return this.projections;
    }

    public Vector[] getCellProjections() {
        return this.cellProjections;
    }

    public int getNumberOfVisibleAtoms() {
        return this.visibleAtoms;
    }

    public int[] coversScreenPoint(int n, int n2) {
        boolean[] blArray = new boolean[this.projections.length];
        int n3 = 0;
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.projections[i].coversScreenPoint(n, n2, this.width, this.height);
            if (!blArray[i]) continue;
            ++n3;
        }
        int[] nArray = new int[n3];
        int n4 = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            nArray[n4] = this.projections[i].getIndex();
            ++n4;
        }
        return nArray;
    }
}

