/*
 * Decompiled with CFR 0.152.
 */
class VectorNormOperator
extends Operator {
    public VectorNormOperator() {
        this.opType = "norm";
        this.nArgs = 1;
        this.argType = 1;
        this.isSingle = true;
        this.arguments = new String[1];
        this.arguments[0] = "vector";
        this.name = "vector norm";
        this.description = "Gives the euclidian norm of a vector.";
    }

    @Override
    public boolean isSingleOperator() {
        return true;
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock) {
        Variable variable;
        try {
            variable = (Variable)formulaBlock;
        }
        catch (Exception exception) {
            VariableSet variableSet = (VariableSet)formulaBlock;
            if (variableSet.countElements() == this.nArgs) {
                variable = variableSet.getElement(0);
            }
            System.out.println(this.opType + " cannot operate on " + variableSet);
            return new Variable("NaN", Double.NaN);
        }
        double[][] dArray = variable.getMatrixValue();
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                d += dArray[i][j] * dArray[i][j];
            }
        }
        d = Math.sqrt(d);
        return new Variable("r", d);
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock, FormulaBlock formulaBlock2) {
        return new Variable("NaN", Double.NaN);
    }
}

