/*
 * Decompiled with CFR 0.152.
 */
class VectorDotOperator
extends Operator {
    public VectorDotOperator() {
        this.opType = "dot";
        this.nArgs = 2;
        this.argType = 1;
        this.isSingle = true;
        this.arguments = new String[2];
        this.arguments[0] = "vector1";
        this.arguments[1] = "vector2";
        this.name = "vector dot product";
        this.description = "Gives the standard dot product of two vectors.";
    }

    @Override
    public boolean isSingleOperator() {
        return true;
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock) {
        int n;
        int n2;
        VariableSet variableSet = (VariableSet)formulaBlock;
        if (variableSet.countElements() != this.nArgs) {
            System.out.println(this.opType + " cannot operate on " + variableSet);
            return new Variable("NaN", Double.NaN);
        }
        Variable[] variableArray = variableSet.getSet();
        double[][] dArray = variableArray[0].getMatrixValue();
        double[][] dArray2 = variableArray[1].getMatrixValue();
        if (dArray.length * dArray[0].length != dArray2.length * dArray2[0].length) {
            System.out.println(this.opType + " can only operate on two equal sized vectors");
            return new Variable("NaN", Double.NaN);
        }
        double[][] dArray3 = new double[dArray.length * dArray[0].length][2];
        int n3 = 0;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < dArray[0].length; ++n) {
                dArray3[n3][0] = dArray[n2][n];
                ++n3;
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            for (n = 0; n < dArray2[0].length; ++n) {
                dArray3[n3][1] = dArray2[n2][n];
                ++n3;
            }
        }
        double d = 0.0;
        for (int i = 0; i < dArray3.length; ++i) {
            d += dArray3[i][0] * dArray3[i][1];
        }
        return new Variable("r", d);
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock, FormulaBlock formulaBlock2) {
        return new Variable("NaN", Double.NaN);
    }
}

