/*
 * Decompiled with CFR 0.152.
 */
class VectorCrossOperator
extends Operator {
    public VectorCrossOperator() {
        this.opType = "cross";
        this.nArgs = 2;
        this.argType = 1;
        this.isSingle = true;
        this.arguments = new String[2];
        this.arguments[0] = "vector1";
        this.arguments[1] = "vector2";
        this.name = "vector cross product";
        this.description = "Gives the standard cross product of two vectors.";
    }

    @Override
    public boolean isSingleOperator() {
        return true;
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock) {
        int n;
        int n2;
        VariableSet variableSet = (VariableSet)formulaBlock;
        if (variableSet.countElements() != this.nArgs) {
            System.out.println(this.opType + " cannot operate on " + variableSet);
            return new Variable("NaN", Double.NaN);
        }
        Variable[] variableArray = variableSet.getSet();
        double[][] dArray = variableArray[0].getMatrixValue();
        double[][] dArray2 = variableArray[1].getMatrixValue();
        if (dArray.length * dArray[0].length != dArray2.length * dArray2[0].length || dArray.length * dArray[0].length != 3) {
            System.out.println(this.opType + " can only operate on two vectors of three elements");
            return new Variable("NaN", Double.NaN);
        }
        double[][] dArray3 = new double[3][2];
        int n3 = 0;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < dArray[0].length; ++n) {
                dArray3[n3][0] = dArray[n2][n];
                ++n3;
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            for (n = 0; n < dArray2[0].length; ++n) {
                dArray3[n3][1] = dArray2[n2][n];
                ++n3;
            }
        }
        double[][] dArray4 = new double[1][3];
        dArray4[0][0] = dArray3[1][0] * dArray3[2][1] - dArray3[2][0] * dArray3[1][1];
        dArray4[0][1] = dArray3[2][0] * dArray3[0][1] - dArray3[0][0] * dArray3[2][1];
        dArray4[0][2] = dArray3[0][0] * dArray3[1][1] - dArray3[1][0] * dArray3[0][1];
        return new Variable("r", dArray4);
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock, FormulaBlock formulaBlock2) {
        return new Variable("NaN", Double.NaN);
    }
}

