/*
 * Decompiled with CFR 0.152.
 */
public class Vector {
    private double[] vec;
    private int dimension;

    public Vector() {
        this.dimension = 3;
        this.vec = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            this.vec[i] = 0.0;
        }
    }

    public Vector(int n) {
        this.dimension = n;
        this.vec = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            this.vec[i] = 0.0;
        }
    }

    public Vector(double[] dArray) {
        this.dimension = dArray.length;
        this.vec = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            this.vec[i] = dArray[i];
        }
    }

    public Vector(double d, double d2, double d3) {
        double[] dArray = new double[]{d, d2, d3};
        this.vec = dArray;
        this.dimension = 3;
    }

    public Vector copy() {
        double[] dArray = new double[this.vec.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.vec[i];
        }
        return new Vector(dArray);
    }

    public double element(int n) {
        if (n >= 0 && n < this.dimension) {
            return this.vec[n];
        }
        return 0.0;
    }

    public void setElement(int n, double d) {
        if (n >= 0 && n < this.dimension) {
            this.vec[n] = d;
        }
    }

    public double[] toArray() {
        return this.vec;
    }

    public double[][] toHorizontalVector() {
        double[][] dArray = new double[1][this.vec.length];
        for (int i = 0; i < this.vec.length; ++i) {
            dArray[0][i] = this.vec[i];
        }
        return dArray;
    }

    public double[][] toVerticalVector() {
        double[][] dArray = new double[this.vec.length][1];
        for (int i = 0; i < this.vec.length; ++i) {
            dArray[i][0] = this.vec[i];
        }
        return dArray;
    }

    public int dimension() {
        return this.dimension;
    }

    public Vector plus(double d) {
        double[] dArray = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            dArray[i] = this.vec[i] + d;
        }
        return new Vector(dArray);
    }

    public Vector minus(double d) {
        double[] dArray = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            dArray[i] = this.vec[i] - d;
        }
        return new Vector(dArray);
    }

    public Vector times(double d) {
        double[] dArray = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            dArray[i] = this.vec[i] * d;
        }
        return new Vector(dArray);
    }

    public Vector dividedBy(double d) {
        double[] dArray = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            dArray[i] = this.vec[i] / d;
        }
        return new Vector(dArray);
    }

    public Vector plus(Vector vector) {
        int n = Math.min(this.dimension, vector.dimension);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.vec[i] + vector.element(i);
        }
        return new Vector(dArray);
    }

    public Vector minus(Vector vector) {
        int n = Math.min(this.dimension, vector.dimension);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.vec[i] - vector.element(i);
        }
        return new Vector(dArray);
    }

    public Vector elementwiseProduct(Vector vector) {
        int n = Math.min(this.dimension, vector.dimension);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.vec[i] * vector.element(i);
        }
        return new Vector(dArray);
    }

    public Vector elementwiseDivision(Vector vector) {
        int n = Math.min(this.dimension, vector.dimension);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.vec[i] / vector.element(i);
        }
        return new Vector(dArray);
    }

    public double dot(Vector vector) {
        int n = Math.min(this.dimension, vector.dimension);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.vec[i] * vector.element(i);
        }
        return d;
    }

    public Vector cross(Vector vector) {
        double[] dArray = new double[3];
        if (this.dimension >= 3 && vector.dimension >= 3) {
            double[] dArray2 = vector.toArray();
            dArray[0] = this.vec[1] * dArray2[2] - this.vec[2] * dArray2[1];
            dArray[1] = this.vec[2] * dArray2[0] - this.vec[0] * dArray2[2];
            dArray[2] = this.vec[0] * dArray2[1] - this.vec[1] * dArray2[0];
        } else {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            dArray[2] = 0.0;
        }
        return new Vector(dArray);
    }

    public double norm() {
        double d = 0.0;
        for (int i = 0; i < this.dimension; ++i) {
            d += this.vec[i] * this.vec[i];
        }
        return Math.sqrt(d);
    }

    public Vector unit() {
        return this.dividedBy(this.norm());
    }

    public Vector resetDimensionality(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.dimension > i ? this.vec[i] : 0.0;
        }
        return new Vector(dArray);
    }

    public Quaternion quaternionize() {
        return new Quaternion(0.0, this.vec[0], this.vec[1], this.vec[2]);
    }

    public Vector rotate(Quaternion quaternion) {
        Quaternion quaternion2 = this.quaternionize();
        Quaternion quaternion3 = quaternion.times(quaternion2).times(quaternion.conjugate());
        return quaternion3.vectorize();
    }

    public Vector rotate(Vector vector, double d) {
        Quaternion quaternion = new Quaternion(vector, d);
        return this.rotate(quaternion);
    }

    public Vector projectionOnPlane(Vector vector) {
        return this.minus(this.projectionOnVector(vector));
    }

    public Vector projectionOnVector(Vector vector) {
        Vector vector2 = vector.unit();
        return vector2.times(this.dot(vector2));
    }

    public Vector matMul(double[][] dArray) throws Exception {
        if (this.dimension == dArray[0].length) {
            double[] dArray2 = new double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[i] = 0.0;
                for (int j = 0; j < dArray[0].length; ++j) {
                    int n = i;
                    dArray2[n] = dArray2[n] + dArray[i][j] * this.vec[j];
                }
            }
            return new Vector(dArray2);
        }
        throw new Exception();
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.dimension; ++i) {
            string = string + this.vec[i] + "  ";
        }
        return string;
    }

    public Vector inversionByPlane(Vector vector, Vector vector2) {
        return this.minus(this.minus(vector2).projectionOnVector(vector).times(2.0));
    }
}

