/*
 * Decompiled with CFR 0.152.
 */
public class Variable
implements FormulaBlock {
    private double[][] value;
    private String name;

    public Variable(String string, double d) {
        this.value = new double[1][1];
        this.value[0][0] = d;
        this.name = string;
    }

    public Variable(String string, double[][] dArray) {
        this.value = dArray;
        this.name = string;
    }

    public Variable copy() {
        Variable variable = new Variable(this.name, 0.0);
        variable.value = new double[this.value.length][this.value[0].length];
        for (int i = 0; i < this.value.length; ++i) {
            for (int j = 0; j < this.value[0].length; ++j) {
                variable.value[i][j] = this.value[i][j];
            }
        }
        return variable;
    }

    public int getHeight() {
        return this.value.length;
    }

    public int getWidth() {
        return this.value[0].length;
    }

    public double[][] getMatrixValue() {
        return this.value;
    }

    public double getValue() {
        return this.value[0][0];
    }

    public double getValue(int n, int n2) {
        if (n >= 0 && n < this.value.length && n2 >= 0 && n2 < this.value[n].length) {
            return this.value[n][n2];
        }
        return 0.0;
    }

    public int getIntValue() {
        return (int)(this.value[0][0] + 1.0E-7);
    }

    public void setValue(double d) {
        this.value[0][0] = d;
    }

    public void setValue(int n) {
        this.value[0][0] = n;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        String string = "";
        if (this.value.length > 1 || this.value[0].length > 1) {
            string = string + "[ ";
        }
        for (int i = 0; i < this.value.length; ++i) {
            if (this.value.length > 1) {
                string = string + "[ ";
            }
            for (int j = 0; j < this.value[i].length; ++j) {
                string = string + FileHandler.formattedDouble(this.value[i][j], 12, 6);
                if (j < this.value[i].length - 1) {
                    string = string + ",";
                }
                string = string + " ";
            }
            if (this.value.length <= 1) continue;
            string = string + "] ";
        }
        if (this.value.length > 1 || this.value[0].length > 1) {
            string = string + "]";
        }
        return string;
    }

    public String getMatrixString() {
        String string = "";
        for (int i = 0; i < this.value.length; ++i) {
            for (int j = 0; j < this.value[i].length; ++j) {
                string = string + FileHandler.formattedDouble(this.value[i][j], 12, 8) + " ";
            }
            if (this.value.length <= 1) continue;
            string = string + "\n";
        }
        return string;
    }

    @Override
    public boolean isOperator() {
        return false;
    }

    @Override
    public boolean isCustomFunction() {
        return false;
    }
}

