/*
 * Decompiled with CFR 0.152.
 */
class TimesOperator
extends Operator {
    public TimesOperator() {
        this.opType = "*";
        this.nArgs = 2;
        this.argType = 2;
        this.isDouble = true;
        this.isMultiplier = true;
        this.arguments = new String[2];
        this.arguments[0] = "x";
        this.arguments[1] = "y";
        this.name = "multiplication";
        this.description = "Multiplication of two variables. For matrices, normal matrix multiplication is done.";
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock) {
        return new Variable("NaN", Double.NaN);
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock, FormulaBlock formulaBlock2) {
        double[][] dArray = ((Variable)formulaBlock).getMatrixValue();
        double[][] dArray2 = ((Variable)formulaBlock2).getMatrixValue();
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray2.length;
        int n4 = dArray2[0].length;
        Object object = new double[][]{{Double.NaN}};
        if (n2 == n3) {
            object = new double[n][n4];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n4; ++j) {
                    object[i][j] = 0.0;
                    for (int k = 0; k < n2; ++k) {
                        double[] dArray3 = object[i];
                        int n5 = j;
                        dArray3[n5] = dArray3[n5] + dArray[i][k] * dArray2[k][j];
                    }
                }
            }
        } else if (n2 == n4 && n == n3 && n2 != n) {
            object = new double[n][n2];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    object[i][j] = dArray[i][j] * dArray2[i][j];
                }
            }
        } else if (n2 == 1 && n == 1) {
            object = new double[n3][n4];
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    object[i][j] = dArray[0][0] * dArray2[i][j];
                }
            }
        } else if (n4 == 1 && n3 == 1) {
            object = new double[n][n2];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    object[i][j] = dArray[i][j] * dArray2[0][0];
                }
            }
        } else {
            System.out.println("Incompatible dimensions in matrix multiplication.");
            object = new double[0][0];
            object[0][0] = Double.NaN;
        }
        return new Variable("r", (double[][])object);
    }
}

