/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.ArrayList;

public class Structure {
    private ArrayList<Particle> particles = new ArrayList();
    private Vector center;
    private Vector[] cell;
    private boolean[] pbc;
    private double[][] inverseCell;
    private String name;

    public Structure(Atom[] atomArray, Cluster[] clusterArray) {
        int n;
        for (n = 0; n < atomArray.length; ++n) {
            this.particles.add(atomArray[n]);
        }
        for (n = 0; n < clusterArray.length; ++n) {
            this.particles.add(clusterArray[n]);
        }
        this.center = new Vector(3);
        this.calculateCenter();
        this.cell = new Vector[3];
        this.cell[0] = new Vector(1.0, 0.0, 0.0);
        this.cell[1] = new Vector(0.0, 1.0, 0.0);
        this.cell[2] = new Vector(0.0, 0.0, 1.0);
        try {
            this.inverseCell = this.inverseCell();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pbc = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            this.pbc[i] = false;
        }
        this.name = "";
    }

    public Structure(Particle[] particleArray) {
        for (int i = 0; i < particleArray.length; ++i) {
            this.particles.add(particleArray[i]);
        }
        this.calculateCenter();
        this.cell = new Vector[3];
        this.cell[0] = new Vector(1.0, 0.0, 0.0);
        this.cell[1] = new Vector(0.0, 1.0, 0.0);
        this.cell[2] = new Vector(0.0, 0.0, 1.0);
        try {
            this.inverseCell = this.inverseCell();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pbc = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            this.pbc[i] = false;
        }
        this.name = "";
    }

    public Structure copy() {
        Structure structure = new Structure(new Particle[0]);
        structure.particles = new ArrayList();
        for (int i = 0; i < this.particles.size(); ++i) {
            structure.particles.add(this.particles.get(i).copy());
        }
        structure.calculateCenter();
        structure.cell = new Vector[3];
        structure.cell[0] = this.cell[0].copy();
        structure.cell[1] = this.cell[1].copy();
        structure.cell[2] = this.cell[2].copy();
        try {
            structure.inverseCell = structure.inverseCell();
        }
        catch (Exception exception) {
            // empty catch block
        }
        structure.pbc = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            structure.pbc[i] = this.pbc[i];
        }
        structure.name = this.name;
        return structure;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public boolean setCell(Vector[] vectorArray, boolean[] blArray) throws Exception {
        Vector[] vectorArray2 = new Vector[3];
        for (int i = 0; i < 3; ++i) {
            vectorArray2[i] = this.cell[i].copy();
        }
        this.cell = vectorArray;
        this.pbc = blArray;
        try {
            this.inverseCell = this.inverseCell();
            return true;
        }
        catch (Exception exception) {
            this.cell = vectorArray2;
            return false;
        }
    }

    public Vector[] getCell() {
        return this.cell;
    }

    public Vector[] getCellCopy() {
        Vector[] vectorArray = new Vector[3];
        for (int i = 0; i < 3; ++i) {
            vectorArray[i] = this.cell[i].copy();
        }
        return vectorArray;
    }

    public boolean[] getBoundaryConditions() {
        return this.pbc;
    }

    public void calculateCenter() {
        if (!ASH.runningScript) {
            int n;
            double[] dArray = new double[3];
            int n2 = 0;
            for (n = 0; n < 3; ++n) {
                dArray[n] = 0.0;
            }
            for (n = 0; n < this.particles.size(); ++n) {
                int n3 = this.particles.get(n).countAtoms();
                for (int i = 0; i < 3; ++i) {
                    int n4 = i;
                    dArray[n4] = dArray[n4] + this.particles.get(n).getCoordinates().element(i) * (double)n3;
                }
                n2 += n3;
            }
            if (n2 > 0) {
                n = 0;
                while (n < 3) {
                    int n5 = n++;
                    dArray[n5] = dArray[n5] / (double)n2;
                }
            }
            this.center = new Vector(dArray);
        }
    }

    public Vector getCenter() {
        if (this.center == null) {
            this.calculateCenter();
        }
        return this.center;
    }

    public ArrayList<Particle> getParticles() {
        return this.particles;
    }

    public Particle getParticle(int n) {
        return this.particles.get(n);
    }

    public Atom[] getAllAtoms() {
        Atom[] atomArray = new Atom[this.countAllAtoms()];
        int n = 0;
        for (int i = 0; i < this.countParticles(); ++i) {
            Atom[] atomArray2 = this.particles.get(i).getAtoms();
            for (int j = 0; j < atomArray2.length; ++j) {
                atomArray[n] = atomArray2[j];
                ++n;
            }
        }
        return atomArray;
    }

    public int countAllAtoms() {
        int n = 0;
        for (int i = 0; i < this.countParticles(); ++i) {
            n += this.particles.get(i).countAtoms();
        }
        return n;
    }

    public void addParticles(Particle[] particleArray) {
        for (int i = 0; i < particleArray.length; ++i) {
            this.particles.add(particleArray[i]);
        }
        this.calculateCenter();
    }

    public void addParticle(Particle particle) {
        this.particles.add(particle);
        this.calculateCenter();
    }

    public void addParticle(int n, Particle particle) {
        this.particles.add(n, particle);
        this.calculateCenter();
    }

    public void addParticle(Particle particle, boolean bl) {
        this.particles.add(particle);
        if (bl) {
            this.calculateCenter();
        }
    }

    public void addParticle(int n, Particle particle, boolean bl) {
        this.particles.add(n, particle);
        if (bl) {
            this.calculateCenter();
        }
    }

    public void removeParticle(int n) throws Exception {
        this.particles.remove(n);
    }

    public void forcePeriodicBounds() {
        try {
            if (this.pbc[0] || this.pbc[1] || this.pbc[2]) {
                for (int i = 0; i < this.particles.size(); ++i) {
                    this.particles.get(i).setCoordinates(this.accountForPeriodicity(this.particles.get(i).getCoordinates()));
                }
            }
        }
        catch (Exception exception) {
            System.out.println("invalid supercell");
        }
    }

    public Vector getDirectCoordinates(Vector vector) {
        try {
            Vector vector2 = vector.matMul(this.inverseCell);
            return vector2;
        }
        catch (Exception exception) {
            return vector;
        }
    }

    public Vector getCartesianCoordinates(Vector vector) {
        Vector vector2 = this.cell[0].times(vector.element(0)).plus(this.cell[1].times(vector.element(1))).plus(this.cell[2].times(vector.element(2)));
        return vector2;
    }

    public Vector accountForPeriodicity(Vector vector) {
        try {
            Vector vector2 = vector.matMul(this.inverseCell);
            for (int i = 0; i < 3; ++i) {
                if (!this.pbc[i]) continue;
                vector2.setElement(i, vector2.element(i) - Math.floor(vector2.element(i)));
            }
            Vector vector3 = this.cell[0].times(vector2.element(0)).plus(this.cell[1].times(vector2.element(1))).plus(this.cell[2].times(vector2.element(2)));
            return vector3;
        }
        catch (Exception exception) {
            return vector;
        }
    }

    public double[][] getInverseCell() {
        return this.inverseCell;
    }

    public void updateInverseCell() throws Exception {
        try {
            this.inverseCell = this.inverseCell();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public double[][] inverseCell() throws Exception {
        double[][] dArray = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                dArray[i][j] = this.cell[j].element(i);
            }
        }
        double[][] dArray2 = new double[3][3];
        double d = dArray[0][0] * (dArray[2][2] * dArray[1][1] - dArray[2][1] * dArray[1][2]) - dArray[1][0] * (dArray[2][2] * dArray[0][1] - dArray[2][1] * dArray[0][2]) + dArray[2][0] * (dArray[1][2] * dArray[0][1] + dArray[1][1] * dArray[0][2]);
        if (d == 0.0) {
            throw new Exception();
        }
        dArray2[0][0] = (dArray[2][2] * dArray[1][1] - dArray[2][1] * dArray[1][2]) / d;
        dArray2[0][1] = -(dArray[2][2] * dArray[0][1] - dArray[2][1] * dArray[0][2]) / d;
        dArray2[0][2] = (dArray[1][2] * dArray[0][1] - dArray[1][1] * dArray[0][2]) / d;
        dArray2[1][0] = -(dArray[2][2] * dArray[1][0] - dArray[2][0] * dArray[1][2]) / d;
        dArray2[1][1] = (dArray[2][2] * dArray[0][0] - dArray[2][0] * dArray[0][2]) / d;
        dArray2[1][2] = -(dArray[1][2] * dArray[0][0] - dArray[1][0] * dArray[0][2]) / d;
        dArray2[2][0] = (dArray[2][1] * dArray[1][0] - dArray[2][0] * dArray[1][1]) / d;
        dArray2[2][1] = -(dArray[2][1] * dArray[0][0] - dArray[2][0] * dArray[0][1]) / d;
        dArray2[2][2] = (dArray[1][1] * dArray[0][0] - dArray[1][0] * dArray[0][1]) / d;
        return dArray2;
    }

    public int countParticles() {
        return this.particles.size();
    }

    public int countPickedParticles() {
        int n = 0;
        for (int i = 0; i < this.particles.size(); ++i) {
            if (!this.particles.get(i).isPicked()) continue;
            ++n;
        }
        return n;
    }

    public void reIndex(Structure structure) {
        if (structure.isSimilarTo(this)) {
            int n;
            int n2;
            int[] nArray = new int[this.particles.size()];
            boolean[] blArray = new boolean[this.particles.size()];
            double[] dArray = new double[this.particles.size()];
            ArrayList<Particle> arrayList = new ArrayList<Particle>();
            for (n2 = 0; n2 < this.particles.size(); ++n2) {
                nArray[n2] = n2;
                blArray[n2] = !this.particles.get(n2).isPicked();
                dArray[n2] = blArray[n2] ? 0.0 : 9.99999999E8;
            }
            n2 = 5;
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < this.particles.size(); ++i) {
                    if (!(dArray[i] > (double)n * 0.5)) continue;
                    double d = 9.9999999999999E13;
                    for (int j = 0; j < this.particles.size(); ++j) {
                        double d2;
                        if (blArray[j] || !structure.getParticle(i).isSimilarTo(this.particles.get(j)) || !((d2 = this.distance(structure.getParticle(i).getCoordinates(), this.particles.get(j).getCoordinates())) < d) || n != n2 - 1 && !(d2 <= (double)(n + 1) * 0.5)) continue;
                        nArray[i] = j;
                        d = d2;
                    }
                    if (!(d < 9.9999999E7)) continue;
                    blArray[nArray[i]] = true;
                    dArray[i] = d;
                }
            }
            for (n = 0; n < this.particles.size(); ++n) {
                arrayList.add(this.particles.get(nArray[n]));
            }
            this.particles = arrayList;
        } else {
            System.out.println("cannot reindex different structures");
        }
    }

    public boolean isSimilarTo(Structure structure) {
        if (this.countParticles() != structure.countParticles()) {
            return false;
        }
        for (int i = 0; i < this.countParticles(); ++i) {
            if (this.particles.get(i).isSimilarTo(structure.getParticle(i))) continue;
            return false;
        }
        return true;
    }

    public static Structure interpolate(Structure structure, Structure structure2, double d) throws Exception {
        if (structure.isSimilarTo(structure2)) {
            Particle[] particleArray = new Particle[structure.countParticles()];
            for (int i = 0; i < structure.countParticles(); ++i) {
                Particle particle = structure.getParticle(i);
                Particle particle2 = structure2.getParticle(i);
                Vector vector = particle2.getCoordinates().minus(particle.getCoordinates()).times(d);
                particleArray[i] = particle.copy();
                particleArray[i].shiftCoordinates(vector);
                if (particle.isAtomic()) continue;
                Quaternion quaternion = particle.getOrientation();
                Quaternion quaternion2 = particle2.getOrientation();
                Quaternion quaternion3 = quaternion2.times(quaternion.inverse());
                Vector vector2 = quaternion3.rotationAxis();
                double d2 = quaternion3.rotationAngle();
                Quaternion quaternion4 = new Quaternion(vector2, d2 * d);
                particleArray[i].rotate(quaternion4);
            }
            Structure structure3 = new Structure(particleArray);
            structure3.setCell(structure.getCell(), structure.getBoundaryConditions());
            structure3.updateInverseCell();
            structure3.forcePeriodicBounds();
            return structure3;
        }
        throw new Exception();
    }

    public double distance(Vector vector, Vector vector2) {
        double d = 0.0;
        if (this.pbc[0] || this.pbc[1] || this.pbc[2]) {
            double d2 = 0.0;
            Vector vector3 = vector.minus(vector2);
            d = vector3.norm();
            for (int i = -1; i <= 1; ++i) {
                if (i != 0 && !this.pbc[0]) continue;
                for (int j = -1; j <= 1; ++j) {
                    if (j != 0 && !this.pbc[1]) continue;
                    for (int k = -1; k <= 1; ++k) {
                        if (k != 0 && !this.pbc[2] || !((d2 = vector3.plus(this.cell[0].times(i)).plus(this.cell[1].times(j)).plus(this.cell[2].times(k)).norm()) < d)) continue;
                        d = d2;
                    }
                }
            }
        } else {
            d = vector.minus(vector2).norm();
        }
        return d;
    }

    public int[] findElements() {
        int n;
        Atom[] atomArray = this.getAllAtoms();
        int[] nArray = new int[200];
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = 0;
        }
        for (n = 0; n < atomArray.length; ++n) {
            int n3 = atomArray[n].getElement();
            nArray[n3] = nArray[n3] + 1;
            if (nArray[atomArray[n].getElement()] != 1) continue;
            ++n2;
        }
        n = 0;
        int[] nArray2 = new int[n2];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            nArray2[n] = i;
            ++n;
        }
        return nArray2;
    }

    public int[] mapAtomsToParticles() {
        Atom[] atomArray = this.getAllAtoms();
        int[] nArray = new int[atomArray.length];
        int n = 0;
        for (int i = 0; i < this.countParticles(); ++i) {
            int n2 = this.particles.get(i).countAtoms();
            for (int j = 0; j < n2; ++j) {
                nArray[n] = i;
                ++n;
            }
        }
        return nArray;
    }

    public int[] countElements() {
        int n;
        Atom[] atomArray = this.getAllAtoms();
        int[] nArray = new int[200];
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = 0;
        }
        for (n = 0; n < atomArray.length; ++n) {
            int n3 = atomArray[n].getElement();
            nArray[n3] = nArray[n3] + 1;
            if (nArray[atomArray[n].getElement()] != 1) continue;
            ++n2;
        }
        int[] nArray2 = new int[n2];
        int n4 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            nArray2[n4] = nArray[i];
            ++n4;
        }
        return nArray2;
    }

    public int copyPart(Structure structure, boolean bl, boolean bl2) {
        if (bl) {
            this.particles.clear();
        }
        if (bl2) {
            Vector[] vectorArray = new Vector[3];
            boolean[] blArray = new boolean[3];
            for (int i = 0; i < 3; ++i) {
                vectorArray[i] = structure.getCell()[i].copy();
                blArray[i] = structure.getBoundaryConditions()[i];
            }
            try {
                this.setCell(vectorArray, blArray);
                this.updateInverseCell();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n = 0;
        for (int i = 0; i < structure.countParticles(); ++i) {
            if (!structure.getParticle(i).isPicked()) continue;
            this.addParticle(structure.getParticle(i).copy(), false);
            ++n;
        }
        return n;
    }

    public void updateElements() {
        Atom[] atomArray = this.getAllAtoms();
        for (int i = 0; i < atomArray.length; ++i) {
            int n = atomArray[i].getElement();
            atomArray[i].setElement(ASH.elementTable.getElement(n % ASH.elementTable.size()));
        }
    }

    public void recolorElements(int n) {
        Atom[] atomArray = this.getAllAtoms();
        for (int i = 0; i < atomArray.length; ++i) {
            if (atomArray[i].getElement() != n) continue;
            atomArray[i].setColor(ASH.elementTable.getElement(n % ASH.elementTable.size()).getColor());
        }
    }

    public void recolorParticle(int n, int n2, int n3, int n4, int n5) {
        Particle particle = this.particles.get(n);
        Atom[] atomArray = particle.getAtoms();
        for (int i = 0; i < atomArray.length; ++i) {
            atomArray[i].setColor(new Color(n2, n3, n4, n5));
        }
    }

    public void invertByPlane(Vector vector, Vector vector2) {
        for (int i = 0; i < this.particles.size(); ++i) {
            Particle particle = this.particles.get(i);
            if (!particle.isPicked()) continue;
            Vector vector3 = this.particles.get(i).getCoordinates();
            particle.setCoordinates(vector3.inversionByPlane(vector, vector2));
            if (particle.isAtomic()) continue;
            Cluster cluster = (Cluster)particle;
            cluster.invertByPlane(vector, vector2);
        }
    }

    public void removeDuplicates(double d) {
        for (int i = 0; i < this.particles.size() - 1; ++i) {
            Particle particle = this.particles.get(i);
            for (int j = i + 1; j < this.particles.size(); ++j) {
                Particle particle2 = this.particles.get(j);
                if (!particle.isSimilarTo(particle2) || !(this.distance(particle.getCoordinates(), particle2.getCoordinates()) < d)) continue;
                this.particles.remove(j);
                --j;
            }
        }
    }
}

