/*
 * Decompiled with CFR 0.152.
 */
class SquareRootOperator
extends Operator {
    public SquareRootOperator() {
        this.opType = "sqrt";
        this.nArgs = 1;
        this.argType = 1;
        this.isSingle = true;
        this.arguments = new String[1];
        this.arguments[0] = "x";
        this.name = "square root";
        this.description = "Evaluates the square root for the given argument.";
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock) {
        Object object;
        Variable variable;
        try {
            variable = (Variable)formulaBlock;
        }
        catch (Exception exception) {
            object = (VariableSet)formulaBlock;
            if (((VariableSet)object).countElements() == this.nArgs) {
                variable = ((VariableSet)object).getElement(0);
            }
            System.out.println(this.opType + " cannot operate on " + object);
            return new Variable("NaN", Double.NaN);
        }
        double[][] dArray = variable.getMatrixValue();
        object = new double[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                object[i][j] = Math.sqrt(dArray[i][j]);
            }
        }
        return new Variable("r", (double[][])object);
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock, FormulaBlock formulaBlock2) {
        return new Variable("NaN", Double.NaN);
    }
}

