/*
 * Decompiled with CFR 0.152.
 */
class RandomVariableOperator
extends Operator {
    public RandomVariableOperator() {
        this.opType = "rnd";
        this.nArgs = 1;
        this.argType = 1;
        this.isSingle = true;
        this.arguments = new String[1];
        this.arguments[0] = "x";
        this.name = "random number";
        this.description = "Generates a uniformly distributed random number from the range [0,x]. If x is a negative integer, a random integer from {0,...,-x} is generated instead.";
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock) {
        Object object;
        Variable variable;
        try {
            variable = (Variable)formulaBlock;
        }
        catch (Exception exception) {
            object = (VariableSet)formulaBlock;
            if (((VariableSet)object).countElements() == this.nArgs) {
                variable = ((VariableSet)object).getElement(0);
            }
            System.out.println(this.opType + " cannot operate on " + object);
            return new Variable("NaN", Double.NaN);
        }
        double[][] dArray = variable.getMatrixValue();
        object = new double[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                object[i][j] = dArray[i][j] > 0.0 ? (Object)(dArray[i][j] * ASH.RNG.nextDouble()) : (Object)ASH.RNG.nextInt((int)(-dArray[i][j]));
            }
        }
        return new Variable("r", (double[][])object);
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock, FormulaBlock formulaBlock2) {
        return new Variable("NaN", Double.NaN);
    }
}

