/*
 * Decompiled with CFR 0.152.
 */
public class Quaternion {
    private double[] qt = new double[]{0.0, 0.0, 0.0, 0.0};

    public Quaternion() {
        this.qt[0] = 0.0;
        this.qt[1] = 0.0;
        this.qt[2] = 0.0;
        this.qt[3] = 0.0;
    }

    public Quaternion(Vector vector, double d) {
        Vector vector2 = vector.dimension() == 3 ? vector.unit() : vector.resetDimensionality(3).unit();
        this.qt[0] = Math.cos(d / 2.0);
        double d2 = Math.sin(d / 2.0);
        this.qt[1] = vector2.element(0) * d2;
        this.qt[2] = vector2.element(1) * d2;
        this.qt[3] = vector2.element(2) * d2;
    }

    public Quaternion(double d, double d2, double d3, double d4) {
        this.qt[0] = d;
        this.qt[1] = d2;
        this.qt[2] = d3;
        this.qt[3] = d4;
    }

    public Quaternion(double[] dArray) {
        for (int i = 0; i < 4; ++i) {
            this.qt[i] = dArray.length > i ? dArray[i] : 0.0;
        }
    }

    public Quaternion copy() {
        return new Quaternion(this.qt[0], this.qt[1], this.qt[2], this.qt[3]);
    }

    public double element(int n) {
        if (n >= 0 && n < 4) {
            return this.qt[n];
        }
        return 0.0;
    }

    public double[] toArray() {
        return this.qt;
    }

    public Quaternion plus(double d) {
        double[] dArray = new double[4];
        for (int i = 0; i < 4; ++i) {
            dArray[i] = this.qt[i] + d;
        }
        return new Quaternion(dArray);
    }

    public Quaternion minus(double d) {
        double[] dArray = new double[4];
        for (int i = 0; i < 4; ++i) {
            dArray[i] = this.qt[i] - d;
        }
        return new Quaternion(dArray);
    }

    public Quaternion times(double d) {
        double[] dArray = new double[4];
        for (int i = 0; i < 4; ++i) {
            dArray[i] = this.qt[i] * d;
        }
        return new Quaternion(dArray);
    }

    public Quaternion dividedBy(double d) {
        double[] dArray = new double[4];
        for (int i = 0; i < 4; ++i) {
            dArray[i] = this.qt[i] / d;
        }
        return new Quaternion(dArray);
    }

    public Quaternion plus(Quaternion quaternion) {
        double[] dArray = new double[4];
        for (int i = 0; i < 4; ++i) {
            dArray[i] = this.qt[i] + quaternion.element(i);
        }
        return new Quaternion(dArray);
    }

    public Quaternion minus(Quaternion quaternion) {
        double[] dArray = new double[4];
        for (int i = 0; i < 4; ++i) {
            dArray[i] = this.qt[i] - quaternion.element(i);
        }
        return new Quaternion(dArray);
    }

    public Quaternion times(Quaternion quaternion) {
        double[] dArray = new double[4];
        double[] dArray2 = quaternion.toArray();
        dArray[0] = this.qt[0] * dArray2[0] - this.qt[1] * dArray2[1] - this.qt[2] * dArray2[2] - this.qt[3] * dArray2[3];
        dArray[1] = this.qt[0] * dArray2[1] + this.qt[1] * dArray2[0] + this.qt[2] * dArray2[3] - this.qt[3] * dArray2[2];
        dArray[2] = this.qt[0] * dArray2[2] - this.qt[1] * dArray2[3] + this.qt[2] * dArray2[0] + this.qt[3] * dArray2[1];
        dArray[3] = this.qt[0] * dArray2[3] + this.qt[1] * dArray2[2] - this.qt[2] * dArray2[1] + this.qt[3] * dArray2[0];
        return new Quaternion(dArray);
    }

    public Quaternion conjugate() {
        double[] dArray = new double[]{this.qt[0], -this.qt[1], -this.qt[2], -this.qt[3]};
        return new Quaternion(dArray);
    }

    public double norm() {
        return Math.sqrt(this.qt[0] * this.qt[0] + this.qt[1] * this.qt[1] + this.qt[2] * this.qt[2] + this.qt[3] * this.qt[3]);
    }

    public Quaternion inverse() {
        return this.conjugate().dividedBy(this.norm());
    }

    public Quaternion unit() {
        return this.dividedBy(this.norm());
    }

    public boolean isUnit() {
        return Math.abs(this.unit().norm() - 1.0) < 1.0E-8;
    }

    public double rotationAngle() {
        return 2.0 * Math.acos(this.element(0));
    }

    public Vector rotationAxis() {
        double d = Math.sin(this.rotationAngle());
        if (d != 0.0) {
            double[] dArray = new double[]{this.qt[1] / d, this.qt[2] / d, this.qt[3] / d};
            return new Vector(dArray);
        }
        double[] dArray = new double[]{0.0, 0.0, 1.0};
        return new Vector(dArray);
    }

    public double[][] rotationMatrix() {
        double[][] dArray = new double[3][3];
        dArray[0][0] = 1.0 - 2.0 * (this.qt[2] * this.qt[2] + this.qt[3] * this.qt[3]);
        dArray[0][1] = 2.0 * (this.qt[1] * this.qt[2] - this.qt[0] * this.qt[3]);
        dArray[0][2] = 2.0 * (this.qt[1] * this.qt[3] + this.qt[0] * this.qt[2]);
        dArray[1][0] = 2.0 * (this.qt[1] * this.qt[2] + this.qt[0] * this.qt[3]);
        dArray[1][1] = 1.0 - 2.0 * (this.qt[1] * this.qt[1] + this.qt[3] * this.qt[3]);
        dArray[1][2] = 2.0 * (this.qt[2] * this.qt[3] - this.qt[0] * this.qt[1]);
        dArray[2][0] = 2.0 * (this.qt[1] * this.qt[3] - this.qt[0] * this.qt[2]);
        dArray[2][1] = 2.0 * (this.qt[2] * this.qt[3] + this.qt[0] * this.qt[1]);
        dArray[2][2] = 1.0 - 2.0 * (this.qt[2] * this.qt[2] + this.qt[1] * this.qt[1]);
        return dArray;
    }

    public Vector vectorize() {
        double[] dArray = new double[]{this.qt[1], this.qt[2], this.qt[3]};
        return new Vector(dArray);
    }
}

