/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;

public class Projection
implements Comparable {
    private int index;
    private double x;
    private double y;
    private double r;
    private Color color;
    private Color lineColor;
    private double depth;

    public Projection(int n) {
        this.index = n;
        this.x = -100.0;
        this.y = -100.0;
        this.r = 0.0;
        this.color = View.white;
        this.lineColor = View.black;
        this.depth = -100.0;
    }

    public int getIndex() {
        return this.index;
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setY(double d) {
        this.y = d;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setRadius(double d) {
        this.r = d;
    }

    public double getRadius() {
        return this.r;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setDepth(double d) {
        this.depth = d;
    }

    public double getDepth() {
        return this.depth;
    }

    public int compareTo(Object object) {
        Projection projection = (Projection)object;
        if (this.depth < projection.depth) {
            return 1;
        }
        if (this.depth > projection.depth) {
            return -1;
        }
        if (this.index < projection.index) {
            return 1;
        }
        if (this.index > projection.index) {
            return -1;
        }
        return 0;
    }

    public boolean isVisible() {
        return !(this.depth < 0.0);
    }

    public Shape getAtomicShape(int n, int n2) {
        double d = this.r * 100.0 * View.displayRadiusMultiplier;
        double d2 = this.x * 100.0 + (double)(n / 2);
        double d3 = -this.y * 100.0 + (double)(n2 / 2);
        return new Ellipse2D.Double(d2 - d, d3 - d, 2.0 * d, 2.0 * d);
    }

    public boolean coversScreenPoint(int n, int n2, int n3, int n4) {
        double d = this.r * 100.0 * View.displayRadiusMultiplier;
        double d2 = this.x * 100.0 + (double)(n3 / 2);
        double d3 = -this.y * 100.0 + (double)(n4 / 2);
        double d4 = Math.sqrt((d2 - (double)n) * (d2 - (double)n) + (d3 - (double)n2) * (d3 - (double)n2));
        return d4 < d;
    }

    public boolean coversPoint(int n, int n2) {
        double d = Math.sqrt((this.x - (double)n) * (this.x - (double)n) + (this.y - (double)n2) * (this.y - (double)n2));
        return d < this.r;
    }
}

