/*
 * Decompiled with CFR 0.152.
 */
class PowerOperator
extends Operator {
    public PowerOperator() {
        this.opType = "^";
        this.nArgs = 2;
        this.argType = 2;
        this.isDouble = true;
        this.isPower = true;
        this.arguments = new String[2];
        this.arguments[0] = "x";
        this.arguments[1] = "y";
        this.name = "power";
        this.description = "Calculates the power function for arbitrary real base and exponent.";
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock) {
        return new Variable("NaN", Double.NaN);
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock, FormulaBlock formulaBlock2) {
        double[][] dArray = ((Variable)formulaBlock).getMatrixValue();
        double[][] dArray2 = ((Variable)formulaBlock2).getMatrixValue();
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray2.length;
        int n4 = dArray2[0].length;
        Object object = new double[][]{{Double.NaN}};
        if (n2 == n4 && n == n3) {
            object = new double[n][n2];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    object[i][j] = Math.pow(dArray[i][j], dArray2[i][j]);
                }
            }
        } else if (n2 == 1 && n == 1) {
            object = new double[n3][n4];
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    object[i][j] = Math.pow(dArray[0][0], dArray2[i][j]);
                }
            }
        } else if (n4 == 1 && n3 == 1 && n2 != n) {
            object = new double[n][n2];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    object[i][j] = Math.pow(dArray[i][j], dArray2[0][0]);
                }
            }
        } else if (n4 == 1 && n3 == 1 && n2 == n) {
            int n5;
            int n6;
            object = new double[n][n2];
            double[][] dArray3 = new double[n][n2];
            for (n6 = 0; n6 < n; ++n6) {
                for (n5 = 0; n5 < n2; ++n5) {
                    dArray3[n6][n5] = n6 == n5 ? 1.0 : 0.0;
                }
            }
            n6 = (int)dArray2[0][0];
            for (n5 = 0; n5 < n6; ++n5) {
                int n7;
                int n8;
                for (n8 = 0; n8 < n; ++n8) {
                    for (n7 = 0; n7 < n2; ++n7) {
                        object[n8][n7] = 0.0;
                        for (int i = 0; i < n2; ++i) {
                            double[] dArray4 = object[n8];
                            int n9 = n7;
                            dArray4[n9] = dArray4[n9] + dArray[n8][i] * dArray3[i][n7];
                        }
                    }
                }
                if (n5 >= n6) continue;
                for (n8 = 0; n8 < n; ++n8) {
                    for (n7 = 0; n7 < n2; ++n7) {
                        dArray3[n8][n7] = object[n8][n7];
                    }
                }
            }
        } else {
            System.out.println("Incompatible dimensions in matrix power.");
            object = new double[0][0];
            object[0][0] = Double.NaN;
        }
        return new Variable("r", (double[][])object);
    }
}

