/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.image.BufferStrategy;

public abstract class Painter
extends Canvas {
    protected BufferStrategy strategy;
    protected boolean leftPressed;
    protected boolean rightPressed;
    protected boolean upPressed;
    protected boolean downPressed;
    protected boolean nextPressed;
    protected boolean prevPressed;
    protected boolean shiftPressed;
    protected boolean rotPressed;
    protected boolean mousePressed;
    protected int wheelClicks = 0;
    protected boolean stillActive = true;
    protected int dragStartX;
    protected int dragStartY;
    protected int dragX;
    protected int dragY;

    public void initializeBuffer() {
        this.createBufferStrategy(2);
        this.strategy = this.getBufferStrategy();
    }

    public void startInteraction() {
        CommandHandler commandHandler = new CommandHandler(this);
        Thread thread = new Thread(commandHandler);
        thread.start();
    }

    public abstract void paint(long var1);

    public void resolveCommands() {
    }

    public void recordSize(int n, int n2) {
    }

    public void pressLeft() {
        this.leftPressed = true;
    }

    public void pressRight() {
        this.rightPressed = true;
    }

    public void pressUp() {
        this.upPressed = true;
    }

    public void pressDown() {
        this.downPressed = true;
    }

    public void pressNext() {
        this.nextPressed = true;
    }

    public void pressPrevious() {
        this.prevPressed = true;
    }

    public void pressShift(ASH aSH) {
        System.out.println("Mouse shift mode on.");
        this.shiftPressed = true;
        aSH.rememberStructure();
    }

    public void pressRotate(ASH aSH) {
        System.out.println("Mouse rotate mode on.");
        aSH.rememberStructure();
        this.rotPressed = true;
    }

    public void releaseLeft() {
        this.leftPressed = false;
    }

    public void releaseRight() {
        this.rightPressed = false;
    }

    public void releaseUp() {
        this.upPressed = false;
    }

    public void releaseDown() {
        this.downPressed = false;
    }

    public void releaseNext() {
        this.nextPressed = false;
    }

    public void releasePrevious() {
        this.prevPressed = false;
    }

    public void releaseShift() {
        System.out.println("Mouse shift mode off.");
        this.shiftPressed = false;
    }

    public void releaseRotate() {
        System.out.println("Mouse rotate mode off.");
        this.rotPressed = false;
    }

    public void mousePressed(int n, int n2) {
        this.mousePressed = true;
        this.dragStartX = n;
        this.dragStartY = n2;
        this.dragX = n;
        this.dragY = n2;
    }

    public void mouseClicked(int n, int n2, int n3) {
    }

    public void mouseReleased(int n, int n2) {
        this.mousePressed = false;
    }

    public void mouseDragged(int n, int n2) {
        this.dragX = n;
        this.dragY = n2;
    }

    public void mouseWheelMoved(int n) {
        this.wheelClicks = n;
    }

    protected boolean commandInLine() {
        return this.leftPressed || this.rightPressed || this.upPressed || this.downPressed || this.mousePressed || this.nextPressed || this.prevPressed || this.shiftPressed || this.rotPressed || this.wheelClicks != 0;
    }

    protected static class CommandHandler
    implements Runnable {
        protected Painter painter;

        public CommandHandler(Painter painter) {
            this.painter = painter;
        }

        @Override
        public void run() {
            while (this.painter.stillActive) {
                try {
                    Thread.sleep(30L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.painter.commandInLine()) continue;
                this.painter.resolveCommands();
            }
        }
    }
}

