/*
 * Decompiled with CFR 0.152.
 */
public abstract class Operator
implements FormulaBlock {
    public static final String PLUS = "+";
    public static final String MINUS = "-";
    public static final String TIMES = "*";
    public static final String DIV = "/";
    public static final String MOD = "%";
    public static final String EQ = "=";
    public static final String LESS = "<";
    public static final String GTR = ">";
    public static final String AND = "&";
    public static final String OR = "|";
    public static final String POW = "^";
    public static final String LP = "(";
    public static final String RP = ")";
    public static final String LSP = "[";
    public static final String RSP = "]";
    public static final String LCP = "{";
    public static final String RCP = "}";
    public static final String NOT = "not";
    public static final String SIN = "sin";
    public static final String COS = "cos";
    public static final String TAN = "tan";
    public static final String ASIN = "asin";
    public static final String ACOS = "acos";
    public static final String ATAN = "atan";
    public static final String LOG = "ln";
    public static final String EXP = "exp";
    public static final String SQRT = "sqrt";
    public static final String ABS = "abs";
    public static final String RND = "rnd";
    public static final String FLOOR = "floor";
    public static final String FREEV = "free";
    public static final String PARTV = "coord";
    public static final String COL = "col";
    public static final String ROW = "row";
    public static final String ELEM = "elem";
    public static final String TR = "tp";
    public static final String UNIT = "unit";
    public static final String ZERO = "zero";
    public static final String SUBST = "insert";
    public static final String ARITH = "as";
    public static final String GEOM = "gs";
    public static final String NORM = "norm";
    public static final String DOT = "dot";
    public static final String CROSS = "cross";
    public static final String SINGLEOP = ":";
    public static final String COMMA = ",";
    public static final String ALL_DELIMS = "+-*/%()[]{}^=<>&|:,";
    public static String[] OPERATORS = new String[]{"+", "-", "*", "/", "%", "=", "<", ">", "&", "|", "^", "not", "sin", "cos", "tan", "asin", "acos", "atan", "ln", "exp", "sqrt", "abs", "rnd", "floor", "free", "coord", "col", "row", "elem", "tp", "unit", "zero", "insert", "as", "gs", "norm", "dot", "cross"};
    public static final int A_NOARG = 0;
    public static final int A_SINGLE = 1;
    public static final int A_DOUBLE = 2;
    protected String opType;
    protected int nArgs;
    protected int argType;
    protected String[] arguments;
    protected String name;
    protected String description;
    protected boolean isSingle = false;
    protected boolean isDouble = false;
    protected boolean isParenthesis = false;
    protected boolean isComparison = false;
    protected boolean isLogic = false;
    protected boolean isMultiplier = false;
    protected boolean isPower = false;
    protected boolean isAddition = false;

    @Override
    public boolean isOperator() {
        return true;
    }

    @Override
    public boolean isCustomFunction() {
        return false;
    }

    public String getType() {
        return this.opType;
    }

    public int getArgType() {
        return this.argType;
    }

    @Override
    public String toString() {
        return this.opType;
    }

    public int getArgumentCount() {
        return this.nArgs;
    }

    public abstract Variable operate(FormulaBlock var1);

    public abstract Variable operate(FormulaBlock var1, FormulaBlock var2);

    public boolean isSingleOperator() {
        return this.isSingle;
    }

    public boolean isDoubleOperator() {
        return this.isDouble;
    }

    public boolean isParenthesisOperator() {
        return this.isParenthesis;
    }

    public boolean isComparisonOperator() {
        return this.isComparison;
    }

    public boolean isLogicOperator() {
        return this.isLogic;
    }

    public boolean isMultiplierOperator() {
        return this.isMultiplier;
    }

    public boolean isPowerOperator() {
        return this.isPower;
    }

    public boolean isAdditionOperator() {
        return this.isAddition;
    }

    public static boolean isSingleOperator(String string) {
        try {
            return Operator.createOperator(string, 1, null).isSingleOperator();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isDoubleOperator(String string) {
        try {
            return Operator.createOperator(string, 2, null).isDoubleOperator();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isParenthesisOperator(String string) {
        try {
            return Operator.createOperator(string, 0, null).isParenthesisOperator();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isComparisonOperator(String string) {
        try {
            return Operator.createOperator(string, 2, null).isComparisonOperator();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isLogicOperator(String string) {
        try {
            return Operator.createOperator(string, 2, null).isLogicOperator();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isMultiplierOperator(String string) {
        try {
            return Operator.createOperator(string, 2, null).isMultiplierOperator();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isAdditionOperator(String string) {
        try {
            return Operator.createOperator(string, 2, null).isAdditionOperator();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isOperator(String string) {
        try {
            Operator.createOperator(string, 1, null);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Operator createOperator(String string, int n, Calculator calculator) throws Exception {
        if (string.equals(PLUS)) {
            return new PlusOperator();
        }
        if (string.equals(MINUS) && n == 1) {
            return new SingleMinusOperator();
        }
        if (string.equals(MINUS) && n == 2) {
            return new MinusOperator();
        }
        if (string.equals(TIMES)) {
            return new TimesOperator();
        }
        if (string.equals(DIV)) {
            return new DividedOperator();
        }
        if (string.equals(MOD)) {
            return new ModuloOperator();
        }
        if (string.equals(POW)) {
            return new PowerOperator();
        }
        if (string.equals(EQ)) {
            return new EqualsOperator();
        }
        if (string.equals(LESS)) {
            return new LessThanOperator();
        }
        if (string.equals(GTR)) {
            return new GreaterThanOperator();
        }
        if (string.equals(AND)) {
            return new LogicAndOperator();
        }
        if (string.equals(OR)) {
            return new LogicOrOperator();
        }
        if (string.equals(NOT)) {
            return new NotOperator();
        }
        if (string.equals(SIN)) {
            return new SinOperator();
        }
        if (string.equals(COS)) {
            return new CosOperator();
        }
        if (string.equals(TAN)) {
            return new TanOperator();
        }
        if (string.equals(ASIN)) {
            return new ArcsinOperator();
        }
        if (string.equals(ACOS)) {
            return new ArccosOperator();
        }
        if (string.equals(ATAN)) {
            return new ArctanOperator();
        }
        if (string.equals(LOG)) {
            return new LogarithmOperator();
        }
        if (string.equals(EXP)) {
            return new ExponentOperator();
        }
        if (string.equals(SQRT)) {
            return new SquareRootOperator();
        }
        if (string.equals(ABS)) {
            return new AbsoluteValueOperator();
        }
        if (string.equals(RND)) {
            return new RandomVariableOperator();
        }
        if (string.equals(TR)) {
            return new TransposeOperator();
        }
        if (string.equals(FLOOR)) {
            return new FloorOperator();
        }
        if (string.equals(PARTV)) {
            return new CoordinatesOperator(calculator.getMaster().getCurrentStructure());
        }
        if (string.equals(FREEV)) {
            return new ConstraintsOperator(calculator.getMaster().getCurrentStructure());
        }
        if (string.equals(COL)) {
            return new MatrixColumnOperator();
        }
        if (string.equals(ROW)) {
            return new MatrixRowOperator();
        }
        if (string.equals(UNIT)) {
            return new UnitMatrixOperator();
        }
        if (string.equals(ZERO)) {
            return new ZeroMatrixOperator();
        }
        if (string.equals(ELEM)) {
            return new MatrixElementOperator();
        }
        if (string.equals(SUBST)) {
            return new MatrixSubstitutionOperator();
        }
        if (string.equals(ARITH)) {
            return new ArithmeticSeriesOperator();
        }
        if (string.equals(GEOM)) {
            return new GeometricSeriesOperator();
        }
        if (string.equals(LP) || string.equals(RP) || string.equals(LSP) || string.equals(RSP) || string.equals(LCP) || string.equals(RCP) || string.equals(COMMA)) {
            return new BracketOperator(string);
        }
        if (string.equals(SINGLEOP)) {
            return new FunctionOperator();
        }
        if (string.equals(NORM)) {
            return new VectorNormOperator();
        }
        if (string.equals(DOT)) {
            return new VectorDotOperator();
        }
        if (string.equals(CROSS)) {
            return new VectorCrossOperator();
        }
        throw new Exception();
    }

    public String getSyntax() {
        String string = "";
        if (this.argType == 0) {
            string = string + this.opType;
        } else if (this.argType == 1) {
            if (this.opType.equals(MINUS)) {
                string = string + this.opType + this.arguments[0];
            } else {
                string = string + this.opType + SINGLEOP;
                if (this.nArgs > 1) {
                    string = string + LCP;
                    for (int i = 0; i < this.nArgs; ++i) {
                        string = string + this.arguments[i];
                        if (i >= this.nArgs - 1) continue;
                        string = string + COMMA;
                    }
                    string = string + RCP;
                } else {
                    string = string + this.arguments[0];
                }
            }
        } else if (this.argType == 2) {
            string = string + this.arguments[0] + this.opType + this.arguments[1];
        }
        return string;
    }

    public String getName() {
        return this.name;
    }

    public String getUsage() {
        return this.description;
    }
}

