/*
 * Decompiled with CFR 0.152.
 */
class MatrixSubstitutionOperator
extends Operator {
    public MatrixSubstitutionOperator() {
        this.opType = "insert";
        this.nArgs = 4;
        this.argType = 1;
        this.isSingle = true;
        this.arguments = new String[4];
        this.arguments[0] = "replacement";
        this.arguments[1] = "original";
        this.arguments[2] = "row index";
        this.arguments[3] = "column index";
        this.name = "element substitution";
        this.description = "Inserts the given value in an existing matrix at the specified position. Also matrices can be inserted, in which case the position specifies the cell where the upper left corner of the inserted matrix will go.";
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock) {
        VariableSet variableSet = (VariableSet)formulaBlock;
        if (variableSet.countElements() != this.nArgs) {
            System.out.println(this.opType + " cannot operate on " + variableSet);
            return new Variable("NaN", Double.NaN);
        }
        Variable[] variableArray = variableSet.getSet();
        double[][] dArray = variableArray[1].getMatrixValue();
        double[][] dArray2 = variableArray[0].getMatrixValue();
        int n = variableArray[2].getIntValue();
        int n2 = variableArray[3].getIntValue();
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        double[][] dArray3 = new double[n3][n4];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                dArray3[i][j] = i < n - 1 || i >= n + dArray2.length - 1 || j < n2 - 1 || j >= n2 + dArray2[0].length - 1 ? dArray[i][j] : dArray2[i - n + 1][j - n2 + 1];
            }
        }
        return new Variable("r", dArray3);
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock, FormulaBlock formulaBlock2) {
        return new Variable("NaN", Double.NaN);
    }
}

