/*
 * Decompiled with CFR 0.152.
 */
class MatrixRowOperator
extends Operator {
    public MatrixRowOperator() {
        this.opType = "row";
        this.nArgs = 2;
        this.argType = 1;
        this.isSingle = true;
        this.arguments = new String[2];
        this.arguments[0] = "matrix";
        this.arguments[1] = "index";
        this.name = "row extraction";
        this.description = "Extracts the given row of the given matrix. If a vector is given as an index, a new matrix is formed from the specified rows.";
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock) {
        VariableSet variableSet = (VariableSet)formulaBlock;
        if (variableSet.countElements() != this.nArgs) {
            System.out.println(this.opType + " cannot operate on " + variableSet);
            return new Variable("NaN", Double.NaN);
        }
        Variable[] variableArray = variableSet.getSet();
        double[][] dArray = variableArray[0].getMatrixValue();
        double[][] dArray2 = variableArray[1].getMatrixValue();
        double[][] dArray3 = new double[dArray2.length][dArray2[0].length * dArray[0].length];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray2[0].length; ++j) {
                int n = (int)dArray2[i][j] - 1;
                for (int k = 0; k < dArray[0].length; ++k) {
                    try {
                        dArray3[i][j * dArray[0].length + k] = dArray[n][k];
                        continue;
                    }
                    catch (Exception exception) {
                        dArray3[i][j * dArray[0].length + k] = Double.NaN;
                    }
                }
            }
        }
        return new Variable("r", dArray3);
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock, FormulaBlock formulaBlock2) {
        return new Variable("NaN", Double.NaN);
    }
}

