/*
 * Decompiled with CFR 0.152.
 */
class MatrixElementOperator
extends Operator {
    public MatrixElementOperator() {
        this.opType = "elem";
        this.nArgs = 3;
        this.argType = 1;
        this.isSingle = true;
        this.arguments = new String[3];
        this.arguments[0] = "matrix";
        this.arguments[1] = "row index";
        this.arguments[2] = "column index";
        this.name = "element extraction";
        this.description = "Extracts the given element of the given matrix. If a matrices is given as indices, a new matrix is formed from the specified elements.";
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock) {
        VariableSet variableSet = (VariableSet)formulaBlock;
        if (variableSet.countElements() != this.nArgs) {
            System.out.println(this.opType + " cannot operate on " + variableSet);
            return new Variable("NaN", Double.NaN);
        }
        Variable[] variableArray = variableSet.getSet();
        double[][] dArray = variableArray[0].getMatrixValue();
        double[][] dArray2 = variableArray[1].getMatrixValue();
        double[][] dArray3 = variableArray[2].getMatrixValue();
        int n = dArray2.length;
        int n2 = dArray2[0].length;
        if (n != dArray3.length || n2 != dArray3[0].length) {
            System.out.println("incompatible dimensions for matrix element extraction");
            return new Variable("NaN", Double.NaN);
        }
        double[][] dArray4 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                try {
                    dArray4[i][j] = dArray[(int)dArray2[i][j] - 1][(int)dArray3[i][j] - 1];
                    continue;
                }
                catch (Exception exception) {
                    dArray4[i][j] = Double.NaN;
                }
            }
        }
        return new Variable("r", dArray4);
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock, FormulaBlock formulaBlock2) {
        return new Variable("NaN", Double.NaN);
    }
}

