/*
 * Decompiled with CFR 0.152.
 */
class MatrixColumnOperator
extends Operator {
    public MatrixColumnOperator() {
        this.opType = "col";
        this.nArgs = 2;
        this.argType = 1;
        this.isSingle = true;
        this.arguments = new String[2];
        this.arguments[0] = "matrix";
        this.arguments[1] = "index";
        this.name = "column extraction";
        this.description = "Extracts the given column of the given matrix. If a vector is given as an index, a new matrix is formed from the specified columns.";
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock) {
        VariableSet variableSet = (VariableSet)formulaBlock;
        if (variableSet.countElements() != this.nArgs) {
            System.out.println(this.opType + " cannot operate on " + variableSet);
            return new Variable("NaN", Double.NaN);
        }
        Variable[] variableArray = variableSet.getSet();
        double[][] dArray = variableArray[0].getMatrixValue();
        double[][] dArray2 = variableArray[1].getMatrixValue();
        double[][] dArray3 = new double[dArray2.length * dArray.length][dArray2[0].length];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray2[0].length; ++j) {
                int n = (int)dArray2[i][j] - 1;
                for (int k = 0; k < dArray.length; ++k) {
                    try {
                        dArray3[i * dArray.length + k][j] = dArray[k][n];
                        continue;
                    }
                    catch (Exception exception) {
                        dArray3[i * dArray.length + k][j] = Double.NaN;
                    }
                }
            }
        }
        return new Variable("r", dArray3);
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock, FormulaBlock formulaBlock2) {
        return new Variable("NaN", Double.NaN);
    }
}

