/*
 * Decompiled with CFR 0.152.
 */
class GeometricSeriesOperator
extends Operator {
    public GeometricSeriesOperator() {
        this.opType = "gs";
        this.nArgs = 3;
        this.argType = 1;
        this.isSingle = true;
        this.arguments = new String[3];
        this.arguments[0] = "start";
        this.arguments[1] = "ratio";
        this.arguments[2] = "length";
        this.name = "geometric series";
        this.description = "Creates a vector of the given length, whose elements form a geometric series (start*ratio^i)";
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock) {
        VariableSet variableSet = (VariableSet)formulaBlock;
        if (variableSet.countElements() != this.nArgs) {
            System.out.println(this.opType + " cannot operate on " + variableSet);
            return new Variable("NaN", Double.NaN);
        }
        Variable[] variableArray = variableSet.getSet();
        double[][] dArray = variableArray[0].getMatrixValue();
        double[][] dArray2 = variableArray[1].getMatrixValue();
        int n = variableArray[2].getIntValue();
        if (n <= 0) {
            System.out.println("non-positive length for geometric series");
            return new Variable("NaN", Double.NaN);
        }
        Object object = new double[][]{{Double.NaN}};
        if (dArray.length == 1) {
            if (dArray[0].length == dArray2[0].length) {
                object = new double[n][dArray[0].length];
                for (int i = 0; i < dArray[0].length; ++i) {
                    double d = 1.0;
                    for (int j = 0; j < n; ++j) {
                        object[j][i] = dArray[0][i] * (d *= dArray2[0][i]);
                    }
                }
            } else if (dArray2.length == 1 && dArray2[0].length == 1) {
                object = new double[n][dArray[0].length];
                for (int i = 0; i < dArray[0].length; ++i) {
                    double d = 1.0;
                    for (int j = 0; j < n; ++j) {
                        object[j][i] = dArray[0][i] * (d *= dArray2[0][0]);
                    }
                }
            }
        } else if (dArray[0].length == 1) {
            if (dArray.length == dArray2.length) {
                object = new double[dArray.length][n];
                for (int i = 0; i < dArray.length; ++i) {
                    double d = 1.0;
                    for (int j = 0; j < n; ++j) {
                        object[i][j] = dArray[i][0] * (d *= dArray2[i][0]);
                    }
                }
            } else if (dArray2.length == 1 && dArray2[0].length == 1) {
                object = new double[dArray.length][n];
                for (int i = 0; i < dArray.length; ++i) {
                    double d = 1.0;
                    for (int j = 0; j < n; ++j) {
                        object[i][j] = dArray[i][0] * (d *= dArray2[0][0]);
                    }
                }
            }
        } else {
            System.out.println("incorrect arguments for " + this.opType);
        }
        return new Variable("r", (double[][])object);
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock, FormulaBlock formulaBlock2) {
        return new Variable("NaN", Double.NaN);
    }
}

