/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class GeoWindow
extends JFrame {
    private ScreenRefresher updater;
    private Painter painter;
    private boolean painterWorking;
    private boolean windowOpen;
    public static final int WINDOW_HEIGHT = 400;
    public static final int WINDOW_WIDTH = 400;
    public static final int FRAME_DT = 30;

    public GeoWindow(ASH aSH) {
        super("Atomic Structure Handler");
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setPreferredSize(new Dimension(400, 400));
        jPanel.setLayout(null);
        this.painter = new GeoPainter(this, aSH);
        this.painter.setBounds(0, 0, 400, 400);
        jPanel.add(this.painter);
        this.setIgnoreRepaint(true);
        this.pack();
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                GeoWindow.this.painter.requestFocus();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                GeoWindow.this.painter.recordSize(componentEvent.getComponent().getWidth(), componentEvent.getComponent().getHeight());
            }
        });
        this.painter.addKeyListener(new KeyInputHandler(this));
        this.painter.addMouseListener(new MouseInputHandler(this));
        this.painter.addMouseMotionListener(new MouseInputHandler(this));
        this.painter.addMouseWheelListener(new MouseInputHandler(this));
        this.painter.initializeBuffer();
        this.painterWorking = true;
        this.windowOpen = true;
    }

    public void startGraphics() {
        this.updater = new ScreenRefresher(this);
        Thread thread = new Thread(this.updater);
        thread.start();
    }

    public void resumeGraphics() {
        this.painterWorking = true;
    }

    public void pauseGraphics() {
        this.painterWorking = false;
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void closeWindow() {
        this.windowOpen = false;
    }

    public void changePainter(Painter painter) {
        this.painterWorking = false;
        this.painter = painter;
        JPanel jPanel = (JPanel)this.getContentPane();
        this.painter.setBounds(0, 0, 400, 400);
        jPanel.removeAll();
        jPanel.add(painter);
        this.pack();
        this.painter.initializeBuffer();
        this.painter.addKeyListener(new KeyInputHandler(this));
        this.painter.addMouseListener(new MouseInputHandler(this));
        this.painter.requestFocus();
        this.painterWorking = true;
    }

    public boolean isOpen() {
        return this.windowOpen;
    }

    public boolean painterWorking() {
        return this.painterWorking;
    }

    private static class ScreenRefresher
    implements Runnable {
        private GeoWindow window;

        public ScreenRefresher(GeoWindow geoWindow) {
            this.window = geoWindow;
        }

        @Override
        public void run() {
            long l = System.currentTimeMillis();
            long l2 = 0L;
            while (this.window.isOpen()) {
                l2 = System.currentTimeMillis() - l;
                l = System.currentTimeMillis();
                if (this.window.painterWorking()) {
                    try {
                        this.window.getPainter().paint(l2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                l2 = System.currentTimeMillis() - l;
                try {
                    Thread.sleep(30L - l2);
                }
                catch (Exception exception) {}
            }
        }
    }

    private class KeyInputHandler
    extends KeyAdapter {
        private GeoWindow window;

        public KeyInputHandler(GeoWindow geoWindow2) {
            this.window = geoWindow2;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 37) {
                this.window.getPainter().pressLeft();
            }
            if (keyEvent.getKeyCode() == 39) {
                this.window.getPainter().pressRight();
            }
            if (keyEvent.getKeyCode() == 38) {
                this.window.getPainter().pressUp();
            }
            if (keyEvent.getKeyCode() == 40) {
                this.window.getPainter().pressDown();
            }
            if (keyEvent.getKeyCode() == 78) {
                this.window.getPainter().pressNext();
            }
            if (keyEvent.getKeyCode() == 80) {
                this.window.getPainter().pressPrevious();
            }
            if (keyEvent.getKeyCode() == 83) {
                this.window.getPainter().pressShift(((GeoPainter)this.window.getPainter()).getManager());
            }
            if (keyEvent.getKeyCode() == 82) {
                this.window.getPainter().pressRotate(((GeoPainter)this.window.getPainter()).getManager());
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 37) {
                this.window.getPainter().releaseLeft();
            }
            if (keyEvent.getKeyCode() == 39) {
                this.window.getPainter().releaseRight();
            }
            if (keyEvent.getKeyCode() == 38) {
                this.window.getPainter().releaseUp();
            }
            if (keyEvent.getKeyCode() == 40) {
                this.window.getPainter().releaseDown();
            }
            if (keyEvent.getKeyCode() == 78) {
                this.window.getPainter().releaseNext();
            }
            if (keyEvent.getKeyCode() == 80) {
                this.window.getPainter().releasePrevious();
            }
            if (keyEvent.getKeyCode() == 83) {
                this.window.getPainter().releaseShift();
            }
            if (keyEvent.getKeyCode() == 82) {
                this.window.getPainter().releaseRotate();
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 37) {
                // empty if block
            }
            if (keyEvent.getKeyCode() == 39) {
                // empty if block
            }
            if (keyEvent.getKeyCode() == 38) {
                // empty if block
            }
            if (keyEvent.getKeyCode() == 40) {
                // empty if block
            }
            if (keyEvent.getKeyCode() == 70) {
                // empty if block
            }
            if (keyEvent.getKeyCode() == 69) {
                // empty if block
            }
        }
    }

    private class MouseInputHandler
    extends MouseAdapter {
        private GeoWindow window;

        public MouseInputHandler(GeoWindow geoWindow2) {
            this.window = geoWindow2;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.window.getPainter().mouseClicked(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount());
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.window.getPainter().mousePressed(mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.window.getPainter().mouseReleased(mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.window.getPainter().mouseDragged(mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.window.getPainter().mouseWheelMoved(mouseWheelEvent.getWheelRotation());
        }
    }
}

