/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;

public class GeoPainter
extends Painter {
    private GeoWindow window;
    private ASH manager;
    private Structure geometry;
    private ViewPoint lookout;
    private View scene;
    private int updatedScene = 0;
    private boolean drawcell = false;
    private boolean drawaxis = false;
    private boolean followCenter = true;
    private boolean displayFrame = false;
    public static boolean MOUSE_INFO = false;
    public static boolean MOUSE_PICK = false;
    private boolean initDone = false;
    private int width;
    private int height;

    public GeoPainter(GeoWindow geoWindow, ASH aSH) {
        this.window = geoWindow;
        this.width = geoWindow.getWidth();
        this.height = geoWindow.getHeight();
        this.manager = aSH;
        this.geometry = null;
        this.lookout = null;
        this.scene = null;
    }

    public void setGeometry(Structure structure) {
        this.geometry = structure;
    }

    public void setViewPoint(ViewPoint viewPoint) {
        this.lookout = viewPoint;
    }

    public ASH getManager() {
        return this.manager;
    }

    public Structure getGeometry() {
        return this.geometry;
    }

    public ViewPoint getViewPoint() {
        return this.lookout;
    }

    public View getView() {
        return this.scene;
    }

    public void resetViewPoint() {
        block2: {
            try {
                this.lookout = ViewPoint.resetViewPoint(this.geometry, this.lookout);
                this.updateGeo();
            }
            catch (Exception exception) {
                if (ASH.runningScript) break block2;
                System.out.println("could not reset the view");
            }
        }
    }

    public void initGeo(Structure structure, ViewPoint viewPoint) {
        this.geometry = structure;
        this.lookout = viewPoint;
        this.scene = new View(structure, viewPoint, this.width, this.height);
        this.stillActive = true;
        this.updatedScene = 5;
        this.initDone = true;
    }

    public void updateGeo(Structure structure, ViewPoint viewPoint) {
        this.geometry = structure;
        this.lookout = viewPoint;
        this.scene = new View(structure, viewPoint, this.width, this.height);
        this.updatedScene = 5;
    }

    public void updateGeo(Structure structure) {
        this.geometry = structure;
        this.scene = new View(structure, this.lookout, this.width, this.height);
        this.updatedScene = 5;
    }

    public void updateGeo(ViewPoint viewPoint) {
        this.lookout = viewPoint;
        this.scene = new View(this.geometry, viewPoint, this.width, this.height);
        this.updatedScene = 5;
    }

    public void updateGeo() {
        this.scene = new View(this.geometry, this.lookout, this.width, this.height);
        this.updatedScene = 5;
    }

    @Override
    public void resolveCommands() {
        double d = 0.0;
        double d2 = 0.0;
        if (this.leftPressed) {
            d -= 0.1;
        }
        if (this.rightPressed) {
            d += 0.1;
        }
        if (this.upPressed) {
            d2 += 0.1;
        }
        if (this.downPressed) {
            d2 -= 0.1;
        }
        if (this.wheelClicks != 0) {
            d2 -= 0.3 * (double)this.wheelClicks;
            this.wheelClicks = 0;
        }
        if (this.mousePressed && (this.dragX - this.dragStartX != 0 || this.dragY - this.dragStartY != 0)) {
            if (this.shiftPressed) {
                int n = this.geometry.countParticles();
                Vector vector = this.lookout.getSide();
                Vector vector2 = this.lookout.getUp();
                Vector vector3 = vector.times(0.1 * (double)(this.dragX - this.dragStartX)).plus(vector2.times(-0.1 * (double)(this.dragY - this.dragStartY)));
                for (int i = 0; i < n; ++i) {
                    if (!this.geometry.getParticle(i).isPicked()) continue;
                    this.geometry.getParticle(i).shiftCoordinates(vector3);
                }
                this.geometry.forcePeriodicBounds();
                this.updateGeo();
                this.dragStartX = this.dragX;
                this.dragStartY = this.dragY;
            } else if (this.rotPressed) {
                int n = this.geometry.countParticles();
                Vector vector = this.lookout.getSide();
                Vector vector4 = this.lookout.getUp();
                Quaternion quaternion = new Quaternion(vector4, 0.01 * (double)(this.dragX - this.dragStartX));
                Quaternion quaternion2 = new Quaternion(vector, 0.01 * (double)(this.dragY - this.dragStartY));
                Quaternion quaternion3 = quaternion.times(quaternion2);
                for (int i = 0; i < n; ++i) {
                    if (!this.geometry.getParticle(i).isPicked()) continue;
                    this.geometry.getParticle(i).rotate(quaternion3);
                }
                this.updateGeo();
                this.dragStartX = this.dragX;
                this.dragStartY = this.dragY;
            } else {
                try {
                    this.lookout.rotateViewPoint((double)(this.dragX - this.dragStartX) * -0.01, (double)(this.dragY - this.dragStartY) * 0.01, this.geometry.getCenter());
                    this.updateGeo();
                    this.dragStartX = this.dragX;
                    this.dragStartY = this.dragY;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (d != 0.0 || d2 != 0.0) {
            try {
                this.lookout.shiftViewPoint(0.4 * d, 10.0 * d2);
                this.updateGeo();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.nextPressed && this.updatedScene < 3) {
            this.manager.nextFrame();
            this.updateGeo();
            this.updatedScene = 7;
        }
        if (this.prevPressed && this.updatedScene < 3) {
            this.manager.previousFrame();
            this.updateGeo();
            this.updatedScene = 7;
        }
    }

    @Override
    public void mouseClicked(int n, int n2, int n3) {
        if (MOUSE_INFO) {
            this.manager.listMouseInfo(n, n2);
        }
        if (MOUSE_PICK) {
            this.manager.pickByMouse(n, n2, n3);
        }
    }

    public void setShowAxis(boolean bl) {
        this.drawaxis = bl;
    }

    public void setShowCell(boolean bl) {
        this.drawcell = bl;
    }

    public void setShowFrame(boolean bl) {
        this.displayFrame = bl;
    }

    public void aimAtCenter() {
        if (this.followCenter && !ASH.runningScript) {
            this.lookout.aimAtCenter(this.geometry);
        }
    }

    @Override
    public void recordSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.setBounds(0, 0, n, n2);
        this.updateGeo();
    }

    private void arrange(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(new BasicStroke(View.STROKE_WIDTH));
        if (!this.initDone) {
            graphics2D.setColor(Color.black);
            graphics2D.fillRect(0, 0, this.width, this.height);
        } else {
            Object object;
            graphics2D.setColor(View.bg);
            graphics2D.fillRect(0, 0, this.width, this.height);
            Projection[] projectionArray = this.scene.getProjections();
            for (int i = 0; i < projectionArray.length; ++i) {
                if (!projectionArray[i].isVisible()) continue;
                object = projectionArray[i].getAtomicShape(this.width, this.height);
                graphics2D.setPaint(projectionArray[i].getLineColor());
                graphics2D.draw((Shape)object);
                graphics2D.setPaint(projectionArray[i].getColor());
                graphics2D.fill((Shape)object);
            }
            if (this.drawcell) {
                graphics2D.setPaint(View.transRed);
                graphics2D.draw(this.scene.getCellAxisLine(0));
                graphics2D.setPaint(View.transGreen);
                graphics2D.draw(this.scene.getCellAxisLine(1));
                graphics2D.setPaint(View.transBlue);
                graphics2D.draw(this.scene.getCellAxisLine(2));
            }
            if (this.drawaxis) {
                graphics2D.setPaint(View.transLightRed);
                graphics2D.draw(this.scene.getUnitAxisLine(0));
                graphics2D.setPaint(View.transLightGreen);
                graphics2D.draw(this.scene.getUnitAxisLine(1));
                graphics2D.setPaint(View.transLightBlue);
                graphics2D.draw(this.scene.getUnitAxisLine(2));
            }
            if (this.displayFrame) {
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                object = new Font("Helvetica", 0, 10);
                String string = "frame " + (this.manager.getCurrentFrame() + 1) + " / " + this.manager.getNumberOfFrames() + "  " + this.manager.getCurrentFrameName();
                TextLayout textLayout = new TextLayout(string, (Font)object, fontRenderContext);
                Dimension dimension = this.getSize();
                graphics2D.setColor(View.black);
                textLayout.draw(graphics2D, 20.0f, 20.0f);
            }
        }
    }

    public BufferedImage getPainting() {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.arrange(graphics2D);
        return bufferedImage;
    }

    @Override
    public void paint(long l) {
        if (this.updatedScene > 2) {
            --this.updatedScene;
            if (this.updatedScene < 5) {
                Graphics2D graphics2D = (Graphics2D)this.strategy.getDrawGraphics();
                this.arrange(graphics2D);
                graphics2D.dispose();
                this.strategy.show();
            }
        }
    }
}

