/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;

public class FileHandler {
    public static File CWD;
    public static File[] PATH;
    public static final int F_XYZ = 1;
    public static final int F_POSCAR = 2;
    public static final int F_SCRIPT = 3;
    public static final int F_POSCAR4 = 4;
    public static final int F_ASE = 5;
    public static final int F_PNG = -1;
    public static final int F_JPG = -2;
    public static final int DECIMALS = 6;
    public static final String ELEM_SEP = "_";

    public static void readPath() {
        String string = System.getenv("PATH");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        PATH = new File[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                FileHandler.PATH[n] = new File(stringTokenizer.nextToken());
                ++n;
            }
            catch (Exception exception) {
                FileHandler.PATH[n] = null;
                ++n;
            }
        }
    }

    public Structure[] readXYZ(String string) throws Exception {
        ArrayList<String> arrayList = this.readLines(string);
        boolean bl = false;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        int n = arrayList.size();
        int n2 = 0;
        int n3 = n;
        while (n2 < n) {
            double d;
            double d2;
            Object object;
            Object object2;
            int n4 = 0;
            try {
                n3 = n4 = Integer.parseInt(arrayList.get(n2).trim());
                ++n2;
            }
            catch (Exception exception) {
                n4 = n3;
            }
            try {
                object2 = new StringTokenizer(arrayList.get(n2).trim(), " \t");
                object = ((StringTokenizer)object2).nextToken();
                double d3 = Double.parseDouble(((StringTokenizer)object2).nextToken());
                d2 = Double.parseDouble(((StringTokenizer)object2).nextToken());
                d = Double.parseDouble(((StringTokenizer)object2).nextToken());
            }
            catch (Exception exception) {
                ++n2;
            }
            object2 = new Particle[n4];
            for (int i = 0; i < n4; ++i) {
                StringTokenizer stringTokenizer = new StringTokenizer(arrayList.get(n2).trim(), " \t");
                String string2 = stringTokenizer.nextToken();
                d2 = Double.parseDouble(stringTokenizer.nextToken());
                d = Double.parseDouble(stringTokenizer.nextToken());
                double d4 = Double.parseDouble(stringTokenizer.nextToken());
                Atom atom = new Atom(new Vector(d2, d, d4));
                Element element = ASH.elementTable.getElement(string2);
                atom.setElement(element);
                object2[i] = atom;
                ++n2;
            }
            object = new Structure((Particle[])object2);
            ((Structure)object).setName(string);
            arrayList2.add(object);
        }
        Structure[] structureArray = new Structure[arrayList2.size()];
        for (int i = 0; i < structureArray.length; ++i) {
            structureArray[i] = (Structure)arrayList2.get(i);
        }
        return structureArray;
    }

    public Structure[] readPoscar(String string) throws Exception {
        Structure[] structureArray;
        boolean bl;
        int n;
        Object object;
        ArrayList<String> arrayList = this.readLines(string);
        int n2 = arrayList.size();
        double d = 0.0;
        int n3 = 0;
        Vector[] vectorArray = new Vector[3];
        String string2 = string;
        try {
            d = Double.parseDouble(arrayList.get(n3));
            ++n3;
        }
        catch (Exception exception) {
            string2 = arrayList.get(n3);
            d = Double.parseDouble(arrayList.get(++n3));
            ++n3;
        }
        for (int i = 0; i < 3; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(arrayList.get(n3), " \t");
            object = new double[3];
            for (int j = 0; j < 3; ++j) {
                object[j] = d * Double.parseDouble(stringTokenizer.nextToken());
            }
            vectorArray[i] = new Vector((double[])object);
            ++n3;
        }
        boolean[] blArray = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            blArray[i] = true;
        }
        Element[] elementArray = new Element[]{};
        try {
            object = new StringTokenizer(arrayList.get(n3), " \t");
            Integer.parseInt(((StringTokenizer)object).nextToken());
        }
        catch (Exception exception) {
            StringTokenizer stringTokenizer = new StringTokenizer(arrayList.get(n3), " \t");
            elementArray = new Element[stringTokenizer.countTokens()];
            int[] nArray = new int[ASH.elementTable.size()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = 0;
            }
            for (n = 0; n < elementArray.length; ++n) {
                try {
                    String string3 = stringTokenizer.nextToken();
                    int n4 = ASH.elementTable.findNumber(string3);
                    if (n4 >= 0 && nArray[n4] > 0) {
                        string3 = string3 + ELEM_SEP + (nArray[n4] + 1);
                        elementArray[n] = ASH.elementTable.getElement(string3);
                        int n5 = n4;
                        nArray[n5] = nArray[n5] + 1;
                        continue;
                    }
                    elementArray[n] = ASH.elementTable.getElement(string3);
                    int n6 = elementArray[n].getNumber();
                    nArray[n6] = nArray[n6] + 1;
                    continue;
                }
                catch (Exception exception2) {
                    elementArray[n] = ASH.elementTable.getElement("Atom" + n);
                }
            }
            ++n3;
        }
        object = new StringTokenizer(arrayList.get(n3), " \t");
        int[] nArray = new int[((StringTokenizer)object).countTokens()];
        int n7 = 0;
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = Integer.parseInt(((StringTokenizer)object).nextToken());
            n7 += nArray[n];
        }
        ++n3;
        if (elementArray.length != nArray.length) {
            elementArray = new Element[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                elementArray[n] = ASH.elementTable.getElement("Atom" + n);
            }
        }
        if (arrayList.get(n3).substring(0, 1).equalsIgnoreCase("S")) {
            n = 1;
            ++n3;
        } else {
            n = 0;
        }
        if (arrayList.get(n3).substring(0, 1).equalsIgnoreCase("C")) {
            bl = true;
            ++n3;
        } else {
            bl = false;
            ++n3;
        }
        Particle[] particleArray = new Atom[n7];
        int n8 = 0;
        Element element = elementArray[n8];
        int n9 = 0;
        for (int i = 0; i < n7; ++i) {
            structureArray = new StringTokenizer(arrayList.get(n3), " \t");
            double d2 = Double.parseDouble(structureArray.nextToken());
            double d3 = Double.parseDouble(structureArray.nextToken());
            double d4 = Double.parseDouble(structureArray.nextToken());
            particleArray[i] = bl ? new Atom(new Vector(d2, d3, d4).times(d)) : new Atom(vectorArray[0].times(d2).plus(vectorArray[1].times(d3)).plus(vectorArray[2].times(d4)));
            if (n != 0) {
                boolean[] blArray2 = new boolean[3];
                if (structureArray.countTokens() > 2) {
                    for (int j = 0; j < 3; ++j) {
                        blArray2[j] = structureArray.nextToken().substring(0, 1).equalsIgnoreCase("T");
                    }
                }
                ((Atom)particleArray[i]).setFrozenCoordinates(blArray2);
            }
            try {
                ((Atom)particleArray[i]).setElement(element);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (++n9 == nArray[n8]) {
                n9 = 0;
                if (++n8 < elementArray.length) {
                    element = elementArray[n8];
                }
            }
            ++n3;
        }
        Structure structure = new Structure(particleArray);
        structure.setName(string2);
        structure.setCell(vectorArray, blArray);
        structureArray = new Structure[]{structure};
        return structureArray;
    }

    public double[][] readData(String string, int n) throws Exception {
        ArrayList<String> arrayList = this.readLines(string);
        int n2 = arrayList.size();
        double[][] dArray = new double[n2][n];
        for (int i = 0; i < n2; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(arrayList.get(i), " \t");
            for (int j = 0; j < n; ++j) {
                try {
                    dArray[i][j] = Double.parseDouble(stringTokenizer.nextToken());
                    continue;
                }
                catch (Exception exception) {
                    dArray[i][j] = Double.NaN;
                }
            }
        }
        return dArray;
    }

    public String[] formatASE(Structure structure) {
        int n;
        int n2;
        int n3 = structure.countAllAtoms();
        String[] stringArray = new String[15 + 2 * n3];
        stringArray[0] = "#! /usr/bin/env python";
        stringArray[1] = "import ase";
        stringArray[2] = "coordinates = [ \\";
        stringArray[3 + n3] = "symbols = [ \\";
        Atom[] atomArray = structure.getAllAtoms();
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[3 + n2] = "  [ ";
            for (n = 0; n < 3; ++n) {
                int n4 = 3 + n2;
                stringArray[n4] = stringArray[n4] + FileHandler.formattedDouble(atomArray[n2].getCoordinates().element(n), 15, 6);
                if (n < 2) {
                    int n5 = 3 + n2;
                    stringArray[n5] = stringArray[n5] + ", ";
                    continue;
                }
                stringArray[4 + n2 + n3] = "  '" + atomArray[n2].getName() + "'";
                if (n2 < n3 - 1) {
                    int n6 = 3 + n2;
                    stringArray[n6] = stringArray[n6] + " ], \\";
                    int n7 = 4 + n2 + n3;
                    stringArray[n7] = stringArray[n7] + ", \\";
                    continue;
                }
                int n8 = 3 + n2;
                stringArray[n8] = stringArray[n8] + " ] ] ";
                int n9 = 4 + n2 + n3;
                stringArray[n9] = stringArray[n9] + " ] ";
            }
        }
        stringArray[4 + 2 * n3] = "cell = [ \\";
        for (n2 = 0; n2 < 3; ++n2) {
            stringArray[5 + n2 + 2 * n3] = "   [ ";
            for (n = 0; n < 3; ++n) {
                int n10 = 5 + n2 + 2 * n3;
                stringArray[n10] = stringArray[n10] + FileHandler.formattedDouble(structure.getCell()[n2].element(n), 15, 6);
                if (n < 2) {
                    int n11 = 5 + n2 + 2 * n3;
                    stringArray[n11] = stringArray[n11] + ", ";
                    continue;
                }
                int n12 = 5 + n2 + 2 * n3;
                stringArray[n12] = stringArray[n12] + " ]";
            }
            if (n2 < 2) {
                int n13 = 5 + n2 + 2 * n3;
                stringArray[n13] = stringArray[n13] + ", \\";
                continue;
            }
            int n14 = 5 + n2 + 2 * n3;
            stringArray[n14] = stringArray[n14] + " ] ";
        }
        stringArray[8 + 2 * n3] = "pbc = [ ";
        for (n2 = 0; n2 < 3; ++n2) {
            if (structure.getBoundaryConditions()[n2]) {
                int n15 = 8 + 2 * n3;
                stringArray[n15] = stringArray[n15] + "True";
            } else {
                int n16 = 8 + 2 * n3;
                stringArray[n16] = stringArray[n16] + "False";
            }
            if (n2 < 2) {
                int n17 = 8 + 2 * n3;
                stringArray[n17] = stringArray[n17] + ", ";
                continue;
            }
            int n18 = 8 + 2 * n3;
            stringArray[n18] = stringArray[n18] + " ] ";
        }
        stringArray[9 + 2 * n3] = "def system(use_symbols=True):";
        stringArray[10 + 2 * n3] = "  global coordinates, symbols";
        stringArray[11 + 2 * n3] = "  if use_symbols:";
        stringArray[12 + 2 * n3] = "    return ase.Atoms(symbols=symbols,positions=coordinates,cell=cell,pbc=pbc)";
        stringArray[13 + 2 * n3] = "  else:";
        stringArray[14 + 2 * n3] = "    return ase.Atoms(numbers=[1]*" + n3 + ",positions=coordinates,cell=cell,pbc=pbc)";
        return stringArray;
    }

    public String[] formatXYZ(Structure structure) {
        int n = structure.countAllAtoms();
        String[] stringArray = new String[2 + n];
        stringArray[1] = " ";
        stringArray[0] = "   " + n;
        Atom[] atomArray = structure.getAllAtoms();
        for (int i = 0; i < n; ++i) {
            String string = atomArray[i].getName();
            if (string.indexOf(ELEM_SEP) > 0) {
                string = string.substring(0, string.indexOf(ELEM_SEP));
            }
            stringArray[2 + i] = string + "     ";
            for (int j = 0; j < 3; ++j) {
                int n2 = 2 + i;
                stringArray[n2] = stringArray[n2] + FileHandler.formattedDouble(atomArray[i].getCoordinates().element(j), 15, 6) + " ";
            }
        }
        return stringArray;
    }

    public String[] formatPoscar(String string, Structure structure, boolean bl, String[] stringArray) {
        int n;
        int n2;
        int n3 = 0;
        if (bl) {
            ++n3;
        }
        String[] stringArray2 = new String[8 + n3 + structure.countAllAtoms()];
        stringArray2[0] = structure.getName();
        stringArray2[1] = "  1.000000";
        for (int i = 0; i < 3; ++i) {
            stringArray2[2 + i] = "    ";
            for (int j = 0; j < 3; ++j) {
                int n4 = 2 + i;
                stringArray2[n4] = stringArray2[n4] + FileHandler.formattedDouble(structure.getCell()[i].element(j), 15, 6) + " ";
            }
        }
        int[] nArray = structure.countElements();
        int[] nArray2 = structure.findElements();
        if (stringArray.length > 0) {
            try {
                int n5;
                if (stringArray.length != nArray2.length) {
                    throw new Exception();
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    n5 = ASH.elementTable.findNumber(stringArray[i]);
                    if (n5 < 1) {
                        throw new Exception();
                    }
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        if (i == n2 || !stringArray[n2].equalsIgnoreCase(stringArray[i])) continue;
                        throw new Exception();
                    }
                    n2 = 0;
                    for (n = 0; n < nArray2.length; ++n) {
                        if (nArray2[n] != n5) continue;
                        n2 = 1;
                    }
                    if (n2 != 0) continue;
                    throw new Exception();
                }
                int[] nArray3 = new int[nArray.length];
                for (n5 = 0; n5 < stringArray.length; ++n5) {
                    n2 = ASH.elementTable.findNumber(stringArray[n5]);
                    for (n = 0; n < nArray2.length; ++n) {
                        if (nArray2[n] != n2) continue;
                        nArray3[n5] = nArray[n];
                    }
                }
                for (n5 = 0; n5 < stringArray.length; ++n5) {
                    nArray2[n5] = ASH.elementTable.findNumber(stringArray[n5]);
                }
                nArray = nArray3;
            }
            catch (Exception exception) {
                System.out.println("Invalid list of elements, ignoring.");
            }
        }
        if (bl) {
            stringArray2[5] = "  ";
            for (int i = 0; i < nArray2.length; ++i) {
                String string2 = ASH.elementTable.getElement(nArray2[i]).getSymbol();
                if (string2.indexOf(ELEM_SEP) > 0) {
                    string2 = string2.substring(0, string2.indexOf(ELEM_SEP));
                }
                stringArray2[5] = stringArray2[5] + string2 + "  ";
            }
        }
        stringArray2[5 + n3] = "  ";
        for (int i = 0; i < nArray.length; ++i) {
            int n6 = 5 + n3;
            stringArray2[n6] = stringArray2[n6] + nArray[i] + "  ";
        }
        stringArray2[6 + n3] = "Selective";
        stringArray2[7 + n3] = "Cartesian";
        Atom[] atomArray = structure.getAllAtoms();
        int n7 = 8 + n3;
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            for (n = 0; n < atomArray.length; ++n) {
                int n8;
                if (atomArray[n].getElement() != nArray2[n2]) continue;
                stringArray2[n7] = "  ";
                for (n8 = 0; n8 < 3; ++n8) {
                    int n9 = n7;
                    stringArray2[n9] = stringArray2[n9] + FileHandler.formattedDouble(atomArray[n].getCoordinates().element(n8), 15, 6) + " ";
                }
                for (n8 = 0; n8 < 3; ++n8) {
                    if (atomArray[n].getFrozenCoordinates()[n8]) {
                        int n10 = n7;
                        stringArray2[n10] = stringArray2[n10] + "T  ";
                        continue;
                    }
                    int n11 = n7;
                    stringArray2[n11] = stringArray2[n11] + "F  ";
                }
                ++n7;
            }
        }
        return stringArray2;
    }

    public boolean findsFile(String string) {
        File file = new File(CWD, string);
        if (!file.isFile() && !(file = new File(string)).isFile() && PATH != null) {
            for (int i = 0; !(i >= PATH.length || PATH[i] != null && (file = new File(PATH[i], string)).isFile()); ++i) {
            }
        }
        return file.isFile();
    }

    protected ArrayList<String> readLines(String string) throws Exception {
        File file = new File(CWD, string);
        if (!file.isFile() && !(file = new File(string)).isFile() && PATH != null) {
            for (int i = 0; !(i >= PATH.length || PATH[i] != null && (file = new File(PATH[i], string)).isFile()); ++i) {
            }
        }
        if (!file.isFile()) {
            throw new Exception();
        }
        FileReader fileReader = new FileReader(file.getPath());
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            if (!string2.trim().equals("")) {
                if (string2 == null) break;
                arrayList.add(string2);
            }
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
        ((Reader)fileReader).close();
        return arrayList;
    }

    public void writeFile(String[] stringArray, String string) throws Exception {
        File file = new File(CWD, string);
        if (string.substring(0, 1).equals("/")) {
            file = new File(string);
        }
        FileWriter fileWriter = new FileWriter(file.getPath());
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        for (int i = 0; i < stringArray.length; ++i) {
            bufferedWriter.write(stringArray[i]);
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
        ((Writer)fileWriter).close();
    }

    public void appendFile(String[] stringArray, String string) throws Exception {
        File file = new File(CWD, string);
        if (!file.isFile()) {
            file = new File(string);
        }
        FileWriter fileWriter = new FileWriter(file.getPath(), true);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        for (int i = 0; i < stringArray.length; ++i) {
            bufferedWriter.write(stringArray[i]);
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
        ((Writer)fileWriter).close();
    }

    public void writeFile(BufferedImage bufferedImage, String string, int n) throws Exception {
        File file = new File(CWD, string);
        ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
    }

    public static String formattedString(String string, int n) {
        String string2 = "";
        while (string2.length() + string.length() < n) {
            string2 = string2 + " ";
        }
        string2 = string2 + string;
        return string2;
    }

    public static String formattedDouble(double d, int n, int n2) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.printf("%" + n + "." + n2 + "f", d);
        String string = stringWriter.toString();
        return string.replace(',', '.');
    }

    public static String formattedInt(int n, int n2) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.printf("%" + n2 + "d", n);
        return stringWriter.toString();
    }
}

