/*
 * Decompiled with CFR 0.152.
 */
class EqualsOperator
extends Operator {
    public EqualsOperator() {
        this.opType = "=";
        this.nArgs = 2;
        this.argType = 2;
        this.isDouble = true;
        this.isComparison = true;
        this.arguments = new String[2];
        this.arguments[0] = "x";
        this.arguments[1] = "y";
        this.name = "equality";
        this.description = "Compares two values. If the values are equal, the equality is given value 1, and 0 otherwise.";
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock) {
        return new Variable("NaN", Double.NaN);
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock, FormulaBlock formulaBlock2) {
        double[][] dArray = ((Variable)formulaBlock).getMatrixValue();
        double[][] dArray2 = ((Variable)formulaBlock2).getMatrixValue();
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray2.length;
        int n4 = dArray2[0].length;
        Object object = new double[][]{{Double.NaN}};
        if (n2 == n4 && n == n3) {
            object = new double[1][1];
            object[0][0] = 1.0;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (dArray[i][j] == dArray2[i][j]) continue;
                    object[0][0] = 0.0;
                }
            }
        } else if (n2 == 1 && n == 1) {
            object = new double[n3][n4];
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    object[i][j] = dArray[0][0] == dArray2[i][j] ? 1.0 : 0.0;
                }
            }
        } else if (n4 == 1 && n3 == 1) {
            object = new double[n][n2];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    object[i][j] = dArray[i][j] == dArray2[0][0] ? 1.0 : 0.0;
                }
            }
        } else {
            System.out.println("Incompatible dimensions in matrix comparison.");
            object = new double[0][0];
            object[0][0] = Double.NaN;
        }
        return new Variable("r", (double[][])object);
    }
}

