/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class Element {
    private int number;
    private String abbr;
    private String name;
    private String electrons;
    private double mass;
    private double radius;
    private Color color;
    public static final int E_H = 1;
    public static final int E_He = 2;
    public static final int E_Li = 3;
    public static final int E_Be = 4;
    public static final int E_B = 5;
    public static final int E_C = 6;
    public static final int E_N = 7;
    public static final int E_O = 8;
    public static final int E_F = 9;
    public static final int E_Ne = 10;
    public static final int E_Na = 11;
    public static final int E_Mg = 12;
    public static final int E_Al = 13;
    public static final int E_Si = 14;
    public static final int E_P = 15;
    public static final int E_S = 16;
    public static final int E_Cl = 17;
    public static final int E_Ar = 18;
    public static final int E_K = 19;
    public static final int E_Ca = 20;
    public static final int E_Sc = 21;
    public static final int E_Ti = 22;
    public static final int E_V = 23;
    public static final int E_Cr = 24;
    public static final int E_Mn = 25;
    public static final int E_Fe = 26;
    public static final int E_Co = 27;
    public static final int E_Ni = 28;
    public static final int E_Cu = 29;
    public static final int E_Zn = 30;
    public static final int E_Ga = 31;
    public static final int E_Ge = 32;
    public static final int E_As = 33;
    public static final int E_Se = 34;
    public static final int E_Br = 35;
    public static final int E_Kr = 36;
    public static final int E_Rb = 37;
    public static final int E_Sr = 38;
    public static final int E_Y = 39;
    public static final int E_Zr = 40;
    public static final int E_Nb = 41;
    public static final int E_Mo = 42;
    public static final int E_Tc = 43;
    public static final int E_Ru = 44;
    public static final int E_Rh = 45;
    public static final int E_Pd = 46;
    public static final int E_Ag = 47;
    public static final int E_Cd = 48;
    public static final int E_In = 49;
    public static final int E_Sn = 50;
    public static final int E_Sb = 51;
    public static final int E_Te = 52;
    public static final int E_I = 53;
    public static final int E_Xe = 54;
    public static final int E_Cs = 55;
    public static final int E_Ba = 56;
    public static final int E_La = 57;
    public static final int E_Ce = 58;
    public static final int E_Pr = 59;
    public static final int E_Nd = 60;
    public static final int E_Pm = 61;
    public static final int E_Sm = 62;
    public static final int E_Eu = 63;
    public static final int E_Gd = 64;
    public static final int E_Tb = 65;
    public static final int E_Dy = 66;
    public static final int E_Ho = 67;
    public static final int E_Er = 68;
    public static final int E_Tm = 69;
    public static final int E_Yb = 70;
    public static final int E_Lu = 71;
    public static final int E_Hf = 72;
    public static final int E_Ta = 73;
    public static final int E_W = 74;
    public static final int E_Re = 75;
    public static final int E_Os = 76;
    public static final int E_Ir = 77;
    public static final int E_Pt = 78;
    public static final int E_Au = 79;
    public static final int E_Hg = 80;
    public static final int E_Tl = 81;
    public static final int E_Pb = 82;
    public static final int E_Bi = 83;
    public static final int E_Po = 84;
    public static final int E_At = 85;
    public static final int E_Rn = 86;
    public static final int E_Fr = 87;
    public static final int E_Ra = 88;
    public static final int E_Ac = 89;
    public static final int E_Th = 90;
    public static final int E_Pa = 91;
    public static final int E_U = 92;
    public static final int E_Np = 93;
    public static final int E_Pu = 94;
    public static final int E_Am = 95;
    public static final int E_Cm = 96;
    public static final int E_Bk = 97;
    public static final int E_Cf = 98;
    public static final int E_Es = 99;
    public static final int E_Fm = 100;
    public static final int E_Md = 101;
    public static final int E_No = 102;
    public static final int E_Lr = 103;
    public static final int E_Rf = 104;
    public static final int E_Db = 105;
    public static final int E_Sg = 106;
    public static final int E_Bh = 107;
    public static final int E_Hs = 108;
    public static final int E_Mt = 109;
    public static final int E_Ds = 110;
    public static final int E_Rg = 111;
    public static final int E_Cn = 112;
    public static final int E_Uut = 113;
    public static final int E_Uuq = 114;
    public static final int E_Uup = 115;
    public static final int E_Uuh = 116;
    public static final int E_Uus = 117;
    public static final int E_Uuo = 118;
    public static final int E_Uue = 119;

    public Element(int n) {
        switch (n) {
            case 1: {
                this.number = 1;
                this.mass = 1.008;
                this.radius = 1.2;
                this.electrons = "1s1";
                this.color = new Color(255, 255, 255, 255);
                this.name = "hydrogen";
                this.abbr = "H";
                break;
            }
            case 2: {
                this.number = 2;
                this.mass = 4.003;
                this.radius = 1.4;
                this.electrons = "1s2";
                this.color = new Color(217, 255, 255, 255);
                this.name = "helium";
                this.abbr = "He";
                break;
            }
            case 3: {
                this.number = 3;
                this.mass = 6.941;
                this.radius = 1.8;
                this.electrons = "1s2 2s1";
                this.color = new Color(204, 128, 255, 255);
                this.name = "lithium";
                this.abbr = "Li";
                break;
            }
            case 4: {
                this.number = 4;
                this.mass = 9.012;
                this.radius = 1.5;
                this.electrons = "1s2 2s2";
                this.color = new Color(194, 255, 0, 255);
                this.name = "beryllium";
                this.abbr = "Be";
                break;
            }
            case 5: {
                this.number = 5;
                this.mass = 10.811;
                this.radius = 1.9;
                this.electrons = "[He] 2s2 2p1";
                this.color = new Color(255, 181, 181, 255);
                this.name = "boron";
                this.abbr = "B";
                break;
            }
            case 6: {
                this.number = 6;
                this.mass = 12.011;
                this.radius = 1.7;
                this.electrons = "[He] 2s2 2p2";
                this.color = new Color(144, 144, 144, 255);
                this.name = "carbon";
                this.abbr = "C";
                break;
            }
            case 7: {
                this.number = 7;
                this.mass = 14.007;
                this.radius = 1.7;
                this.electrons = "[He] 2s2 2p3";
                this.color = new Color(48, 80, 248, 255);
                this.name = "nitrogen";
                this.abbr = "N";
                break;
            }
            case 8: {
                this.number = 8;
                this.mass = 15.999;
                this.radius = 1.5;
                this.electrons = "[He] 2s2 2p4";
                this.color = new Color(255, 13, 13, 255);
                this.name = "oxygen";
                this.abbr = "O";
                break;
            }
            case 9: {
                this.name = "fluorine";
                this.abbr = "F";
                this.number = 9;
                this.mass = 18.998;
                this.electrons = "[He] 2s2 2p5";
                this.radius = 1.5;
                this.color = new Color(144, 224, 80, 255);
                break;
            }
            case 10: {
                this.name = "neon";
                this.abbr = "Ne";
                this.number = 10;
                this.mass = 20.18;
                this.electrons = "[He] 2s2 2p6";
                this.radius = 1.5;
                this.color = new Color(179, 227, 245, 255);
                break;
            }
            case 11: {
                this.name = "sodium";
                this.abbr = "Na";
                this.number = 11;
                this.mass = 22.988;
                this.electrons = "[Ne] 3s1";
                this.radius = 2.3;
                this.color = new Color(171, 92, 242, 255);
                break;
            }
            case 12: {
                this.name = "magnesium";
                this.abbr = "Mg";
                this.number = 12;
                this.mass = 24.305;
                this.electrons = "[Ne] 3s2";
                this.radius = 1.7;
                this.color = new Color(138, 255, 0, 255);
                break;
            }
            case 13: {
                this.name = "aluminium";
                this.abbr = "Al";
                this.number = 13;
                this.mass = 26.982;
                this.electrons = "[Ne] 3s2 3p1";
                this.radius = 1.8;
                this.color = new Color(191, 166, 166, 255);
                break;
            }
            case 14: {
                this.name = "silicon";
                this.abbr = "Si";
                this.number = 14;
                this.mass = 28.086;
                this.electrons = "[Ne] 3s2 3p2";
                this.radius = 2.1;
                this.color = new Color(240, 200, 160, 255);
                break;
            }
            case 15: {
                this.name = "phosphorus";
                this.abbr = "P";
                this.number = 15;
                this.mass = 30.974;
                this.electrons = "[Ne] 3s2 3p3";
                this.radius = 1.8;
                this.color = new Color(255, 128, 0, 255);
                break;
            }
            case 16: {
                this.name = "sulfur";
                this.abbr = "S";
                this.number = 16;
                this.mass = 32.065;
                this.electrons = "[Ne] 3s2 3p4";
                this.radius = 1.8;
                this.color = new Color(255, 255, 48, 255);
                break;
            }
            case 17: {
                this.name = "chlorine";
                this.abbr = "Cl";
                this.number = 17;
                this.mass = 35.453;
                this.electrons = "[Ne] 3s2 3p5";
                this.radius = 1.8;
                this.color = new Color(31, 240, 31, 255);
                break;
            }
            case 18: {
                this.name = "argon";
                this.abbr = "Ar";
                this.number = 18;
                this.mass = 39.948;
                this.electrons = "[Ne] 3s2 3p6";
                this.radius = 1.9;
                this.color = new Color(128, 209, 227, 255);
                break;
            }
            case 19: {
                this.name = "potassium";
                this.abbr = "K";
                this.number = 19;
                this.mass = 39.098;
                this.electrons = "[Ar] 4s1";
                this.radius = 2.8;
                this.color = new Color(143, 64, 212, 255);
                break;
            }
            case 20: {
                this.name = "calsium";
                this.abbr = "Ca";
                this.number = 20;
                this.mass = 40.078;
                this.electrons = "[Ar] 4s2";
                this.radius = 2.3;
                this.color = new Color(61, 255, 0, 255);
                break;
            }
            case 21: {
                this.name = "scandium";
                this.abbr = "Sc";
                this.number = 21;
                this.mass = 44.956;
                this.electrons = "[Ar] 3d1 4s2";
                this.radius = 2.1;
                this.color = new Color(230, 230, 230, 255);
                break;
            }
            case 22: {
                this.name = "titanium";
                this.abbr = "Ti";
                this.number = 22;
                this.mass = 47.867;
                this.electrons = "[Ar] 3d2 4s2";
                this.radius = 2.0;
                this.color = new Color(191, 194, 199, 255);
                break;
            }
            case 23: {
                this.name = "vanadium";
                this.abbr = "V";
                this.number = 23;
                this.mass = 50.942;
                this.electrons = "[Ar] 3d3 4s2";
                this.radius = 1.9;
                this.color = new Color(166, 166, 171, 255);
                break;
            }
            case 24: {
                this.name = "chromium";
                this.abbr = "Cr";
                this.number = 24;
                this.mass = 51.996;
                this.electrons = "[Ar] 3d4 4s2";
                this.radius = 1.8;
                this.color = new Color(138, 153, 199, 255);
                break;
            }
            case 25: {
                this.name = "manganese";
                this.abbr = "Mn";
                this.number = 25;
                this.mass = 54.938;
                this.electrons = "[Ar] 3d5 4s2";
                this.radius = 1.7;
                this.color = new Color(156, 122, 199, 255);
                break;
            }
            case 26: {
                this.name = "iron";
                this.abbr = "Fe";
                this.number = 26;
                this.mass = 55.845;
                this.electrons = "[Ar] 3d6 4s2";
                this.radius = 1.7;
                this.color = new Color(224, 102, 51, 255);
                break;
            }
            case 27: {
                this.name = "cobalt";
                this.abbr = "Co";
                this.number = 27;
                this.mass = 58.933;
                this.electrons = "[Ar] 3d7 4s2";
                this.radius = 1.6;
                this.color = new Color(240, 144, 160, 255);
                break;
            }
            case 28: {
                this.name = "nickel";
                this.abbr = "Ni";
                this.number = 28;
                this.mass = 58.693;
                this.electrons = "[Ar] 3d9 4s1";
                this.radius = 1.6;
                this.color = new Color(80, 208, 80, 255);
                break;
            }
            case 29: {
                this.name = "copper";
                this.abbr = "Cu";
                this.number = 29;
                this.mass = 63.546;
                this.electrons = "[Ar] 3d10 4s1";
                this.radius = 1.4;
                this.color = new Color(200, 128, 51, 255);
                break;
            }
            case 30: {
                this.name = "zinc";
                this.abbr = "Zn";
                this.number = 30;
                this.mass = 65.38;
                this.electrons = "[Ar] 3d10 4s2";
                this.radius = 1.4;
                this.color = new Color(125, 128, 176, 255);
                break;
            }
            case 31: {
                this.name = "gallium";
                this.abbr = "Ga";
                this.number = 31;
                this.mass = 69.723;
                this.electrons = "[Ar] 3d10 4s2 4p1";
                this.radius = 1.9;
                this.color = new Color(194, 143, 143, 255);
                break;
            }
            case 32: {
                this.name = "germanium";
                this.abbr = "Ge";
                this.number = 32;
                this.mass = 72.64;
                this.electrons = "[Ar] 3d10 4s2 4p2";
                this.radius = 2.1;
                this.color = new Color(102, 143, 143, 255);
                break;
            }
            case 33: {
                this.name = "arsenic";
                this.abbr = "As";
                this.number = 33;
                this.mass = 74.921;
                this.electrons = "[Ar] 3d10 4s2 4p3";
                this.radius = 1.9;
                this.color = new Color(189, 128, 227, 255);
                break;
            }
            case 34: {
                this.name = "selenium";
                this.abbr = "Se";
                this.number = 34;
                this.mass = 78.96;
                this.electrons = "[Ar] 3d10 4s2 4p4";
                this.radius = 1.9;
                this.color = new Color(255, 161, 0, 255);
                break;
            }
            case 35: {
                this.name = "bromine";
                this.abbr = "Br";
                this.number = 35;
                this.mass = 79.904;
                this.electrons = "[Ar] 3d10 4s2 4p5";
                this.radius = 1.9;
                this.color = new Color(166, 41, 41, 255);
                break;
            }
            case 36: {
                this.name = "krypton";
                this.abbr = "Kr";
                this.number = 36;
                this.mass = 83.798;
                this.electrons = "[Ar] 3d10 4s2 4p6";
                this.radius = 2.0;
                this.color = new Color(92, 184, 209, 255);
                break;
            }
            case 37: {
                this.name = "rubidium";
                this.abbr = "Rb";
                this.number = 37;
                this.mass = 85.467;
                this.electrons = "[Kr] 5s1";
                this.radius = 3.0;
                this.color = new Color(112, 46, 176, 255);
                break;
            }
            case 38: {
                this.name = "strontium";
                this.abbr = "Sr";
                this.number = 38;
                this.mass = 87.62;
                this.electrons = "[Kr] 5s2";
                this.radius = 2.5;
                this.color = new Color(0, 255, 0, 255);
                break;
            }
            case 39: {
                this.name = "yttrium";
                this.abbr = "Y";
                this.number = 39;
                this.mass = 88.909;
                this.electrons = "[Kr] 4d1 5s2";
                this.radius = 1.9;
                this.color = new Color(148, 255, 255, 255);
                break;
            }
            case 40: {
                this.name = "zirconium";
                this.abbr = "Zr";
                this.number = 40;
                this.mass = 91.224;
                this.electrons = "[Kr] 4d2 5s2";
                this.radius = 1.9;
                this.color = new Color(148, 224, 224, 255);
                break;
            }
            case 41: {
                this.name = "niobium";
                this.abbr = "Nb";
                this.number = 41;
                this.mass = 92.906;
                this.electrons = "[Kr] 4d4 5s1";
                this.radius = 1.8;
                this.color = new Color(115, 194, 201, 255);
                break;
            }
            case 42: {
                this.name = "molybdenum";
                this.abbr = "Mo";
                this.number = 42;
                this.mass = 95.94;
                this.electrons = "[Kr] 4d5 5s1";
                this.radius = 1.7;
                this.color = new Color(84, 181, 181, 255);
                break;
            }
            case 43: {
                this.name = "technetium";
                this.abbr = "Tc";
                this.number = 43;
                this.mass = 98.0;
                this.electrons = "[Kr] 4d5 5s2";
                this.radius = 1.6;
                this.color = new Color(59, 158, 158, 255);
                break;
            }
            case 44: {
                this.name = "ruthenium";
                this.abbr = "Ru";
                this.number = 44;
                this.mass = 101.07;
                this.electrons = "[Kr] 4d7 5s1";
                this.radius = 1.6;
                this.color = new Color(36, 143, 143, 255);
                break;
            }
            case 45: {
                this.name = "rhodium";
                this.abbr = "Rh";
                this.number = 45;
                this.mass = 102.906;
                this.electrons = "[Kr] 4d8 5s1";
                this.radius = 1.6;
                this.color = new Color(10, 125, 140, 255);
                break;
            }
            case 46: {
                this.name = "palladium";
                this.abbr = "Pd";
                this.number = 46;
                this.mass = 106.42;
                this.electrons = "[Kr] 4d10";
                this.radius = 1.6;
                this.color = new Color(0, 105, 133, 255);
                break;
            }
            case 47: {
                this.name = "silver";
                this.abbr = "Ag";
                this.number = 47;
                this.mass = 107.868;
                this.electrons = "[Kr] 4d10 5s1";
                this.radius = 1.7;
                this.color = new Color(192, 192, 192, 255);
                break;
            }
            case 48: {
                this.name = "cadmium";
                this.abbr = "Cd";
                this.number = 48;
                this.mass = 112.411;
                this.electrons = "[Kr] 4d10 5s2";
                this.radius = 1.6;
                this.color = new Color(255, 217, 143, 255);
                break;
            }
            case 49: {
                this.name = "indium";
                this.abbr = "In";
                this.number = 49;
                this.mass = 114.818;
                this.electrons = "[Kr] 4d10 5s2 5p1";
                this.radius = 1.9;
                this.color = new Color(166, 117, 115, 255);
                break;
            }
            case 50: {
                this.name = "tin";
                this.abbr = "In";
                this.number = 50;
                this.mass = 118.71;
                this.electrons = "[Kr] 4d10 5s2 5p2";
                this.radius = 2.2;
                this.color = new Color(102, 128, 128, 255);
                break;
            }
            case 51: {
                this.name = "antimony";
                this.abbr = "Sb";
                this.number = 51;
                this.mass = 121.76;
                this.electrons = "[Kr] 4d10 5s2 5p3";
                this.radius = 2.0;
                this.color = new Color(158, 99, 181, 255);
                break;
            }
            case 52: {
                this.name = "tellurium";
                this.abbr = "Te";
                this.number = 52;
                this.mass = 127.6;
                this.electrons = "[Kr] 4d10 5s2 5p4";
                this.radius = 2.0;
                this.color = new Color(212, 122, 0, 255);
                break;
            }
            case 53: {
                this.name = "iodine";
                this.abbr = "I";
                this.number = 53;
                this.mass = 127.6;
                this.electrons = "[Kr] 4d10 5s2 5p5";
                this.radius = 2.0;
                this.color = new Color(148, 0, 148, 255);
                break;
            }
            case 54: {
                this.name = "xenon";
                this.abbr = "Xe";
                this.number = 54;
                this.mass = 131.293;
                this.electrons = "[Kr] 4d10 5s2 5p6";
                this.radius = 2.2;
                this.color = new Color(66, 158, 176, 255);
                break;
            }
            case 55: {
                this.name = "cesium";
                this.abbr = "Cs";
                this.number = 55;
                this.mass = 132.905;
                this.electrons = "[Xe] 6s1";
                this.radius = 3.4;
                this.color = new Color(87, 23, 143, 255);
                break;
            }
            case 56: {
                this.name = "barium";
                this.abbr = "Ba";
                this.number = 56;
                this.mass = 137.33;
                this.electrons = "[Xe] 6s2";
                this.radius = 2.7;
                this.color = new Color(0, 201, 0, 255);
                break;
            }
            case 57: {
                this.name = "lanthanum";
                this.abbr = "La";
                this.number = 57;
                this.mass = 138.905;
                this.electrons = "[Xe] 5d1 6s2";
                this.radius = 2.6;
                this.color = new Color(112, 212, 255, 255);
                break;
            }
            case 58: {
                this.name = "cerium";
                this.abbr = "Ce";
                this.number = 58;
                this.mass = 140.116;
                this.electrons = "[Xe] 4f2 6s2";
                this.radius = 2.6;
                this.color = new Color(255, 255, 199, 255);
                break;
            }
            case 59: {
                this.name = "praseodymium";
                this.abbr = "Pr";
                this.number = 59;
                this.mass = 140.908;
                this.electrons = "[Xe] 4f3 6s2";
                this.radius = 2.6;
                this.color = new Color(217, 255, 199, 255);
                break;
            }
            case 60: {
                this.name = "neodymium";
                this.abbr = "Ne";
                this.number = 60;
                this.mass = 144.242;
                this.electrons = "[Xe] 4f4 6s2";
                this.radius = 2.5;
                this.color = new Color(199, 255, 199, 255);
                break;
            }
            case 61: {
                this.name = "promethium";
                this.abbr = "Pm";
                this.number = 61;
                this.mass = 145.0;
                this.electrons = "[Xe] 4f5 6s2";
                this.radius = 2.4;
                this.color = new Color(163, 255, 199, 255);
                break;
            }
            case 62: {
                this.name = "samarium";
                this.abbr = "Sm";
                this.number = 62;
                this.mass = 150.36;
                this.electrons = "[Xe] 4f6 6s2";
                this.radius = 2.4;
                this.color = new Color(143, 255, 199, 255);
                break;
            }
            case 63: {
                this.name = "europium";
                this.abbr = "Eu";
                this.number = 63;
                this.mass = 151.964;
                this.electrons = "[Xe] 4f7 6s2";
                this.radius = 2.4;
                this.color = new Color(97, 255, 199, 255);
                break;
            }
            case 64: {
                this.name = "gadolinium";
                this.abbr = "Gd";
                this.number = 64;
                this.mass = 157.25;
                this.electrons = "[Xe] 4f7 5d1 6s2";
                this.radius = 2.4;
                this.color = new Color(69, 255, 199, 255);
                break;
            }
            case 65: {
                this.name = "terbium";
                this.abbr = "Tb";
                this.number = 65;
                this.mass = 158.925;
                this.electrons = "[Xe] 4f9 6s2";
                this.radius = 2.3;
                this.color = new Color(48, 255, 199, 255);
                break;
            }
            case 66: {
                this.name = "dysporsium";
                this.abbr = "Dy";
                this.number = 66;
                this.mass = 162.5;
                this.electrons = "[Xe] 4f10 6s2";
                this.radius = 2.3;
                this.color = new Color(31, 255, 199, 255);
                break;
            }
            case 67: {
                this.name = "holmium";
                this.abbr = "Ho";
                this.number = 67;
                this.mass = 164.93;
                this.electrons = "[Xe] 4f11 6s2";
                this.radius = 2.3;
                this.color = new Color(0, 255, 156, 255);
                break;
            }
            case 68: {
                this.name = "erbium";
                this.abbr = "Er";
                this.number = 68;
                this.mass = 167.259;
                this.electrons = "[Xe] 4f12 6s2";
                this.radius = 2.2;
                this.color = new Color(0, 230, 117, 255);
                break;
            }
            case 69: {
                this.name = "thulium";
                this.abbr = "Tm";
                this.number = 69;
                this.mass = 168.934;
                this.electrons = "[Xe] 4f13 6s2";
                this.radius = 2.2;
                this.color = new Color(0, 212, 82, 255);
                break;
            }
            case 70: {
                this.name = "ytterbium";
                this.abbr = "Yb";
                this.number = 70;
                this.mass = 173.04;
                this.electrons = "[Xe] 4f14 6s2";
                this.radius = 2.1;
                this.color = new Color(0, 191, 56, 255);
                break;
            }
            case 71: {
                this.name = "lutetium";
                this.abbr = "Lu";
                this.number = 71;
                this.mass = 174.967;
                this.electrons = "[Xe] 4f14 5d1 6s2";
                this.radius = 2.1;
                this.color = new Color(0, 171, 36, 255);
                break;
            }
            case 72: {
                this.name = "hafnium";
                this.abbr = "Hf";
                this.number = 72;
                this.mass = 178.49;
                this.electrons = "[Xe] 4f14 5d2 6s2";
                this.radius = 2.0;
                this.color = new Color(77, 194, 255, 255);
                break;
            }
            case 73: {
                this.name = "tantalum";
                this.abbr = "Ta";
                this.number = 73;
                this.mass = 180.948;
                this.electrons = "[Xe] 4f14 5d3 6s2";
                this.radius = 1.9;
                this.color = new Color(77, 166, 255, 255);
                break;
            }
            case 74: {
                this.name = "tungsten";
                this.abbr = "Ta";
                this.number = 74;
                this.mass = 183.84;
                this.electrons = "[Xe] 4f14 5d4 6s2";
                this.radius = 1.9;
                this.color = new Color(33, 148, 214, 255);
                break;
            }
            case 75: {
                this.name = "rhenium";
                this.abbr = "Re";
                this.number = 75;
                this.mass = 186.207;
                this.electrons = "[Xe] 4f14 5d5 6s2";
                this.radius = 1.8;
                this.color = new Color(38, 125, 171, 255);
                break;
            }
            case 76: {
                this.name = "osmium";
                this.abbr = "Os";
                this.number = 76;
                this.mass = 190.23;
                this.electrons = "[Xe] 4f14 5d6 6s2";
                this.radius = 1.7;
                this.color = new Color(38, 102, 150, 255);
                break;
            }
            case 77: {
                this.name = "iridium";
                this.abbr = "Ir";
                this.number = 77;
                this.mass = 192.217;
                this.electrons = "[Xe] 4f14 5d7 6s2";
                this.radius = 1.7;
                this.color = new Color(23, 84, 135, 255);
                break;
            }
            case 78: {
                this.name = "platinum";
                this.abbr = "Pt";
                this.number = 78;
                this.mass = 195.084;
                this.electrons = "[Xe] 4f14 5d9 6s1";
                this.radius = 1.7;
                this.color = new Color(208, 208, 224, 255);
                break;
            }
            case 79: {
                this.name = "gold";
                this.abbr = "Au";
                this.number = 79;
                this.mass = 196.967;
                this.electrons = "[Xe] 4f14 5d10 6s1";
                this.radius = 1.7;
                this.color = new Color(255, 209, 35, 255);
                break;
            }
            case 80: {
                this.name = "mercury";
                this.abbr = "Hg";
                this.number = 80;
                this.mass = 200.59;
                this.electrons = "[Xe] 4f14 5d10 6s2";
                this.radius = 1.6;
                this.color = new Color(184, 184, 208, 255);
                break;
            }
            case 81: {
                this.name = "thallium";
                this.abbr = "Tl";
                this.number = 81;
                this.mass = 204.383;
                this.electrons = "[Xe] 4f14 5d10 6s2 6p1";
                this.radius = 2.0;
                this.color = new Color(166, 84, 77, 255);
                break;
            }
            case 82: {
                this.name = "lead";
                this.abbr = "Pb";
                this.number = 82;
                this.mass = 207.2;
                this.electrons = "[Xe] 4f14 5d10 6s2 6p2";
                this.radius = 2.0;
                this.color = new Color(87, 89, 97, 255);
                break;
            }
            case 83: {
                this.name = "bismuth";
                this.abbr = "Bi";
                this.number = 83;
                this.mass = 208.98;
                this.electrons = "[Xe] 4f14 5d10 6s2 6p3";
                this.radius = 2.1;
                this.color = new Color(158, 79, 181, 255);
                break;
            }
            case 84: {
                this.name = "polonium";
                this.abbr = "Po";
                this.number = 84;
                this.mass = 209.0;
                this.electrons = "[Xe] 4f14 5d10 6s2 6p4";
                this.radius = 2.0;
                this.color = new Color(171, 92, 0, 255);
                break;
            }
            case 85: {
                this.name = "astatine";
                this.abbr = "At";
                this.number = 85;
                this.mass = 210.0;
                this.electrons = "[Xe] 4f14 5d10 6s2 6p5";
                this.radius = 2.0;
                this.color = new Color(117, 79, 69, 255);
                break;
            }
            case 86: {
                this.name = "radon";
                this.abbr = "Rn";
                this.number = 86;
                this.mass = 222.0;
                this.electrons = "[Xe] 4f14 5d10 6s2 6p6";
                this.radius = 2.2;
                this.color = new Color(66, 130, 150, 255);
                break;
            }
            case 87: {
                this.name = "francium";
                this.abbr = "Fr";
                this.number = 87;
                this.mass = 223.0;
                this.electrons = "[Rn] 7s1";
                this.radius = 3.5;
                this.color = new Color(66, 0, 102, 255);
                break;
            }
            case 88: {
                this.name = "radium";
                this.abbr = "Ra";
                this.number = 88;
                this.mass = 226.0;
                this.electrons = "[Rn] 7s2";
                this.radius = 2.8;
                this.color = new Color(0, 125, 0, 255);
                break;
            }
            case 89: {
                this.name = "actinium";
                this.abbr = "Ac";
                this.number = 89;
                this.mass = 227.0;
                this.electrons = "[Rn] 6d1 7s2";
                this.radius = 2.7;
                this.color = new Color(112, 171, 250, 255);
                break;
            }
            case 90: {
                this.name = "thorium";
                this.abbr = "Th";
                this.number = 90;
                this.mass = 232.038;
                this.electrons = "[Rn] 6d2 7s2";
                this.radius = 2.6;
                this.color = new Color(0, 186, 255, 255);
                break;
            }
            case 91: {
                this.name = "protactinium";
                this.abbr = "Pa";
                this.number = 91;
                this.mass = 231.036;
                this.electrons = "[Rn] 5f2 6d1 7s2";
                this.radius = 2.4;
                this.color = new Color(0, 161, 255, 255);
                break;
            }
            case 92: {
                this.name = "uranium";
                this.abbr = "U";
                this.number = 92;
                this.mass = 238.029;
                this.electrons = "[Rn] 5f3 6d1 7s2";
                this.radius = 1.9;
                this.color = new Color(0, 143, 255, 255);
                break;
            }
            case 93: {
                this.name = "neptunium";
                this.abbr = "Np";
                this.number = 93;
                this.mass = 237.0;
                this.electrons = "[Rn] 5f4 6d1 7s2";
                this.radius = 1.9;
                this.color = new Color(0, 128, 255, 255);
                break;
            }
            case 94: {
                this.name = "plutonium";
                this.abbr = "Pu";
                this.number = 94;
                this.mass = 244.0;
                this.electrons = "[Rn] 5f6 7s2";
                this.radius = 1.9;
                this.color = new Color(0, 107, 255, 255);
                break;
            }
            case 95: {
                this.name = "americium";
                this.abbr = "Am";
                this.number = 95;
                this.mass = 243.0;
                this.electrons = "[Rn] 5f7 7s2";
                this.radius = 1.9;
                this.color = new Color(84, 92, 242, 255);
                break;
            }
            case 96: {
                this.name = "curium";
                this.abbr = "Cm";
                this.number = 96;
                this.mass = 247.0;
                this.electrons = "[Rn] 5f7 6d1 7s2";
                this.radius = 1.9;
                this.color = new Color(120, 92, 227, 255);
                break;
            }
            case 97: {
                this.name = "berkelium";
                this.abbr = "Bk";
                this.number = 97;
                this.mass = 247.0;
                this.electrons = "[Rn] 5f9 7s2";
                this.radius = 1.9;
                this.color = new Color(138, 79, 227, 255);
                break;
            }
            case 98: {
                this.name = "californium";
                this.abbr = "Cf";
                this.number = 98;
                this.mass = 251.0;
                this.electrons = "[Rn] 5f10 7s2";
                this.radius = 1.9;
                this.color = new Color(161, 54, 212, 255);
                break;
            }
            case 99: {
                this.name = "einsteinium";
                this.abbr = "Es";
                this.number = 99;
                this.mass = 252.0;
                this.electrons = "[Rn] 5f11 7s2";
                this.radius = 1.9;
                this.color = new Color(179, 31, 212, 255);
                break;
            }
            case 100: {
                this.name = "fermium";
                this.abbr = "Fe";
                this.number = 100;
                this.mass = 257.0;
                this.electrons = "[Rn] 5f12 7s2";
                this.radius = 1.9;
                this.color = new Color(179, 31, 186, 255);
                break;
            }
            case 101: {
                this.name = "mendelevium";
                this.abbr = "Md";
                this.number = 101;
                this.mass = 258.0;
                this.electrons = "[Rn] 5f13 7s2";
                this.radius = 1.9;
                this.color = new Color(179, 13, 166, 255);
                break;
            }
            case 102: {
                this.name = "nobelium";
                this.abbr = "No";
                this.number = 102;
                this.mass = 259.0;
                this.electrons = "[Rn] 5f14 7s2";
                this.radius = 1.9;
                this.color = new Color(189, 13, 135, 255);
                break;
            }
            case 103: {
                this.name = "lawrencium";
                this.abbr = "Lr";
                this.number = 103;
                this.mass = 262.0;
                this.electrons = "[Rn] 5f14 7s2 7p1";
                this.radius = 1.9;
                this.color = new Color(199, 0, 102, 255);
                break;
            }
            case 104: {
                this.name = "rutherfordium";
                this.abbr = "Rf";
                this.number = 104;
                this.mass = 267.0;
                this.electrons = "[Rn] 5f14 6d2 7s2";
                this.radius = 1.9;
                this.color = new Color(204, 0, 89, 255);
                break;
            }
            case 105: {
                this.name = "dubnium";
                this.abbr = "Db";
                this.number = 105;
                this.mass = 268.0;
                this.electrons = "[Rn] 5f14 6d3 7s2";
                this.radius = 1.9;
                this.color = new Color(209, 0, 79, 255);
                break;
            }
            case 106: {
                this.name = "seaborgium";
                this.abbr = "Sg";
                this.number = 106;
                this.mass = 271.0;
                this.electrons = "[Rn] 5f14 6d4 7s2";
                this.radius = 1.9;
                this.color = new Color(217, 0, 69, 255);
                break;
            }
            case 107: {
                this.name = "bohrium";
                this.abbr = "Bh";
                this.number = 107;
                this.mass = 270.0;
                this.electrons = "[Rn] 5f14 6d5 7s2";
                this.radius = 1.9;
                this.color = new Color(224, 0, 56, 255);
                break;
            }
            case 108: {
                this.name = "hassium";
                this.abbr = "Hs";
                this.number = 108;
                this.mass = 269.0;
                this.electrons = "[Rn] 5f14 6d6 7s2";
                this.radius = 1.9;
                this.color = new Color(230, 0, 46, 255);
                break;
            }
            case 109: {
                this.name = "meitnerium";
                this.abbr = "Mt";
                this.number = 109;
                this.mass = 278.0;
                this.electrons = "[Rn] 5f14 6d7 7s2";
                this.radius = 1.9;
                this.color = new Color(235, 0, 38, 255);
                break;
            }
            case 110: {
                this.name = "darmstadium";
                this.abbr = "Ds";
                this.number = 110;
                this.mass = 281.0;
                this.electrons = "[Rn] 5f14 6d9 7s1";
                this.radius = 1.9;
                this.color = new Color(200, 200, 200, 255);
                break;
            }
            case 111: {
                this.name = "roentgenium";
                this.abbr = "Rg";
                this.number = 111;
                this.mass = 281.0;
                this.electrons = "[Rn] 5f14 6d10 7s1";
                this.radius = 1.9;
                this.color = new Color(200, 200, 200, 255);
                break;
            }
            case 112: {
                this.name = "copernicium";
                this.abbr = "Cn";
                this.number = 112;
                this.mass = 285.0;
                this.electrons = "[Rn] 5f14 6d10 7s2";
                this.radius = 1.9;
                this.color = new Color(200, 200, 200, 255);
                break;
            }
            case 113: {
                this.name = "ununtrium";
                this.abbr = "Uut";
                this.number = 113;
                this.mass = 286.0;
                this.electrons = "[Rn] 5f14 6d10 7s2 7p1";
                this.radius = 1.9;
                this.color = new Color(200, 200, 200, 255);
                break;
            }
            case 114: {
                this.name = "ununquadium";
                this.abbr = "Uuq";
                this.number = 114;
                this.mass = 289.0;
                this.electrons = "[Rn] 5f14 6d10 7s2 7p2";
                this.radius = 1.9;
                this.color = new Color(200, 200, 200, 255);
                break;
            }
            case 115: {
                this.name = "ununpentium";
                this.abbr = "Uup";
                this.number = 115;
                this.mass = 289.0;
                this.electrons = "[Rn] 5f14 6d10 7s2 7p3";
                this.radius = 1.9;
                this.color = new Color(200, 200, 200, 255);
                break;
            }
            case 116: {
                this.name = "ununhexium";
                this.abbr = "Uuh";
                this.number = 116;
                this.mass = 293.0;
                this.electrons = "[Rn] 5f14 6d10 7s2 7p4";
                this.radius = 1.9;
                this.color = new Color(200, 200, 200, 255);
                break;
            }
            case 117: {
                this.name = "ununseptium";
                this.abbr = "Uus";
                this.number = 117;
                this.mass = 294.0;
                this.electrons = "[Rn] 5f14 6d10 7s2 7p5";
                this.radius = 1.9;
                this.color = new Color(200, 200, 200, 255);
                break;
            }
            case 118: {
                this.name = "ununoctium";
                this.abbr = "Uuo";
                this.number = 118;
                this.mass = 294.0;
                this.electrons = "[Rn] 5f14 6d10 7s2 7p6";
                this.radius = 1.9;
                this.color = new Color(200, 200, 200, 255);
                break;
            }
            case 119: {
                this.name = "ununennium";
                this.abbr = "Uue";
                this.number = 119;
                this.mass = 294.0;
                this.electrons = "[Uuo] 8s1";
                this.radius = 1.9;
                this.color = new Color(200, 200, 200, 255);
                break;
            }
            case 0: {
                this.number = 120;
                this.mass = 1.0;
                this.radius = 1.0;
                this.electrons = "";
                this.color = new Color(50, 180, 20, 255);
                this.name = "special";
                this.abbr = " ";
                break;
            }
            default: {
                this.number = n;
                this.mass = 1.0;
                this.radius = 1.0;
                this.electrons = "";
                this.color = new Color((59 * (n - 120) + 100) % 200, (43 * (n - 120) + 180) % 200, (47 * (n - 120) + 220) % 200, 255);
                this.name = "special";
                this.abbr = " ";
            }
        }
    }

    public int getNumber() {
        return this.number;
    }

    public double getMass() {
        return this.mass;
    }

    public String getSymbol() {
        return this.abbr;
    }

    public String getName() {
        return this.name;
    }

    public String getElectrons() {
        return this.electrons;
    }

    public Color getColor() {
        return this.color;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setNumber(int n) {
        this.number = n;
    }

    public void setMass(double d) {
        this.mass = d;
    }

    public void setSymbol(String string) {
        this.abbr = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setElectrons(String string) {
        this.electrons = string;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setRadius(double d) {
        this.radius = d;
    }
}

