/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.StringTokenizer;

public class CustomFunction
implements FormulaBlock {
    private String name;
    private int args;
    private String[] coms;
    private int[] argpos;
    private Calculator calc;

    public CustomFunction(String string, String string2, Calculator calculator) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "#");
        int n = 0;
        if (string2.substring(0, 1).equals("#")) {
            this.coms = new String[stringTokenizer.countTokens() + 1];
            this.argpos = new int[this.coms.length];
            n = 1;
            this.coms[0] = "";
            this.argpos[0] = Integer.parseInt(string2.substring(1, 2)) - 1;
            if (this.argpos[0] < 0) {
                throw new Exception();
            }
            if (this.argpos[0] + 1 > this.args) {
                this.args = this.argpos[0] + 1;
            }
        } else {
            this.coms = new String[stringTokenizer.countTokens()];
            this.argpos = new int[this.coms.length - 1];
        }
        this.args = 0;
        for (int i = n; i < this.coms.length; ++i) {
            String string3 = stringTokenizer.nextToken();
            if (i == 0) {
                this.coms[i] = string3;
                continue;
            }
            this.coms[i] = string3.substring(1, string3.length());
            this.argpos[i - 1] = Integer.parseInt(string3.substring(0, 1)) - 1;
            if (this.argpos[i - 1] < 0) {
                throw new Exception();
            }
            if (this.argpos[i - 1] + 1 <= this.args) continue;
            this.args = this.argpos[i - 1] + 1;
        }
        this.name = string;
        this.calc = calculator;
        Variable[] variableArray = new Variable[this.args];
        for (int i = 0; i < this.args; ++i) {
            variableArray[i] = new Variable("0", 0.0);
        }
        this.expand(new VariableSet("x", variableArray));
    }

    public String getName() {
        return this.name;
    }

    public int getArgumentCount() {
        return this.args;
    }

    public int[] getArgumentPositions() {
        return this.argpos;
    }

    public String getExpression(String[] stringArray) {
        int n;
        String string = "";
        for (n = 0; n < this.coms.length - 1; ++n) {
            string = string + this.coms[n];
            if (stringArray.length <= this.argpos[n]) continue;
            string = string + stringArray[this.argpos[n]];
        }
        string = string + this.coms[this.coms.length - 1];
        for (n = this.args; stringArray.length > n; ++n) {
            string = string + stringArray[n] + " ";
        }
        return string;
    }

    @Override
    public String toString() {
        String[] stringArray = new String[this.args];
        for (int i = 0; i < this.args; ++i) {
            stringArray[i] = "#" + i;
        }
        return this.getExpression(stringArray);
    }

    @Override
    public boolean isOperator() {
        return false;
    }

    @Override
    public boolean isCustomFunction() {
        return true;
    }

    public ArrayList<FormulaBlock> expand(FormulaBlock formulaBlock) throws Exception {
        int n;
        Variable[] variableArray = new Variable[this.args];
        try {
            if (this.args != 1) {
                throw new Exception();
            }
            variableArray[0] = (Variable)formulaBlock;
        }
        catch (Exception exception) {
            VariableSet variableSet = (VariableSet)formulaBlock;
            if (variableSet.countElements() == this.args) {
                for (n = 0; n < this.args; ++n) {
                    variableArray[n] = variableSet.getElement(n);
                }
            }
            System.out.println(this.name + " cannot operate on " + variableSet);
            throw new Exception();
        }
        String[] stringArray = new String[this.args];
        for (int i = 0; i < this.args; ++i) {
            stringArray[i] = "00000000000" + i;
        }
        ArrayList<FormulaBlock> arrayList = this.calc.splitExpression(this.getExpression(stringArray));
        for (n = 0; n < arrayList.size(); ++n) {
            try {
                Variable variable = (Variable)arrayList.get(n);
                for (int i = 0; i < this.args; ++i) {
                    if (!variable.getName().equals("00000000000" + i)) continue;
                    arrayList.set(n, variableArray[i].copy());
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public String getSyntax(String[] stringArray) {
        String string = "";
        string = string + this.name + ":";
        if (this.args > 1) {
            string = string + "{";
            for (int i = 0; i < this.args; ++i) {
                string = string + stringArray[i];
                if (i >= this.args - 1) continue;
                string = string + ",";
            }
            string = string + "}";
        } else {
            string = string + stringArray[0];
        }
        return string;
    }
}

