/*
 * Decompiled with CFR 0.152.
 */
class CoordinatesOperator
extends Operator {
    private Structure geo;

    public CoordinatesOperator(Structure structure) {
        this.geo = structure;
        this.opType = "coord";
        this.nArgs = 1;
        this.argType = 1;
        this.isSingle = true;
        this.arguments = new String[1];
        this.arguments[0] = "particle";
        this.name = "coordinates";
        this.description = "Gives the coordinates of the particle of the given index, in the currently displayed geometry, as a column vector.";
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock) {
        Object object;
        block12: {
            double[][] dArray;
            block11: {
                Variable variable;
                try {
                    variable = (Variable)formulaBlock;
                }
                catch (Exception exception) {
                    object = (VariableSet)formulaBlock;
                    if (((VariableSet)object).countElements() == this.nArgs) {
                        variable = ((VariableSet)object).getElement(0);
                    }
                    System.out.println(this.opType + " cannot operate on " + object);
                    return new Variable("NaN", Double.NaN);
                }
                dArray = variable.getMatrixValue();
                object = new double[][]{{Double.NaN}};
                if (dArray.length != 1) break block11;
                object = new double[3][dArray[0].length];
                for (int i = 0; i < dArray[0].length; ++i) {
                    try {
                        Vector vector = this.geo.getParticle((int)dArray[0][i]).getCoordinates();
                        object[0][i] = vector.element(0);
                        object[1][i] = vector.element(1);
                        object[2][i] = vector.element(2);
                        continue;
                    }
                    catch (Exception exception) {
                        for (int j = 0; j < 3; ++j) {
                            object[j][i] = Double.NaN;
                        }
                    }
                }
                break block12;
            }
            if (dArray[0].length != 1) break block12;
            object = new double[dArray.length][3];
            for (int i = 0; i < dArray.length; ++i) {
                try {
                    Vector vector = this.geo.getParticle((int)dArray[i][0]).getCoordinates();
                    object[i][0] = vector.element(0);
                    object[i][1] = vector.element(1);
                    object[i][2] = vector.element(2);
                    continue;
                }
                catch (Exception exception) {
                    for (int j = 0; j < 3; ++j) {
                        object[i][j] = Double.NaN;
                    }
                }
            }
        }
        return new Variable("r", (double[][])object);
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock, FormulaBlock formulaBlock2) {
        return new Variable("NaN", Double.NaN);
    }
}

