/*
 * Decompiled with CFR 0.152.
 */
class ConstraintsOperator
extends Operator {
    private Structure geo;

    public ConstraintsOperator(Structure structure) {
        this.geo = structure;
        this.opType = "free";
        this.nArgs = 1;
        this.argType = 1;
        this.isSingle = true;
        this.arguments = new String[1];
        this.arguments[0] = "particle";
        this.name = "constraints";
        this.description = "Gives the constraint flags of the particle of the given index, in the currently displayed geometry, as a row vector.";
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock) {
        Object object;
        block14: {
            double[][] dArray;
            block13: {
                Variable variable;
                try {
                    variable = (Variable)formulaBlock;
                }
                catch (Exception exception) {
                    object = (VariableSet)formulaBlock;
                    if (((VariableSet)object).countElements() == this.nArgs) {
                        variable = ((VariableSet)object).getElement(0);
                    }
                    System.out.println(this.opType + " cannot operate on " + object);
                    return new Variable("NaN", Double.NaN);
                }
                dArray = variable.getMatrixValue();
                object = new double[][]{{Double.NaN}};
                if (dArray.length != 1) break block13;
                object = new double[3][dArray[0].length];
                for (int i = 0; i < dArray[0].length; ++i) {
                    int n;
                    try {
                        boolean[] blArray = ((Atom)this.geo.getParticle((int)dArray[0][i])).getFrozenCoordinates();
                        for (n = 0; n < 3; ++n) {
                            object[n][i] = blArray[n] ? (Object)1.0 : (Object)0.0;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        for (n = 0; n < 3; ++n) {
                            object[n][i] = Double.NaN;
                        }
                    }
                }
                break block14;
            }
            if (dArray[0].length != 1) break block14;
            object = new double[dArray.length][3];
            for (int i = 0; i < dArray.length; ++i) {
                int n;
                try {
                    boolean[] blArray = ((Atom)this.geo.getParticle((int)dArray[0][i])).getFrozenCoordinates();
                    for (n = 0; n < 3; ++n) {
                        object[i][n] = blArray[n] ? (Object)1.0 : (Object)0.0;
                    }
                    continue;
                }
                catch (Exception exception) {
                    for (n = 0; n < 3; ++n) {
                        object[i][n] = Double.NaN;
                    }
                }
            }
        }
        return new Variable("r", (double[][])object);
    }

    @Override
    public Variable operate(FormulaBlock formulaBlock, FormulaBlock formulaBlock2) {
        return new Variable("NaN", Double.NaN);
    }
}

