/*
 * Decompiled with CFR 0.152.
 */
public class Cluster
implements Particle {
    private Particle[] parts;
    private Vector[] neutralPositions;
    private Quaternion rotation;
    private Vector center;
    private boolean picked;
    private boolean hidden;

    public Cluster(Particle[] particleArray) {
        this.parts = particleArray;
        this.calculateCenter();
        this.pick(true);
        this.neutralPositions = new Vector[this.parts.length];
        for (int i = 0; i < this.parts.length; ++i) {
            this.neutralPositions[i] = this.parts[i].getCoordinates().minus(this.center);
        }
        this.rotation = new Quaternion(1.0, 0.0, 0.0, 0.0);
    }

    @Override
    public Cluster copy() {
        Particle[] particleArray = new Particle[this.countParticles()];
        for (int i = 0; i < particleArray.length; ++i) {
            particleArray[i] = this.parts[i].copy();
        }
        Cluster cluster = new Cluster(particleArray);
        cluster.neutralPositions = new Vector[this.neutralPositions.length];
        for (int i = 0; i < this.neutralPositions.length; ++i) {
            cluster.neutralPositions[i] = this.neutralPositions[i].copy();
        }
        cluster.rotation = this.rotation.copy();
        cluster.picked = this.picked;
        cluster.hidden = this.hidden;
        return cluster;
    }

    @Override
    public boolean isSimilarTo(Particle particle) {
        if (this.countParticles() != particle.countParticles()) {
            return false;
        }
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.parts[i].isSimilarTo(particle.getParticle(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Vector getCoordinates() {
        return this.center;
    }

    public void scale(double d) {
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.parts[i].isAtomic()) {
                this.neutralPositions[i] = this.neutralPositions[i].times(d);
                continue;
            }
            ((Cluster)this.parts[i]).scale(d);
        }
        this.updateAtomPositions();
    }

    private void updateAtomPositions() {
        for (int i = 0; i < this.parts.length; ++i) {
            Vector vector;
            if (this.parts[i].isAtomic()) {
                vector = this.neutralPositions[i].rotate(this.rotation).plus(this.center);
                this.parts[i].setCoordinates(vector);
                continue;
            }
            vector = this.neutralPositions[i].rotate(this.rotation).plus(this.center);
            this.parts[i].setCoordinates(vector);
            ((Cluster)this.parts[i]).updateAtomPositions();
        }
    }

    @Override
    public void setCoordinates(Vector vector) {
        this.center = vector;
        this.updateAtomPositions();
    }

    @Override
    public void shiftCoordinates(Vector vector) {
        this.center = this.center.plus(vector);
        this.updateAtomPositions();
    }

    @Override
    public void rotate(Quaternion quaternion) {
        this.rotation = quaternion.times(this.rotation);
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].rotate(quaternion);
        }
        this.updateAtomPositions();
    }

    private void calculateCenter() {
        int n;
        double[] dArray = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray[i] = 0.0;
        }
        Atom[] atomArray = this.getAtoms();
        for (n = 0; n < atomArray.length; ++n) {
            for (int i = 0; i < 3; ++i) {
                int n2 = i;
                dArray[n2] = dArray[n2] + atomArray[n].getCoordinates().element(i);
            }
        }
        n = 0;
        while (n < 3) {
            int n3 = n++;
            dArray[n3] = dArray[n3] / (double)atomArray.length;
        }
        this.center = new Vector(dArray);
    }

    @Override
    public double getMass() {
        double d = 0.0;
        Atom[] atomArray = this.getAtoms();
        for (int i = 0; i < atomArray.length; ++i) {
            d += atomArray[i].getMass();
        }
        return d;
    }

    @Override
    public Atom[] getAtoms() {
        int n = this.countAtoms();
        Atom[] atomArray = new Atom[n];
        int n2 = 0;
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.parts[i].isAtomic()) {
                atomArray[n2] = (Atom)this.parts[i];
                ++n2;
                continue;
            }
            Atom[] atomArray2 = this.parts[i].getAtoms();
            for (int j = 0; j < atomArray2.length; ++j) {
                atomArray[n2] = atomArray2[j];
                ++n2;
            }
        }
        return atomArray;
    }

    @Override
    public Particle[] getParticles() {
        return this.parts;
    }

    @Override
    public Particle getParticle(int n) {
        return this.parts[n];
    }

    @Override
    public int countAtoms() {
        int n = 0;
        for (int i = 0; i < this.parts.length; ++i) {
            n += this.parts[i].countAtoms();
        }
        return n;
    }

    @Override
    public int countParticles() {
        return this.parts.length;
    }

    @Override
    public Quaternion getOrientation() {
        return this.rotation;
    }

    @Override
    public void pick(boolean bl) {
        this.picked = bl;
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].pick(bl);
        }
    }

    @Override
    public void hide(boolean bl) {
        this.hidden = bl;
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].hide(bl);
        }
    }

    @Override
    public boolean isPicked() {
        return this.picked;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    @Override
    public String toString() {
        String string = "cluster ";
        string = string + "of " + FileHandler.formattedInt(this.countAtoms(), 4) + " ";
        string = string + "   (" + FileHandler.formattedDouble(this.center.element(0), 12, 6) + ", " + FileHandler.formattedDouble(this.center.element(1), 12, 6) + ", " + FileHandler.formattedDouble(this.center.element(2), 12, 6) + ")";
        return string;
    }

    public void invertByPlane(Vector vector, Vector vector2) {
        Vector vector3 = this.rotation.rotationAxis();
        double d = this.rotation.rotationAngle();
        Vector vector4 = vector.rotate(new Quaternion(vector3, -d));
        for (int i = 0; i < this.parts.length; ++i) {
            this.neutralPositions[i] = this.neutralPositions[i].inversionByPlane(vector4, new Vector(0.0, 0.0, 0.0));
            if (this.parts[i].isAtomic()) continue;
            ((Cluster)this.parts[i]).invertByPlane(vector, vector2);
        }
        this.updateAtomPositions();
    }
}

