/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Calculator {
    private ASH caller;
    private Hashtable<String, CustomFunction> functions;
    private static int recursionDepth = 0;

    public Calculator(ASH aSH) {
        this.caller = aSH;
        this.functions = new Hashtable();
    }

    public ASH getMaster() {
        return this.caller;
    }

    public void defineFunction(String string, CustomFunction customFunction) throws Exception {
        if (Operator.isOperator(string)) {
            throw new Exception();
        }
        this.functions.put(string, customFunction);
    }

    public void removeFunction(String string) throws Exception {
        if (Operator.isOperator(string)) {
            throw new Exception();
        }
        this.functions.remove(string);
    }

    public CustomFunction getFunction(String string) throws Exception {
        if (this.functions.containsKey(string)) {
            return this.functions.get(string);
        }
        throw new Exception();
    }

    public Operator[] listOperators() {
        Operator[] operatorArray = new Operator[Operator.OPERATORS.length];
        for (int i = 0; i < Operator.OPERATORS.length; ++i) {
            try {
                operatorArray[i] = Operator.createOperator(Operator.OPERATORS[i], 2, this);
                continue;
            }
            catch (Exception exception) {
                operatorArray[i] = null;
            }
        }
        return operatorArray;
    }

    public CustomFunction[] listFunctions() {
        CustomFunction[] customFunctionArray;
        Enumeration<String> enumeration = this.functions.keys();
        Object[] objectArray = new String[]{};
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            customFunctionArray = enumeration.nextElement();
            String[] stringArray = new String[]{customFunctionArray};
            objectArray = StringCombiner.combine((String[])objectArray, stringArray);
        }
        Arrays.sort(objectArray);
        customFunctionArray = new CustomFunction[objectArray.length];
        for (int i = 0; i < customFunctionArray.length; ++i) {
            try {
                customFunctionArray[i] = this.getFunction((String)objectArray[i]);
                continue;
            }
            catch (Exception exception) {
                customFunctionArray[i] = null;
            }
        }
        return customFunctionArray;
    }

    public ArrayList<FormulaBlock> splitExpression(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+-*/%()[]{}^=<>&|:,", true);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        ArrayList<FormulaBlock> arrayList = new ArrayList<FormulaBlock>();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-")) {
                if (i == 0) {
                    arrayList.add(Operator.createOperator(stringArray[i], 1, this));
                    ++n;
                    continue;
                }
                if (stringArray[i - 1].equals("(")) {
                    arrayList.add(Operator.createOperator(stringArray[i], 1, this));
                    ++n;
                    continue;
                }
                if (Operator.isOperator(stringArray[i - 1])) {
                    arrayList.add(Operator.createOperator(stringArray[i], 1, this));
                    ++n;
                    continue;
                }
                if (stringArray[i - 1].equals(":")) {
                    arrayList.add(Operator.createOperator(stringArray[i], 1, this));
                    ++n;
                    continue;
                }
                if (stringArray[i - 1].substring(stringArray[i - 1].length() - 1, stringArray[i - 1].length()).equalsIgnoreCase("E")) {
                    arrayList.remove(n - 1);
                    arrayList.add(this.caller.parseVariable(stringArray[i - 1] + stringArray[i] + stringArray[i + 1]));
                    ++i;
                    continue;
                }
                arrayList.add(Operator.createOperator(stringArray[i], 2, this));
                ++n;
                continue;
            }
            if (Operator.isDoubleOperator(stringArray[i])) {
                arrayList.add(Operator.createOperator(stringArray[i], 2, this));
                ++n;
                continue;
            }
            if (i < stringArray.length - 2 && stringArray[i + 1].equals(":")) {
                try {
                    Operator operator = Operator.createOperator(stringArray[i], 1, this);
                    arrayList.add(operator);
                    ++n;
                    continue;
                }
                catch (Exception exception) {
                    try {
                        CustomFunction customFunction = this.getFunction(stringArray[i]);
                        arrayList.add(customFunction);
                        ++n;
                        continue;
                    }
                    catch (Exception exception2) {
                        System.out.println("unknown function " + stringArray[i]);
                        throw new Exception();
                    }
                }
            }
            if (stringArray[i].equals(":")) continue;
            if (Operator.isParenthesisOperator(stringArray[i])) {
                arrayList.add(Operator.createOperator(stringArray[i], 0, this));
                ++n;
                continue;
            }
            arrayList.add(this.caller.parseVariable(stringArray[i]));
            ++n;
        }
        return arrayList;
    }

    public void substitute(ArrayList<FormulaBlock> arrayList, FormulaBlock formulaBlock, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            arrayList.remove(n);
        }
        arrayList.add(n, formulaBlock);
    }

    public void substitute(ArrayList<FormulaBlock> arrayList, ArrayList<FormulaBlock> arrayList2, int n, int n2) {
        int n3;
        for (n3 = n; n3 < n2; ++n3) {
            arrayList.remove(n);
        }
        for (n3 = 0; n3 < arrayList2.size(); ++n3) {
            arrayList.add(n, arrayList2.get(n3));
        }
    }

    public ArrayList<FormulaBlock> subExpression(ArrayList<FormulaBlock> arrayList, int n, int n2) {
        ArrayList<FormulaBlock> arrayList2 = new ArrayList<FormulaBlock>();
        for (int i = n; i < n2; ++i) {
            arrayList2.add(arrayList.get(i));
        }
        return arrayList2;
    }

    public void writeFormula(ArrayList<FormulaBlock> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            System.out.print(((Object)arrayList.get(i)).toString() + " ");
        }
        System.out.println();
    }

    public VariableSet evaluateSet(ArrayList<FormulaBlock> arrayList) throws Exception {
        int n;
        Object object;
        int n2 = 1;
        int n3 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!arrayList.get(i).isOperator()) continue;
            object = (Operator)arrayList.get(i);
            if (((Operator)object).getType().equals("{")) {
                ++n3;
                continue;
            }
            if (((Operator)object).getType().equals("}")) {
                --n3;
                continue;
            }
            if (!((Operator)object).getType().equals(",") || n3 != 0) continue;
            ++n2;
        }
        if (n2 == 0) {
            System.out.println("empty sets not allowed");
            throw new Exception();
        }
        Variable[] variableArray = new Variable[n2];
        object = new int[n2][2];
        object[0][0] = 0;
        object[n2 - 1][1] = arrayList.size();
        int n4 = 0;
        n3 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            if (!arrayList.get(n).isOperator()) continue;
            Operator operator = (Operator)arrayList.get(n);
            if (operator.getType().equals("{")) {
                ++n3;
                continue;
            }
            if (operator.getType().equals("}")) {
                --n3;
                continue;
            }
            if (!operator.getType().equals(",") || n3 != 0) continue;
            object[n4][1] = n;
            object[++n4][0] = n + 1;
        }
        for (n = 0; n < n2; ++n) {
            variableArray[n] = this.evaluateExpression(this.subExpression(arrayList, (int)object[n][0], (int)object[n][1]));
        }
        VariableSet variableSet = new VariableSet("set", variableArray);
        return variableSet;
    }

    public Variable evaluateMatrix(ArrayList<FormulaBlock> arrayList) throws Exception {
        int n;
        Object object;
        int n2;
        int n3 = 1;
        int n4 = 1;
        int n5 = 0;
        int n6 = 1;
        int n7 = 1;
        boolean bl = false;
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            if (!arrayList.get(n2).isOperator()) continue;
            object = (Operator)arrayList.get(n2);
            if (((Operator)object).getType().equals("[")) {
                ++n5;
                n7 = 1;
                if (++n6 == 2) {
                    n3 = 2;
                    continue;
                }
                if (n6 <= 2) continue;
                System.out.println("Matrices of more than 2 dimensions not supported.");
                throw new Exception();
            }
            if (((Operator)object).getType().equals("]")) {
                if (--n6 < 1) {
                    System.out.println("Parenthesis mismatch in matrix definition.");
                    throw new Exception();
                }
                if (bl) {
                    if (n7 == n4) continue;
                    System.out.println("Inconsistent row lengths in matrix definition.");
                    throw new Exception();
                }
                n4 = n7;
                bl = true;
                continue;
            }
            if (!((Operator)object).getType().equals(",")) continue;
            ++n7;
        }
        if (!bl) {
            n4 = n7;
            bl = true;
        }
        n6 = 1;
        n2 = -1;
        if (n3 == 1) {
            n5 = 1;
            n2 = 0;
        }
        object = new double[n5][n4];
        int[][][] nArray = new int[n5][n4][2];
        if (n2 == 0) {
            nArray[0][0][0] = 0;
            nArray[n5 - 1][n4 - 1][1] = arrayList.size();
        }
        int n8 = n2;
        int n9 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            if (!arrayList.get(n).isOperator()) continue;
            Operator operator = (Operator)arrayList.get(n);
            if (operator.getType().equals("[")) {
                n9 = 0;
                ++n6;
                nArray[++n8][n9][0] = n + 1;
                continue;
            }
            if (operator.getType().equals("]")) {
                --n6;
                nArray[n8][n9][1] = n;
                ++n9;
                continue;
            }
            if (!operator.getType().equals(",") || n6 != n3) continue;
            nArray[n8][n9][1] = n;
            nArray[n8][++n9][0] = n + 1;
        }
        for (n = 0; n < n5; ++n) {
            for (int i = 0; i < n4; ++i) {
                Variable variable = this.evaluateExpression(this.subExpression(arrayList, nArray[n][i][0], nArray[n][i][1]));
                object[n][i] = variable.getValue();
            }
        }
        Variable variable = new Variable("mat", (double[][])object);
        return variable;
    }

    public void resetRecursionDepth() {
        recursionDepth = 0;
    }

    public Variable evaluateExpression(ArrayList<FormulaBlock> arrayList) throws Exception {
        FormulaBlock formulaBlock;
        Operator operator;
        Operator operator2;
        int n;
        if (++recursionDepth > 1000) {
            System.out.println("Max recursion depth reached in function evaluation.");
            throw new Exception();
        }
        if (arrayList.size() == 0) {
            throw new Exception();
        }
        if (arrayList.size() == 1) {
            return (Variable)arrayList.get(0);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            if (!arrayList.get(n).isOperator()) continue;
            operator2 = (Operator)arrayList.get(n);
            if (operator2.getType().equals("(")) {
                if (++n4 != 1) continue;
                n2 = n;
                continue;
            }
            if (!operator2.getType().equals(")") || --n4 != 0) continue;
            n3 = n;
            this.substitute(arrayList, this.evaluateExpression(this.subExpression(arrayList, n2 + 1, n3)), n2, n3 + 1);
            n -= n3 - n2 + 1;
        }
        if (n4 != 0) {
            System.out.println("mismatched parenthesis");
            throw new Exception();
        }
        n2 = 0;
        n3 = 0;
        n4 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            if (!arrayList.get(n).isOperator()) continue;
            operator2 = (Operator)arrayList.get(n);
            if (operator2.getType().equals("[")) {
                if (++n4 != 1) continue;
                n2 = n;
                continue;
            }
            if (!operator2.getType().equals("]") || --n4 != 0) continue;
            n3 = n;
            this.substitute(arrayList, this.evaluateMatrix(this.subExpression(arrayList, n2 + 1, n3)), n2, n3 + 1);
            n -= n3 - n2 + 1;
        }
        if (n4 != 0) {
            System.out.println("mismatched square brackets.");
            throw new Exception();
        }
        n2 = 0;
        n3 = 0;
        n4 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            if (!arrayList.get(n).isOperator()) continue;
            operator2 = (Operator)arrayList.get(n);
            if (operator2.getType().equals("{")) {
                if (++n4 != 1) continue;
                n2 = n;
                continue;
            }
            if (!operator2.getType().equals("}") || --n4 != 0) continue;
            n3 = n;
            this.substitute(arrayList, this.evaluateSet(this.subExpression(arrayList, n2 + 1, n3)), n2, n3 + 1);
            n -= n3 - n2 + 1;
        }
        if (n4 != 0) {
            System.out.println("mismatched curly brackets.");
            throw new Exception();
        }
        if (arrayList.get(0).isOperator() && (operator = (Operator)arrayList.get(0)).isDoubleOperator()) {
            throw new Exception();
        }
        int n5 = 0;
        while (n5 < 2) {
            if (arrayList.size() == 1) {
                return (Variable)arrayList.get(0);
            }
            for (int i = arrayList.size() - 2; i >= 0; --i) {
                if (arrayList.get(i).isOperator()) {
                    formulaBlock = (Operator)arrayList.get(i);
                    switch (n5) {
                        case 0: {
                            if (((Operator)formulaBlock).isSingleOperator()) {
                                this.substitute(arrayList, ((Operator)formulaBlock).operate(arrayList.get(i + 1)), i, i + 2);
                                i = -1;
                            }
                            if (!((Operator)formulaBlock).isPowerOperator()) break;
                            this.substitute(arrayList, ((Operator)formulaBlock).operate(arrayList.get(i - 1), arrayList.get(i + 1)), i - 1, i + 2);
                            i = -1;
                            break;
                        }
                        case 1: {
                            if (!((Operator)formulaBlock).isPowerOperator()) break;
                            this.substitute(arrayList, ((Operator)formulaBlock).operate(arrayList.get(i - 1), arrayList.get(i + 1)), i - 1, i + 2);
                            i = -1;
                        }
                    }
                    continue;
                }
                if (arrayList.get(i).isCustomFunction()) {
                    formulaBlock = (CustomFunction)arrayList.get(i);
                    if (n5 != 0) continue;
                    ArrayList<FormulaBlock> arrayList2 = ((CustomFunction)formulaBlock).expand(arrayList.get(i + 1));
                    this.substitute(arrayList, this.evaluateExpression(arrayList2), i, i + 2);
                    i = -1;
                    continue;
                }
                if (i != 0) continue;
                n5 += 2;
            }
        }
        while (n5 < 6) {
            if (arrayList.size() == 1) {
                return (Variable)arrayList.get(0);
            }
            if (arrayList.size() == 2) {
                throw new Exception();
            }
            for (int i = 1; i < arrayList.size() - 1; ++i) {
                if (arrayList.get(i).isOperator()) {
                    formulaBlock = (Operator)arrayList.get(i);
                    switch (n5) {
                        case 2: {
                            if (((Operator)formulaBlock).isMultiplierOperator()) {
                                this.substitute(arrayList, ((Operator)formulaBlock).operate(arrayList.get(i - 1), arrayList.get(i + 1)), i - 1, i + 2);
                                i = -1;
                                break;
                            }
                            if (i != arrayList.size() - 2) break;
                            ++n5;
                            break;
                        }
                        case 3: {
                            if (((Operator)formulaBlock).isAdditionOperator()) {
                                this.substitute(arrayList, ((Operator)formulaBlock).operate(arrayList.get(i - 1), arrayList.get(i + 1)), i - 1, i + 2);
                                i = -1;
                                break;
                            }
                            if (i != arrayList.size() - 2) break;
                            ++n5;
                            break;
                        }
                        case 4: {
                            if (((Operator)formulaBlock).isComparisonOperator()) {
                                this.substitute(arrayList, ((Operator)formulaBlock).operate(arrayList.get(i - 1), arrayList.get(i + 1)), i - 1, i + 2);
                                i = -1;
                                break;
                            }
                            if (i != arrayList.size() - 2) break;
                            ++n5;
                            break;
                        }
                        case 5: {
                            if (((Operator)formulaBlock).isLogicOperator()) {
                                this.substitute(arrayList, ((Operator)formulaBlock).operate(arrayList.get(i - 1), arrayList.get(i + 1)), i - 1, i + 2);
                                i = -1;
                                break;
                            }
                            if (i != arrayList.size() - 2) break;
                            ++n5;
                        }
                    }
                    continue;
                }
                if (i != arrayList.size() - 2) continue;
                ++n5;
            }
        }
        return (Variable)arrayList.get(0);
    }

    public void accessManual(String string) {
        try {
            Operator operator = Operator.createOperator(string, 2, this);
            System.out.println("\nCalculator manual for '" + operator.getType() + "' (" + operator.getName() + ")\n");
            System.out.println("Syntax: " + operator.getSyntax());
            System.out.println("\n" + operator.getUsage() + "\n");
        }
        catch (Exception exception) {
            try {
                CustomFunction customFunction = this.getFunction(string);
                String[] stringArray = new String[customFunction.getArgumentCount()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = "#" + (i + 1);
                }
                System.out.println("Calculator manual for '" + string + "'\n");
                System.out.println("Syntax: " + customFunction.getSyntax(stringArray));
                System.out.println("\nCustom function " + customFunction.getExpression(stringArray) + "");
            }
            catch (Exception exception2) {
                System.out.println("unknown function " + string);
            }
        }
    }
}

