/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class Atom
implements Particle {
    private String name;
    private int element;
    private int index = 0;
    private double mass;
    private Vector coordinates;
    private Vector velocity;
    private Vector force;
    private Color color;
    private double radius;
    private boolean picked;
    private boolean hidden;
    private boolean[] free;

    public Atom(Vector vector) {
        this.coordinates = vector;
        this.name = "";
        this.element = 0;
        this.mass = 10.0;
        this.velocity = new Vector(3);
        this.force = new Vector(3);
        this.free = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            this.free[i] = true;
        }
        this.radius = 1.0;
        this.color = View.white;
        this.picked = ASH.defaultPick;
        this.hidden = false;
    }

    @Override
    public Atom copy() {
        Atom atom = new Atom(this.coordinates.copy());
        atom.index = this.index;
        atom.mass = this.mass;
        atom.element = this.element;
        atom.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha());
        atom.velocity = this.velocity.copy();
        atom.force = this.force.copy();
        atom.free = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            atom.free[i] = this.free[i];
        }
        atom.radius = this.radius;
        atom.picked = this.picked;
        atom.hidden = this.hidden;
        atom.name = this.name;
        return atom;
    }

    public void pick() {
        this.picked = true;
    }

    @Override
    public void pick(boolean bl) {
        this.picked = bl;
    }

    @Override
    public void hide(boolean bl) {
        this.hidden = bl;
    }

    public void unpick() {
        this.picked = false;
    }

    @Override
    public boolean isPicked() {
        return this.picked;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setElement(int n) {
        this.element = n;
    }

    public void setElement(Element element) {
        this.element = element.getNumber();
        this.color = element.getColor();
        this.mass = element.getMass();
        this.radius = element.getRadius();
        this.name = element.getSymbol();
    }

    public int getElement() {
        return this.element;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public void setMass(double d) {
        this.mass = d;
    }

    @Override
    public double getMass() {
        return this.mass;
    }

    @Override
    public void setCoordinates(Vector vector) {
        this.coordinates = vector;
    }

    @Override
    public void shiftCoordinates(Vector vector) {
        this.coordinates = this.coordinates.plus(vector);
    }

    @Override
    public Vector getCoordinates() {
        return this.coordinates;
    }

    public void setVelocity(Vector vector) {
        this.velocity = vector;
    }

    public Vector getVelocity() {
        return this.velocity;
    }

    public void setForce(Vector vector) {
        this.force = vector;
    }

    public Vector getForce() {
        return this.force;
    }

    public void setFrozenCoordinates(boolean[] blArray) {
        for (int i = 0; i < 3; ++i) {
            this.free[i] = blArray.length > i ? blArray[i] : false;
        }
    }

    public boolean[] getFrozenCoordinates() {
        return this.free;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setRadius(double d) {
        this.radius = d;
    }

    public double getRadius() {
        return this.radius;
    }

    @Override
    public void rotate(Quaternion quaternion) {
    }

    @Override
    public Quaternion getOrientation() {
        return new Quaternion(1.0, 0.0, 0.0, 0.0);
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public int countAtoms() {
        return 1;
    }

    @Override
    public int countParticles() {
        return 1;
    }

    @Override
    public boolean isSimilarTo(Particle particle) {
        if (this.countAtoms() != particle.countAtoms()) {
            return false;
        }
        Atom atom = (Atom)particle;
        return atom.getElement() == this.element;
    }

    @Override
    public Particle getParticle(int n) {
        return this;
    }

    @Override
    public Atom[] getAtoms() {
        Atom[] atomArray = new Atom[]{this};
        return atomArray;
    }

    @Override
    public Particle[] getParticles() {
        Particle[] particleArray = new Particle[]{this};
        return particleArray;
    }

    @Override
    public String toString() {
        String string = "atom            ";
        string = string + "   (" + FileHandler.formattedDouble(this.coordinates.element(0), 12, 6) + ", " + FileHandler.formattedDouble(this.coordinates.element(1), 12, 6) + ", " + FileHandler.formattedDouble(this.coordinates.element(2), 12, 6) + ")";
        for (int i = 0; i < 3; ++i) {
            string = this.free[i] ? string + " t" : string + " f";
        }
        string = string + "  " + FileHandler.formattedInt(this.element, 3) + " " + ASH.elementTable.getElement(this.element).getSymbol();
        return string;
    }
}

