/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;

public class ASH {
    public static final String C_PICK = "pick";
    public static final String C_UNPICK = "unpick";
    public static final String C_JOIN = "union";
    public static final String C_INTERSECT = "intersect";
    public static final String C_OVER = "replace";
    public static final String C_ALL = "all";
    public static final String C_XM = "xmore";
    public static final String C_XL = "xless";
    public static final String C_YM = "ymore";
    public static final String C_YL = "yless";
    public static final String C_ZM = "zmore";
    public static final String C_ZL = "zless";
    public static final String C_RANGE = "range";
    public static final String C_ELE = "element";
    public static final String C_PART = "particle";
    public static final String C_PARTS = "particles";
    public static final String C_LIST = "list";
    public static final String C_COMM = "command";
    public static final String C_SHIFT = "shift";
    public static final String C_ROT = "rotate";
    public static final String C_COPY = "copy";
    public static final String C_CUT = "cut";
    public static final String C_PASTE = "paste";
    public static final String C_CELL = "cell";
    public static final String C_DEL = "delete";
    public static final String C_ADD = "create";
    public static final String C_RM = "remove";
    public static final String C_DUPLO = "duplicates";
    public static final String C_NBOR = "neighbors";
    public static final String C_INTERP = "interpolate";
    public static final String C_REIND = "reindex";
    public static final String C_NEW = "new";
    public static final String C_NEXT = "next";
    public static final String C_JUMP = "switch";
    public static final String C_MOVE = "move";
    public static final String C_PREV = "previous";
    public static final String C_FIRST = "first";
    public static final String C_LAST = "last";
    public static final String C_FRAME = "frame";
    public static final String C_PROJ = "projection";
    public static final String C_PERSP = "perspective";
    public static final String C_ISOM = "isometric";
    public static final String C_LENS = "lenticular";
    public static final String C_WRITE = "write";
    public static final String C_OPEN = "open";
    public static final String C_XYZ = "xyz";
    public static final String C_POSCAR = "poscar";
    public static final String C_POSCAR4 = "poscar4";
    public static final String C_PNG = "png";
    public static final String C_ASE = "ase";
    public static final String C_SCRIPT = "script";
    public static final String C_SET = "define";
    public static final String C_DEFAULT = "default";
    public static final String C_ECHO = "echo";
    public static final String C_VALUE = "value";
    public static final String C_FUNC = "function";
    public static final String C_EXIT = "exit";
    public static final String C_SHOW = "show";
    public static final String C_HIDE = "hide";
    public static final String C_AXIS = "axis";
    public static final String C_VIEW = "view";
    public static final String C_RESET = "reset";
    public static final String C_ZOOM = "zoom";
    public static final String C_POINT = "point";
    public static final String C_ANGLE = "angle";
    public static final String C_COLOR = "recolor";
    public static final String C_BG = "bg";
    public static final String C_RAD = "resize";
    public static final String C_INV = "mirror";
    public static final String C_X = "x";
    public static final String C_Y = "y";
    public static final String C_Z = "z";
    public static final String C_PLANE = "plane";
    public static final String C_MOD = "cell";
    public static final String C_CELLX = "x";
    public static final String C_CELLY = "y";
    public static final String C_CELLZ = "z";
    public static final String C_EXP = "expand";
    public static final String C_CLU = "cluster";
    public static final String C_UNCLU = "uncluster";
    public static final String C_UNDO = "undo";
    public static final String C_ALIAS = "alias";
    public static final String C_MAN = "man";
    public static final String C_CALCMAN = "calcman";
    public static final String C_PRINT = "print";
    public static final String C_STRING = "string";
    public static final String C_SHRINK = "shrink";
    public static final String C_GROW = "grow";
    public static final String C_RENAME = "rename";
    public static final String C_SWITCH = "switch";
    public static final String C_MOUSE = "mouse";
    public static final String C_INFO = "info";
    public static final String C_DIR = "directory";
    public static final String C_SCALE = "scale";
    public static final String C_WAIT = "wait";
    public static final String C_BEND = "bend";
    public static final String C_SPHERE = "sphere";
    public static final String C_SCREEN = "screen";
    public static final String C_OLDFILE = "append";
    public static final String C_NEWFILE = "file";
    public static final String C_FREEZE = "constrain";
    public static final String C_DATA = "data";
    public static final String C_NOOPTION = "xxxxxxxx";
    public static final String C_IF = "if";
    public static final String C_ELSE = "else";
    public static final String C_ENDIF = "endif";
    public static final String C_WHILE = "while";
    public static final String C_ENDWHILE = "endwhile";
    public static final String INSET = "    ";
    public static final String COMMENT = "###";
    public static String[] mainCommands;
    private String[] commands;
    private static final String HISTORY_FILE = ".ash_history";
    private static final String LAUNCH_FILE = ".ash_launch";
    public static final String K_CX = "cellx";
    public static final String K_CY = "celly";
    public static final String K_CZ = "cellz";
    public static final String K_BX = "pbcx";
    public static final String K_BY = "pbcy";
    public static final String K_BZ = "pbcz";
    public static final String K_FR = "frame";
    public static final String K_NFR = "nframes";
    public static final String K_NPART = "nparts";
    public static final String K_NATOM = "natoms";
    public static final String K_VIEW = "view";
    public static final String K_VUP = "viewup";
    public static final String K_VZOOM = "viewzoom";
    public static final String K_VDIR = "viewto";
    public static final String K_PI = "pi";
    public static final String K_E = "e";
    public static final String K_VERSION = "version";
    public static String[] keys;
    private static final String VERSION = "0.4";
    private static final String[] DEFAULT_LAUNCH;
    public static Random RNG;
    public static Calculator adder;
    public static long startTime;
    public static PeriodicTable elementTable;
    private GeoPainter painter;
    private boolean notFinished;
    public static boolean runningScript;
    private ArrayList<Structure> undos;
    private ArrayList<Structure> frames;
    private int currentFrame;
    private Hashtable<String, Command> commandTable;
    private Hashtable<String, Variable> variables;
    private Hashtable<String, StringVariable> stringVariables;
    private Hashtable<String, Alias> aliases;
    private Structure[] clipboardAtoms;
    private static final int CLIPSIZE = 10;
    private boolean showDir = false;
    public static boolean defaultPick;
    private static String PROMPT;

    public ASH(String[] stringArray) {
        Object object;
        String[][] stringArray2;
        startTime = System.currentTimeMillis();
        FileHandler.CWD = new File(".");
        FileHandler.readPath();
        this.variables = new Hashtable();
        this.stringVariables = new Hashtable();
        this.aliases = new Hashtable();
        this.commandTable = new Hashtable();
        adder = new Calculator(this);
        this.commandTable.put(C_EXIT, new Exit(this));
        this.commandTable.put(C_PRINT, new Print(this));
        this.commandTable.put(C_PICK, new Pick(this));
        this.commandTable.put(C_UNPICK, new Unpick(this));
        this.commandTable.put(C_LIST, new List(this));
        this.commandTable.put(C_CLU, new Clusterize(this));
        this.commandTable.put(C_UNCLU, new Unclusterize(this));
        this.commandTable.put(C_ROT, new Rotate(this));
        this.commandTable.put(C_SHIFT, new Shift(this));
        this.commandTable.put(C_DEL, new Delete(this));
        this.commandTable.put(C_ADD, new Add(this));
        this.commandTable.put(C_COPY, new Copy(this));
        this.commandTable.put(C_CUT, new Cut(this));
        this.commandTable.put(C_PASTE, new Paste(this));
        this.commandTable.put("cell", new SetCell(this));
        this.commandTable.put(C_EXP, new Expand(this));
        this.commandTable.put(C_RAD, new Resize(this));
        this.commandTable.put(C_COLOR, new Recolor(this));
        this.commandTable.put(C_INV, new Invert(this));
        this.commandTable.put(C_SHOW, new Show(this));
        this.commandTable.put(C_HIDE, new Hide(this));
        this.commandTable.put("view", new Reposition(this));
        this.commandTable.put(C_INTERP, new Interpolate(this));
        this.commandTable.put(C_REIND, new Reindex(this));
        this.commandTable.put("frame", new FrameSwitch(this));
        this.commandTable.put(C_WRITE, new Write(this));
        this.commandTable.put(C_OPEN, new Open(this));
        this.commandTable.put(C_UNDO, new Undo(this));
        this.commandTable.put(C_SET, new Define(this));
        this.commandTable.put(C_VALUE, new Evaluate(this));
        this.commandTable.put(C_ALIAS, new MakeAlias(this));
        this.commandTable.put(C_ELE, new ElementSwitch(this));
        this.commandTable.put(C_MOUSE, new MouseSwitch(this));
        this.commandTable.put(C_DIR, new DirectorySwitch(this));
        this.commandTable.put(C_SCALE, new Scale(this));
        this.commandTable.put(C_BEND, new Bend(this));
        this.commandTable.put(C_WAIT, new Wait(this));
        this.commandTable.put(C_FREEZE, new Constrain(this));
        this.commandTable.put(C_CALCMAN, new CalcManual(this));
        Manual manual = new Manual(this);
        this.commandTable.put(C_MAN, manual);
        this.commands = new String[0];
        mainCommands = new String[0];
        Enumeration<String> enumeration = this.commandTable.keys();
        while (enumeration.hasMoreElements()) {
            stringArray2 = enumeration.nextElement();
            object = new String[]{stringArray2};
            mainCommands = StringCombiner.combine(mainCommands, object);
        }
        Arrays.sort(mainCommands);
        stringArray2 = new String[][]{mainCommands};
        manual.setOptions(stringArray2);
        enumeration = this.commandTable.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            String[] stringArray3 = new String[]{object};
            this.commands = StringCombiner.combine(this.commands, StringCombiner.comboPermute(stringArray3, this.commandTable.get(object).getOptions(), ""));
        }
        this.notFinished = true;
        this.runProgram(stringArray);
    }

    private void runProgram(String[] stringArray) {
        Object object;
        GeoWindow geoWindow = new GeoWindow(this);
        geoWindow.startGraphics();
        geoWindow.pauseGraphics();
        this.painter = (GeoPainter)geoWindow.getPainter();
        this.painter.recordSize(400, 400);
        Particle[] particleArray = new Atom[]{};
        Structure structure = new Structure(particleArray);
        this.frames = new ArrayList();
        this.undos = new ArrayList();
        this.currentFrame = 0;
        this.frames.add(structure);
        this.clipboardAtoms = new Structure[10];
        for (int i = 0; i < 10; ++i) {
            this.clipboardAtoms[i] = new Structure(particleArray);
        }
        ViewPoint viewPoint = new ViewPoint(new Vector(0.0, 0.0, 50.0), new Vector(0.0, 0.0, -10.0), new Vector(0.0, 1.0, 0.0));
        this.painter.initGeo(structure, viewPoint);
        geoWindow.resumeGraphics();
        this.notFinished = true;
        try {
            object = new FileHandler();
            if (((FileHandler)object).findsFile(LAUNCH_FILE)) {
                this.executeScript(LAUNCH_FILE);
            } else {
                ((FileHandler)object).writeFile(DEFAULT_LAUNCH, ".ash_launch_default");
                this.executeScript(".ash_launch_default");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stringArray.length > 0) {
            object = "";
            for (int i = 0; i < stringArray.length; ++i) {
                object = (String)object + stringArray[i] + " ";
            }
            this.executeCommand((String)object);
        }
        this.painter.startInteraction();
        while (this.notFinished) {
            String string;
            if (this.showDir) {
                try {
                    object = FileHandler.CWD.getCanonicalPath() + PROMPT;
                }
                catch (Exception exception) {
                    object = PROMPT;
                }
            } else {
                object = PROMPT;
            }
            if ((string = this.readCommandLine((String)object)).equals("")) continue;
            this.executeCommand(string);
        }
        System.exit(0);
    }

    public int[] findChars(String string, String string2, boolean bl) {
        int n;
        int[] nArray = new int[string.length()];
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\"') {
                if (bl2) {
                    bl2 = false;
                    if (--n3 > 0) {
                        bl3 = true;
                    }
                } else {
                    ++n3;
                    bl2 = true;
                    bl3 = false;
                }
            }
            if (string.charAt(i) == '\'') {
                if (bl3) {
                    bl3 = false;
                    if (--n3 > 0) {
                        bl2 = true;
                    }
                } else {
                    ++n3;
                    bl3 = true;
                    bl2 = false;
                }
            }
            for (n = 0; n < string2.length(); ++n) {
                if (string.charAt(i) != string2.charAt(n) || bl && (bl2 || bl3)) continue;
                nArray[n2] = i;
                ++n2;
            }
        }
        int[] nArray2 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray2[n] = nArray[n];
        }
        return nArray2;
    }

    public static String removeComment(String string) {
        try {
            return string.substring(0, string.indexOf(COMMENT));
        }
        catch (Exception exception) {
            return string;
        }
    }

    public String[] splitCommand(String string) {
        if (string.length() == 0) {
            return new String[0];
        }
        int[] nArray = this.findChars(string, ";", true);
        int[] nArray2 = new int[nArray.length + 2];
        nArray2[0] = -1;
        nArray2[nArray2.length - 1] = string.length();
        for (int i = 1; i < nArray2.length - 1; ++i) {
            nArray2[i] = nArray[i - 1];
        }
        String[] stringArray = new String[nArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = string.substring(nArray2[i] + 1, nArray2[i + 1]).trim();
        }
        return stringArray;
    }

    public String[] splitArgument(String string) {
        int n;
        if (string.length() < 1) {
            String[] stringArray = new String[]{""};
            return stringArray;
        }
        int[] nArray = this.findChars(string, " \t", true);
        int[] nArray2 = new int[nArray.length + 2];
        nArray2[0] = -1;
        nArray2[nArray2.length - 1] = string.length();
        for (int i = 1; i < nArray2.length - 1; ++i) {
            nArray2[i] = nArray[i - 1];
        }
        String[] stringArray = new String[nArray.length + 1];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = string.charAt(nArray2[n] + 1) == '\"' && string.charAt(nArray2[n + 1] - 1) == '\"' || string.charAt(nArray2[n] + 1) == '\'' && string.charAt(nArray2[n + 1] - 1) == '\'' ? string.substring(nArray2[n] + 2, nArray2[n + 1] - 1) : string.substring(nArray2[n] + 1, nArray2[n + 1]);
        }
        n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                stringArray[i] = this.parseS(stringArray[i]);
            }
            catch (Exception exception) {
                stringArray[i] = "";
            }
            if (stringArray[i].length() != 0) continue;
            ++n;
        }
        String[] stringArray2 = new String[stringArray.length - n];
        if (stringArray2.length == 0) {
            String[] stringArray3 = new String[]{""};
            return stringArray3;
        }
        n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) {
                ++n;
                continue;
            }
            stringArray2[i - n] = stringArray[i];
        }
        return stringArray2;
    }

    public void executeCommand(String string) {
        String[] stringArray = this.splitCommand(ASH.removeComment(string).trim());
        for (int i = 0; i < stringArray.length; ++i) {
            this.executeSingleCommand(stringArray[i]);
        }
    }

    public void executeSingleCommand(String string) {
        String[] stringArray = this.splitArgument(string);
        try {
            String[] stringArray2;
            boolean bl = false;
            Command command = null;
            try {
                command = this.commandTable.get(stringArray[0]);
                command.getName();
            }
            catch (Exception exception) {
                command = null;
            }
            if (command == null) {
                try {
                    command = this.commandTable.get(stringArray[1]);
                    command.getName();
                }
                catch (Exception exception) {
                    command = null;
                }
                if (command == null) {
                    throw new Exception();
                }
                bl = true;
                stringArray2 = stringArray[0];
                stringArray[0] = stringArray[1];
                stringArray[1] = stringArray2;
            }
            stringArray2 = new String[stringArray.length - 1];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = stringArray[i + 1];
            }
            try {
                command.execute(stringArray2);
            }
            catch (Exception exception) {
                this.printMessage("Invalid call for " + stringArray[0] + ". Syntax for the command is:\n" + command.getUsage(), "Invalid command while executing script: '" + string + "'");
            }
            return;
        }
        catch (Exception exception) {
            block17: {
                Alias alias = null;
                try {
                    alias = this.getAlias(stringArray[0]);
                    if (alias == null) {
                        throw new Exception();
                    }
                    try {
                        String[] stringArray3 = new String[stringArray.length - 1];
                        for (int i = 0; i < stringArray3.length; ++i) {
                            stringArray3[i] = stringArray[i + 1];
                        }
                        String string2 = alias.getCommand(stringArray3);
                        this.executeCommand(string2);
                    }
                    catch (Exception exception2) {
                        this.printMessage("invalid arguments for " + stringArray[0], "Invalid command while executing script: '" + string + "'");
                    }
                }
                catch (Exception exception3) {
                    if (stringArray[0].length() <= 0) break block17;
                    this.printMessage("unknown command " + stringArray[0], "Invalid command while executing script: '" + string + "'");
                }
            }
            return;
        }
    }

    public void rememberStructure() {
        if (!runningScript) {
            this.undos.add(this.frames.get(this.currentFrame).copy());
            if (this.undos.size() > 30) {
                this.undos.remove(0);
            }
        }
    }

    public void forgetStructures() {
        this.undos.clear();
    }

    public Structure recallStructure() {
        if (this.undos.size() > 0) {
            return this.undos.remove(this.undos.size() - 1);
        }
        return this.frames.get(this.currentFrame);
    }

    public int makeCluster() throws Exception {
        Structure structure = this.frames.get(this.currentFrame);
        int n = 0;
        for (int i = 0; i < structure.countParticles(); ++i) {
            Particle particle = structure.getParticle(i);
            if (!particle.isPicked()) continue;
            ++n;
        }
        if (n == 0) {
            throw new Exception();
        }
        Particle[] particleArray = new Particle[n];
        int n2 = 0;
        for (int i = 0; i < structure.countParticles(); ++i) {
            Particle particle = structure.getParticle(i);
            if (!particle.isPicked()) continue;
            particleArray[n2] = particle;
            ++n2;
            try {
                structure.removeParticle(i);
                --i;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        structure.addParticle(new Cluster(particleArray));
        return particleArray.length;
    }

    public int breakCluster() {
        Structure structure = this.frames.get(this.currentFrame);
        int n = 0;
        for (int i = 0; i < structure.countParticles(); ++i) {
            Particle particle = structure.getParticle(i);
            if (!particle.isPicked() || particle.isAtomic()) continue;
            Particle[] particleArray = ((Cluster)particle).getParticles();
            try {
                structure.removeParticle(i);
                --i;
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int j = 0; j < particleArray.length; ++j) {
                structure.addParticle(++i, particleArray[j], false);
                ++n;
            }
        }
        return n;
    }

    public void addParticle(Particle particle) {
        this.frames.get(this.currentFrame).addParticle(particle);
    }

    public void removeParticle(int n) throws Exception {
        this.frames.get(this.currentFrame).removeParticle(n);
    }

    public void removePicked() {
        try {
            Structure structure = this.frames.get(this.currentFrame);
            for (int i = structure.countParticles() - 1; i >= 0; --i) {
                if (!structure.getParticle(i).isPicked()) continue;
                structure.removeParticle(i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addFrame(Structure structure) {
        if (this.currentFrame == this.frames.size() - 1) {
            this.frames.add(structure);
        } else {
            this.frames.add(this.currentFrame + 1, structure);
        }
    }

    public void deleteFrame(int n) {
        if (n >= 0 && n < this.frames.size()) {
            try {
                if (this.currentFrame == n) {
                    if (n < this.frames.size() - 1) {
                        this.changeFrame(this.currentFrame + 1);
                        --this.currentFrame;
                        this.painter.aimAtCenter();
                        this.painter.updateGeo();
                    } else if (this.frames.size() > 1) {
                        this.changeFrame(this.currentFrame - 1);
                        this.painter.aimAtCenter();
                        this.painter.updateGeo();
                    } else {
                        this.currentFrame = 0;
                        Particle[] particleArray = new Atom[]{};
                        Structure structure = new Structure(particleArray);
                        this.frames.add(structure);
                        this.painter.aimAtCenter();
                        this.painter.updateGeo(structure);
                    }
                }
                this.frames.remove(n);
            }
            catch (Exception exception) {
                this.printMessage("could not delete frame");
            }
        } else {
            this.printMessage("no such frame");
        }
    }

    public void printMessage(String string, boolean bl) {
        if (!runningScript || bl) {
            System.out.println(string);
        }
    }

    public void printMessage(String string) {
        if (!runningScript) {
            System.out.println(string);
        }
    }

    public void printMessage(String string, String string2) {
        if (runningScript) {
            System.out.println(string2);
        } else {
            System.out.println(string);
        }
    }

    public void nextFrame() {
        try {
            Structure structure = this.frames.get(this.currentFrame + 1);
            this.painter.setGeometry(structure);
            ++this.currentFrame;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void previousFrame() {
        try {
            Structure structure = this.frames.get(this.currentFrame - 1);
            this.painter.setGeometry(structure);
            --this.currentFrame;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void changeFrame(int n) {
        try {
            Structure structure = this.frames.get(n);
            this.painter.setGeometry(structure);
            this.currentFrame = n;
            this.forgetStructures();
        }
        catch (Exception exception) {
            this.printMessage("no such frame");
        }
    }

    public void pickAll(boolean bl, boolean bl2) {
        try {
            if (!bl2) {
                Structure structure = this.frames.get(this.currentFrame);
                int n = structure.countParticles();
                for (int i = 0; i < n; ++i) {
                    structure.getParticle(i).pick(bl);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pickElement(int n, boolean bl, boolean bl2) {
        try {
            Structure structure = this.frames.get(this.currentFrame);
            int n2 = structure.countParticles();
            for (int i = 0; i < n2; ++i) {
                if (!structure.getParticle(i).isAtomic()) continue;
                Atom atom = (Atom)structure.getParticle(i);
                if (!bl2) {
                    if (atom.getElement() != n) continue;
                    atom.pick(bl);
                    continue;
                }
                if (atom.getElement() == n) continue;
                atom.pick(!bl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pickAtom(int n, boolean bl, boolean bl2) {
        try {
            Structure structure = this.frames.get(this.currentFrame);
            int n2 = structure.countParticles();
            if (!bl2) {
                structure.getParticle(n).pick(bl);
            } else {
                for (int i = 0; i < structure.countParticles(); ++i) {
                    if (i == n) continue;
                    structure.getParticle(i).pick(!bl);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pickSphere(Vector vector, double d, boolean bl, boolean bl2) {
        try {
            Structure structure = this.frames.get(this.currentFrame);
            int n = structure.countParticles();
            for (int i = 0; i < n; ++i) {
                Particle particle = structure.getParticle(i);
                Vector vector2 = particle.getCoordinates();
                if (!bl2) {
                    if (!(vector2.minus(vector).norm() < d)) continue;
                    particle.pick(bl);
                    continue;
                }
                if (!(vector2.minus(vector).norm() >= d)) continue;
                particle.pick(!bl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pickArea(Vector vector, Vector vector2, boolean bl, boolean bl2) {
        try {
            Structure structure = this.frames.get(this.currentFrame);
            int n = structure.countParticles();
            for (int i = 0; i < n; ++i) {
                Particle particle = structure.getParticle(i);
                Vector vector3 = particle.getCoordinates();
                if (!bl2) {
                    if (!(vector3.minus(vector).dot(vector2) > 0.0)) continue;
                    particle.pick(bl);
                    continue;
                }
                if (!(vector3.minus(vector).dot(vector2) <= 0.0)) continue;
                particle.pick(!bl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void shiftAtoms(Vector vector) {
        try {
            Structure structure = this.frames.get(this.currentFrame);
            int n = structure.countParticles();
            for (int i = 0; i < n; ++i) {
                if (!structure.getParticle(i).isPicked()) continue;
                structure.getParticle(i).shiftCoordinates(vector);
            }
            structure.forcePeriodicBounds();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void listCell() {
        try {
            Structure structure = this.frames.get(this.currentFrame);
            for (int i = 0; i < 3; ++i) {
                Vector vector = structure.getCell()[i];
                this.printMessage("cell vector " + (i + 1) + "   (" + FileHandler.formattedDouble(vector.element(0), 12, 5) + ", " + FileHandler.formattedDouble(vector.element(1), 12, 5) + ", " + FileHandler.formattedDouble(vector.element(2), 12, 5) + ")", true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void listVariables() {
        try {
            String string;
            FileHandler fileHandler = new FileHandler();
            this.printMessage("Pre-defined:", true);
            for (int i = 0; i < keys.length; ++i) {
                this.printMessage(FileHandler.formattedString(keys[i] + " = ", 20) + this.parseVariable(keys[i]), true);
            }
            this.printMessage("Custom:", true);
            Enumeration<String> enumeration = this.variables.keys();
            Object[] objectArray = new String[this.variables.size()];
            int n = 0;
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                string = this.variables.get(string2).toString();
                objectArray[n] = FileHandler.formattedString(string2 + " = ", 20) + string;
                ++n;
            }
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                this.printMessage((String)objectArray[i], true);
            }
            enumeration = this.stringVariables.keys();
            objectArray = new String[this.stringVariables.size()];
            n = 0;
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                string = this.stringVariables.get(string3).toString();
                objectArray[n] = FileHandler.formattedString(string3 + " = ", 20) + "'" + string + "'";
                ++n;
            }
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                this.printMessage((String)objectArray[i], true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void listFunctions() {
        try {
            FileHandler fileHandler = new FileHandler();
            this.printMessage("Pre-defined:", true);
            Operator[] operatorArray = adder.listOperators();
            for (int i = 0; i < operatorArray.length; ++i) {
                this.printMessage(FileHandler.formattedString(operatorArray[i].getType(), 15) + " " + FileHandler.formattedString(operatorArray[i].getSyntax(), 40) + " (" + operatorArray[i].getName() + ")", true);
            }
            this.printMessage("Custom:", true);
            CustomFunction[] customFunctionArray = adder.listFunctions();
            for (int i = 0; i < customFunctionArray.length; ++i) {
                String[] stringArray = new String[customFunctionArray[i].getArgumentCount()];
                for (int j = 0; j < stringArray.length; ++j) {
                    stringArray[j] = "#" + (j + 1);
                }
                this.printMessage(FileHandler.formattedString(customFunctionArray[i].getName(), 20) + " " + FileHandler.formattedString(customFunctionArray[i].getSyntax(stringArray) + " = ", 30) + customFunctionArray[i].getExpression(stringArray), true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void listCommands() {
        try {
            for (int i = 0; i < mainCommands.length; ++i) {
                this.printMessage(mainCommands[i], true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void listAliases() {
        try {
            Enumeration<String> enumeration = this.aliases.keys();
            Object[] objectArray = new String[this.aliases.size()];
            int n = 0;
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                Alias alias = this.aliases.get(string);
                String[] stringArray = new String[alias.getArgumentCount()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = "#" + (i + 1);
                }
                String string2 = string;
                for (int i = string.length(); i < 20; ++i) {
                    string2 = string2 + " ";
                }
                objectArray[n] = string2 + " " + alias.getCommand(stringArray);
                ++n;
            }
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                this.printMessage((String)objectArray[i], true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void listElements() {
        Structure structure = this.frames.get(this.currentFrame);
        int[] nArray = structure.findElements();
        int[] nArray2 = structure.countElements();
        for (int i = 0; i < nArray2.length; ++i) {
            try {
                Element element = this.parseElement(nArray[i]);
                this.printMessage("element " + FileHandler.formattedInt(element.getNumber(), 3) + ", " + element.getSymbol() + ":  " + nArray2[i] + " particles.   ", true);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void listAll() {
        try {
            Structure structure = this.frames.get(this.currentFrame);
            int n = structure.countParticles();
            for (int i = 0; i < n; ++i) {
                Particle particle = structure.getParticle(i);
                this.printMessage(FileHandler.formattedInt(i, 6) + "  " + ((Object)particle).toString(), true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pickByMouse(int n, int n2, int n3) {
        int[] nArray = this.painter.getView().coversScreenPoint(n, n2);
        if (nArray.length > 0) {
            int n4;
            Structure structure = this.frames.get(this.currentFrame);
            Atom[] atomArray = structure.getAllAtoms();
            int[] nArray2 = structure.mapAtomsToParticles();
            boolean[] blArray = new boolean[structure.countParticles()];
            for (n4 = 0; n4 < blArray.length; ++n4) {
                blArray[n4] = false;
            }
            if (n3 == 1) {
                Particle particle;
                n4 = nArray2[nArray[nArray.length - 1]];
                particle.pick(!(particle = structure.getParticle(n4)).isPicked());
            } else if (n3 == 2) {
                blArray[nArray[nArray.length - 1]] = true;
                for (n4 = 0; n4 < nArray.length - 1; ++n4) {
                    Particle particle;
                    int n5 = nArray2[nArray[n4]];
                    if (blArray[n5]) continue;
                    particle.pick(!(particle = structure.getParticle(n5)).isPicked());
                    blArray[n5] = true;
                }
            } else if (n3 == 3) {
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    int n6 = nArray2[nArray[n4]];
                    if (blArray[n6]) continue;
                    Particle particle = structure.getParticle(n6);
                    particle.pick(true);
                    blArray[n6] = true;
                }
            }
            this.painter.updateGeo();
        }
    }

    public void listMouseInfo(int n, int n2) {
        int[] nArray = this.painter.getView().coversScreenPoint(n, n2);
        if (nArray.length > 0) {
            Structure structure = this.frames.get(this.currentFrame);
            Atom[] atomArray = structure.getAllAtoms();
            int[] nArray2 = structure.mapAtomsToParticles();
            this.printMessage("mouse query", true);
            for (int i = 0; i < nArray.length; ++i) {
                System.out.print(atomArray[nArray[i]].toString());
                Particle particle = structure.getParticle(nArray2[nArray[i]]);
                if (particle.isAtomic()) {
                    this.printMessage("  independent " + nArray2[nArray[i]], true);
                    continue;
                }
                this.printMessage("  in cluster  " + nArray2[nArray[i]], true);
            }
            System.out.print(PROMPT + " ");
        }
    }

    public void listPicked() {
        try {
            Structure structure = this.frames.get(this.currentFrame);
            int n = structure.countParticles();
            for (int i = 0; i < n; ++i) {
                Particle particle = structure.getParticle(i);
                if (!particle.isPicked()) continue;
                this.printMessage(FileHandler.formattedInt(i, 6) + "  " + ((Object)particle).toString(), true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void bend(Vector vector, Vector vector2, Vector vector3) throws Exception {
        Vector vector4 = vector3.projectionOnPlane(vector);
        double d = vector4.norm();
        vector4 = vector4.unit();
        Vector vector5 = vector.unit();
        Vector vector6 = vector5.cross(vector4);
        if (d < 0.001) {
            this.printMessage("cannot bend by a zero radius");
            throw new Exception();
        }
        Structure structure = this.frames.get(this.currentFrame);
        this.rememberStructure();
        for (int i = 0; i < structure.countParticles(); ++i) {
            Particle particle = structure.getParticle(i);
            if (!particle.isPicked()) continue;
            Vector vector7 = particle.getCoordinates().minus(vector2);
            double d2 = vector7.dot(vector5);
            double d3 = vector7.dot(vector4);
            double d4 = vector7.dot(vector6);
            double d5 = 0.0;
            d5 = d3 > 0.0 ? d4 / d : -d4 / d;
            Vector vector8 = vector4.times(d3).rotate(vector5, d5).plus(vector5.times(d2));
            particle.setCoordinates(vector8.plus(vector2));
            if (particle.isAtomic()) continue;
            particle.rotate(new Quaternion(vector5, d5));
        }
        structure.forcePeriodicBounds();
        structure.calculateCenter();
        this.painter.aimAtCenter();
        this.painter.updateGeo();
    }

    public void scale(double d, boolean bl, int n) throws Exception {
        Structure structure = this.frames.get(this.currentFrame);
        this.rememberStructure();
        for (int i = 0; i < structure.countParticles(); ++i) {
            Particle particle = structure.getParticle(i);
            if (!particle.isPicked()) continue;
            if (n == 3) {
                particle.setCoordinates(particle.getCoordinates().times(d));
            } else if (n > -1) {
                Vector vector = structure.getDirectCoordinates(particle.getCoordinates());
                vector.setElement(n, vector.element(n) * d);
                particle.setCoordinates(structure.getCartesianCoordinates(vector));
            }
            if (!bl || particle.isAtomic()) continue;
            ((Cluster)particle).scale(d);
        }
        if (n >= 0) {
            Vector[] vectorArray = structure.getCell();
            for (int i = 0; i < 3; ++i) {
                if (n != 3 && n != i) continue;
                vectorArray[i] = vectorArray[i].times(d);
            }
            structure.updateInverseCell();
        }
        structure.calculateCenter();
        this.painter.aimAtCenter();
        this.painter.updateGeo();
    }

    public void reIndex(int n) throws Exception {
        if (this.frames.size() <= n || n < 0) {
            throw new Exception();
        }
        this.frames.get(this.currentFrame).reIndex(this.frames.get(n));
        this.painter.aimAtCenter();
        this.painter.updateGeo();
    }

    public void updateElements() {
        for (int i = 0; i < this.frames.size(); ++i) {
            this.frames.get(i).updateElements();
        }
    }

    public void listNeighbors(int n) {
        int n2;
        int n3;
        Structure structure = this.frames.get(this.currentFrame);
        int n4 = structure.countPickedParticles();
        int n5 = structure.countParticles();
        double[][] dArray = new double[n4][n];
        int[][] nArray = new int[n4][n];
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n3][n2] = -1.0;
                nArray[n3][n2] = -1;
            }
        }
        n3 = -1;
        for (n2 = 0; n2 < n5; ++n2) {
            int n6;
            Particle particle = structure.getParticle(n2);
            if (!particle.isPicked()) continue;
            ++n3;
            for (n6 = 0; n6 < n5; ++n6) {
                if (n2 == n6) continue;
                Particle particle2 = structure.getParticle(n6);
                double d = structure.distance(particle.getCoordinates(), particle2.getCoordinates());
                boolean bl = false;
                int n7 = 0;
                while (!bl) {
                    if (dArray[n3][n7] < 0.0 || dArray[n3][n7] > d) {
                        bl = true;
                        for (int i = n - 1; i > n7; --i) {
                            dArray[n3][i] = dArray[n3][i - 1];
                            nArray[n3][i] = nArray[n3][i - 1];
                        }
                        dArray[n3][n7] = d;
                        nArray[n3][n7] = n6;
                    }
                    if (++n7 != n) continue;
                    bl = true;
                }
            }
            if (particle.isAtomic()) {
                System.out.print("atom    " + FileHandler.formattedInt(n2, (int)(2.0 + Math.log(n5) / Math.log(10.0))) + " el. " + FileHandler.formattedInt(((Atom)particle).getElement(), 5) + " : ");
            } else {
                System.out.print("cluster " + FileHandler.formattedInt(n2, (int)(2.0 + Math.log(n5) / Math.log(10.0))) + " of " + FileHandler.formattedInt(particle.countAtoms(), 6) + " : ");
            }
            for (n6 = 0; n6 < n; ++n6) {
                if (nArray[n3][n6] < 0) continue;
                if (n6 > 0) {
                    System.out.print(",");
                }
                System.out.print("  " + FileHandler.formattedInt(nArray[n3][n6], (int)(2.0 + Math.log(n5) / Math.log(10.0))) + " " + FileHandler.formattedDouble(dArray[n3][n6], 8, 3));
            }
            this.printMessage("");
        }
    }

    public void interpolate(int n, int n2, int n3) {
        System.out.println(n + " " + n2 + " " + n3);
        try {
            Structure structure = this.frames.get(n);
            Structure structure2 = this.frames.get(n2);
            for (int i = 0; i < n3; ++i) {
                double d = (double)(n3 - i) / (double)(n3 + 1);
                Structure structure3 = Structure.interpolate(structure, structure2, d);
                this.addFrame(structure3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String readCommandLine(String string) {
        System.out.print(string + " ");
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string2 = "";
        try {
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            this.printMessage("command line error");
        }
        return string2;
    }

    public void writeGeometry(String string, Structure structure, int n, String[] stringArray) throws Exception {
        FileHandler fileHandler = new FileHandler();
        String[] stringArray2 = new String[]{""};
        if (n == 2) {
            stringArray2 = fileHandler.formatPoscar(string, structure, true, stringArray);
            fileHandler.writeFile(stringArray2, string);
        } else if (n == 4) {
            stringArray2 = fileHandler.formatPoscar(string, structure, false, stringArray);
            fileHandler.writeFile(stringArray2, string);
        } else if (n == 1) {
            stringArray2 = fileHandler.formatXYZ(structure);
            fileHandler.writeFile(stringArray2, string);
        } else if (n == 5) {
            stringArray2 = fileHandler.formatASE(structure);
            fileHandler.writeFile(stringArray2, string);
        } else if (n == -1) {
            BufferedImage bufferedImage = this.painter.getPainting();
            fileHandler.writeFile(bufferedImage, string, n);
        } else {
            throw new Exception();
        }
    }

    public void writeGeometries(String string, Structure[] structureArray, int n) throws Exception {
        FileHandler fileHandler = new FileHandler();
        String[] stringArray = new String[]{""};
        if (n == 1) {
            for (int i = 0; i < structureArray.length; ++i) {
                stringArray = fileHandler.formatXYZ(structureArray[i]);
                fileHandler.appendFile(stringArray, string);
            }
        } else {
            throw new Exception();
        }
    }

    public Structure[] readGeometry(String string, int n) throws Exception {
        FileHandler fileHandler = new FileHandler();
        if (n == 1) {
            return fileHandler.readXYZ(string);
        }
        if (n == 2) {
            return fileHandler.readPoscar(string);
        }
        throw new Exception();
    }

    public void executeScript(String string) throws Exception {
        try {
            this.frames.get(this.currentFrame).calculateCenter();
            this.rememberStructure();
            runningScript = true;
            FileHandler fileHandler = new FileHandler();
            ArrayList<String> arrayList = fileHandler.readLines(string);
            this.executeBlock(arrayList, 0, arrayList.size());
            runningScript = false;
            this.frames.get(this.currentFrame).calculateCenter();
            this.painter.aimAtCenter();
            this.painter.updateGeo();
        }
        catch (Exception exception) {
            runningScript = false;
            throw exception;
        }
    }

    public void executeBlock(ArrayList<String> arrayList, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            int n3;
            String string;
            int n4;
            StringTokenizer stringTokenizer = new StringTokenizer(arrayList.get(i), " \t");
            if (stringTokenizer.countTokens() <= 0) continue;
            String[] stringArray = new String[stringTokenizer.countTokens()];
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                stringArray[n4] = stringTokenizer.nextToken();
            }
            if (stringArray[0].equalsIgnoreCase(C_IF)) {
                int n5;
                n4 = 1;
                string = "";
                for (int j = 1; j < stringArray.length; ++j) {
                    string = string + stringArray[j];
                }
                Variable variable = new Variable(C_IF, 0.0);
                try {
                    variable = this.evaluateExpression(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                n3 = variable.getIntValue() == 1 ? 1 : 0;
                int n6 = -1;
                int n7 = -1;
                for (n5 = i + 1; n6 < i && n5 < n2; ++n5) {
                    StringTokenizer stringTokenizer2 = new StringTokenizer(arrayList.get(n5), " ");
                    if (!stringTokenizer2.hasMoreTokens()) continue;
                    String string2 = stringTokenizer2.nextToken();
                    if (string2.equalsIgnoreCase(C_ENDIF)) {
                        if (--n4 != 0) continue;
                        n6 = n5;
                        continue;
                    }
                    if (string2.equalsIgnoreCase(C_IF)) {
                        ++n4;
                        continue;
                    }
                    if (!string2.equalsIgnoreCase(C_ELSE) || n4 != 1) continue;
                    n7 = n5;
                }
                if (n6 < 0) {
                    this.printMessage("unclosed if structure found", true);
                }
                if (n3 != 0) {
                    if (n7 > i) {
                        this.executeBlock(arrayList, i + 1, n7);
                    } else {
                        this.executeBlock(arrayList, i + 1, n6);
                    }
                } else if (n7 > i) {
                    this.executeBlock(arrayList, n7 + 1, n6);
                }
                i = n5 - 1;
                continue;
            }
            if (stringArray[0].equalsIgnoreCase(C_WHILE)) {
                int n8;
                n4 = 1;
                string = "";
                for (n8 = 1; n8 < stringArray.length; ++n8) {
                    string = string + stringArray[n8];
                }
                n3 = -1;
                for (n8 = i + 1; n3 < i && n8 < n2; ++n8) {
                    StringTokenizer stringTokenizer3 = new StringTokenizer(arrayList.get(n8), " ");
                    if (!stringTokenizer3.hasMoreTokens()) continue;
                    String string3 = stringTokenizer3.nextToken();
                    if (string3.equalsIgnoreCase(C_ENDWHILE)) {
                        if (--n4 != 0) continue;
                        n3 = n8;
                        continue;
                    }
                    if (!string3.equalsIgnoreCase(C_WHILE)) continue;
                    ++n4;
                }
                if (n3 < 0) {
                    this.printMessage("unclosed while structure found", true);
                }
                Variable variable = new Variable(C_IF, 0.0);
                try {
                    variable = this.evaluateExpression(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                while (variable.getIntValue() == 1) {
                    this.executeBlock(arrayList, i + 1, n8 - 1);
                    try {
                        variable = this.evaluateExpression(string);
                    }
                    catch (Exception exception) {}
                }
                i = n8 - 1;
                continue;
            }
            this.executeCommand(arrayList.get(i));
        }
    }

    public void changeProjectionType(int n) {
        this.painter.getViewPoint().setProjectionType(n);
        this.painter.aimAtCenter();
        this.painter.updateGeo();
    }

    public Element parseElement(int n) throws Exception {
        if (n > 0 && n < elementTable.fill()) {
            return elementTable.getElement(n);
        }
        System.out.println("Element " + n + " has not been defined yet. Try naming it first?");
        throw new Exception();
    }

    public Element parseElement(String string) throws Exception {
        int n = 0;
        try {
            n = this.parseI(string);
        }
        catch (Exception exception) {
            return elementTable.getElement(string);
        }
        if (n > 0 && n < elementTable.fill()) {
            return elementTable.getElement(n);
        }
        throw new Exception();
    }

    public double parseR(String string) throws Exception {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            double[][] dArray = this.evaluateExpression(string).getMatrixValue();
            if (dArray.length == 1 && dArray[0].length == 1) {
                return dArray[0][0];
            }
            throw new Exception();
        }
    }

    public double[] parseVector(String string) throws Exception {
        double[][] dArray = this.evaluateExpression(string).getMatrixValue();
        if (dArray.length == 1) {
            double[] dArray2 = new double[dArray[0].length];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = dArray[0][i];
            }
            return dArray2;
        }
        if (dArray[0].length == 1) {
            double[] dArray3 = new double[dArray.length];
            for (int i = 0; i < dArray3.length; ++i) {
                dArray3[i] = dArray[i][0];
            }
            return dArray3;
        }
        throw new Exception();
    }

    public double[][] parseMatrix(String string) throws Exception {
        return this.evaluateExpression(string).getMatrixValue();
    }

    public int findVector(String[] stringArray, int n, Vector vector) throws Exception {
        int n2 = vector.dimension();
        try {
            double[] dArray = this.parseVector(stringArray[n]);
            if (dArray.length == n2) {
                for (int i = 0; i < n2; ++i) {
                    vector.setElement(i, dArray[i]);
                }
                return 1;
            }
            throw new Exception();
        }
        catch (Exception exception) {
            int n3;
            double[] dArray = new double[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                dArray[n3] = this.parseR(stringArray[n3 + n]);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                vector.setElement(n3, dArray[n3]);
            }
            return n2;
        }
    }

    public Variable parseVariable(String string) throws Exception {
        try {
            if (this.isKeyword(string)) {
                return this.getKeyValue(string);
            }
            return new Variable(string, Double.parseDouble(string));
        }
        catch (Exception exception) {
            return this.getVariable(string);
        }
    }

    public StringVariable parseStringVariable(String string) {
        try {
            if (this.isKeyword(string)) {
                return new StringVariable(string, this.getKeyValue(string).toString());
            }
            return this.getStringVariable(string);
        }
        catch (Exception exception) {
            try {
                return new StringVariable(string, this.getVariable(string).toString());
            }
            catch (Exception exception2) {
                return new StringVariable(string, string);
            }
        }
    }

    public int parseI(String string) throws Exception {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            double[][] dArray = this.evaluateExpression(string).getMatrixValue();
            if (dArray.length == 1 && dArray[0].length == 1) {
                return (int)dArray[0][0];
            }
            throw new Exception();
        }
    }

    public String parseS(String string) throws Exception {
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            String string4 = string.substring(i, i + 1);
            if (string4.equals("$")) {
                String string5;
                if (bl) {
                    bl = false;
                    string5 = "";
                    try {
                        string5 = bl2 ? string5 + this.parseI(string3) : string5 + this.parseR(string3);
                    }
                    catch (Exception exception) {
                        try {
                            Variable variable = this.evaluateExpression(string3);
                            double[][] dArray = variable.getMatrixValue();
                            string5 = bl2 ? string5 + variable.getHeight() + " " + variable.getWidth() : string5 + variable.getMatrixString();
                        }
                        catch (Exception exception2) {
                            string5 = this.parseStringVariable(string3).toString();
                        }
                    }
                    string2 = string2 + string5;
                    continue;
                }
                string3 = "";
                bl = true;
                if ((string5 = string.substring(++i, i + 1)).equals("I")) {
                    bl2 = true;
                    continue;
                }
                if (string5.equals("R")) {
                    bl2 = false;
                    continue;
                }
                bl2 = false;
                --i;
                continue;
            }
            if (bl) {
                string3 = string3 + string4;
                continue;
            }
            string2 = string2 + string4;
        }
        return string2;
    }

    public void defineAlias(String string, Alias alias) throws Exception {
        if (this.isCommand(string)) {
            throw new Exception();
        }
        this.aliases.put(string, alias);
    }

    public Alias getAlias(String string) throws Exception {
        if (this.aliases.containsKey(string)) {
            return this.aliases.get(string);
        }
        throw new Exception();
    }

    public void defineVariable(String string, Variable variable) throws Exception {
        if (this.isKeyword(string)) {
            throw new Exception();
        }
        Variable variable2 = new Variable(string, variable.getMatrixValue());
        this.variables.put(string, variable2);
    }

    public void defineStringVariable(String string, StringVariable stringVariable) throws Exception {
        if (this.isKeyword(string)) {
            throw new Exception();
        }
        StringVariable stringVariable2 = new StringVariable(string, stringVariable.toString());
        this.stringVariables.put(string, stringVariable2);
    }

    public void removeVariable(String string) throws Exception {
        if (this.isKeyword(string)) {
            throw new Exception();
        }
        this.variables.remove(string);
    }

    public void removeStringVariable(String string) throws Exception {
        if (this.isKeyword(string)) {
            throw new Exception();
        }
        this.stringVariables.remove(string);
    }

    public void defineVariable(String string, double d) throws Exception {
        if (this.isKeyword(string)) {
            throw new Exception();
        }
        Variable variable = new Variable(string, d);
        this.variables.put(string, variable);
    }

    public void defineStringVariable(String string, String string2) throws Exception {
        if (this.isKeyword(string)) {
            throw new Exception();
        }
        StringVariable stringVariable = new StringVariable(string, string2);
        this.stringVariables.put(string, stringVariable);
    }

    public Variable getVariable(String string) throws Exception {
        if (this.variables.containsKey(string)) {
            return this.variables.get(string);
        }
        throw new Exception();
    }

    public StringVariable getStringVariable(String string) throws Exception {
        if (this.stringVariables.containsKey(string)) {
            return this.stringVariables.get(string);
        }
        throw new Exception();
    }

    public static String concatenate(String[] stringArray, int n, int n2) {
        String string = "";
        for (int i = n; i < n2; ++i) {
            string = string + stringArray[i];
        }
        return string;
    }

    public boolean isCommand(String string) {
        for (int i = 0; i < this.commands.length; ++i) {
            if (!string.equalsIgnoreCase(this.commands[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isKeyword(String string) {
        int n;
        for (n = 0; n < keys.length; ++n) {
            if (!string.equalsIgnoreCase(keys[n])) continue;
            return true;
        }
        for (n = 0; n < this.commands.length; ++n) {
            if (!string.equalsIgnoreCase(this.commands[n])) continue;
            return true;
        }
        n = elementTable.findNumber(string);
        return n >= 0;
    }

    public Variable getKeyValue(String string) throws Exception {
        Variable variable;
        if (string.equalsIgnoreCase(K_CX)) {
            variable = new Variable(string, this.frames.get(this.currentFrame).getCell()[0].toHorizontalVector());
        } else if (string.equalsIgnoreCase(K_CY)) {
            variable = new Variable(string, this.frames.get(this.currentFrame).getCell()[1].toHorizontalVector());
        } else if (string.equalsIgnoreCase(K_CZ)) {
            variable = new Variable(string, this.frames.get(this.currentFrame).getCell()[2].toHorizontalVector());
        } else if (string.equalsIgnoreCase(K_BX)) {
            variable = this.frames.get(this.currentFrame).getBoundaryConditions()[0] ? new Variable(string, 1.0) : new Variable(string, 0.0);
        } else if (string.equalsIgnoreCase(K_BY)) {
            variable = this.frames.get(this.currentFrame).getBoundaryConditions()[1] ? new Variable(string, 1.0) : new Variable(string, 0.0);
        } else if (string.equalsIgnoreCase(K_BZ)) {
            variable = this.frames.get(this.currentFrame).getBoundaryConditions()[2] ? new Variable(string, 1.0) : new Variable(string, 0.0);
        } else if (string.equalsIgnoreCase(K_NFR)) {
            variable = new Variable(string, this.frames.size());
        } else if (string.equalsIgnoreCase("frame")) {
            variable = new Variable(string, this.currentFrame + 1);
        } else if (string.equalsIgnoreCase(K_NPART)) {
            variable = new Variable(string, this.frames.get(this.currentFrame).countParticles());
        } else if (string.equalsIgnoreCase(K_NATOM)) {
            variable = new Variable(string, this.frames.get(this.currentFrame).getAllAtoms().length);
        } else if (string.equalsIgnoreCase("view")) {
            variable = new Variable(string, this.painter.getViewPoint().getPosition().toVerticalVector());
        } else if (string.equalsIgnoreCase(K_VUP)) {
            variable = new Variable(string, this.painter.getViewPoint().getUp().toVerticalVector());
        } else if (string.equalsIgnoreCase(K_VZOOM)) {
            variable = new Variable(string, this.painter.getViewPoint().getZoom());
        } else if (string.equalsIgnoreCase(K_VDIR)) {
            variable = new Variable(string, this.painter.getViewPoint().getDirection().toVerticalVector());
        } else if (string.equalsIgnoreCase(K_PI)) {
            variable = new Variable(K_PI, Math.PI);
        } else if (string.equalsIgnoreCase(K_E)) {
            variable = new Variable(K_E, Math.E);
        } else if (string.equalsIgnoreCase(K_VERSION)) {
            variable = new Variable(K_VERSION, Double.parseDouble(VERSION));
        } else {
            int n = elementTable.findNumber(string);
            if (n >= 0) {
                return new Variable(string, n);
            }
            return this.getVariable(string);
        }
        return variable;
    }

    public Variable evaluateExpression(String string) throws Exception {
        if (this.isKeyword(string)) {
            return this.getKeyValue(string);
        }
        ArrayList<FormulaBlock> arrayList = adder.splitExpression(string);
        adder.resetRecursionDepth();
        return adder.evaluateExpression(arrayList);
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public Structure getCurrentStructure() {
        return this.frames.get(this.currentFrame);
    }

    public String getCurrentFrameName() {
        try {
            return this.frames.get(this.currentFrame).getName();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public int getNumberOfFrames() {
        return this.frames.size();
    }

    public void hidePicked(boolean bl) {
        Structure structure = this.frames.get(this.currentFrame);
        ArrayList<Particle> arrayList = structure.getParticles();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!arrayList.get(i).isPicked()) continue;
            arrayList.get(i).hide(bl);
        }
        this.painter.updateGeo();
    }

    public void printManual(String string) {
        String[] stringArray = new String[mainCommands.length];
        try {
            for (int i = 0; i < mainCommands.length; ++i) {
                Command command = this.commandTable.get(mainCommands[i]);
                stringArray[i] = "\nManual for '" + command.getName() + "'\n" + "\nUsage: > " + command.getUsage() + "\n" + "\n" + command.getInstructions() + "\n\n";
            }
            new FileHandler().writeFile(stringArray, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void accessCalculatorManual(String string) {
        adder.accessManual(string);
    }

    public void accessManual(String string) {
        block5: {
            try {
                Command command = this.commandTable.get(string);
                this.printMessage("\nManual for '" + command.getName() + "'\n", true);
                this.printMessage("Usage: > " + command.getUsage(), true);
                this.printMessage("\n" + command.getInstructions() + "\n", true);
            }
            catch (Exception exception) {
                try {
                    Alias alias = this.getAlias(string);
                    String[] stringArray = new String[alias.getArgumentCount()];
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = "#" + (i + 1);
                    }
                    this.printMessage("Manual for '" + string + "'", true);
                    this.printMessage(string + " is an alias for '" + alias.getCommand(stringArray) + "'", true);
                }
                catch (Exception exception2) {
                    if (string.length() <= 0) break block5;
                    this.printMessage("an unknown command " + string, true);
                }
            }
        }
    }

    public static void recolorBackground(int n, int n2, int n3, int n4) {
        View.bg = new Color(n, n2, n3, n4);
    }

    public static void recolorPick(int n, int n2, int n3, int n4) {
        View.picked = new Color(n, n2, n3, n4);
        View.hiddenPicked = new Color(n, n2, n3, n4 / 6);
    }

    public static void recolorUnpick(int n, int n2, int n3, int n4) {
        View.unpicked = new Color(n, n2, n3, n4);
        View.hiddenUnpicked = new Color(n, n2, n3, n4 / 6);
    }

    public static void recolorElement(int n, int n2, int n3, int n4, int n5) {
        elementTable.getElement(n % elementTable.size()).setColor(new Color(n2, n3, n4, n5));
    }

    public static void resizeElement(int n, double d) {
        elementTable.getElement(n % elementTable.size()).setRadius(d);
    }

    public static void main(String[] stringArray) {
        RNG = new Random();
        ASH aSH = new ASH(stringArray);
    }

    static {
        keys = new String[]{K_CX, K_CY, K_CZ, K_BX, K_BY, K_BZ, "frame", K_NFR, K_NPART, K_NATOM, "view", K_VUP, K_VZOOM, K_VDIR, K_PI, K_E, K_VERSION};
        DEFAULT_LAUNCH = new String[]{"print \"This is Atomic Structure Handler $version$\"", "print \" \"", "print \"- view the available commands by typing 'list command'\"", "print \"- view the manual by typing 'man' followed by the name of a command\"", "print \"- edit launch options in the file .ash_launch\""};
        elementTable = new PeriodicTable();
        runningScript = false;
        defaultPick = true;
        PROMPT = " >";
    }

    private class Wait
    extends Command {
        protected Wait(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_WAIT;
            this.minValues = 0;
            this.maxValues = 0;
            this.cOptions = new String[0][0];
            this.cArgs = "(milliseconds)";
            this.cInstructions = "Stops the execution of the program for the given time. This can be used for animating scripts.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            this.master.painter.updateGeo();
            Thread.sleep(ASH.this.parseI(stringArray[0]));
        }
    }

    private class Bend
    extends Command {
        protected Bend(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_BEND;
            this.minValues = 4;
            this.maxValues = 9;
            this.cOptions = new String[1][];
            String[] stringArray = new String[]{"x", "y", "z", ASH.C_AXIS};
            this.cOptions[0] = stringArray;
            this.cInstructions = "Bends the geometry around an axis. This is done by defining an axis vector, a reference point through which the axis is set, and a 'radius' vector defining the bending radius. (Only the component of the radius vector perpendicular to the bending axis is meningful. If the vector is not perpendicular to the axis, the perpendicular component is automatically extracted. It must not be a zero vector.) If you move by the radius vector from the reference point and take the line parallel to the bending axis, you get a line in space which is not affected by the bending operation. Let us call this the 'contact' line. Now consider the plane passing through the contact line, perpendicular to the plane defined the bending axis and the contact line (perpendicular to the radius vector). Let this be called the 'wrapping' plane. This plane is bent as if wrapping a cylinder defined by the axis and radius, so that the original in-plane distances are the same as the final distances measured along the cylinder surface. Naturally the operation also bends other planes. This is done so that straight lines in the direction of the radius vector are conserved. That is, planes parallel to the wrapping plane but closer to the axis are squeezed (distances in the bend direction are shrunk) and the planes farther from the axis are stretched. The operation only affetcs the currently active particles. Positions and orientations of clusters are affected, but their internal structure is not.\nOptions:\n    x (py) (pz) (ry) (rz) - Bends the system around an axis set in the x direction, [1, 0, 0]. The axis is fixed at [0, py, pz] and the radius vector is defined as [0, ry, rz].\n    y (px) (pz) (rx) (rz) - Bends the system around an axis set in the y direction, [0, 1, 0]. The axis is fixed at [px, 0, pz] and the radius vector is defined as [rx, 0, rz].\n    z (px) (py) (rx) (ry) - Bends the system around an axis set in the z direction, [0, 0, 1]. The axis is fixed at [px, py, 0] and the radius vector is defined as [rx, ry, 0].\n    axis (ax) (ay) (az) (px) (py) (pz) (rx) (ry) (rz) - Bends the system around an arbitrary axis [ax, ay, az] at [px, py, pz]. The radius vector is defined as [rx, ry, rz]. Only the component perpendicular to the axis is meaningful, and it must not be zero, i.e., the radius vector must not be parallel to the axis.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            int n = 1;
            Vector vector = new Vector(3);
            Vector vector2 = new Vector(3);
            Vector vector3 = new Vector(3);
            if (stringArray[0].equalsIgnoreCase(ASH.C_AXIS)) {
                n += ASH.this.findVector(stringArray, n, vector);
                n += ASH.this.findVector(stringArray, n, vector2);
                n += ASH.this.findVector(stringArray, n, vector3);
            } else if (stringArray[0].equalsIgnoreCase("x")) {
                vector = new Vector(1.0, 0.0, 0.0);
                Vector vector4 = new Vector(2);
                Vector vector5 = new Vector(2);
                n += ASH.this.findVector(stringArray, n, vector4);
                n += ASH.this.findVector(stringArray, n, vector5);
                vector2 = new Vector(0.0, vector4.element(0), vector4.element(1));
                vector3 = new Vector(0.0, vector5.element(0), vector5.element(1));
            } else if (stringArray[0].equalsIgnoreCase("y")) {
                vector = new Vector(0.0, 1.0, 0.0);
                Vector vector6 = new Vector(2);
                Vector vector7 = new Vector(2);
                n += ASH.this.findVector(stringArray, n, vector6);
                n += ASH.this.findVector(stringArray, n, vector7);
                vector2 = new Vector(vector6.element(0), 0.0, vector6.element(1));
                vector3 = new Vector(vector7.element(0), 0.0, vector7.element(1));
            } else if (stringArray[0].equalsIgnoreCase("z")) {
                vector = new Vector(0.0, 0.0, 1.0);
                Vector vector8 = new Vector(2);
                Vector vector9 = new Vector(2);
                n += ASH.this.findVector(stringArray, n, vector8);
                n += ASH.this.findVector(stringArray, n, vector9);
                vector2 = new Vector(vector8.element(0), vector8.element(1), 0.0);
                vector3 = new Vector(vector9.element(0), vector9.element(1), 0.0);
            } else {
                throw new Exception();
            }
            if (stringArray.length != n) {
                throw new Exception();
            }
            ASH.this.bend(vector, vector2, vector3);
        }
    }

    private class Scale
    extends Command {
        protected Scale(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_SCALE;
            this.minValues = 0;
            this.maxValues = 0;
            this.cOptions = new String[1][];
            String[] stringArray = new String[]{ASH.C_NOOPTION, "cell", "x", "y", "z", ASH.C_PARTS};
            this.cOptions[0] = stringArray;
            this.cArgs = "(factor)";
            this.cInstructions = "Scaling operation. By default, the entire cell is scaled with respect to the origin by the given scaling factor. This includes scaling the supercell vectors, shifting particles, and scaling clusters. However, only active particles are affected.\nOptions;\n    cell (factor) - Scales the supercell and shifts the particles accordingly, but does not scale the size of clusters. If the given factor is a vector, its components are used for scaling in the directions of the corresponding supercell vectors.\n    x (factor) - Scales the supercell and shifts particles only in the direction of the first supercell vector.\n    y (factor) - Scales the supercell and shifts particles only in the direction of the second supercell vector.\n    z (factor) - Scales the supercell and shifts particles only in the direction of the third supercell vector.\n    particles (factor) - Only the sizes of clusters are scaled, no particles are shifted.";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void execute(String[] stringArray) throws Exception {
            if (stringArray.length == 1) {
                double d = ASH.this.parseR(stringArray[0]);
                ASH.this.scale(d, true, 3);
                return;
            } else {
                if (stringArray.length != 2) throw new Exception();
                if (stringArray[0].equalsIgnoreCase("cell")) {
                    try {
                        Vector vector = new Vector(3);
                        ASH.this.findVector(stringArray, 1, vector);
                        ASH.this.scale(vector.element(0), false, 0);
                        ASH.this.scale(vector.element(1), false, 1);
                        ASH.this.scale(vector.element(2), false, 2);
                        return;
                    }
                    catch (Exception exception) {
                        double d = ASH.this.parseR(stringArray[1]);
                        ASH.this.scale(d, false, 3);
                    }
                    return;
                } else if (stringArray[0].equalsIgnoreCase("x")) {
                    double d = ASH.this.parseR(stringArray[1]);
                    ASH.this.scale(d, false, 0);
                    return;
                } else if (stringArray[0].equalsIgnoreCase("y")) {
                    double d = ASH.this.parseR(stringArray[1]);
                    ASH.this.scale(d, false, 1);
                    return;
                } else if (stringArray[0].equalsIgnoreCase("z")) {
                    double d = ASH.this.parseR(stringArray[1]);
                    ASH.this.scale(d, false, 2);
                    return;
                } else {
                    if (!stringArray[0].equalsIgnoreCase(ASH.C_PARTS)) throw new Exception();
                    double d = ASH.this.parseR(stringArray[1]);
                    ASH.this.scale(d, true, -1);
                }
            }
        }
    }

    private class DirectorySwitch
    extends Command {
        protected DirectorySwitch(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_DIR;
            this.minValues = 0;
            this.maxValues = 1;
            this.cOptions = new String[1][];
            String[] stringArray = new String[]{ASH.C_NOOPTION, "switch", ASH.C_LIST};
            this.cOptions[0] = stringArray;
            this.cInstructions = "Access to directory operations. By default, the command prints the current working directory. To emulate shell commands, one may define aliases such as 'alias cd directory switch', 'alias ls directory list' and 'alias pwd directory'.\nOptions:\n    switch (directory) - Switches to the given directory.\n    list - Lists the contents of the current directory.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            if (stringArray.length == 0) {
                ASH.this.printMessage(FileHandler.CWD.getCanonicalPath(), true);
            } else if (stringArray.length == 1) {
                if (stringArray[0].equalsIgnoreCase(ASH.C_LIST)) {
                    String[] stringArray2 = FileHandler.CWD.list();
                    for (int i = 0; i < stringArray2.length; ++i) {
                        String string = stringArray2[i];
                        ASH.this.printMessage(string, true);
                    }
                }
            } else if (stringArray.length == 2 && stringArray[0].equalsIgnoreCase("switch")) {
                File file = new File(FileHandler.CWD, stringArray[1]);
                if (file.isDirectory()) {
                    FileHandler.CWD = file;
                } else {
                    file = new File(stringArray[1]);
                    if (file.isDirectory()) {
                        FileHandler.CWD = file;
                    } else {
                        ASH.this.printMessage("No such directory.", true);
                    }
                }
            }
        }
    }

    private class MouseSwitch
    extends Command {
        protected MouseSwitch(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_MOUSE;
            this.minValues = 0;
            this.maxValues = 0;
            this.cOptions = new String[1][];
            String[] stringArray = new String[]{ASH.C_INFO, ASH.C_PICK};
            this.cOptions[0] = stringArray;
            this.cInstructions = "Toggles response to mouse clicks in the visualization window.\nOptions:\n    info - Toggles mouse query mode. When the query mode is on, one can view the coordinates of atoms by clicking on them in the visualization window. If several atoms are on the 'line of sight', all their coordinates will be displayed in order of depth, starting from the one farthest away.\n    pick - Toggles mouse selection mode. When the selection mode is on, one can select and unselect atoms by clicking on them. A sinlge click either selects or unselects the atom that was clicked on, depending on whether it was previously selected or not. A double click does the same for all the particles on the 'line of sight'. A triple click selects all the particles on the line of sight. (It will not unselect any previously selected atoms, like a double click does.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            if (stringArray[0].equalsIgnoreCase(ASH.C_INFO)) {
                if (GeoPainter.MOUSE_INFO) {
                    GeoPainter.MOUSE_INFO = false;
                    ASH.this.printMessage("Mouse query mode is now off.");
                } else {
                    GeoPainter.MOUSE_INFO = true;
                    ASH.this.printMessage("Mouse query mode is now on.");
                }
            } else if (stringArray[0].equalsIgnoreCase(ASH.C_PICK)) {
                if (GeoPainter.MOUSE_PICK) {
                    GeoPainter.MOUSE_PICK = false;
                    ASH.this.printMessage("Mouse select mode is now off.");
                } else {
                    GeoPainter.MOUSE_PICK = true;
                    ASH.this.printMessage("Mouse select mode is now on.");
                }
            }
        }
    }

    private class ElementSwitch
    extends Command {
        protected ElementSwitch(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_ELE;
            this.minValues = 1;
            this.maxValues = 2;
            this.cOptions = new String[1][];
            String[] stringArray = new String[]{ASH.C_RENAME, "switch"};
            this.cOptions[0] = stringArray;
            this.cInstructions = "Manipulates element data.\nOptions:\n    rename (element) (name) - Sets a name for the given element. Note, that you cannot rename indices 1-119, since those are fixed to represent the real elements. Indices 0 and 120 and up can be named freely.\n    switch [(old element)] (new element) - If only one argument is given, all the currently active atoms will be changed to the given element. If two arguments are given, the atoms of the specified element (in all frames) will be turned to atoms of the new element.";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void execute(String[] stringArray) throws Exception {
            if (stringArray[0].equalsIgnoreCase(ASH.C_RENAME)) {
                if (stringArray.length != 3) throw new Exception();
                int n = ASH.this.parseI(stringArray[1]);
                if (n > 0 && n < 120) {
                    ASH.this.printMessage("Cannot rename element " + n + ", " + ASH.this.parseElement(n).getSymbol() + ".", true);
                    throw new Exception();
                }
                if (n < 0 || n >= elementTable.fill()) {
                    ASH.this.printMessage("The list of elements only goes up to " + elementTable.fill() + ".", true);
                    throw new Exception();
                }
                Element element = ASH.this.parseElement(n);
                String string = stringArray[2];
                element.setSymbol(string);
                element.setName(string);
                ASH.this.updateElements();
                return;
            } else {
                if (!stringArray[0].equalsIgnoreCase("switch")) return;
                if (stringArray.length == 2) {
                    Element element = elementTable.getElement(stringArray[1]);
                    Structure structure = (Structure)ASH.this.frames.get(ASH.this.currentFrame);
                    Atom[] atomArray = structure.getAllAtoms();
                    ASH.this.rememberStructure();
                    for (int i = 0; i < atomArray.length; ++i) {
                        if (!atomArray[i].isPicked()) continue;
                        atomArray[i].setElement(element);
                    }
                    this.master.painter.updateGeo();
                    return;
                } else {
                    if (stringArray.length != 3) throw new Exception();
                    Element element = ASH.this.parseElement(stringArray[1]);
                    int n = element.getNumber();
                    Element element2 = elementTable.getElement(stringArray[2]);
                    for (int i = 0; i < ASH.this.frames.size(); ++i) {
                        Structure structure = (Structure)ASH.this.frames.get(i);
                        Atom[] atomArray = structure.getAllAtoms();
                        for (int j = 0; j < atomArray.length; ++j) {
                            if (atomArray[j].getElement() != n) continue;
                            atomArray[j].setElement(element2);
                        }
                    }
                    this.master.painter.updateGeo();
                }
            }
        }
    }

    private class MakeAlias
    extends Command {
        protected MakeAlias(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_ALIAS;
            this.minValues = 0;
            this.maxValues = 0;
            this.cInstructions = "Creates an alias for a command. Once an alias is defined, entering it will lead to the original command being executed. If further arguments follow the alias, they are appended to the command. If one wishes to insert arguments inside the aliased command, this can be done by including the strings '#1', '#2' etc. (up to #9) in the alias definition. Upon calling the alias, this will lead to each '#1' being replaced by the first following argument etc. To include a series of commands in a single alias, wrap the full command series in quotes (\" or ', if you need nested quotes, alter between the two). Using a semicolon (;) without quotes will cut the evaluation of the command 'alias' and start immediately executing whatever follows. \nExample: > alias cd \"directory switch #1; print ' *  changed the directory to   *'; directory\" (alias definition) \n         > cd ..  (alias call)";
            this.cArgs = "(name)  (command)";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            if (stringArray.length > 1) {
                String string = stringArray[0];
                String string2 = "";
                for (int i = 1; i < stringArray.length; ++i) {
                    string2 = string2 + stringArray[i] + " ";
                }
                Alias alias = null;
                try {
                    alias = new Alias(string, string2);
                    try {
                        ASH.this.defineAlias(string, alias);
                    }
                    catch (Exception exception) {
                        ASH.this.printMessage(string + " is a reserved keyword", true);
                    }
                }
                catch (Exception exception) {
                    ASH.this.printMessage("invalid alias definition", true);
                }
            } else {
                throw new Exception();
            }
        }
    }

    private class CalcManual
    extends Command {
        protected CalcManual(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_CALCMAN;
            this.minValues = 0;
            this.maxValues = 0;
            this.cOptions = new String[1][];
            String[] stringArray = Operator.OPERATORS;
            this.cOptions[0] = stringArray;
            this.cInstructions = "Displays a brief explanation on the usage of the given function or operator.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            if (stringArray.length != 1) {
                throw new Exception();
            }
            ASH.this.accessCalculatorManual(stringArray[0]);
        }
    }

    private class Manual
    extends Command {
        protected Manual(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_MAN;
            this.minValues = 0;
            this.maxValues = 0;
            this.cInstructions = "Displays a brief explanation on the usage of the given command.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            if (stringArray.length != 1) {
                throw new Exception();
            }
            ASH.this.accessManual(stringArray[0]);
        }
    }

    private class Evaluate
    extends Command {
        protected Evaluate(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_VALUE;
            this.minValues = 0;
            this.maxValues = 0;
            this.cInstructions = "Evaluates an expression. The expression can contain real numbers, variables, operators and custom functions. Normal operators such as '+', '-', '*', and '/' work, as well as a set of common functions such as 'sin', 'ln', and 'exp'. Note that functions are defined using a colon (:), as in 'sin:(2*pi)' or exp:-1. For a multi-valued function, the arguments must be wrapped in curly brackets, as in 'col:{mat,1}' Comparison and logic operators such as '=', '<', '>', '&' (and), and '|' (or) are also available. A true statement is given a value of 1, an untrue one 0. Furthermore, one may define matrices and vectors using square brackets, e.g., '[[1,0][0,2]]'. When operating on matrices, most functions operate on the individual matrix elements, for instance 'exp' just takes the exponential of the matrix elements, not the matrix exponential. Multiplication and power operators ('*' and '^') invoke true matrix multiplication if possible, but if dimensions are incompatible (say, you multiply a matrix and a scalar), they also try to do element-wise operations if possible.\n The command also allows evaluation of strings, similarly to the command print. In addition, one may wish to include evaluation within command arguments, for instance when scripting. This can be done by encasing a variable or an expression between two dollar signs ($), in which case the string within the signs is evaluated. By default, a double precision value is extracted, but whether a real or an integer value is printed may be requested by adding an 'R' or 'I' immediately after the first $ symbol. (If your expression begins with a variable with a name starting with I or R, always include the format specifier!). For a matrix valued variable, normal evaluation prints the values of all the cells in a one-line format, where the rows and columns are separated by square brackets. When evaluation is invoked by $'s, the integer valued printout just prints the dimensions of the matrix, while the real valued printout prints the values of all the cells in a multi-line format, with no brackets. \nExample: > value 2.0+cos:pi. \n         > value 'pi = $Rpi$, approximately $Ipi$'";
            this.cArgs = "(expression)";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            if (stringArray.length > 0) {
                String string = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + stringArray[i];
                }
                try {
                    ASH.this.printMessage(string + " = " + ASH.this.evaluateExpression(string), true);
                }
                catch (Exception exception) {
                    try {
                        ASH.this.printMessage(string + " = '" + ASH.this.getStringVariable(string) + "'", true);
                    }
                    catch (Exception exception2) {
                        ASH.this.printMessage(string + " = '" + ASH.this.parseS(string) + "'", true);
                    }
                }
            } else {
                throw new Exception();
            }
        }
    }

    private class Define
    extends Command {
        protected Define(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_SET;
            this.minValues = 0;
            this.maxValues = 0;
            this.cOptions = new String[2][];
            String[] stringArray = new String[]{ASH.C_NOOPTION, ASH.C_ECHO, ASH.C_RM};
            this.cOptions[0] = stringArray;
            String[] stringArray2 = new String[]{ASH.C_NOOPTION, ASH.C_STRING};
            this.cOptions[1] = stringArray2;
            this.cInstructions = "Defines a variable or a function. For a variable, the definition can be a real number or an expression that can be evaluated immediately, or a string, in which case the option string is needed. In the case of an expression, the result of the evaluation is stored in the variable. When defining a string, evaluation of expressions can be included using dollar signs ($), as explained in the manual of value. A function on the other hand is an expression that is not evaluated immediately, but which can take arguments that affect its value. To define a function, include strings '#1', #2, ..., #9 in the definition to specify the arguments of the function. (The number of arguments is limited to 9, but a single argument can be a vector or a matrix of arbitrary size.) The syntax for calling the variables and functions are explained in the manual of 'value'.\nExample: > define var 1+2 (Stores 3.0 in the variable 'var'.)\n         > define f (var+#1)/#2 (If 'var' had the value 3.0, this defines the function f(x,y) = (3.0+x)/y; the definition is invalid if 'var' has not been defined.)\nOptions:\n    (variable) (value) - The first argument is the name of the variable or function, the second the number or expression which is stored.\n    echo (variable) (value) - Same as the default command, but the value stored is shown.\n    remove (variable) - Removes the variable associated to the given name.\n        string (variable) (value) - Stores a string in the variable.";
            this.cArgs = "(variable)  [ (value) ]";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void execute(String[] stringArray) throws Exception {
            if (stringArray.length <= 1) throw new Exception();
            if (stringArray[0].equalsIgnoreCase(ASH.C_RM)) {
                if (stringArray[1].equalsIgnoreCase(ASH.C_STRING)) {
                    if (stringArray.length <= 2) throw new Exception();
                    try {
                        ASH.this.removeStringVariable(stringArray[2]);
                        return;
                    }
                    catch (Exception exception) {
                        ASH.this.printMessage(stringArray[2] + " is a reserved keyword", true);
                    }
                    return;
                } else {
                    try {
                        ASH.this.removeVariable(stringArray[1]);
                        ASH.this.removeStringVariable(stringArray[1]);
                        adder.removeFunction(stringArray[1]);
                        return;
                    }
                    catch (Exception exception) {
                        ASH.this.printMessage(stringArray[1] + " is a reserved keyword", true);
                    }
                }
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            if (stringArray[0].equalsIgnoreCase(ASH.C_ECHO)) {
                bl = true;
                ++n;
            }
            if (stringArray[n].equalsIgnoreCase(ASH.C_STRING)) {
                bl2 = true;
                ++n;
            }
            String string = stringArray[0 + n];
            String string2 = "";
            for (int i = 1 + n; i < stringArray.length; ++i) {
                string2 = string2 + stringArray[i];
            }
            double d = 0.0;
            if (bl2) {
                try {
                    ASH.this.defineStringVariable(string, ASH.this.parseS(string2));
                    ASH.this.removeVariable(string);
                    if (!bl) return;
                    ASH.this.printMessage(string + " = '" + ASH.this.getStringVariable(string) + "'", true);
                    return;
                }
                catch (Exception exception) {
                    ASH.this.printMessage(string + " is a reserved keyword", true);
                }
                return;
            }
            if (string2.indexOf("#") == -1) {
                try {
                    Variable variable = ASH.this.evaluateExpression(string2);
                    try {
                        ASH.this.defineVariable(string, variable);
                        ASH.this.removeStringVariable(string);
                        if (!bl) return;
                        ASH.this.printMessage(string + " = " + variable, true);
                        return;
                    }
                    catch (Exception exception) {
                        ASH.this.printMessage(string + " is a reserved keyword", true);
                        return;
                    }
                }
                catch (Exception exception) {
                    ASH.this.printMessage("invalid definition", true);
                }
                return;
            }
            try {
                CustomFunction customFunction = new CustomFunction(string, string2, adder);
                try {
                    adder.defineFunction(string, customFunction);
                    if (!bl) return;
                    int n2 = customFunction.getArgumentCount();
                    String[] stringArray2 = new String[n2];
                    System.out.print(string + ":{");
                    for (int i = 0; i < n2; ++i) {
                        stringArray2[i] = "#" + (i + 1);
                        System.out.print(stringArray2[i]);
                        if (i < n2 - 1) {
                            System.out.print(",");
                            continue;
                        }
                        System.out.print("} = ");
                    }
                    ASH.this.printMessage(customFunction.getExpression(stringArray2), true);
                    return;
                }
                catch (Exception exception) {
                    ASH.this.printMessage(string + " is a reserved function", true);
                    return;
                }
            }
            catch (Exception exception) {
                ASH.this.printMessage("invalid function definition", true);
            }
        }
    }

    private class Undo
    extends Command {
        protected Undo(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_UNDO;
            this.minValues = 0;
            this.maxValues = 0;
            this.cInstructions = "Undos the previous operations. Note that the undo command only considers structural changes, not, e.g., changes in the graphical representation. The undo buffer exists only for the current frame and it is cleared every time a different frame is accessed.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            Structure structure = ASH.this.recallStructure();
            ASH.this.frames.set(ASH.this.currentFrame, structure);
            ((Structure)ASH.this.frames.get(ASH.this.currentFrame)).calculateCenter();
            this.master.painter.setGeometry(structure);
            this.master.painter.aimAtCenter();
            this.master.painter.updateGeo();
        }
    }

    private class Open
    extends Command {
        protected Open(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_OPEN;
            this.minValues = 0;
            this.maxValues = 0;
            this.cOptions = new String[1][];
            String[] stringArray = new String[]{ASH.C_XYZ, ASH.C_POSCAR, ASH.C_SCRIPT, ASH.C_DATA};
            this.cArgs = "(filename) [ (width) (variable) ]";
            this.cOptions[0] = stringArray;
            this.cInstructions = "Reads data from a file.\nOptions:\n    xyz (filename) - Reads geometry data from an XYZ format file.\n    poscar (filename) - Reads geometry data from a POSCAR format file.\n    script (filename) - Reads a command script file.\n    data (filename) (width) (variable) - Reads a data matrix and stores it in a matrix variable of the given width. The values should be separated by spaces and newlines. If non numerical values are met, NaN values are stored in the corresponding cells of the matrix.";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void execute(String[] stringArray) throws Exception {
            if (stringArray.length == 2) {
                if (stringArray[0].equalsIgnoreCase(ASH.C_XYZ)) {
                    String string = stringArray[1];
                    try {
                        Structure[] structureArray = ASH.this.readGeometry(string, 1);
                        for (int i = structureArray.length - 1; i >= 0; --i) {
                            ASH.this.addFrame(structureArray[i]);
                        }
                    }
                    catch (Exception exception) {
                        ASH.this.printMessage("could not read from " + string, true);
                    }
                    if (((Structure)ASH.this.frames.get(ASH.this.currentFrame)).countParticles() == 0) {
                        ASH.this.deleteFrame(ASH.this.currentFrame);
                    } else {
                        ASH.this.changeFrame(ASH.this.currentFrame + 1);
                    }
                    ASH.this.printMessage("frame " + (ASH.this.currentFrame + 1));
                    if (ASH.this.currentFrame == 0) {
                        this.master.painter.resetViewPoint();
                        return;
                    } else {
                        this.master.painter.aimAtCenter();
                        this.master.painter.updateGeo();
                    }
                    return;
                }
                if (stringArray[0].equalsIgnoreCase(ASH.C_POSCAR)) {
                    String string = stringArray[1];
                    try {
                        Structure[] structureArray = ASH.this.readGeometry(string, 2);
                        for (int i = structureArray.length - 1; i >= 0; --i) {
                            ASH.this.addFrame(structureArray[i]);
                        }
                    }
                    catch (Exception exception) {
                        ASH.this.printMessage("could not read from " + string, true);
                    }
                    if (((Structure)ASH.this.frames.get(ASH.this.currentFrame)).countParticles() == 0) {
                        ASH.this.deleteFrame(ASH.this.currentFrame);
                    } else {
                        ASH.this.changeFrame(ASH.this.currentFrame + 1);
                    }
                    ASH.this.printMessage("frame " + (ASH.this.currentFrame + 1));
                    if (ASH.this.currentFrame == 0) {
                        this.master.painter.resetViewPoint();
                        return;
                    } else {
                        this.master.painter.aimAtCenter();
                        this.master.painter.updateGeo();
                    }
                    return;
                }
                if (!stringArray[0].equalsIgnoreCase(ASH.C_SCRIPT)) throw new Exception();
                String string = stringArray[1];
                try {
                    ASH.this.executeScript(string);
                    return;
                }
                catch (Exception exception) {
                    ASH.this.printMessage("could not read from " + string, true);
                }
                return;
            }
            if (stringArray.length != 4) throw new Exception();
            if (!stringArray[0].equalsIgnoreCase(ASH.C_DATA)) return;
            String string = stringArray[1];
            int n = ASH.this.parseI(stringArray[2]);
            String string2 = stringArray[3];
            try {
                double[][] dArray = new FileHandler().readData(string, n);
                Variable variable = new Variable(string2, dArray);
                ASH.this.defineVariable(string2, variable);
                return;
            }
            catch (Exception exception) {
                ASH.this.printMessage("could not read from " + string, true);
            }
        }
    }

    private class Write
    extends Command {
        protected Write(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_WRITE;
            this.minValues = 0;
            this.maxValues = 0;
            this.cOptions = new String[2][];
            String[] stringArray = new String[]{ASH.C_NOOPTION, ASH.C_ALL};
            this.cOptions[0] = stringArray;
            String[] stringArray2 = new String[]{ASH.C_POSCAR, ASH.C_POSCAR4, ASH.C_XYZ, ASH.C_PNG, ASH.C_ASE};
            this.cOptions[1] = stringArray2;
            this.cArgs = "(filename)  [ (type1) (type2) ... ]";
            this.cInstructions = "Writes data to a file. This may mean writing the coordinates of the geometry in a text file or rendering an image of the current view. For data files, the poscar and xyz formats are currently implemented. Note that when the names of elements are written, if the name of the element contains the character '_', it and anything following will be ignored when writing (e.g., 'Mg', 'Mg_2', and 'Mg_frozen' are all written as 'Mg'). This is done to allow the user to define groups of atoms which correspond to the same element but are handled separately in ASH. If you want the names of the groups to be different in the output as well, use some other delimiter (e.g., Mg2 or Mg.2). \nOptions:\n    all - Writes the geometries of all frames in either one file, one after another (xyz), or each in its own file (poscar). By default only the geometry of the current frame is written.\n        poscar (filename) [(type1) (type2) ...] - Writes the geometry in POSCAR format used by VASP 5. By default, elements are listed in order of atomic numbers. By giving a list of element symbols, e.g., Mg O Si, the user can force the order of the elements in the written file.\n        poscar4 (filename) [(type1) (type2) ...] - Writes the geometry in POSCAR format used by VASP 4. By default, elements are listed in order of atomic numbers. By giving a list of element symbols, e.g., Mg O Si, the user can force the order of the elements in the written file.\n        xyz (filename) - Writes the geometry in xyz format.\n        ase (filename) - Writes the geometry as an ASE Python script.\n        png (filename) - Writes the geometry in png format as an image.";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void execute(String[] stringArray) throws Exception {
            boolean bl = false;
            int n = 0;
            if (stringArray[0].equalsIgnoreCase(ASH.C_ALL)) {
                bl = true;
                n = 1;
            }
            if (stringArray.length < 2 + n) throw new Exception();
            if (stringArray[n].equalsIgnoreCase(ASH.C_POSCAR)) {
                String string;
                String string2 = string = stringArray[1 + n];
                try {
                    int n2 = ASH.this.currentFrame;
                    int n3 = ASH.this.currentFrame + 1;
                    if (bl) {
                        n2 = 0;
                        n3 = ASH.this.frames.size();
                    }
                    for (int i = n2; i < n3; ++i) {
                        int n4 = string.length();
                        string2 = bl ? string + (i + 1) : string;
                        if (!string.substring(n4 - 3, n4).equalsIgnoreCase("CAR")) {
                            string2 = string2 + ".POSCAR";
                        }
                        String[] stringArray2 = new String[stringArray.length - 2 - n];
                        for (int j = 2 + n; j < stringArray.length; ++j) {
                            stringArray2[j - 2 - n] = stringArray[j];
                        }
                        ASH.this.writeGeometry(string2, (Structure)ASH.this.frames.get(i), 2, stringArray2);
                        ASH.this.printMessage("wrote " + string2);
                    }
                    return;
                }
                catch (Exception exception) {
                    ASH.this.printMessage("could not write to " + string2, true);
                    return;
                }
            } else if (stringArray[n].equalsIgnoreCase(ASH.C_POSCAR4)) {
                String string;
                String string3 = string = stringArray[1 + n];
                try {
                    int n5 = ASH.this.currentFrame;
                    int n6 = ASH.this.currentFrame + 1;
                    if (bl) {
                        n5 = 0;
                        n6 = ASH.this.frames.size();
                    }
                    for (int i = n5; i < n6; ++i) {
                        int n7 = string.length();
                        string3 = bl ? string + (i + 1) : string;
                        if (!string.substring(n7 - 3, n7).equalsIgnoreCase("CAR")) {
                            string3 = string3 + ".POSCAR";
                        }
                        String[] stringArray3 = new String[stringArray.length - 2 - n];
                        for (int j = 2 + n; j < stringArray.length; ++j) {
                            stringArray3[j - 2 - n] = stringArray[j];
                        }
                        ASH.this.writeGeometry(string3, (Structure)ASH.this.frames.get(i), 4, stringArray3);
                        ASH.this.printMessage("wrote " + string3);
                    }
                    return;
                }
                catch (Exception exception) {
                    ASH.this.printMessage("could not write to " + string3, true);
                    return;
                }
            } else if (stringArray[n].equalsIgnoreCase(ASH.C_PNG)) {
                String string;
                String string4 = string = stringArray[1 + n];
                try {
                    int n8 = ASH.this.currentFrame;
                    int n9 = ASH.this.currentFrame + 1;
                    int n10 = ASH.this.currentFrame;
                    if (bl) {
                        n8 = 0;
                        n9 = ASH.this.frames.size();
                    }
                    for (int i = n8; i < n9; ++i) {
                        int n11 = string.length();
                        string4 = bl ? string + (i + 1) : string;
                        if (!string.substring(n11 - 4, n11).equalsIgnoreCase(".png")) {
                            string4 = string4 + ".png";
                        }
                        Structure structure = (Structure)ASH.this.frames.get(i);
                        this.master.painter.setGeometry(structure);
                        this.master.painter.updateGeo();
                        ASH.this.writeGeometry(string4, structure, -1, null);
                        ASH.this.printMessage("wrote " + string4);
                    }
                    Structure structure = (Structure)ASH.this.frames.get(n10);
                    this.master.painter.setGeometry(structure);
                    this.master.painter.updateGeo();
                    return;
                }
                catch (Exception exception) {
                    ASH.this.printMessage("could not write to " + string4, true);
                }
                return;
            } else if (stringArray[n].equalsIgnoreCase(ASH.C_ASE)) {
                String string = stringArray[1 + n];
                int n12 = string.length();
                String string5 = string;
                if (!string.substring(n12 - 4, n12).equalsIgnoreCase(".py")) {
                    string5 = string + ".py";
                }
                try {
                    if (bl) {
                        Structure[] structureArray = new Structure[ASH.this.frames.size()];
                        for (int i = 0; i < structureArray.length; ++i) {
                            structureArray[i] = (Structure)ASH.this.frames.get(i);
                        }
                        ASH.this.writeGeometries(string5, structureArray, 5);
                    } else {
                        ASH.this.writeGeometry(string5, (Structure)ASH.this.frames.get(ASH.this.currentFrame), 5, null);
                    }
                    ASH.this.printMessage("wrote " + string5);
                    return;
                }
                catch (Exception exception) {
                    ASH.this.printMessage("could not write to " + string5, true);
                }
                return;
            } else {
                if (!stringArray[n].equalsIgnoreCase(ASH.C_XYZ)) throw new Exception();
                String string = stringArray[1 + n];
                int n13 = string.length();
                String string6 = string;
                if (!string.substring(n13 - 4, n13).equalsIgnoreCase(".xyz")) {
                    string6 = string + ".xyz";
                }
                try {
                    if (bl) {
                        Structure[] structureArray = new Structure[ASH.this.frames.size()];
                        for (int i = 0; i < structureArray.length; ++i) {
                            structureArray[i] = (Structure)ASH.this.frames.get(i);
                        }
                        ASH.this.writeGeometries(string6, structureArray, 1);
                    } else {
                        ASH.this.writeGeometry(string6, (Structure)ASH.this.frames.get(ASH.this.currentFrame), 1, null);
                    }
                    ASH.this.printMessage("wrote " + string6);
                    return;
                }
                catch (Exception exception) {
                    ASH.this.printMessage("could not write to " + string6, true);
                }
            }
        }
    }

    private class FrameSwitch
    extends Command {
        protected FrameSwitch(ASH aSH2) {
            super(aSH2);
            this.cName = "frame";
            this.minValues = 0;
            this.maxValues = 2;
            this.cOptions = new String[1][];
            String[] stringArray = new String[]{ASH.C_PREV, ASH.C_NEXT, ASH.C_FIRST, ASH.C_LAST, "switch", ASH.C_NEW, ASH.C_RM, ASH.C_MOVE, ASH.C_RENAME};
            this.cOptions[0] = stringArray;
            this.cInstructions = "Manipulates frames. Note that you can also browse frames using the 'n' (next) and 'p' (previous) keys when the visualization window is active.\nOptions:\n    previous - Switch to the previous frame.\n    next - Switch to the next frame.\n    first - Switch to the first frame.\n    last - Switch to the last frame.\n    switch (index) - Switch to the specified frame.\n    new - Create a new frame after the current one.\n    remove [(i1) [(i2)]] - For no arguments, deletes the current frame. For one argument, deletes the specified frame. For two arguments, deletes all frames in the range i1, i1+1, ... , i2.\n    move (index) - Moves the current frame to the given index position.\n    rename (name) - Renames the frame. By default, the frames are named according to filenames.";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void execute(String[] stringArray) throws Exception {
            if (stringArray.length == 1) {
                if (stringArray[0].equalsIgnoreCase(ASH.C_PREV)) {
                    ASH.this.changeFrame(ASH.this.currentFrame - 1);
                    ASH.this.printMessage("frame " + (ASH.this.currentFrame + 1));
                    this.master.painter.aimAtCenter();
                    this.master.painter.updateGeo();
                    return;
                } else if (stringArray[0].equalsIgnoreCase(ASH.C_NEXT)) {
                    ASH.this.changeFrame(ASH.this.currentFrame + 1);
                    ASH.this.printMessage("frame " + (ASH.this.currentFrame + 1));
                    this.master.painter.aimAtCenter();
                    this.master.painter.updateGeo();
                    return;
                } else if (stringArray[0].equalsIgnoreCase(ASH.C_FIRST)) {
                    ASH.this.changeFrame(0);
                    ASH.this.printMessage("frame " + (ASH.this.currentFrame + 1));
                    this.master.painter.aimAtCenter();
                    this.master.painter.updateGeo();
                    return;
                } else if (stringArray[0].equalsIgnoreCase(ASH.C_LAST)) {
                    ASH.this.changeFrame(ASH.this.frames.size() - 1);
                    ASH.this.printMessage("frame " + (ASH.this.currentFrame + 1));
                    this.master.painter.aimAtCenter();
                    this.master.painter.updateGeo();
                    return;
                } else if (stringArray[0].equalsIgnoreCase(ASH.C_NEW)) {
                    Particle[] particleArray = new Atom[]{};
                    ASH.this.frames.add(ASH.this.currentFrame + 1, new Structure(particleArray));
                    ASH.this.changeFrame(ASH.this.currentFrame + 1);
                    ASH.this.printMessage("frame " + (ASH.this.currentFrame + 1));
                    this.master.painter.aimAtCenter();
                    this.master.painter.updateGeo();
                    return;
                } else {
                    if (!stringArray[0].equalsIgnoreCase(ASH.C_RM)) throw new Exception();
                    ASH.this.printMessage("deleting frame " + (ASH.this.currentFrame + 1));
                    ASH.this.deleteFrame(ASH.this.currentFrame);
                    this.master.painter.updateGeo();
                }
                return;
            } else if (stringArray.length == 2) {
                if (stringArray[0].equalsIgnoreCase("switch")) {
                    int n = ASH.this.parseI(stringArray[1]) - 1;
                    ASH.this.changeFrame(n);
                    ASH.this.printMessage("frame " + (ASH.this.currentFrame + 1));
                    this.master.painter.aimAtCenter();
                    this.master.painter.updateGeo();
                    return;
                } else if (stringArray[0].equalsIgnoreCase(ASH.C_MOVE)) {
                    int n = ASH.this.parseI(stringArray[1]) - 1;
                    ASH.this.frames.add(n, ASH.this.frames.remove(ASH.this.currentFrame));
                    ASH.this.changeFrame(n);
                    ASH.this.printMessage("frame " + (ASH.this.currentFrame + 1));
                    this.master.painter.aimAtCenter();
                    this.master.painter.updateGeo();
                    return;
                } else if (stringArray[0].equalsIgnoreCase(ASH.C_RM)) {
                    int n = ASH.this.parseI(stringArray[1]) - 1;
                    if (n >= 0 && n < ASH.this.frames.size()) {
                        ASH.this.printMessage("deleting frame " + (n + 1));
                        ASH.this.deleteFrame(n);
                    }
                    this.master.painter.updateGeo();
                    return;
                } else {
                    if (!stringArray[0].equalsIgnoreCase(ASH.C_RENAME)) throw new Exception();
                    Structure structure = (Structure)ASH.this.frames.get(ASH.this.currentFrame);
                    structure.setName(stringArray[1]);
                    this.master.painter.updateGeo();
                }
                return;
            } else {
                if (stringArray.length != 3) throw new Exception();
                if (!stringArray[0].equalsIgnoreCase(ASH.C_RM)) throw new Exception();
                int n = ASH.this.parseI(stringArray[1]) - 1;
                int n2 = ASH.this.parseI(stringArray[2]);
                int n3 = ASH.this.frames.size();
                for (int i = n; i < n2; ++i) {
                    if (n >= 0 && n < ASH.this.frames.size() && i < n3) {
                        ASH.this.printMessage("deleting frame " + (i + 1));
                        ASH.this.deleteFrame(n);
                        if (ASH.this.currentFrame <= n) continue;
                        ASH.this.currentFrame--;
                        continue;
                    }
                    ++n;
                }
                this.master.painter.updateGeo();
            }
        }
    }

    private class Reindex
    extends Command {
        protected Reindex(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_REIND;
            this.minValues = 0;
            this.maxValues = 0;
            this.cArgs = "(index)";
            this.cInstructions = "Reorders the indices of particles according to another master structure, whose index must be given. The routine searches for similar particles close to each other in the two structures. If it finds that a particle from one structure is at a distance less than a certain match radius to a similar particle in the other structure, but they have different indices, the particle in the currently active frame will be allocated the index of the particle in the master frame. This is repeated with an expanding matching radius for the remaining particles until all have received a new index.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            int n;
            if (stringArray.length == 1) {
                n = ASH.this.parseI(stringArray[0]) - 1;
                if (ASH.this.frames.size() <= n) {
                    throw new Exception();
                }
            } else {
                throw new Exception();
            }
            ASH.this.rememberStructure();
            ASH.this.reIndex(n);
        }
    }

    private class Interpolate
    extends Command {
        protected Interpolate(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_INTERP;
            this.minValues = 0;
            this.maxValues = 0;
            this.cArgs = " [ [ (initial) ]  (final) ]  (frames)";
            this.cInstructions = "Interpolates between two structures by linearly shifting atoms and rotating clusters. The command can only be used between two similar structures, that is, for structures that have the same number of particles of each type with the same indices.\nOptions:\n    [[(initial)] (final)] (frames) - If only one argument is given, it specifies the number of interpolated frames to be created. The interpolation is done by uniform steps. For example, a command of '3' frames will generate frames where the coordinates are shifted by 0.25, 0.5 and 0.75 from the initial to the final configuration. ( v = v_0 + a*(v_1-v_0) ) By default, the frames used for interpolation are the current (initial) and the next frame (final). These can be specified by additional arguments, however.";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void execute(String[] stringArray) throws Exception {
            if (stringArray.length == 1) {
                if (ASH.this.frames.size() - 1 <= ASH.this.currentFrame) throw new Exception();
                ASH.this.interpolate(ASH.this.currentFrame, ASH.this.currentFrame + 1, ASH.this.parseI(stringArray[0]));
            } else if (stringArray.length == 2) {
                if (ASH.this.frames.size() <= ASH.this.parseI(stringArray[0]) - 1 || ASH.this.parseI(stringArray[0]) <= 0) throw new Exception();
                ASH.this.interpolate(ASH.this.currentFrame, ASH.this.parseI(stringArray[0]) - 1, ASH.this.parseI(stringArray[1]));
            } else {
                if (stringArray.length != 3) throw new Exception();
                if (ASH.this.frames.size() <= ASH.this.parseI(stringArray[0]) - 1 || ASH.this.frames.size() <= ASH.this.parseI(stringArray[1]) - 1 || ASH.this.parseI(stringArray[0]) <= 0 || ASH.this.parseI(stringArray[1]) <= 0) throw new Exception();
                ASH.this.interpolate(ASH.this.parseI(stringArray[0]) - 1, ASH.this.parseI(stringArray[1]) - 1, ASH.this.parseI(stringArray[2]));
            }
            this.master.painter.updateGeo();
        }
    }

    private class Reposition
    extends Command {
        protected Reposition(ASH aSH2) {
            super(aSH2);
            this.cName = "view";
            this.minValues = 0;
            this.maxValues = 3;
            this.cOptions = new String[1][];
            String[] stringArray = new String[]{ASH.C_RESET, ASH.C_ZOOM, ASH.C_ANGLE, ASH.C_POINT, ASH.C_PERSP, ASH.C_ISOM, ASH.C_LENS};
            this.cOptions[0] = stringArray;
            this.cInstructions = "Changes the viewpoint. Note that you can also manipulate the view by dragging with the mouse (rotate) and pressing the arrow keys (left/right: rotate, up/down: zoom) while the visualization window has focus. The parameters defining the current viewpoint are always stored in predefined variables such as viewx, viewy, viewz, viewzoom, etc. For a list, enter the command 'list value'.\nOptions:\n    reset - Resets the viewpoint to a default: The viewpoint is moved above (in the z-direction of) the center of the system with the 'up' direction of the view set in the y-direction. The distance from the center of the system is determined according to the total number of particles.\n    zoom (zoom) - Sets the zoom level to the given value. A larger value means a closer zoom.\n    angle (phi) (theta) [(distance)] - Defines a new viewpoint in spherical coordinates. Phi is the angle in the xy-plane with respect to the x-axis. Theta is the angle with respect to the z-axis.\n    point (x) (y) (z) - Defines a new viewpoint in Cartesian coordinates.\n    perspective - A perspetive projection is applied.\n    isometric - An isometric projection is applied.\n    lenticular - A lenticular projection is applied.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            ViewPoint viewPoint = this.master.painter.getViewPoint();
            int n = 1;
            if (runningScript) {
                runningScript = false;
                ((Structure)ASH.this.frames.get(ASH.this.currentFrame)).calculateCenter();
                runningScript = true;
            }
            if (stringArray[0].equalsIgnoreCase(ASH.C_RESET)) {
                this.master.painter.resetViewPoint();
                if (stringArray.length != n) {
                    throw new Exception();
                }
            } else if (stringArray[0].equalsIgnoreCase(ASH.C_PERSP)) {
                ASH.this.changeProjectionType(0);
                if (stringArray.length != n) {
                    throw new Exception();
                }
            } else if (stringArray[0].equalsIgnoreCase(ASH.C_ISOM)) {
                ASH.this.changeProjectionType(1);
                if (stringArray.length != n) {
                    throw new Exception();
                }
            } else if (stringArray[0].equalsIgnoreCase(ASH.C_LENS)) {
                ASH.this.changeProjectionType(2);
                if (stringArray.length != n) {
                    throw new Exception();
                }
            } else if (stringArray[0].equalsIgnoreCase(ASH.C_ZOOM)) {
                Vector vector = viewPoint.getDirection();
                double d = ASH.this.parseR(stringArray[1]);
                ++n;
                if (d <= 0.0) {
                    throw new Exception();
                }
                if (stringArray.length != n) {
                    throw new Exception();
                }
                vector = vector.unit().times(d);
                viewPoint.setDirection(vector);
                this.master.painter.updateGeo(viewPoint);
            } else if (stringArray[0].equalsIgnoreCase(ASH.C_ANGLE)) {
                double d = ASH.this.parseR(stringArray[1]);
                double d2 = ASH.this.parseR(stringArray[2]);
                Vector vector = ((Structure)ASH.this.frames.get(ASH.this.currentFrame)).getCenter();
                double d3 = 100.0;
                if (stringArray.length == (n += 2)) {
                    d3 = vector.minus(viewPoint.getPosition()).norm();
                } else {
                    d3 = ASH.this.parseR(stringArray[n]);
                    ++n;
                }
                if (stringArray.length != n) {
                    throw new Exception();
                }
                Vector vector2 = new Vector(d3 * Math.cos(d) * Math.sin(d2), d3 * Math.sin(d) * Math.sin(d2), d3 * Math.cos(d2));
                vector2 = vector2.plus(vector);
                viewPoint.setPosition(vector2);
                viewPoint.aimAtCenter((Structure)ASH.this.frames.get(ASH.this.currentFrame));
                viewPoint.setUp(new Vector(-Math.cos(d) * Math.cos(d2), -Math.sin(d) * Math.cos(d2), Math.sin(d2)));
                this.master.painter.updateGeo(viewPoint);
            } else if (stringArray[0].equalsIgnoreCase(ASH.C_POINT)) {
                Vector vector = new Vector(3);
                if (stringArray.length != (n += ASH.this.findVector(stringArray, n, vector))) {
                    throw new Exception();
                }
                viewPoint.setPosition(vector);
                viewPoint.setUp(new Vector(0.0, 0.0, 1.0));
                viewPoint.aimAtCenter((Structure)ASH.this.frames.get(ASH.this.currentFrame));
                this.master.painter.updateGeo(viewPoint);
            } else {
                throw new Exception();
            }
        }
    }

    private class Hide
    extends Command {
        protected Hide(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_HIDE;
            this.minValues = 0;
            this.maxValues = 0;
            this.cOptions = new String[1][];
            String[] stringArray = new String[]{ASH.C_NOOPTION, ASH.C_AXIS, "cell", "frame", ASH.C_DIR};
            this.cOptions[0] = stringArray;
            this.cInstructions = "Hides excess information. By default, the currently active particles will be hidden.\nOptions:\n    axis - The basis vectors of the Cartesian coordinate system are not drawn in the visualization window.\n    cell - The basis vectors of the supercell are not drawn in the visualization window.\n    frame - The number of current frame and total number of frames is not displayed in the visualization window.\n    directory - The current working directory is not displayed in the prompt.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            if (stringArray.length == 0) {
                ASH.this.hidePicked(true);
            } else if (stringArray.length == 1) {
                if (stringArray[0].equalsIgnoreCase(ASH.C_AXIS)) {
                    this.master.painter.setShowAxis(false);
                } else if (stringArray[0].equalsIgnoreCase("cell")) {
                    this.master.painter.setShowCell(false);
                } else if (stringArray[0].equalsIgnoreCase("frame")) {
                    this.master.painter.setShowFrame(false);
                } else if (stringArray[0].equalsIgnoreCase(ASH.C_DIR)) {
                    ASH.this.showDir = false;
                } else {
                    throw new Exception();
                }
                this.master.painter.updateGeo();
            } else {
                throw new Exception();
            }
        }
    }

    private class Show
    extends Command {
        protected Show(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_SHOW;
            this.minValues = 0;
            this.maxValues = 0;
            this.cOptions = new String[1][];
            String[] stringArray = new String[]{ASH.C_NOOPTION, ASH.C_AXIS, "cell", "frame", ASH.C_DIR};
            this.cOptions[0] = stringArray;
            this.cInstructions = "Displays additional information. By default, the currently active particles are made visible (if some were hidden).\nOptions:\n    axis - The basis vectors of the Cartesian coordinate system are drawn in the visualization window as red (x), green (y) and blue (z) lines, meeting in the origin.\n    cell - The basis vectors of the supercell are drawn in the visualization window as red (x), green (y) and blue (z) lines, meeting in the origin of the Cartesian coordinate system.\n    frame - The number of current frame and total number of frames is displayed in the visualization window.\n    directory - The current working directory is displayed in the prompt.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            if (stringArray.length == 0) {
                ASH.this.hidePicked(false);
            } else if (stringArray.length == 1) {
                if (stringArray[0].equalsIgnoreCase(ASH.C_AXIS)) {
                    this.master.painter.setShowAxis(true);
                } else if (stringArray[0].equalsIgnoreCase("cell")) {
                    this.master.painter.setShowCell(true);
                } else if (stringArray[0].equalsIgnoreCase("frame")) {
                    this.master.painter.setShowFrame(true);
                } else if (stringArray[0].equalsIgnoreCase(ASH.C_DIR)) {
                    ASH.this.showDir = true;
                } else {
                    throw new Exception();
                }
                this.master.painter.updateGeo();
            } else {
                throw new Exception();
            }
        }
    }

    private class Invert
    extends Command {
        protected Invert(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_INV;
            this.minValues = 1;
            this.maxValues = 6;
            this.cOptions = new String[1][];
            String[] stringArray = new String[]{"x", "y", "z", ASH.C_PLANE};
            this.cOptions[0] = stringArray;
            this.cInstructions = "Mirrors structures with respect to a given plane. Possible periodic boundaries are applied automatically. The internal structures of clusters are also mirrored. Note that the arguments are given in Cartesian coordinates, not with respect to the supercell vectors.\nOptions:\n    x (x) - Mirrors the x-coordinates of all particles with respect to the plane passing through the point [x, 0, 0].\n    y (y) - Mirrors the y-coordinates of all particles with respect to the plane passing through the point [0, y, 0].\n    z (z) - Mirrors the z-coordinates of all particles with respect to the plane passing through the point [0, 0, z].\n    plane (vx) (vy) (vz) (px) (py) (pz) - Mirrors the coordinates of all particles with respect to the plane normal to the vector [vx, vy, vz] passing through the point [px, py, pz].";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            int n = 1;
            Vector vector = new Vector(1.0, 0.0, 0.0);
            Vector vector2 = new Vector(0.0, 0.0, 0.0);
            if (stringArray[0].equalsIgnoreCase("x")) {
                vector = new Vector(1.0, 0.0, 0.0);
                vector2 = new Vector(ASH.this.parseR(stringArray[1]), 0.0, 0.0);
                ++n;
            } else if (stringArray[0].equalsIgnoreCase("y")) {
                vector = new Vector(0.0, 1.0, 0.0);
                vector2 = new Vector(0.0, ASH.this.parseR(stringArray[1]), 0.0);
                ++n;
            } else if (stringArray[0].equalsIgnoreCase("z")) {
                vector = new Vector(0.0, 0.0, 1.0);
                vector2 = new Vector(0.0, 0.0, ASH.this.parseR(stringArray[1]));
                ++n;
            } else if (stringArray[0].equalsIgnoreCase(ASH.C_PLANE)) {
                n += ASH.this.findVector(stringArray, n, vector);
                n += ASH.this.findVector(stringArray, n, vector2);
            } else {
                throw new Exception();
            }
            if (stringArray.length != n) {
                throw new Exception();
            }
            ASH.this.rememberStructure();
            Structure structure = (Structure)ASH.this.frames.get(ASH.this.currentFrame);
            structure.invertByPlane(vector, vector2);
            structure.forcePeriodicBounds();
            structure.calculateCenter();
            this.master.painter.aimAtCenter();
            this.master.painter.updateGeo();
        }
    }

    private class Recolor
    extends Command {
        protected Recolor(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_COLOR;
            this.minValues = 0;
            this.maxValues = 0;
            this.cArgs = "[ (element) / (index) ]  (red)  (green)  (blue)  [ (alpha) ]";
            this.cOptions = new String[1][];
            String[] stringArray = new String[]{ASH.C_NOOPTION, ASH.C_ELE, ASH.C_PART, ASH.C_BG, ASH.C_PICK, ASH.C_UNPICK};
            this.cOptions[0] = stringArray;
            this.cInstructions = "Changes the color of atoms. The new color should be given in RGBA format, as 4 integers between 0 and 255. If one omits the alpha parameter, a value of 255 is given (opaque).\nOptions:\n    (red) (green) (blue) [(alpha)] - By default, the color of the currently selected atoms are set to the given value.\n    element (element) (red) (green) (blue) [(alpha)] - Changes the color of a certain element. This setting will be saved, so that any new atoms of that particular type will have this radius.\n    particle (index) (red) (green) (blue) [(alpha)] - Changes the color of a given particle.\n    bg (red) (green) (blue) [(alpha)] - Changes the color of the background.\n    pick (red) (green) (blue) [(alpha)] - Changes the color of the outline of selected particles.\n    unpick (red) (green) (blue) [(alpha)] - Changes the color of the outline of deselected particles.";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void execute(String[] stringArray) throws Exception {
            if (stringArray[0].equalsIgnoreCase(ASH.C_ELE) || stringArray[0].equalsIgnoreCase(ASH.C_PART)) {
                int n = ASH.this.parseI(stringArray[2]);
                int n2 = ASH.this.parseI(stringArray[3]);
                int n3 = ASH.this.parseI(stringArray[4]);
                int n4 = 255;
                if (stringArray.length == 6) {
                    n4 = ASH.this.parseI(stringArray[5]);
                }
                if (stringArray[0].equalsIgnoreCase(ASH.C_ELE)) {
                    int n5 = ASH.this.parseI(stringArray[1]);
                    ASH.recolorElement(n5, n, n2, n3, n4);
                    for (int i = 0; i < ASH.this.frames.size(); ++i) {
                        ((Structure)ASH.this.frames.get(i)).recolorElements(n5);
                    }
                    this.master.painter.updateGeo();
                    return;
                } else {
                    if (!stringArray[0].equalsIgnoreCase(ASH.C_PART)) throw new Exception();
                    int n6 = ASH.this.parseI(stringArray[1]);
                    ((Structure)ASH.this.frames.get(ASH.this.currentFrame)).recolorParticle(n6, n, n2, n3, n4);
                    this.master.painter.updateGeo();
                }
                return;
            } else if (stringArray[0].equalsIgnoreCase(ASH.C_BG) || stringArray[0].equalsIgnoreCase(ASH.C_PICK) || stringArray[0].equalsIgnoreCase(ASH.C_UNPICK)) {
                int n = ASH.this.parseI(stringArray[1]);
                int n7 = ASH.this.parseI(stringArray[2]);
                int n8 = ASH.this.parseI(stringArray[3]);
                int n9 = 255;
                if (stringArray.length == 5) {
                    n9 = ASH.this.parseI(stringArray[4]);
                }
                if (stringArray[0].equalsIgnoreCase(ASH.C_BG)) {
                    ASH.recolorBackground(n, n7, n8, n9);
                    this.master.painter.updateGeo();
                    return;
                } else if (stringArray[0].equalsIgnoreCase(ASH.C_PICK)) {
                    ASH.recolorPick(n, n7, n8, n9);
                    this.master.painter.updateGeo();
                    return;
                } else {
                    if (!stringArray[0].equalsIgnoreCase(ASH.C_UNPICK)) return;
                    ASH.recolorUnpick(n, n7, n8, n9);
                    this.master.painter.updateGeo();
                }
                return;
            } else {
                if (stringArray.length != 4 && stringArray.length != 3) throw new Exception();
                int n = ASH.this.parseI(stringArray[0]);
                int n10 = ASH.this.parseI(stringArray[1]);
                int n11 = ASH.this.parseI(stringArray[2]);
                int n12 = 255;
                if (stringArray.length == 4) {
                    n12 = ASH.this.parseI(stringArray[3]);
                }
                Structure structure = (Structure)ASH.this.frames.get(ASH.this.currentFrame);
                for (int i = 0; i < structure.countParticles(); ++i) {
                    if (!structure.getParticle(i).isPicked()) continue;
                    structure.recolorParticle(i, n, n10, n11, n12);
                }
                this.master.painter.updateGeo();
            }
        }
    }

    private class Resize
    extends Command {
        protected Resize(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_RAD;
            this.minValues = 0;
            this.maxValues = 2;
            this.cOptions = new String[1][];
            String[] stringArray = new String[]{ASH.C_NOOPTION, ASH.C_ELE, ASH.C_PART, ASH.C_SHRINK, ASH.C_GROW};
            this.cOptions[0] = stringArray;
            this.cInstructions = "Changes the radii of atoms used for visualization. All the atoms have a display radius as an internal property, but there is also a global scaling factor affecting the actual radii of the atoms drawn in the graphics window. By default, this scaling factor is " + View.displayRadiusMultiplier + " and it can be adjusted with the options " + ASH.C_SHRINK + " and " + ASH.C_GROW + ". The other options of the command operate on the display radii of the atoms.\n" + "Options:\n" + ASH.INSET + "(radius) - By default, the radii of the currently selected atoms are set to the given value.\n" + ASH.INSET + ASH.C_ELE + " (element) (radius) - Changes the radius of a certain element. This setting will be saved, so that any new atoms of that particular type will have this radius.\n" + ASH.INSET + ASH.C_PART + " (index) (radius) - Changes the radius of a given particle.\n" + ASH.INSET + ASH.C_SHRINK + " - Makes all atoms a bit smaller.\n" + ASH.INSET + ASH.C_GROW + " - Makes all atoms a bit bigger.";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void execute(String[] stringArray) throws Exception {
            if (stringArray.length == 3) {
                if (stringArray[0].equalsIgnoreCase(ASH.C_ELE)) {
                    int n = ASH.this.parseI(stringArray[1]);
                    double d = ASH.this.parseR(stringArray[2]);
                    for (int i = 0; i < ASH.this.frames.size(); ++i) {
                        Structure structure = (Structure)ASH.this.frames.get(i);
                        Atom[] atomArray = structure.getAllAtoms();
                        for (int j = 0; j < atomArray.length; ++j) {
                            if (atomArray[j].getElement() != n) continue;
                            atomArray[j].setRadius(d);
                        }
                    }
                    ASH.resizeElement(n, d);
                    this.master.painter.updateGeo();
                    return;
                } else {
                    if (!stringArray[0].equalsIgnoreCase(ASH.C_PART)) throw new Exception();
                    int n = ASH.this.parseI(stringArray[1]);
                    double d = ASH.this.parseR(stringArray[2]);
                    Atom[] atomArray = ((Structure)ASH.this.frames.get(ASH.this.currentFrame)).getParticle(n).getAtoms();
                    for (int i = 0; i < atomArray.length; ++i) {
                        atomArray[i].setRadius(d);
                    }
                    this.master.painter.updateGeo();
                }
                return;
            } else {
                if (stringArray.length != 1) throw new Exception();
                if (stringArray[0].equalsIgnoreCase(ASH.C_SHRINK)) {
                    View.displayRadiusMultiplier *= 0.8;
                } else if (stringArray[0].equalsIgnoreCase(ASH.C_GROW)) {
                    View.displayRadiusMultiplier *= 1.25;
                } else {
                    double d = ASH.this.parseR(stringArray[0]);
                    Structure structure = (Structure)ASH.this.frames.get(ASH.this.currentFrame);
                    for (int i = 0; i < structure.countParticles(); ++i) {
                        if (!structure.getParticle(i).isPicked()) continue;
                        Atom[] atomArray = structure.getParticle(i).getAtoms();
                        for (int j = 0; j < atomArray.length; ++j) {
                            atomArray[j].setRadius(d);
                        }
                    }
                }
                this.master.painter.updateGeo();
            }
        }
    }

    private class Expand
    extends Command {
        protected Expand(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_EXP;
            this.minValues = 0;
            this.maxValues = 0;
            this.cOptions = new String[1][];
            String[] stringArray = new String[]{ASH.C_NOOPTION, "x", "y", "z"};
            this.cOptions[0] = stringArray;
            this.cArgs = "(multiplier)";
            this.cInstructions = "Multiplies the structure in the given direction by the given number of times. This means that the particles are duplicated and shifted as defined by the supercell vectors. Finally, the supercell vectors are also stretched. Boundary conditions remain as they were; they can be changed using the command 'cell'.\nOptions:\n    (multiplier) - Expands the structure in all directions according to the multiplier. If the multiplier is a vector, the integer parts of the components are used as expansion factors for the corresponding directions.\n    x (multiplier) - Expands the structure in the direction of the first supercell vector.\n    y (multiplier) - Expands the structure in the direction of the second supercell vector.\n    z (multiplier) - Expands the structure in the direction of the third supercell vector.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            int n;
            int n2;
            int n3;
            boolean bl = true;
            Structure structure = (Structure)ASH.this.frames.get(ASH.this.currentFrame);
            Vector[] vectorArray = structure.getCellCopy();
            Vector[] vectorArray2 = structure.getCellCopy();
            int[] nArray = new int[3];
            int n4 = 1;
            if (stringArray[0].equalsIgnoreCase("x")) {
                int n5;
                nArray[0] = n5 = ASH.this.parseI(stringArray[1]);
                nArray[1] = 1;
                nArray[2] = 1;
                ++n4;
                if (n5 <= 0) {
                    throw new Exception();
                }
            } else if (stringArray[0].equalsIgnoreCase("y")) {
                int n6 = ASH.this.parseI(stringArray[1]);
                nArray[0] = 1;
                nArray[1] = n6;
                nArray[2] = 1;
                ++n4;
                if (n6 <= 0) {
                    throw new Exception();
                }
            } else if (stringArray[0].equalsIgnoreCase("z")) {
                int n7 = ASH.this.parseI(stringArray[1]);
                nArray[0] = 1;
                nArray[1] = 1;
                nArray[2] = n7;
                ++n4;
                if (n7 <= 0) {
                    throw new Exception();
                }
            } else {
                n4 = 0;
                try {
                    Vector vector = new Vector(3);
                    n3 = ASH.this.findVector(stringArray, n4, vector);
                    n4 += n3;
                    for (n2 = 0; n2 < 3; ++n2) {
                        nArray[n2] = (int)vector.element(n2);
                        if (nArray[n2] > 0) continue;
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    n3 = ASH.this.parseI(stringArray[n4]);
                    ++n4;
                    for (n2 = 0; n2 < 3; ++n2) {
                        nArray[n2] = n3;
                        if (nArray[n2] > 0) continue;
                        throw new Exception();
                    }
                }
            }
            if (stringArray.length != n4) {
                throw new Exception();
            }
            ASH.this.rememberStructure();
            for (n = 0; n < 3; ++n) {
                vectorArray[n] = vectorArray[n].times(nArray[n]);
            }
            structure.setCell(vectorArray, structure.getBoundaryConditions());
            n = structure.countParticles();
            for (n3 = 0; n3 < n; ++n3) {
                for (n2 = 0; n2 < nArray[0]; ++n2) {
                    for (int i = 0; i < nArray[1]; ++i) {
                        for (int j = 0; j < nArray[2]; ++j) {
                            if (n2 <= 0 && i <= 0 && j <= 0) continue;
                            Particle particle = structure.getParticle(n3).copy();
                            particle.shiftCoordinates(vectorArray2[0].times(n2));
                            particle.shiftCoordinates(vectorArray2[1].times(i));
                            particle.shiftCoordinates(vectorArray2[2].times(j));
                            structure.addParticle(particle);
                        }
                    }
                }
            }
            structure.forcePeriodicBounds();
            structure.calculateCenter();
            this.master.painter.aimAtCenter();
            this.master.painter.updateGeo();
        }
    }

    private class SetCell
    extends Command {
        protected SetCell(ASH aSH2) {
            super(aSH2);
            this.cName = "cell";
            this.minValues = 1;
            this.maxValues = 4;
            this.cOptions = new String[1][];
            String[] stringArray = new String[]{ASH.C_NOOPTION, "x", "y", "z"};
            this.cOptions[0] = stringArray;
            this.cInstructions = "Sets supercell axis vectors. Note that the supercell vectors cannot be linearly dependent. If you try to define a vector such that the supercell becomes degenerate, the program will ignore the command.\nOptions:\n    (cell matrix) - By default, the command expects the full supercell in matrix format where the row vectors define the supercell vectors.\n    x (cx) [(cy) (cz)] [(pbc)] - Reset the first cell vector. If only one scalar argument, (cx), is given, the vector is set to [cx, 0, 0]. Otherwise all three components of the vector are expected as arguments. In addition, one can specify if this direction is periodic. (For periodic bounds, give 't', 'true', 'pbc', or '1'; for free bounds, give 'f', 'false', 'free', or '0'.)\n    y [(cx)] (cy) [(cz)] [(pbc)] - Reset the second cell vector. If only one scalar argument, (cy), is given, the vector is set to [0, cy, 0]. Otherwise all three components of the vector are expected as arguments. In addition, one can specify if this direction is periodic. (For periodic bounds, give 't', 'true', 'pbc', or '1'; for free bounds, give 'f', 'false', 'free', or '0'.)\n    z [(cx) (cy)] (cz) [(pbc)] - Reset the first cell vector. If only one scalar argument, (cz), is given, the vector is set to [0, 0, cz]. Otherwise all three components of the vector are expected as arguments. In addition, one can specify if this direction is periodic. (For periodic bounds, give 't', 'true', 'pbc', or '1'; for free bounds, give 'f', 'false', 'free', or '0'.)\n";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            int n;
            int n2;
            boolean[] blArray;
            Vector[] vectorArray;
            Structure structure;
            block23: {
                block20: {
                    int n3;
                    block21: {
                        block25: {
                            block24: {
                                block22: {
                                    int n4 = -1;
                                    if (stringArray[0].equalsIgnoreCase("x")) {
                                        n4 = 0;
                                    } else if (stringArray[0].equalsIgnoreCase("y")) {
                                        n4 = 1;
                                    } else if (stringArray[0].equalsIgnoreCase("z")) {
                                        n4 = 2;
                                    }
                                    structure = (Structure)ASH.this.frames.get(ASH.this.currentFrame);
                                    vectorArray = structure.getCellCopy();
                                    blArray = structure.getBoundaryConditions();
                                    if (n4 < 0) break block20;
                                    n3 = 1;
                                    Vector vector = new Vector(3);
                                    try {
                                        n2 = ASH.this.findVector(stringArray, n3, vector);
                                        n3 += n2;
                                    }
                                    catch (Exception exception) {
                                        vector.setElement(n4, ASH.this.parseR(stringArray[n3]));
                                        ++n3;
                                    }
                                    vectorArray[n4] = vector;
                                    if (stringArray.length != n3 + 1) break block21;
                                    n2 = -1;
                                    try {
                                        n2 = ASH.this.parseI(stringArray[4]);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    if (!stringArray[n3].equalsIgnoreCase("t") && !stringArray[n3].equalsIgnoreCase("true") && !stringArray[n3].equalsIgnoreCase("pbc")) break block22;
                                    blArray[n4] = true;
                                    break block23;
                                }
                                if (!stringArray[n3].equalsIgnoreCase("f") && !stringArray[n3].equalsIgnoreCase("false") && !stringArray[n3].equalsIgnoreCase("free")) break block24;
                                blArray[n4] = false;
                                break block23;
                            }
                            if (n2 != 1) break block25;
                            blArray[n4] = true;
                            break block23;
                        }
                        if (n2 != 0) break block23;
                        blArray[n4] = false;
                        break block23;
                    }
                    if (stringArray.length > n3 + 1) {
                        throw new Exception();
                    }
                    break block23;
                }
                double[][] dArray = ASH.this.parseMatrix(stringArray[0]);
                if (dArray.length == 3 && dArray[0].length == 3) {
                    for (int i = 0; i < 3; ++i) {
                        vectorArray[i] = new Vector(3);
                        for (n2 = 0; n2 < 3; ++n2) {
                            vectorArray[i].setElement(n2, dArray[i][n2]);
                        }
                    }
                }
            }
            ASH.this.rememberStructure();
            boolean bl = false;
            for (n = 0; n < 3; ++n) {
                for (n2 = 0; n2 < 3; ++n2) {
                    Double d = new Double(vectorArray[n].element(n2));
                    if (!d.isNaN() && !d.isInfinite()) continue;
                    bl = true;
                }
            }
            if (bl) {
                ASH.this.printMessage("NaN component in a cell vector, keeping old supercell", true);
            } else {
                n = structure.setCell(vectorArray, blArray) ? 1 : 0;
                structure.forcePeriodicBounds();
                structure.calculateCenter();
                this.master.painter.aimAtCenter();
                this.master.painter.updateGeo();
                if (n != 0) {
                    ASH.this.printMessage("new supercell: ");
                    for (n2 = 0; n2 < 3; ++n2) {
                        ASH.this.printMessage("cell vector " + (n2 + 1) + "   (" + FileHandler.formattedDouble(vectorArray[n2].element(0), 12, 5) + ", " + FileHandler.formattedDouble(vectorArray[n2].element(1), 12, 5) + ", " + FileHandler.formattedDouble(vectorArray[n2].element(2), 12, 5) + ")");
                    }
                } else {
                    ASH.this.printMessage("linearly dependent cell vectors, keeping old supercell", true);
                }
            }
        }
    }

    private class Paste
    extends Command {
        protected Paste(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_PASTE;
            this.minValues = 0;
            this.maxValues = 0;
            this.cOptions = new String[2][];
            String[] stringArray = new String[]{ASH.C_NOOPTION, ASH.C_JOIN, ASH.C_OVER};
            this.cOptions[0] = stringArray;
            String[] stringArray2 = new String[]{ASH.C_NOOPTION, "cell"};
            this.cOptions[1] = stringArray2;
            this.cArgs = "[ (slot) ]";
            this.cInstructions = "Pastes structures from the clipboard. By default, supercell information is not pasted.\nOptions:\n    union - The current structure is appended with the data on the clipboard. (default)\n    replace - The current structure is discarded and replaced by the data on the clipboard.\n        cell - The current supercell data is replaced by the data on the clipboard.\n             [(slot)] - There are 10 slots for copies. By default, slot 0 is used, but this can be specified by giving an index.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            Structure structure = (Structure)ASH.this.frames.get(ASH.this.currentFrame);
            int n = 0;
            boolean bl = false;
            boolean bl2 = false;
            if (stringArray.length > 0 && stringArray[0 + n].equalsIgnoreCase(ASH.C_OVER)) {
                ++n;
                bl = true;
            } else if (stringArray.length > 0 && stringArray[0 + n].equalsIgnoreCase(ASH.C_JOIN)) {
                ++n;
            }
            if (stringArray.length > 0 + n && stringArray[0 + n].equalsIgnoreCase("cell")) {
                bl2 = true;
                ++n;
            }
            ASH.this.rememberStructure();
            int n2 = 0;
            if (stringArray.length > 0 + n) {
                try {
                    n2 = ASH.this.parseI(stringArray[n]);
                    ++n;
                    if (n2 < 0 || n2 >= 10) {
                        n2 = 0;
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    ASH.this.printMessage("Invalid slot index (must be an integer between 0 and 9), using default slot 0.");
                }
            }
            int n3 = structure.copyPart(ASH.this.clipboardAtoms[n2], bl, bl2);
            ASH.this.printMessage("pasted " + n3 + " particles");
            structure.forcePeriodicBounds();
            structure.calculateCenter();
            this.master.painter.aimAtCenter();
            this.master.painter.updateGeo();
        }
    }

    private class Cut
    extends Command {
        protected Cut(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_CUT;
            this.minValues = 0;
            this.maxValues = 0;
            this.cOptions = new String[2][];
            String[] stringArray = new String[]{ASH.C_NOOPTION, ASH.C_JOIN, ASH.C_OVER};
            this.cOptions[0] = stringArray;
            String[] stringArray2 = new String[]{ASH.C_NOOPTION, "cell"};
            this.cOptions[1] = stringArray2;
            this.cArgs = "[ (slot) ]";
            this.cInstructions = "Copies structures on the clipboard and then deletes them. Only currently selected particles are copied. By default, supercell information is not copied.\nOptions:\n    union - The structure already on the clipboard is appended.\n    replace - The structure already on the clipboard is discarded and replaced. (default)\n        cell - The supercell is also copied on the clipboard.\n             [(slot)] - There are 10 slots for copies. By default, slot 0 is used, but this can be specified by giving an index.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            Structure structure = (Structure)ASH.this.frames.get(ASH.this.currentFrame);
            int n = 0;
            boolean bl = false;
            boolean bl2 = false;
            if (stringArray.length > 0 && stringArray[0 + n].equalsIgnoreCase(ASH.C_JOIN)) {
                ++n;
            } else {
                if (stringArray.length > 0 && stringArray[0 + n].equalsIgnoreCase(ASH.C_OVER)) {
                    ++n;
                }
                bl = true;
            }
            if (stringArray.length > 0 + n && stringArray[0 + n].equalsIgnoreCase("cell")) {
                bl2 = true;
                ++n;
            }
            int n2 = 0;
            if (stringArray.length > 0 + n) {
                try {
                    n2 = ASH.this.parseI(stringArray[n]);
                    ++n;
                    if (n2 < 0 || n2 >= 10) {
                        n2 = 0;
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    ASH.this.printMessage("Invalid slot index (must be an integer between 0 and 9), using default slot 0.");
                }
            }
            int n3 = ASH.this.clipboardAtoms[n2].copyPart(structure, bl, bl2);
            ASH.this.printMessage("copied " + n3 + " particles");
            ASH.this.rememberStructure();
            ASH.this.removePicked();
        }
    }

    private class Copy
    extends Command {
        protected Copy(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_COPY;
            this.minValues = 0;
            this.maxValues = 0;
            this.cOptions = new String[2][];
            String[] stringArray = new String[]{ASH.C_NOOPTION, ASH.C_JOIN, ASH.C_OVER};
            this.cOptions[0] = stringArray;
            String[] stringArray2 = new String[]{ASH.C_NOOPTION, "cell"};
            this.cOptions[1] = stringArray2;
            this.cArgs = "[ (slot) ]";
            this.cInstructions = "Copies structures on the clipboard. Only currently selected particles are copied. By default, supercell information is not copied.\nOptions:\n    union - The structure already on the clipboard is appended.\n    replace - The structure already on the clipboard is discarded and replaced. (default)\n        cell - The supercell is also copied on the clipboard.\n             [(slot)] - There are 10 slots for copies. By default, slot 0 is used, but this can be specified by giving an index.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            Structure structure = (Structure)ASH.this.frames.get(ASH.this.currentFrame);
            int n = 0;
            boolean bl = false;
            boolean bl2 = false;
            if (stringArray.length > 0 && stringArray[0 + n].equalsIgnoreCase(ASH.C_JOIN)) {
                ++n;
            } else {
                if (stringArray.length > 0 && stringArray[0 + n].equalsIgnoreCase(ASH.C_OVER)) {
                    ++n;
                }
                bl = true;
            }
            if (stringArray.length > 0 + n && stringArray[0 + n].equalsIgnoreCase("cell")) {
                bl2 = true;
                ++n;
            }
            int n2 = 0;
            if (stringArray.length > 0 + n) {
                try {
                    n2 = ASH.this.parseI(stringArray[n]);
                    ++n;
                    if (n2 < 0 || n2 >= 10) {
                        n2 = 0;
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    ASH.this.printMessage("Invalid slot index (must be an integer between 0 and 9), using default slot 0.");
                }
            }
            int n3 = ASH.this.clipboardAtoms[n2].copyPart(structure, bl, bl2);
            ASH.this.printMessage("copied " + n3 + " particles");
        }
    }

    private class Add
    extends Command {
        protected Add(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_ADD;
            this.minValues = 0;
            this.maxValues = 0;
            this.cInstructions = "Creates an atom in the system at the given position. Also the element of the atom can be specified by an index or a chemical symbol. To introduce new types of atoms (say, 'oxygen+'), give the name of the new species as the element and a new index starting from 120 is automatically given. By default, the atom will be of element 'Atom0'.";
            this.cArgs = "(x)  (y)  (z)  [ (element) ]";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            Element element;
            Vector vector = new Vector(3);
            int n = ASH.this.findVector(stringArray, 0, vector);
            Atom atom = new Atom(vector);
            if (stringArray.length == n + 1) {
                element = ASH.this.parseElement(stringArray[n]);
            } else if (stringArray.length == n) {
                element = elementTable.getElement("Atom0");
            } else {
                throw new Exception();
            }
            atom.setElement(element);
            ASH.this.rememberStructure();
            ASH.this.addParticle(atom);
            ((Structure)ASH.this.frames.get(ASH.this.currentFrame)).calculateCenter();
            this.master.painter.aimAtCenter();
            this.master.painter.updateGeo();
        }
    }

    private class Delete
    extends Command {
        protected Delete(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_DEL;
            this.minValues = 0;
            this.maxValues = 2;
            this.cOptions = new String[1][];
            String[] stringArray = new String[]{ASH.C_NOOPTION, ASH.C_DUPLO};
            this.cOptions[0] = stringArray;
            this.cInstructions = "Deletes particles.\nOptions:\n    [(i1) [(i2)]] - By default, the selected particles are annihilated. If one integer argument is given, the particle with corresponding index is deleted. If two arguments are given, (i1) (i2), the particles within the range i1, i1+1, ..., i2 are deleted.\n    duplicates [(range)] - Duplicate particles are deleted. That is, if there are two similar particles at a distance of less than a certain range, the latter (one with greater index) is destroyed. By default the range is 0.1, but the user can specify any range.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            if (stringArray.length == 0) {
                ASH.this.rememberStructure();
                ASH.this.removePicked();
            } else if (stringArray.length == 1) {
                if (stringArray[0].equalsIgnoreCase(ASH.C_DUPLO)) {
                    ASH.this.rememberStructure();
                    ((Structure)ASH.this.frames.get(ASH.this.currentFrame)).removeDuplicates(0.1);
                } else {
                    ASH.this.rememberStructure();
                    ASH.this.removeParticle(ASH.this.parseI(stringArray[0]));
                }
            } else if (stringArray.length == 2) {
                if (stringArray[0].equalsIgnoreCase(ASH.C_DUPLO)) {
                    ASH.this.rememberStructure();
                    ((Structure)ASH.this.frames.get(ASH.this.currentFrame)).removeDuplicates(ASH.this.parseR(stringArray[1]));
                } else {
                    int n = ASH.this.parseI(stringArray[0]);
                    int n2 = ASH.this.parseI(stringArray[1]);
                    for (int i = n; i < n2 + 1; ++i) {
                        ASH.this.rememberStructure();
                        ASH.this.removeParticle(n);
                    }
                }
            } else {
                throw new Exception();
            }
            try {
                ((Structure)ASH.this.frames.get(ASH.this.currentFrame)).calculateCenter();
                this.master.painter.aimAtCenter();
                this.master.painter.updateGeo();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class Constrain
    extends Command {
        protected Constrain(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_FREEZE;
            this.cArgs = "[ (fx) (fy) (fz) ]";
            this.cInstructions = "Manipulates atomic constraints. Often, one may wish to freeze certain atoms in a simulation. This command allows you to handle the flags for atomic constraints in three directions. These flags are meant to be printed and used by an external simulation software - they have no effect on how the atoms are handled in ASH.\n    - By default, the command sets the constraint flags of all selected particles to false.\n     (fx) (fy) (fz) - Sets the constraint flags of all selected particles to the given values. The values may be given using keywords 'f', 't', 'false', or 'true', or as variables for which the values 1 and 0 are interpreted as true and false, respectively. Other values are interpreted to mean that the corresponding flag should not be touched.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            int n;
            Atom[] atomArray;
            int[] nArray = new int[]{-1, -1, -1};
            int n2 = 0;
            if (stringArray.length > 0) {
                try {
                    atomArray = new Vector(3);
                    n2 = ASH.this.findVector(stringArray, 0, (Vector)atomArray);
                    for (n = 0; n < 3; ++n) {
                        if ((int)atomArray.element(n) == 0) {
                            nArray[n] = 0;
                            continue;
                        }
                        if ((int)atomArray.element(n) != 1) continue;
                        nArray[n] = 1;
                    }
                }
                catch (Exception exception) {
                    for (n = 0; n < 3; ++n) {
                        int n3 = -1;
                        try {
                            n3 = ASH.this.parseI(stringArray[n]);
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        if (stringArray[n].equalsIgnoreCase("t") || stringArray[n].equalsIgnoreCase("true")) {
                            nArray[n] = 1;
                            continue;
                        }
                        if (stringArray[n].equalsIgnoreCase("f") || stringArray[n].equalsIgnoreCase("false")) {
                            nArray[n] = 0;
                            continue;
                        }
                        if (n3 == 1) {
                            nArray[n] = 1;
                            continue;
                        }
                        if (n3 != 0) continue;
                        nArray[n] = 0;
                    }
                }
                if (n2 != stringArray.length) {
                    throw new Exception();
                }
            } else {
                nArray[0] = 0;
                nArray[1] = 0;
                nArray[2] = 0;
            }
            ASH.this.rememberStructure();
            atomArray = ((Structure)ASH.this.frames.get(ASH.this.currentFrame)).getAllAtoms();
            for (n = 0; n < atomArray.length; ++n) {
                if (!atomArray[n].isPicked()) continue;
                boolean[] blArray = atomArray[n].getFrozenCoordinates();
                for (int i = 0; i < 3; ++i) {
                    if (nArray[i] == 1) {
                        blArray[i] = true;
                        continue;
                    }
                    if (nArray[i] != 0) continue;
                    blArray[i] = false;
                }
                atomArray[n].setFrozenCoordinates(blArray);
            }
            ((Structure)ASH.this.frames.get(ASH.this.currentFrame)).calculateCenter();
            this.master.painter.aimAtCenter();
            this.master.painter.updateGeo();
        }
    }

    private class Shift
    extends Command {
        protected Shift(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_SHIFT;
            this.minValues = 0;
            this.maxValues = 0;
            this.cInstructions = "Shifts selected particles by a given vector. If the system is periodic, periodic boundary conditions are automatically applied on atomic particles. Periodicity is not employed on single atoms within clusters, but on the entire cluster (as determined by the center of the cluster).";
            this.cArgs = "(x)  (y)  (z)";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            Vector vector = new Vector(3);
            int n = ASH.this.findVector(stringArray, 0, vector);
            if (n != stringArray.length) {
                throw new Exception();
            }
            ASH.this.rememberStructure();
            ASH.this.shiftAtoms(vector);
            ((Structure)ASH.this.frames.get(ASH.this.currentFrame)).calculateCenter();
            this.master.painter.aimAtCenter();
            this.master.painter.updateGeo();
        }
    }

    private class Rotate
    extends Command {
        protected Rotate(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_ROT;
            this.minValues = 0;
            this.maxValues = 0;
            this.cOptions = new String[1][];
            String[] stringArray = new String[]{"x", "y", "z", ASH.C_AXIS};
            this.cOptions[0] = stringArray;
            this.cInstructions = "Rotates selected clusters around their centers. Atomic particles are not affected since they have no internal structure. If you wish to rotate the entire system, you should first join all particles in one cluster.\nOptions:\n    x (angle) - Rotation around the x-axis by the given angle.\n    y (angle) - Rotation around the y-axis by the given angle.\n    z (angle) - Rotation around the z-axis by the given angle.\n    axis (ax) (ay) (az) (angle) - Rotation around the vector [ax, ay, az] by the given angle.";
            this.cArgs = "[(ax) (ay) (az)]  (angle)";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            Vector vector = new Vector(0.0, 0.0, 1.0);
            int n = 0;
            if (stringArray[0].equalsIgnoreCase("x")) {
                vector = new Vector(1.0, 0.0, 0.0);
            } else if (stringArray[0].equalsIgnoreCase("y")) {
                vector = new Vector(0.0, 1.0, 0.0);
            } else if (stringArray[0].equalsIgnoreCase("z")) {
                vector = new Vector(0.0, 0.0, 1.0);
            } else if (stringArray[0].equalsIgnoreCase(ASH.C_AXIS)) {
                n = ASH.this.findVector(stringArray, 1, vector);
            } else {
                throw new Exception();
            }
            if (stringArray.length != 2 + n) {
                throw new Exception();
            }
            double d = ASH.this.parseR(stringArray[1 + n]);
            Quaternion quaternion = new Quaternion(vector, d);
            ASH.this.rememberStructure();
            Structure structure = (Structure)ASH.this.frames.get(ASH.this.currentFrame);
            for (int i = 0; i < structure.countParticles(); ++i) {
                if (!structure.getParticle(i).isPicked()) continue;
                structure.getParticle(i).rotate(quaternion);
            }
            ((Structure)ASH.this.frames.get(ASH.this.currentFrame)).calculateCenter();
            this.master.painter.aimAtCenter();
            this.master.painter.updateGeo();
        }
    }

    private class Unclusterize
    extends Command {
        protected Unclusterize(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_UNCLU;
            this.minValues = 0;
            this.maxValues = 0;
            this.cInstructions = "Breaks all selected clusters to their constituent particles. Only one level of clusterization is removed, so a cluster containing smaller clusters is broken into these smaller clusters instead of atomic particles.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            this.master.rememberStructure();
            int n = this.master.breakCluster();
            ASH.this.printMessage("broke clusters to " + n + " particles");
            this.master.painter.updateGeo();
        }
    }

    private class Clusterize
    extends Command {
        protected Clusterize(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_CLU;
            this.minValues = 0;
            this.maxValues = 0;
            this.cInstructions = "Joins selected particles to a cluster, which is then treated as a single particle with structure. The structure of smaller clusters are retained when joint to bigger clusters.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            this.master.rememberStructure();
            try {
                int n = this.master.makeCluster();
                ASH.this.printMessage("joint " + n + " particles to a cluster");
            }
            catch (Exception exception) {
                ASH.this.printMessage("empty selection");
            }
            this.master.painter.updateGeo();
        }
    }

    private class List
    extends Command {
        protected List(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_LIST;
            this.minValues = 0;
            this.maxValues = 1;
            this.cOptions = new String[1][];
            String[] stringArray = new String[]{ASH.C_NOOPTION, ASH.C_PARTS, ASH.C_ELE, "cell", ASH.C_VALUE, ASH.C_ALIAS, ASH.C_COMM, ASH.C_FUNC, ASH.C_NBOR};
            this.cOptions[0] = stringArray;
            this.cInstructions = "Prints data on screen.\nOptions:\n    - By default, the indices and coordinates of the currently selected particles are listed.\n    particles - The indices and coordinates of all particles of the current frame are listed.\n    element - The names and indices as well as the number of such particles in the current frame are listed.\n    cell - The components of the supercell vectors are listed (in Cartesian coordinates).\n    value - The names and stored values of the currently defined variables are listed.\n    function - The names and syntax of the currently defined functions are listed.\n    alias - The names and stored commands of the currently defined aliases are listed.\n    command - The available commands are listed.\n    neighbors [n] - Lists the n closest neighbors of all currently selected particles. By default, n = 8. Note that the lists are made for particles, not atoms, and they include all particles in the system, even unselected ones.";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void execute(String[] stringArray) throws Exception {
            if (stringArray.length == 0) {
                this.master.listPicked();
                return;
            } else if (stringArray.length == 1) {
                if (stringArray[0].equalsIgnoreCase(ASH.C_PARTS)) {
                    this.master.listAll();
                    return;
                } else if (stringArray[0].equalsIgnoreCase(ASH.C_ELE)) {
                    this.master.listElements();
                    return;
                } else if (stringArray[0].equalsIgnoreCase("cell")) {
                    this.master.listCell();
                    return;
                } else if (stringArray[0].equalsIgnoreCase(ASH.C_VALUE)) {
                    this.master.listVariables();
                    return;
                } else if (stringArray[0].equalsIgnoreCase(ASH.C_FUNC)) {
                    this.master.listFunctions();
                    return;
                } else if (stringArray[0].equalsIgnoreCase(ASH.C_ALIAS)) {
                    this.master.listAliases();
                    return;
                } else if (stringArray[0].equalsIgnoreCase(ASH.C_COMM)) {
                    this.master.listCommands();
                    return;
                } else {
                    if (!stringArray[0].equalsIgnoreCase(ASH.C_NBOR)) throw new Exception();
                    this.master.listNeighbors(8);
                }
                return;
            } else {
                if (stringArray.length != 2) throw new Exception();
                if (!stringArray[0].equalsIgnoreCase(ASH.C_NBOR)) return;
                this.master.listNeighbors(ASH.this.parseI(stringArray[1]));
            }
        }
    }

    private class Unpick
    extends Command {
        protected Unpick(ASH aSH2) {
            super(aSH2);
            this.minValues = 0;
            this.maxValues = 6;
            this.cName = ASH.C_UNPICK;
            this.cOptions = new String[2][];
            String[] stringArray = new String[]{ASH.C_NOOPTION, ASH.C_JOIN, ASH.C_OVER, ASH.C_INTERSECT};
            this.cOptions[0] = stringArray;
            String[] stringArray2 = new String[]{ASH.C_ALL, ASH.C_XM, ASH.C_XL, ASH.C_YM, ASH.C_YL, ASH.C_ZM, ASH.C_ZL, ASH.C_RANGE, ASH.C_ELE, ASH.C_PART, ASH.C_PARTS, ASH.C_SPHERE};
            this.cOptions[1] = stringArray2;
            this.cInstructions = "Deselects a group of particles to be excluded from further operations.\nOptions:\n    union - A union of the currently selected particles and those specified by the command will become active.\n    replace - The currently selected particles will become inactive, then the particles specified by the command will become active.\n    intersect - An intersection of the currently selected particles and those specified by the command will become active. (default)\n    default - Turns the default pick mode off. That is, new particles are by default deselected when introduced.\n        all - Deselect all particles.\n        xmore (x) - The particles whose x coordinate is greater than the given real are deselected.\n        xless (x) - The particles whose x coordinate is less than the given real are deselected.\n        ymore (y) - The particles whose y coordinate is greater than the given real are deselected.\n        yless (y) - The particles whose y coordinate is less than the given real are deselected.\n        zmore (z) - The particles whose z coordinate is greater than the given real are deselected.\n        zless (z) - The particles whose z coordinate is less than the given real are deselected.\n        range (vx) (vy) (vz) (ux) (uy) (uz) - The vector u defines a point in space and the vector v a normal vector for a plane. Placing this plane at the given point, the particles located on that side of the plane to where the vector points are deselected.\n        sphere (ux) (uy) (uz) (r) - The vector u defines a point in space and r a radius so that the particles within this radius are deselected. If r is a vector, the norm of the vector is used as the radius.\n        element (e1) [(e2)] - If only one integer argument is given, all atomic particles of that element type are deselected. If two integers are given, all elements in the range e1, e1+1, ..., e2 are deselected.\n        particle (p1) [(p2) [(p3) ... ]] - The particles whose indices are given are deselected.\n        particles (p1) (p2) - The particles in the index range p1, p1+1, ..., p2 are deselected.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            boolean bl = false;
            boolean bl2 = true;
            int n = 0;
            if (stringArray[0].equalsIgnoreCase(ASH.C_JOIN)) {
                n = 1;
                bl = true;
                bl2 = true;
            } else if (stringArray[0].equalsIgnoreCase(ASH.C_INTERSECT)) {
                n = 1;
                bl = false;
                bl2 = true;
            } else if (stringArray[0].equalsIgnoreCase(ASH.C_OVER)) {
                n = 1;
                bl = false;
                bl2 = false;
            } else if (stringArray[0].equalsIgnoreCase(ASH.C_DEFAULT) && stringArray.length == 1) {
                defaultPick = false;
                return;
            }
            boolean bl3 = false;
            if (!bl2) {
                ASH.this.pickAll(true, false);
            }
            if (stringArray[0 + n].equalsIgnoreCase(ASH.C_ALL)) {
                if (stringArray.length != ++n) {
                    throw new Exception();
                }
                this.master.pickAll(bl3, bl);
                this.master.painter.updateGeo();
            } else if (stringArray[0 + n].equalsIgnoreCase(ASH.C_XM) || stringArray[0 + n].equalsIgnoreCase(ASH.C_XL) || stringArray[0 + n].equalsIgnoreCase(ASH.C_YM) || stringArray[0 + n].equalsIgnoreCase(ASH.C_YL) || stringArray[0 + n].equalsIgnoreCase(ASH.C_ZM) || stringArray[0 + n].equalsIgnoreCase(ASH.C_ZL) || stringArray[0 + n].equalsIgnoreCase(ASH.C_RANGE)) {
                Vector vector = new Vector(1.0, 0.0, 0.0);
                Vector vector2 = new Vector(0.0, 0.0, 0.0);
                if (stringArray[0 + n].equalsIgnoreCase(ASH.C_XM)) {
                    vector = new Vector(1.0, 0.0, 0.0);
                    vector2 = new Vector(ASH.this.parseR(stringArray[++n]), 0.0, 0.0);
                    ++n;
                } else if (stringArray[0 + n].equalsIgnoreCase(ASH.C_XL)) {
                    vector = new Vector(-1.0, 0.0, 0.0);
                    vector2 = new Vector(ASH.this.parseR(stringArray[++n]), 0.0, 0.0);
                    ++n;
                } else if (stringArray[0 + n].equalsIgnoreCase(ASH.C_YM)) {
                    vector = new Vector(0.0, 1.0, 0.0);
                    vector2 = new Vector(0.0, ASH.this.parseR(stringArray[++n]), 0.0);
                    ++n;
                } else if (stringArray[0 + n].equalsIgnoreCase(ASH.C_YL)) {
                    vector = new Vector(0.0, -1.0, 0.0);
                    vector2 = new Vector(0.0, ASH.this.parseR(stringArray[++n]), 0.0);
                    ++n;
                } else if (stringArray[0 + n].equalsIgnoreCase(ASH.C_ZM)) {
                    vector = new Vector(0.0, 0.0, 1.0);
                    vector2 = new Vector(0.0, 0.0, ASH.this.parseR(stringArray[++n]));
                    ++n;
                } else if (stringArray[0 + n].equalsIgnoreCase(ASH.C_ZL)) {
                    vector = new Vector(0.0, 0.0, -1.0);
                    vector2 = new Vector(0.0, 0.0, ASH.this.parseR(stringArray[++n]));
                    ++n;
                } else {
                    ++n;
                    n += ASH.this.findVector(stringArray, n, vector);
                    n += ASH.this.findVector(stringArray, n, vector2);
                }
                if (stringArray.length != n) {
                    throw new Exception();
                }
                this.master.pickArea(vector2, vector, bl3, bl);
                this.master.painter.updateGeo();
            } else if (stringArray[0 + n].equalsIgnoreCase(ASH.C_ELE)) {
                for (int i = 1 + n; i < stringArray.length; ++i) {
                    this.master.pickElement(ASH.this.parseI(stringArray[i]), bl3, bl);
                }
                this.master.painter.updateGeo();
            } else if (stringArray[0 + n].equalsIgnoreCase(ASH.C_PART)) {
                for (int i = 1 + n; i < stringArray.length; ++i) {
                    this.master.pickAtom(ASH.this.parseI(stringArray[i]), bl3, bl);
                }
                this.master.painter.updateGeo();
            } else if (stringArray[0 + n].equalsIgnoreCase(ASH.C_PARTS)) {
                if (stringArray.length == 3 + n) {
                    int n2 = ASH.this.parseI(stringArray[1 + n]);
                    int n3 = ASH.this.parseI(stringArray[2 + n]);
                    for (int i = n2; i < n3; ++i) {
                        this.master.pickAtom(i, bl3, bl);
                    }
                } else {
                    throw new Exception();
                }
                this.master.painter.updateGeo();
            } else if (stringArray[0 + n].equalsIgnoreCase(ASH.C_SPHERE)) {
                ++n;
                Vector vector = new Vector(3);
                n += ASH.this.findVector(stringArray, n, vector);
                double d = 0.0;
                try {
                    Vector vector3 = new Vector(3);
                    int n4 = ASH.this.findVector(stringArray, n, vector3);
                    n += n4;
                    d = vector3.norm();
                }
                catch (Exception exception) {
                    d = ASH.this.parseR(stringArray[n]);
                    ++n;
                }
                if (stringArray.length != n) {
                    throw new Exception();
                }
                this.master.pickSphere(vector, d, bl3, bl);
                this.master.painter.updateGeo();
            } else {
                throw new Exception();
            }
        }
    }

    private class Pick
    extends Command {
        protected Pick(ASH aSH2) {
            super(aSH2);
            this.minValues = 0;
            this.maxValues = 6;
            this.cName = ASH.C_PICK;
            this.cOptions = new String[2][];
            String[] stringArray = new String[]{ASH.C_NOOPTION, ASH.C_JOIN, ASH.C_OVER, ASH.C_INTERSECT};
            this.cOptions[0] = stringArray;
            String[] stringArray2 = new String[]{ASH.C_ALL, ASH.C_XM, ASH.C_XL, ASH.C_YM, ASH.C_YL, ASH.C_ZM, ASH.C_ZL, ASH.C_RANGE, ASH.C_SPHERE, ASH.C_ELE, ASH.C_PART, ASH.C_PARTS, ASH.C_DEFAULT};
            this.cOptions[1] = stringArray2;
            this.cInstructions = "Selects a group of particles for further operations.\nOptions:\n    union - A union of the currently selected particles and those specified by the command will become active.\n    replace - The currently selected particles will become inactive, then the particles specified by the command will become active. (default)\n    intersect - An intersection of the currently selected particles and those specified by the command will become active.\n    default - Turns the default pick mode on. That is, new particles are by default selected when introduced.\n        all - Select all particles.\n        xmore (x) - The particles whose x coordinate is greater than the given real are selected.\n        xless (x) - The particles whose x coordinate is less than the given real are selected.\n        ymore (y) - The particles whose y coordinate is greater than the given real are selected.\n        yless (y) - The particles whose y coordinate is less than the given real are selected.\n        zmore (z) - The particles whose z coordinate is greater than the given real are selected.\n        zless (z) - The particles whose z coordinate is less than the given real are selected.\n        range (vx) (vy) (vz) (ux) (uy) (uz) - The vector u defines a point in space and the vector v a normal vector for a plane. Placing this plane at the given point, the particles located on that side of the plane to where the vector points are selected.\n        sphere (ux) (uy) (uz) (r) - The vector u defines a point in space and r a radius so that the particles within this radius are selected. If r is a vector, the norm of the vector is used as the radius.\n        element (e1) [(e2)] - If only one integer argument is given, all atomic particles of that element type are selected. If two integers are given, all elements in the range e1, e1+1, ..., e2 are selected.\n        particle (p1) [(p2) [(p3) ... ]] - The particles whose indices are given are selected.\n        particles (p1) (p2) - The particles in the index range p1, p1+1, ..., p2 are selected.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            if (stringArray[0].equalsIgnoreCase(ASH.C_JOIN)) {
                n = 1;
                bl = false;
                bl2 = true;
            } else if (stringArray[0].equalsIgnoreCase(ASH.C_INTERSECT)) {
                n = 1;
                bl = true;
                bl2 = true;
            } else if (stringArray[0].equalsIgnoreCase(ASH.C_OVER)) {
                n = 1;
                bl = false;
                bl2 = false;
            } else if (stringArray[0].equalsIgnoreCase(ASH.C_DEFAULT) && stringArray.length == 1) {
                defaultPick = true;
                return;
            }
            boolean bl3 = true;
            if (!bl2) {
                ASH.this.pickAll(false, false);
            }
            if (stringArray[0 + n].equalsIgnoreCase(ASH.C_ALL)) {
                if (stringArray.length != ++n) {
                    throw new Exception();
                }
                this.master.pickAll(bl3, bl);
                this.master.painter.updateGeo();
            } else if (stringArray[0 + n].equalsIgnoreCase(ASH.C_XM) || stringArray[0 + n].equalsIgnoreCase(ASH.C_XL) || stringArray[0 + n].equalsIgnoreCase(ASH.C_YM) || stringArray[0 + n].equalsIgnoreCase(ASH.C_YL) || stringArray[0 + n].equalsIgnoreCase(ASH.C_ZM) || stringArray[0 + n].equalsIgnoreCase(ASH.C_ZL) || stringArray[0 + n].equalsIgnoreCase(ASH.C_RANGE)) {
                Vector vector = new Vector(1.0, 0.0, 0.0);
                Vector vector2 = new Vector(0.0, 0.0, 0.0);
                if (stringArray[0 + n].equalsIgnoreCase(ASH.C_XM)) {
                    vector = new Vector(1.0, 0.0, 0.0);
                    vector2 = new Vector(ASH.this.parseR(stringArray[++n]), 0.0, 0.0);
                    ++n;
                } else if (stringArray[0 + n].equalsIgnoreCase(ASH.C_XL)) {
                    vector = new Vector(-1.0, 0.0, 0.0);
                    vector2 = new Vector(ASH.this.parseR(stringArray[++n]), 0.0, 0.0);
                    ++n;
                } else if (stringArray[0 + n].equalsIgnoreCase(ASH.C_YM)) {
                    vector = new Vector(0.0, 1.0, 0.0);
                    vector2 = new Vector(0.0, ASH.this.parseR(stringArray[++n]), 0.0);
                    ++n;
                } else if (stringArray[0 + n].equalsIgnoreCase(ASH.C_YL)) {
                    vector = new Vector(0.0, -1.0, 0.0);
                    vector2 = new Vector(0.0, ASH.this.parseR(stringArray[++n]), 0.0);
                    ++n;
                } else if (stringArray[0 + n].equalsIgnoreCase(ASH.C_ZM)) {
                    vector = new Vector(0.0, 0.0, 1.0);
                    vector2 = new Vector(0.0, 0.0, ASH.this.parseR(stringArray[++n]));
                    ++n;
                } else if (stringArray[0 + n].equalsIgnoreCase(ASH.C_ZL)) {
                    vector = new Vector(0.0, 0.0, -1.0);
                    vector2 = new Vector(0.0, 0.0, ASH.this.parseR(stringArray[++n]));
                    ++n;
                } else {
                    ++n;
                    n += ASH.this.findVector(stringArray, n, vector);
                    n += ASH.this.findVector(stringArray, n, vector2);
                }
                if (stringArray.length != n) {
                    throw new Exception();
                }
                this.master.pickArea(vector2, vector, bl3, bl);
                this.master.painter.updateGeo();
            } else if (stringArray[0 + n].equalsIgnoreCase(ASH.C_ELE)) {
                for (int i = 1 + n; i < stringArray.length; ++i) {
                    this.master.pickElement(ASH.this.parseI(stringArray[i]), bl3, bl);
                }
                this.master.painter.updateGeo();
            } else if (stringArray[0 + n].equalsIgnoreCase(ASH.C_PART)) {
                for (int i = 1 + n; i < stringArray.length; ++i) {
                    this.master.pickAtom(ASH.this.parseI(stringArray[i]), bl3, bl);
                }
                this.master.painter.updateGeo();
            } else if (stringArray[0 + n].equalsIgnoreCase(ASH.C_PARTS)) {
                if (stringArray.length == 3 + n) {
                    int n2 = ASH.this.parseI(stringArray[1 + n]);
                    int n3 = ASH.this.parseI(stringArray[2 + n]);
                    for (int i = n2; i < n3; ++i) {
                        this.master.pickAtom(i, bl3, bl);
                    }
                } else {
                    throw new Exception();
                }
                this.master.painter.updateGeo();
            } else if (stringArray[0 + n].equalsIgnoreCase(ASH.C_SPHERE)) {
                ++n;
                Vector vector = new Vector(3);
                n += ASH.this.findVector(stringArray, n, vector);
                double d = 0.0;
                try {
                    Vector vector3 = new Vector(3);
                    int n4 = ASH.this.findVector(stringArray, n, vector3);
                    n += n4;
                    d = vector3.norm();
                }
                catch (Exception exception) {
                    d = ASH.this.parseR(stringArray[n]);
                    ++n;
                }
                if (stringArray.length != n) {
                    throw new Exception();
                }
                this.master.pickSphere(vector, d, bl3, bl);
                this.master.painter.updateGeo();
            } else {
                throw new Exception();
            }
        }
    }

    private class Print
    extends Command {
        protected Print(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_PRINT;
            this.cOptions = new String[1][];
            String[] stringArray = new String[]{ASH.C_NOOPTION, ASH.C_SCREEN, ASH.C_OLDFILE, ASH.C_NEWFILE};
            this.cOptions[0] = stringArray;
            this.cArgs = "[ (filename) ]  (message)";
            this.cInstructions = "Writes the given strings on screen or in a file. If several strings are given, separated by spaces, they are printed one by one. (This is different to value, which removes all white spaces.) Any leading spaces are ignored, however. To include a value of a variable or an expression in the print output, wrap the variable name in dollar signs ($), e.g., $pi$, $1+1$. For more details, see the manual for 'value'.\n    (message) - By default, the given strings are printed on screen. This is invoked if the first argument given is neither screen, append nor file.\n    screen (message) - Writes the message on screen. Usually, the option screen is redundant, but if you want to start the message with, say, append you need to include screen first - otherwise it will be interpreted as a command for printing to a file.\n    append (filename) (message) - Appends the given message to a file of the given name.\n    file (filename) (message) - Writes the given message to a new file of the given name. Note that if a file exist by that name, it will be overwritten!";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            boolean bl = true;
            boolean bl2 = false;
            int n = 0;
            String string = "";
            String string2 = "";
            if (stringArray[0].equalsIgnoreCase(ASH.C_SCREEN)) {
                n = 1;
            } else if (stringArray[0].equalsIgnoreCase(ASH.C_OLDFILE)) {
                string2 = stringArray[1];
                n = 2;
                bl = false;
            } else if (stringArray[0].equalsIgnoreCase(ASH.C_NEWFILE)) {
                string2 = stringArray[1];
                n = 2;
                bl = false;
                bl2 = true;
            }
            for (int i = n; i < stringArray.length; ++i) {
                string = string + stringArray[i] + " ";
            }
            if (bl) {
                ASH.this.printMessage(string, true);
            } else if (bl2) {
                String[] stringArray2 = new String[]{string};
                new FileHandler().writeFile(stringArray2, string2);
            } else {
                String[] stringArray3 = new String[]{string};
                new FileHandler().appendFile(stringArray3, string2);
            }
        }
    }

    private class Exit
    extends Command {
        protected Exit(ASH aSH2) {
            super(aSH2);
            this.cName = ASH.C_EXIT;
            this.cInstructions = "Terminates the program.";
        }

        @Override
        protected void execute(String[] stringArray) throws Exception {
            this.master.notFinished = false;
        }
    }

    private abstract class Command {
        protected String cName;
        protected String[][] cOptions;
        protected String cArgs;
        protected String cInstructions;
        protected ASH master;
        protected int minValues;
        protected int maxValues;

        protected Command(ASH aSH2) {
            this.master = aSH2;
            this.minValues = 0;
            this.maxValues = 0;
            this.cOptions = new String[0][0];
            this.cArgs = "";
            this.cInstructions = "";
            this.cName = "";
        }

        protected String getName() {
            return this.cName;
        }

        protected String[] getOptions() {
            String[] stringArray = new String[]{this.cName};
            String[] stringArray2 = new String[]{""};
            for (int i = 0; i < this.cOptions.length; ++i) {
                String[] stringArray3 = new String[this.cOptions[i].length];
                for (int j = 0; j < stringArray3.length; ++j) {
                    stringArray3[j] = this.cOptions[i][j].equals(ASH.C_NOOPTION) ? "" : " " + this.cOptions[i][j];
                }
                stringArray2 = StringCombiner.comboPermute(stringArray2, stringArray3, "");
            }
            return stringArray2;
        }

        protected String getUsage() {
            String string = this.cName;
            for (int i = 0; i < this.cOptions.length; ++i) {
                boolean bl = false;
                String string2 = "";
                int n = 0;
                for (int j = 0; j < this.cOptions[i].length; ++j) {
                    if (this.cOptions[i][j].equals(ASH.C_NOOPTION)) {
                        bl = true;
                        continue;
                    }
                    if (++n > 1) {
                        string2 = string2 + " / ";
                    }
                    string2 = string2 + this.cOptions[i][j];
                }
                string = bl ? string + "  [ " + string2 + " ]" : string + "  " + string2;
            }
            if (!this.cArgs.equals("")) {
                string = string + "  " + this.cArgs;
            }
            if (this.maxValues > 0) {
                string = this.minValues > 0 ? (this.minValues != this.maxValues ? string + "  (" + this.minValues + "-" + this.maxValues + " parameters)" : string + "  (" + this.maxValues + " parameters)") : string + "  [ (0-" + this.maxValues + " parameters) ]";
            }
            return string;
        }

        protected void setOptions(String[][] stringArray) {
            this.cOptions = stringArray;
        }

        protected String getInstructions() {
            return this.cInstructions;
        }

        protected abstract void execute(String[] var1) throws Exception;
    }
}

