/*
 * This file has been modified by Tommi Junttila by adding the
 * procedures and variables starting with the prefix "TJ_".
 */
#include<limits.h>
#include"formula.H"
#include"graph.H"
#include"dimensions.H"
#include <stdlib.h>
#include <fstream.h>
/* TJ includes */
#include "TJ_defs.H"
#include "TJ_partition.H"

#if defined(TJ_NAUTY)
#include "nauty.h"
#endif

Decision ** HashTable;
unsigned int LastChoice;
Decision * LastDecision;
unsigned int Scapegoat;
Statevector * LastVector;
unsigned int currentdfsnum = 1;
SearchTrace * Trace;
unsigned int CardFireList;
unsigned int pos;
unsigned int isbounded;
unsigned int State::card = 0;

#define VERYLARGE UINT_MAX


/* TJ statistics */
static unsigned long TJ_stats_nof_canonizer_called = 0;
static unsigned long TJ_stats_dead_nodes_max = 0;
static unsigned long TJ_stats_dead_nodes_sum = 0;
static unsigned long TJ_stats_trivial = 0;
static unsigned long TJ_stats_easy = 0;

static unsigned long TJ_nauty_search_tree_max = 0;
static unsigned long TJ_nauty_search_tree_sum = 0;


void statistics(unsigned int s, unsigned int e, unsigned int h)
{
  cout << "\n\n>>>>> " << s << " States, " << e << " Edges, " << h << " Hash table entries\n\n";
#if defined(SYMMETRY)
#if(SYMMINTEGRATION == 6) || (SYMMINTEGRATION == 7)
  cout << (double)(TJ_stats_trivial * 100) / (double)TJ_stats_nof_canonizer_called
       << "% trivial and "
       << (double)(TJ_stats_easy * 100) / (double)TJ_stats_nof_canonizer_called
       << "% easy markings\n";
  if(TJ_stats_nof_canonizer_called - TJ_stats_trivial - TJ_stats_easy != 0) {
    cout << "Hard markings, dead nodes: max="
	 << TJ_stats_dead_nodes_max
	 << ", average="
	 << (double)TJ_stats_dead_nodes_sum/(double)(TJ_stats_nof_canonizer_called - TJ_stats_trivial - TJ_stats_easy)
	 << "\n";
  }
#elif (SYMMINTEGRATION == 8)
  cout << (double)(TJ_stats_trivial*100)/(double)TJ_stats_nof_canonizer_called
       << "% trivial markings\n";
  cout << "Nauty search tree size: max="
       << TJ_nauty_search_tree_max
       << ", average of non-trivial cases="
       << (double)TJ_nauty_search_tree_sum / (double)(TJ_stats_nof_canonizer_called - TJ_stats_trivial)
       << "\n";
#endif
#endif
}

Transition ** firelist()
{
  Transition ** tl;
  Transition * t;
  int i;
  tl = new Transition * [Transitions[0] -> NrEnabled + 1];
  for(i=0,t = Transitions[0]->StartOfEnabledList; t; t = t -> NextEnabled)
    {
#ifdef EXTENDEDCTL
	if(t -> pathrestriction[TemporalIndex])
	{
#endif
      tl[i++] = t;
#ifdef EXTENDEDCTL
	}
#endif
    }
  tl[i] = (Transition *) 0;
  CardFireList = i;
  return tl;
}

void printstate();

Statevector * TSCCRepresentitives;

#ifndef MODELCHECKING

#ifdef STUBBORN
#include"stubborn.H"
#endif
State * SYMMPROC();
unsigned int MinBookmark; // MIN number of the first closed marking
                          // in the currently or last recently processed TSCC
void printpath(State *,ofstream *);
void print_path(State * s)
{
	if(pflg)
	{
		ofstream pathstream(pathfile);
		if(!pathstream)
		{
			cerr << "Cannot open path output file: " << pathfile <<
			"\nno output written\n";
		}
		pathstream << "PATH\n";
		printpath(s,&pathstream);
	}
	if(Pflg)
	{
		cout << "PATH\n";
		printpath(s,(ofstream *) 0);
	}
}
void printpath(State *s,ofstream * pathstream)
{
	// print a path from initial state to s
	if(s -> parent)
	{
		printpath(s -> parent,pathstream);
		if(Pflg)
		{
		cout << s -> parent -> firelist[s -> parent -> current] -> name << "\n";
		}
		if(pflg)
		{
		(*pathstream) << s -> parent -> firelist[s -> parent -> current] -> name << "\n";
		}
	}
}

void printincompletestates(State *s,ofstream * graphstream,int level)
{
	int i,j;
	// level = 1 --> top level, no firelist, mark '!'
	// level = 0 --> other level, firelist,  mark '*'
	if(!s) return;

	if(gmflg)
	{
	  (*graphstream) << "STATE " << (level ? "! " : "* ") << s ->dfs ;
	  j=0;
	  if(graphformat == 'm')
	  {
		 for(i=0;i<Places[0]->cnt;i++)
		 {
			 if(Places[i]->current_marking)
				{
				 if(Places[i]->current_marking == VERYLARGE)
				 {
				 (*graphstream) << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << "oo" ;
				 }
				 else
				 {
				 (*graphstream) << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << Places[i]->current_marking ;
				 }
				 }
		 }

	  }
		 (*graphstream) << "\n\n";
	  if(!level)
	  {
	  for(i=0; i < s -> current;i++)
	  {
		(*graphstream) << s -> firelist[i]->name << " -> " << s -> succ[i]->dfs << "\n";
      }
		(*graphstream) << s -> firelist[s->current]->name << " => " << s -> succ[s->current]->dfs << "\n";
	  for(i = s -> current + 1; s ->firelist[i];i++)
	  {
		(*graphstream) << s -> firelist[i]->name << " -> ?\n";
      }
	  }
	  (*graphstream) << "\n";
	}
	if(GMflg)
	{
	  cout << "STATE " << (level ? "! " : "* ") << s ->dfs;
	  j=0;
	  if(graphformat == 'm')
	  {
		 for(i=0;i<Places[0]->cnt;i++)
		 {
			 if(Places[i]->current_marking)
			 {
				 if(Places[i]->current_marking == VERYLARGE)
				 {

				 cout << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << "oo";
				 }
				 else
				 {
				 cout << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << Places[i]->current_marking ;
				 }
			 }
		 }

	  }
	  cout << "\n\n";
	  if(!level)
	  {
	  for(i=0; i < s -> current;i++)
	  {
		cout << s -> firelist[i]->name << " -> " <<
		s -> succ[i]->dfs << "\n";
      }
		cout << s -> firelist[s->current]->name << " => " << s -> succ[s->current]->dfs << "\n";
	  for(i = s -> current + 1; s ->firelist[i];i++)
	  {
		cout << s -> firelist[i]->name << " -> ?\n";
      }
	  }
	  cout << "\n";
	}
if(!s->parent) return;
#ifdef COVER
		  if(s -> NewOmega)
		  {
			  // Replace new omegas by their old values
			  for(i=0;s ->NewOmega[i];i++)
			  {
				s ->NewOmega[i]->set_marking(s ->NewOmega[i]->lastfinite);
				s ->NewOmega[i]->bounded = true;
			  }
			  delete [] s ->NewOmega;
		  }
#endif
	s -> parent -> firelist[s -> parent -> current] -> backfire();
	printincompletestates(s -> parent,graphstream,0);
}

#ifdef COVER
void print_reg_path(State *s, State * startofrepeatingseq,ofstream * pathstream,int level)
{
	if(level)
	{
		if(!pflg && ! Pflg) return;
		if(pflg)
		{
			pathstream = new ofstream(pathfile);
			if(!pathstream)
			{
				cerr << "Cannot open path output file: " << pathfile
				<< "\nno output written\n";
				return;
			}
			(*pathstream) << "PATH EXPRESSION \n";
		}
		else
		{
			cout << "PATH EXPRESSION \n";
		}
	}
	// print a regular expression for path  from initial state to 
	// generalised state s in coverability graph
	if(startofrepeatingseq)
	{
		if(s == startofrepeatingseq)
		{
			if(s -> parent)
			{
				int i;
				print_reg_path(s -> parent,s->smaller,pathstream,0);
			if(s->smaller) 
			{
				if(Pflg)
				{
				cout << " ";
				}
				else
				{
				(*pathstream) << " ";
				}
			}
			else
			{
				if(Pflg)
				{
				cout << "\n";
				}
				else
				{
				(*pathstream) << "\n";
				}
			}
				if(Pflg)
				{
				cout << s -> parent -> firelist[s -> parent -> current] -> name;
				}
				else
				{
				(*pathstream) << s -> parent -> firelist[s -> parent -> current] -> name;
				}
			}
			if(s->smaller) 
			{
				if(Pflg)
				{
				cout << " )";
				}
				else
				{
				(*pathstream) << " )";
				}
			}
			if(Pflg)
			{
			cout << "\n(";
			}
			else
			{
			(*pathstream) << "\n(";
			}
		}
		else
		{
			if(s -> parent)
			{
				int i;
				print_reg_path(s -> parent,startofrepeatingseq,pathstream,0);
				if(Pflg)
				{
				cout << " " << s -> parent -> firelist[s->parent->current] -> name ;
				}
				else
				{
				(*pathstream)  << " " << s -> parent -> firelist[s->parent->current] -> name;
				}
			}
			if(s->smaller) 
			{
				if(Pflg)
				{
				cout << " )";
				}
				else
				{
				(*pathstream) << " )";
				}
			}
		}
	}
	else
	{
		if(s -> parent)
		{
			int i;
			print_reg_path(s -> parent,s->smaller,pathstream,0);
			if(s->smaller) 
			{
				if(Pflg)
				{
				cout << " ";
				}
				else
				{
				(*pathstream) << " ";
				}
			}
			else
			{
				if(Pflg)
				{
				cout << "\n";
				}
				else
				{
				(*pathstream) << "\n";
				}
			}
			if(Pflg)
			{
			cout << s -> parent -> firelist[s->parent->current] -> name ;
			}
			else
			{
			(*pathstream) << s -> parent -> firelist[s->parent->current] -> name ;
			}
				
		}
		if(s->smaller) 
		{
			if(Pflg)
			{
			cout << " )";
			}
			else
			{
			(*pathstream) << " )";
			}
		}
	}
}
#endif
		

#define MIN(X,Y) ( (X) < (Y) ? (X) : (Y)) 

State * CurrentState;

unsigned int depth_first()
{
  ofstream * graphstream;
  unsigned int i;
  unsigned int NumberOfStates;
  State * NewState;
  // init initial marking and hash table
  isbounded = 1;
  if(gmflg) {
    graphstream = new ofstream(graphfile);
    if(!*graphstream) {
      cerr << "cannot open graph output file: " << graphfile << "\n";
      cerr << "no output written\n";
      gmflg = false;
    }
  }
  Trace = new SearchTrace [CardStore];
  for(i = 0; i < HASHSIZE;i++) {
    HashTable[i] = (Decision *) 0;
  }
  NumberOfStates = 1;
  if(search_marking()) cerr << "Sollte eigentlich nicht vorkommen";
  CurrentState = insert_marking();
  CurrentState -> current = 0;
  CurrentState -> firelist = FIRELIST();
  CurrentState -> parent = (State *) 0;
#ifdef DEADLOCK
  if(!(CurrentState -> firelist) || ! (CurrentState -> firelist[0]))
    {
      // early abortion
      cout << "\ndead state found!\n";
      printstate();
      print_path(CurrentState);
      printincompletestates(CurrentState,graphstream,1);
      statistics(NumberOfStates,Edges,NonEmptyHash);
      return 1;
    }
#endif
#ifdef TSCC
  TSCCRepresentitives = (Statevector *) 0;
#endif
#ifdef BOUNDEDPLACE
  if(!CheckPlace)
    {
      cerr << "\nspecify place to be checked in analysis tak file\n";
      _exit(4);
    }
#endif
#ifdef DEADTRANSITION 
  if(!CheckTransition)
    {
      cerr << "\n specify transition to be checked in analysis task file!\n";
      _exit(4);
    }
  if(CheckTransition -> enabled)
    {
      // early abortion
      cout << "\ntransition " << CheckTransition -> name << " is not dead!\n";
      printstate();
      print_path(CurrentState);
      printincompletestates(CurrentState, graphstream,1);//1=toplevel
      
      statistics(NumberOfStates,Edges,NonEmptyHash);
      return 1;
    }
#endif
  
#if (defined ( STUBBORN ) && defined ( REACHABILITY ) )
  if(!CurrentState -> firelist )
    {
#ifdef EXTENDED
      CurrentState -> firelist = firelist();
#else
      // early abortion  
      cout << "\nstate found!\n";
      printstate();
      print_path(CurrentState);
      printincompletestates(CurrentState, graphstream,1);//1=toplevel
      statistics(NumberOfStates,Edges,NonEmptyHash);
      return 1;
#endif
    }
#endif
#if ( defined (REACHABILITY ) && ! defined ( STUBBORN ) ) 
  for(i=0;i<Places[0]->cnt;i++) {
    if(Places[i]->current_marking != Places[i]->target_marking)
      break;
  }
  if(i >= Places[0]->cnt) // target_marking found!
    {
      // early abortion  
      cout << "\nstate found!\n";
      printstate();
      print_path(CurrentState);
      printincompletestates(CurrentState, graphstream,1);//1=toplevel
      statistics(NumberOfStates,Edges,NonEmptyHash);
      return 1; 
    }
#endif
#ifdef COVER
  CurrentState -> NewOmega = (Place **) 0;
#endif
#ifdef STATEPREDICATE
  int res;
  if(!F)
    {	
      cerr << "\nspecify predicate in analysis task file!\n";
      _exit(4);
    }
  F = F -> reduce(&res);
  if(res<2) return res;	
  F = F -> posate();
  F -> tempcard = 0;
  F -> setstatic();
  if(F ->  tempcard) 
    {
      cerr << "temporal operators are not allowed in state predicates\n";
      exit(3);
    }
  cout << "\n Formula with\n" << F -> card << " subformula.\n";
  F -> parent = (formula *) 0;
  if(F -> initatomic())
    {
      cout << "\nstate found!\n";
      printstate();
      print_path(CurrentState);
      printincompletestates(CurrentState,graphstream,1);
      statistics(NumberOfStates,Edges,NonEmptyHash);
      return 1;
    }
#endif
  CurrentState -> succ = new State * [CardFireList+1];
  CurrentState -> dfs = CurrentState -> min = 0;
  
  // process marking until returning from initial state
  
  while(CurrentState) {
#ifdef EXTENDED
    // dfsnum must be passed to net.H for tracing lastdisabed and lastfired
    currentdfsnum = CurrentState -> dfs + 1; // 0 reserved for "never disabled"
    // and "never fired"
#endif
    if(CurrentState->firelist[CurrentState->current]) {
      // there is a next state that needs to be explored
      Edges++;
      if((Edges % REPORTFREQUENCY) == 0)
	cerr << "st: " << NumberOfStates << "     edg: " << Edges << "\n";
      CurrentState->firelist[CurrentState->current]->fire();
#ifdef COVER
      //In coverability graphs, we need to check for new w
      
      // 1. Search backwards until last w-Intro for smaller state
      Statevector * smallerblock;
      unsigned int NrCovered;
      unsigned int blockindex;
      unsigned int smallerfirst, smallerlast;
      State * smallerstate;
      Place ** NewOmegas;
      
      NewOmegas = (Place **)0;
      // for all ancestor states do ...
      for(smallerstate = CurrentState; smallerstate;
	  smallerstate = smallerstate -> parent) {
	NrCovered = 0;
	// for all fragements of state vector do ...
	smallerfirst = Places[0]->cnt;
	for(smallerblock = smallerstate -> contents;
	    smallerblock;
	    smallerblock = smallerblock -> prev) {
	  smallerlast = smallerfirst;
	  smallerfirst = Places[0]->cnt - smallerblock->length;
	  // for all elements in block ....
	  for(blockindex= 0;blockindex < smallerlast - smallerfirst;
	      blockindex++) {
	    // case 1: smaller state[i] > current state [i] 
	    // ---> continue with previous state
	    if((*smallerblock)[blockindex] >
	       Places[blockindex+smallerfirst]->current_marking) {
	      goto nextstate;
	    }
	    // case 2: smaller state < current state
	    // count w-Intro
	    if((*smallerblock)[blockindex] <
	       Places[blockindex+smallerfirst]->current_marking) {
	      NrCovered++;
	    }
	    // case 3: smaller state = current state --> do nothing
	  }
	}
	// if arrived here, it holds smaller <= current
	// covering is proper iff NrCovered > 0
	// If covering is not proper, (smaller state = current state)
	// current marking is not new, ancestors of smaller marking cannot
	// be smaller than current marking, since they would be smaller than
	// this smaller marking --> leave w-Intro procedure
	if(!NrCovered) {
	  smallerstate = (State *) 0;
	  goto endomegaproc;
	}
	// Here, smallerstate IS less than current state.
	isbounded = 0;
	NewOmegas = new Place * [NrCovered+1];
	// for all fragements of state vector do ...
	NrCovered = 0;
	smallerfirst = Places[0]->cnt;
	for(smallerblock = smallerstate -> contents;
	    smallerblock;
	    smallerblock = smallerblock -> prev) {
	  smallerlast = smallerfirst;
	  smallerfirst = Places[0]->cnt - smallerblock->length;
	  // for all elements in block ....
	  for(blockindex= 0;blockindex < smallerlast - smallerfirst;
	      blockindex++) {
	    if((*smallerblock)[blockindex] <
	       Places[blockindex+smallerfirst]->current_marking) {
	      // Here we have a place that deserves a new Omega
	      // 1. set old value in place record
	      Places[blockindex+smallerfirst] -> lastfinite = 
		Places[blockindex+smallerfirst] -> current_marking;
	      Places[blockindex+smallerfirst] -> set_marking(VERYLARGE);
	      Places[blockindex+smallerfirst] -> bounded = false;
	      NewOmegas[NrCovered++] = Places[blockindex+smallerfirst];
	    }
	  }
	}
	NewOmegas[NrCovered] = (Place*) 0;
	goto endomegaproc;
	
      nextstate:
	if(smallerstate -> smaller) {
	  // smallerstate is a omega-introducing state
	  break;
	}
      }
    endomegaproc:
      if(!NewOmegas) smallerstate = (State *) 0;
#endif /* COVER */
      if(NewState = 
#ifdef SYMMETRY
	 SYMMPROC()
#else
search_marking()
#endif
	 )
	{
	  // State exists!
#ifdef COVER
	  if(NewOmegas)
	    {
	      // Replace new omegas by their old values
	      for(i = 0; NewOmegas[i]; i++) {
		NewOmegas[i]->set_marking(NewOmegas[i]->lastfinite);
		NewOmegas[i]->bounded = true;
	      }
	      delete [] NewOmegas;
	    }
#endif /* COVER */
	  CurrentState -> firelist[CurrentState -> current] -> backfire();
#ifdef STATEPREDICATE
	  update_formula(CurrentState -> firelist[CurrentState -> current]);
#endif
	  CurrentState -> succ[CurrentState -> current] = NewState;
	  CurrentState -> min = MIN(CurrentState -> min, NewState -> min);
	  (CurrentState -> current) ++;
	}
      else
	{
	  NewState = 
#if ( defined ( SYMMETRY ) )  && ( SYMMINTEGRATION > 2 )
	    kr_insert_marking();
#else
	  insert_marking();
#endif
#ifdef STATEPREDICATE
	  update_formula(CurrentState -> firelist[CurrentState -> current]);
#endif
	  NewState -> current = 0;
	  NewState -> firelist = FIRELIST();
	  NewState -> parent = CurrentState;
	  NewState -> succ =  new State * [CardFireList+1];
	  NewState -> dfs = NewState -> min = NumberOfStates++;
	  CurrentState -> succ[CurrentState -> current] = NewState;
#ifdef STATEPREDICATE
	  if(F -> value)
	    {
	      // early abortion
	      cout << "\nstate found!\n";
	      printstate();
	      print_path(NewState);
	      printincompletestates(NewState, graphstream,1);//1=toplevel
	      statistics(NumberOfStates,Edges,NonEmptyHash);
	      return 1;
	    }
#endif
#ifdef COVER
	  NewState -> smaller = smallerstate;
	  NewState -> NewOmega = NewOmegas;
#endif
#ifdef DEADLOCK
	  if(!(NewState -> firelist) || !(NewState -> firelist[0]))
	    {
	      // early abortion
	      cout << "\ndead state found!\n";
	      printstate();
	      print_path(NewState);
	      printincompletestates(NewState, graphstream,1);//1=toplevel
	      statistics(NumberOfStates,Edges,NonEmptyHash);
	      return 1;
	    }
#endif
#ifdef DEADTRANSITION 
	if(CheckTransition -> enabled) {
	    // early abortion
	  cout << "\ntransition " <<  CheckTransition -> name << " is not dead!\n";
	  printstate();
	  print_path(NewState);
	  printincompletestates(NewState, graphstream,1);//1=toplevel
	  statistics(NumberOfStates,Edges,NonEmptyHash);
	  return 1;
	}
#endif
#if ( defined ( STUBBORN ) && defined ( REACHABILITY ) ) 
	if(!NewState -> firelist ) {
#ifdef EXTENDED
	  NewState -> firelist = firelist();
#else
	  // early abortion  
	  cout << "\nstate found!\n";
	  printstate();
	  print_path(NewState);
	  printincompletestates(NewState, graphstream,1);//1=toplevel
	  statistics(NumberOfStates,Edges,NonEmptyHash);
	  return 1;
#endif
	}
#endif
#if ( defined (REACHABILITY ) && ! defined ( STUBBORN ) ) 
	for(i=0;i<Places[0]->cnt;i++) {
	  if(Places[i]->current_marking != Places[i]->target_marking)
	    break;
	}
	if(i >= Places[0]->cnt) { // target_marking found!
	  // early abortion  
	  cout << "\nstate found!\n";
	  printstate();
	  print_path(NewState);
	  printincompletestates(NewState, graphstream,1);//1=toplevel
	  statistics(NumberOfStates,Edges,NonEmptyHash);
	  return 1; 
	}
#endif

	CurrentState = NewState;
#ifdef COVER
	if(CheckPlace) {
	  if(!CheckPlace->bounded) {
	    cout << "place " << CheckPlace -> name << " is unbounded!\n";
	    print_reg_path(CurrentState,CurrentState->smaller,(ofstream *) 0,1);
	    cout << "\n";
	    printincompletestates(CurrentState,graphstream,1);
	    statistics(NumberOfStates,Edges,NonEmptyHash);
	    return 1;
	  }
	}
#endif
	    }
	}
      else
	{
	  // close state and return to previous state
	  int j;
	  if(gmflg)
	    {
	      (*graphstream) << "STATE " << CurrentState ->dfs;
	      j=0;
	      if(graphformat == 'm') {
		for(i=0;i<Places[0]->cnt;i++) {
		  if(Places[i]->current_marking) {
		    if(Places[i]->current_marking == VERYLARGE) {
		      (*graphstream) << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << "oo" ;
		    }
		    else {
		      (*graphstream) << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << Places[i]->current_marking ;
		    }
		  }
		}
	      }
	      (*graphstream) << "\n\n";
	      for(i=0; CurrentState ->firelist[i];i++) {
		(*graphstream) << CurrentState -> firelist[i]->name << " -> " <<
		  CurrentState -> succ[i]->dfs << "\n";
	      }
	      (*graphstream) << "\n";
	    }
	  if(GMflg)
	    {
	      cout << "STATE " << CurrentState ->dfs;
	      j=0;
	      if(graphformat == 'm')
		{
		  for(i=0;i<Places[0]->cnt;i++)
		    {
		      if(Places[i]->current_marking)
			{
			  if(Places[i]->current_marking == VERYLARGE)
			    {
			      cout << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << "oo" ;
			    }
			  else
			    {
			      cout << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << Places[i]->current_marking ;
			    }
			}
		    }
		  
		}
	      cout << "\n\n";
	      for(i=0; CurrentState ->firelist[i];i++)
		{
		  cout << CurrentState -> firelist[i]->name << " -> " <<
		    CurrentState -> succ[i]->dfs << "\n";
		}
	      cout << "\n";
	    }
#if defined(EXTENDED) && ! defined(MODELCHECKING)
	  // if last state in TSCC, retrieve ignored transitions
	  if((CurrentState -> dfs == CurrentState -> min)
	     && (CurrentState -> dfs >= MinBookmark))
	    {
	      // TSCC closed. Check for ignored transitions or incomplete up-sets
#ifdef STATEPREDICATE
	      // implement SPP2 of Kristensen/Valmari (2000)
	      Transition ** forgotten;
	      
	      forgotten = F -> spp2(CurrentState);
	      if(forgotten)
		{
				// fire list must be extended
		  unsigned int nf;
		  for(nf = 0; forgotten[nf]; nf++);
		  Transition ** newFL = new Transition * [nf + CurrentState -> current];
		  State ** newSucc = new State * [nf + CurrentState -> current];
		  for(i=0;i < CurrentState -> current;i++)
		    {
		      newFL[i] = CurrentState -> firelist[i];
		      newSucc[i] = CurrentState -> succ[i];
		    }
		  for(i=0;i<nf;i++)
		    {
		      newFL[CurrentState -> current + i] = forgotten[i];
		    }
		  newFL[i] = (Transition *) 0;
		  delete [] CurrentState -> firelist;
		  delete [] CurrentState -> succ;
		  CurrentState -> firelist = newFL;
		  CurrentState -> succ = newSucc;
		  continue;
		}
	      
#else
	      Transition * ignored;
	      unsigned int CardIgnored;
	      
	      CardIgnored = 0;
	      Transitions[0]-> StartOfIgnoredList = (Transition *) 0;
	      for(ignored = Transitions[0]->StartOfEnabledList;ignored;
		  ignored = ignored -> NextEnabled)
		{
		  if((ignored -> lastdisabled <= CurrentState -> dfs)
		     && (ignored -> lastfired <= CurrentState -> dfs))
		    {
		      // transition IS ignored
		      CardIgnored ++;
		      ignored -> NextIgnored = Transitions[0]->StartOfIgnoredList;
		      Transitions[0]->StartOfIgnoredList = ignored;
		    }
		}
	      if(Transitions[0]->StartOfIgnoredList)
		{
				// there are ignored transitions
		  Transition * tt;
		  Transition ** newFL = new Transition *[CurrentState -> current + CardIgnored + 1];
		  State ** newSucc = new State *[CurrentState->current + CardIgnored];
		  int u;
		  for(u=0;u<CurrentState->current;u++)
		    {
		      newFL[u]= CurrentState->firelist[u];
		      newSucc[u] = CurrentState -> succ[u];
		    }
		  for(tt = Transitions[0]->StartOfIgnoredList;
		      tt;
		      tt = tt -> NextIgnored)
		    {
		      newFL[u++] = tt;
		    }
		  newFL[u] = (Transition*)0;
		  delete [] CurrentState -> firelist;
		  delete [] CurrentState -> succ;
		  CurrentState->firelist = newFL;
		  CurrentState -> succ = newSucc;
		  continue;
		}
#ifdef TSCC
	      else
		{
		  //TSCC really closed: deposit state
		  Statevector * s;
		  
		  MinBookmark = NumberOfStates;
		  s = new Statevector(Places[0]->cnt);
		  s -> prev = TSCCRepresentitives;
		  TSCCRepresentitives = s;
		  for(i=0;i < Places[0]->cnt;i++)
		    {
		      s->set(i,Places[i]->current_marking);
		    }
		}
#endif
#endif
	    }
#endif
#ifdef COVER
	  if(CurrentState -> NewOmega)
	    {
	      // Replace new omegas by their old values
	      for(i=0;CurrentState ->NewOmega[i];i++)
		{
		  CurrentState ->NewOmega[i]->set_marking(CurrentState ->NewOmega[i]->lastfinite);
		  CurrentState ->NewOmega[i]->bounded = true;
		}
	      delete [] CurrentState ->NewOmega;
	    }
#endif
	  delete [] CurrentState -> succ;
	  delete [] CurrentState -> firelist;
	  CurrentState = CurrentState -> parent;
	  if(CurrentState)
	    {
	      CurrentState -> firelist[CurrentState -> current] -> backfire();
#ifdef STATEPREDICATE
		  update_formula(CurrentState -> firelist[CurrentState -> current]);
#endif
	      CurrentState -> min = MIN(CurrentState -> min, CurrentState-> succ[CurrentState -> current]-> min);
	      CurrentState -> current ++;
	    }
	}
	}
#ifdef REACHABILITY
	cout << "\n state is not reachable!\n";
#endif
#ifdef DEADLOCK
	cout << "\nnet does not have deadlocks!\n";
#endif
#ifdef STATEPREDICATE
	cout << "\n predicate is not satisfiable!\n";
#endif
#ifdef DEADTRANSITION
	cout << "\ntransition " << CheckTransition -> name << " is dead!\n";
#endif
#ifdef BOUNDEDPLACE
	cout << "\nplace " << CheckPlace -> name << " is bounded!\n";
#endif
#ifdef BOUNDEDNET
	if(isbounded)
	  {
	    cout << "\nnet is bounded!\n";
	  }
	else
	  {
	    cout << "\nnet is unbounded!\n";
	  }
#endif
	statistics(NumberOfStates,Edges,NonEmptyHash);
	return 0;
}


unsigned int breadth_first()
{
  ofstream * graphstream;
  unsigned int limit;
  unsigned int d;
  unsigned int i;
  unsigned int NumberOfStates;

  if(gmflg)
  {
	  graphstream = new ofstream(graphfile);
		if(!graphstream)
		{
			cerr << "Cannot open graph output file: " << graphfile
			<< "\nno output written\n";
			gmflg = false;
		}
  }
		

  State * CurrentState, * NewState, * initial;
  // init initial marking and hash table
  Trace = new SearchTrace [CardStore];
  for(i = 0; i < HASHSIZE;i++)
    {
      HashTable[i] = (Decision *) 0;
    }
  NumberOfStates = d = limit = 1;
  initial = CurrentState = insert_marking();
  CurrentState -> dfs = 0;
  CurrentState -> current = 0;
  CurrentState -> min = true;
  CurrentState -> firelist = FIRELIST();
	int j;
	if(gmflg)
	{
	  (*graphstream) << "STATE " << CurrentState ->dfs << "; DEPTH 0";
	  j=0;
	  if(graphformat == 'm')
	  {
		 for(i=0;i<Places[0]->cnt;i++)
		 {
			 if(Places[i]->current_marking)
			 {
				 if(Places[i]->current_marking == VERYLARGE)
				 {
				 (*graphstream) << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << "oo" ;
				 }
				 else
				 {
				 (*graphstream) << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << Places[i]->current_marking ;
				 }
			 }
		 }

	  }
	  (*graphstream) << "\n\n";
	  for(i=0;CurrentState -> firelist[i];i++)
	  {
		(*graphstream) << CurrentState -> firelist[i]->name << "\n";
	  }
	  (*graphstream) << "\n";
	}
	if(GMflg)
	{
	  cout << "STATE " << CurrentState ->dfs << "; DEPTH 0";
	  j=0;
	  if(graphformat == 'm')
	  {
		 for(i=0;i<Places[0]->cnt;i++)
		 {
			 if(Places[i]->current_marking)
			 {
				 if(Places[i]->current_marking == VERYLARGE)
				 {
				 cout << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << "oo" ;
				 }
				 else
				 {
				 cout << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << Places[i]->current_marking ;
				 }
			 }
		 }

	  }
	  cout << "\n\n";
	  for(i=0;CurrentState -> firelist[i];i++)
	  {
		cout << CurrentState -> firelist[i]->name << "\n";
	  }
	  cout << "\n";
	}
#ifdef STUBBORN
  if(!CurrentState -> firelist )
	{
		// early abortion  
#ifdef REACHABILITY
	      cout << "\nstate found!\n";
#endif
#ifdef DEADTRANSITION
	      cout << "\ntransition " << CheckTransition -> name << " is not dead!\n";
#endif
		  printstate();
		  print_path(CurrentState);
	statistics(NumberOfStates,Edges,NonEmptyHash);
	return 1;
         }
#endif
#ifdef DEADLOCK 
	if(!CurrentState -> firelist || ! (CurrentState -> firelist[0]))
	{
		 // early abortion 
		 cout << "\ndead state found!\n";
		 printstate();
		 print_path(CurrentState);
		 statistics(NumberOfStates,Edges,NonEmptyHash);
		 return 1;
	}
#endif

#if ( defined (REACHABILITY ) && ! defined ( STUBBORN ) ) 
for(i=0;i<Places[0]->cnt;i++)
{
	 if(Places[i]->current_marking != Places[i]->target_marking)
		 break;
}
if(i >= Places[0]->cnt) // target_marking found!
{
		// early abortion  
#ifdef REACHABILITY
	      cout << "\nstate found!\n";
#endif
#ifdef DEADTRANSITION
	      cout << "\nstransition " CheckTransition -> name << " is not dead!\n";
#endif
		  printstate();
		print_path(CurrentState);
	statistics(NumberOfStates,Edges,NonEmptyHash);
	 return 1; 
}
#endif
  CurrentState -> parent = (State *) 0;
  CurrentState -> succ = new State * [CardFireList];
  
  // process marking until returning from initial state
  
  while(CurrentState)
    {
      if(CurrentState -> firelist[CurrentState -> current])
	{
          if(d == limit)
	  {
		// working layer
	        Edges ++;
	      if(!(Edges % REPORTFREQUENCY)) 
              cerr << "st: " << NumberOfStates << "     edg: " << Edges << "\n";
	        CurrentState -> firelist[CurrentState -> current] -> fire();
	        if(NewState = 
#ifdef SYMMETRY
SYMMPROC()
#else
search_marking()
#endif
)
	        {
	            CurrentState -> firelist[CurrentState -> current] -> backfire();
	            CurrentState -> succ[(CurrentState -> current)++] = (State *) 0;
	        }
	        else
	        {
	            NewState = 
#if ( defined ( SYMMETRY ) )  && ( SYMMINTEGRATION > 2 )
		      kr_insert_marking();
#else
		    insert_marking();
#endif
		    CurrentState -> min = true;
                NewState -> dfs =  NumberOfStates ++;
	            NewState -> current = 0;
	            NewState -> firelist = FIRELIST();
	            NewState -> parent = CurrentState;
	            NewState -> succ =  new State * [CardFireList];
	if(gmflg)
	{
	  (*graphstream) << "STATE " << NewState ->dfs << " FROM " <<
	  CurrentState -> dfs << " BY " << 
	  CurrentState -> firelist[CurrentState -> current] -> name
	  << "; DEPTH " << limit;
	  j=0;
	  if(graphformat == 'm')
	  {
		 for(i=0;i<Places[0]->cnt;i++)
		 {
			 if(Places[i]->current_marking)
			 {
				 if(Places[i]->current_marking == VERYLARGE)
				 {
				 (*graphstream) << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << "oo" ;
				 }
				 else
				 {
				 (*graphstream) << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << Places[i]->current_marking ;
				 }
			  }
		 }

	  }
	  (*graphstream) << "\n\n";
	  if(NewState -> firelist)
	  {
	  for(i=0;NewState -> firelist[i];i++)
	  {
		(*graphstream) << NewState -> firelist[i]->name << "\n";
	  }
	  }
	  (*graphstream) << "\n";
	}
	if(GMflg)
	{
	  cout << "STATE " << NewState ->dfs << " FROM " <<
	  CurrentState -> dfs << " BY " << 
	  CurrentState -> firelist[CurrentState -> current] -> name
	  << "; DEPTH " << limit;
	  j=0;
	  if(graphformat == 'm')
	  {
		 for(i=0;i<Places[0]->cnt;i++)
		 {
			 if(Places[i]->current_marking)
			 {
				 if(Places[i]->current_marking == VERYLARGE)
				 {
				 cout << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << "oo" ;
				 }
				 else
				 {
				 cout << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << Places[i]->current_marking ;
				 }
			 }
		 }

	  }
	  cout << "\n\n";
	  if(NewState -> firelist)
	  {
	  for(i=0;NewState -> firelist[i];i++)
	  {
		cout << NewState -> firelist[i]->name << "\n";
	  }
	  }
	  cout << "\n";
	}
	            CurrentState -> succ[CurrentState -> current] = NewState;
#ifdef STUBBORN
                    if(!NewState -> firelist )
	            {
		        // early abortion  
#ifdef REACHABILITY
	                cout << "\nstate found!\n";
#endif
#ifdef DEADTRANSITION
	                cout << "\ntransition " << CheckTransition -> name << " is not dead!\n";
#endif
					printstate();
		        print_path(NewState);
	statistics(NumberOfStates,Edges,NonEmptyHash);
		        return 1;
                    }
#endif
#ifdef DEADLOCK
                if(!NewState -> firelist || !(NewState -> firelist[0]))
	            {
		        // early abortion  
	                cout << "\ndead state found!\n";
					printstate();
		        print_path(NewState);
	statistics(NumberOfStates,Edges,NonEmptyHash);
		        return 1;
                    }
#endif
#if ( defined (REACHABILITY ) && ! defined ( STUBBORN ) ) 
for(i=0;i<Places[0]->cnt;i++)
{
	 if(Places[i]->current_marking != Places[i]->target_marking)
		 break;
}
if(i >= Places[0]->cnt) // target_marking found!
{
		// early abortion  
	      cout << "\nstate found!\n";
		  printstate();
		print_path(NewState);
	statistics(NumberOfStates,Edges,NonEmptyHash);
	 return 1; 
}
#endif

	            CurrentState->firelist[CurrentState -> current]->backfire();
		    CurrentState->current++;
	    }
	}
	else
        {
		// proceed forward to working layer
		if(CurrentState -> succ[CurrentState -> current])
		{	
			CurrentState -> firelist[CurrentState -> current]->fire();
			CurrentState = CurrentState->succ[CurrentState->current];
			CurrentState -> min = false;
			CurrentState -> current = 0;
			d++;
		}
		else
		{
			(CurrentState -> current)++;
		}
	}
      }
      else
	{
	  // close state and return to previous state
		// new state closed
	  if(CurrentState -> min)
	  {
		  CurrentState = CurrentState -> parent;
                  if(CurrentState) CurrentState -> min = true;
	  }
	  else
	  {
		  CurrentState = CurrentState -> parent;  
	          if(CurrentState) CurrentState -> succ[CurrentState -> current] = (State *) 0;
	  }
	  
	  d--;
	  if(CurrentState)
	    {
	      CurrentState -> firelist[CurrentState -> current] -> backfire();
	      CurrentState -> current ++;
	    }
	  else
	    {
		if(initial->min)
		{
		limit++;
		d = 1;
		CurrentState = initial;
		CurrentState -> current = 0;
		initial-> min = false;
		}
            }
	}
	}
	statistics(NumberOfStates,Edges,NonEmptyHash);
	return 0;
}
	  
void RemoveGraph()
{
	int i;

	for(i=0;i<HASHSIZE;i++)
	{
		if(HashTable[i]) delete HashTable[i];
		HashTable[i] = (Decision *) 0;
	}
}

#ifdef STUBBORN
bool mutual_reach()
{
  unsigned int i;
  unsigned int NumberOfStates;
  State * NewState;
  // init initial marking and hash table
  Trace = new SearchTrace [CardStore];
  RemoveGraph();
  NumberOfStates = 1;
  NonEmptyHash = 0;
  if(search_marking())
  {
	cerr << " Wat soll dat denn?";
  }
  CurrentState = insert_marking();
  CurrentState -> current = 0;
  Edges = 0;
  CurrentState -> firelist = stubbornfirelistreach();

  if(!CurrentState -> firelist )
	{
		// early abortion  
  statistics(NumberOfStates,Edges,NonEmptyHash);
		return true;
    }
  CurrentState -> parent = (State *) 0;
  CurrentState -> succ = new State * [CardFireList];
  
  // process marking until returning from initial state
  
  while(CurrentState)
    {
      if(CurrentState -> firelist[CurrentState -> current])
	{
	  // there is a next state that needs to be explored
	  Edges ++;
	      if(!(Edges % REPORTFREQUENCY)) 
              cerr << "st: " << NumberOfStates << "     edg: " << Edges << "\n";
	  CurrentState -> firelist[CurrentState -> current] -> fire();
	  if(NewState = 
#ifdef SYMMETRY
SYMMPROC()
#else
search_marking()
#endif
)
	    {
		  // State exists!
	      CurrentState -> firelist[CurrentState -> current] -> backfire();
	      CurrentState -> succ[CurrentState -> current] = NewState;
	      (CurrentState -> current) ++;
	    }
	  else
	    {
	      NewState = 
#if ( defined ( SYMMETRY ) )  && ( SYMMINTEGRATION > 2 )
kr_insert_marking();
#else
insert_marking();
#endif
	      NewState -> current = 0;
	      NewState -> firelist = stubbornfirelistreach();
	      NewState -> parent = CurrentState;
	      NewState -> succ =  new State * [CardFireList];
	      CurrentState -> succ[CurrentState -> current] = NewState;
  if(!NewState -> firelist )
	{
		// early abortion  
  statistics(NumberOfStates,Edges,NonEmptyHash);
		return true;
    }
	      CurrentState = NewState;
	    }
	}
      else
	{
	  // close state and return to previous state
	  CurrentState = CurrentState -> parent;
	  if(CurrentState)
	    {
	      CurrentState -> firelist[CurrentState -> current] -> backfire();
	      CurrentState -> current ++;
	    }
	}
    }
  statistics(NumberOfStates,Edges,NonEmptyHash);
  return false;
}

#endif

#ifdef REVERSIBILITY
int reversibility()
{
	unsigned int i;
	for(i=0;i<Places[0]->cnt;i++)
	{
		Places[i]->initial_marking = Places[i] -> current_marking;
	}
	// Compute representitives of all TSCC 
	depth_first();
	//Check whether initial marking is reachable
	for(;TSCCRepresentitives;TSCCRepresentitives = TSCCRepresentitives->prev)
	{
		// 1. initialize start and target markings
		for(i=0;i < Places[0]->cnt;i++)
		{	
			Places[i]->target_marking = Places[i]->initial_marking;
			Places[i]->set_marking((*TSCCRepresentitives)[i]);
		}
		for(i=0;i<Transitions[0]->cnt;i++)
		{
			Transitions[i]->check_enabled();
		}
		if(!mutual_reach())
		{
			cout << "\nnot reversible: no return to m0 from reported state\n\n";
			printstate();
			return 1;
		}
	}
	cout << "\n net is reversible!\n";
	return(0);
}
#endif

#ifdef HOME

int home()
{
	unsigned int i;
	Statevector * New, * Old, * Candidate;

	// Compute representitives of all TSCC 
	depth_first();
	Candidate = TSCCRepresentitives;
	if(!Candidate)
	{
		cout << "serious internal error, maybe memory overflow?\n";
		_exit( 2);
	}
	New = Candidate -> prev;
	Old = (Statevector *) 0;

	// First loop creates candidate for home property
	while(New)
	{
		// 1. initialize start and target markings
		for(i=0;i < Places[0]->cnt;i++)
		{	
			Places[i]->target_marking = (*Candidate)[i];
			Places[i]->set_marking((*New)[i]);
		}
		for(i=0;i<Transitions[0]->cnt;i++)
		{
			Transitions[i]->check_enabled();
		}
		if(!mutual_reach())
		{
			Candidate -> prev = Old;
			Old = Candidate;
			Candidate = New;
		}
		New = New -> prev;
	}
	while(Old)
	{
		// 1. initialize start and target markings
		for(i=0;i < Places[0]->cnt;i++)
		{	
			Places[i]->target_marking = (*Candidate)[i];
			Places[i]->set_marking((*Old)[i]);
		}
		for(i=0;i<Transitions[0]->cnt;i++)
		{
			Transitions[i]->check_enabled();
		}
		if(!mutual_reach())
		{
			cout << "\nnet does not have home markings!\n\n";
			return 1;
		}
		Old = Old -> prev;
	}
	cout << "\n\n home marking found (reported state)\n\n";
	for(i=0;i<Places[0]->cnt;i++)
	{
		Places[i]->set_marking((*Candidate)[i]);
	}
	printstate();
	return(0);
}
		
#endif

#endif


/*
 * Code for TJ algorithms begins here
 */

/*
 * The current permutation and a temporary permutation needed sometimes
 */
static unsigned int *perm = 0;
static unsigned int *temp_perm = 0;

/*
 * TJ_perm_index stores the information of how the current permutation
 *  is produced i.e. the indexes of selected left transversal permutations
 * TJ_best_perm_index is the TJ_perm_index of the (first) permutation producing
 *  the lex-least marking found so far
 */
static int *TJ_perm_index = 0;
static int *TJ_best_perm_index = 0;

/*
 * This tells to which level to backtrack (backjump)
 */
static int TJ_backtrack_to_level = 0;

/*
 * Statistics information
 */
static unsigned int TJ_stats_aut_gens;
static unsigned int TJ_stats_dead_nodes;
static unsigned int TJ_stats_canrep_updates;

static void TJ_permute(const int level, const int current)
{
  /*
   * permute  h_{1} * ... * h_{l-1} to h_{1} * ... * h_{l-1} * h_{l,c}
   * perm(x) = (h_{1}(... (h_{l-1}(x))...) ->
   * perm'(x) = perm(h_{l,c}(x)) ->
   * perm'(x) = (h_{1} * ... * h_{l-1} * h_{l,c})(x)
   */

  int i;

  {
    /* // Code for
       for(i = Store[level].argnr; i < Places[0]->cnt; i++) {
       TJ_DEBUG_ASSERT(vector[i-Store[level].argnr] >= Store[level].argnr);
       TJ_DEBUG_ASSERT(vector[i-Store[level].argnr] < Places[0]->cnt);
       temp_perm[i] =
         perm[Store[level].image[current].vector[i-Store[level].argnr]];
       }
    */
    
    register unsigned int * vec =
      Store[level].image[current].vector;
    register unsigned int *temp_permp = temp_perm + Store[level].argnr;
    for(i = Places[0]->cnt - Store[level].argnr; i > 0;) {
      TJ_DEBUG_ASSERT(*vec >= Store[level].argnr);
      TJ_DEBUG_ASSERT(*vec < Places[0]->cnt);
      i--;
      *temp_permp = perm[*vec];
      vec++;
      temp_permp++;
    }
  }
  {
    /* // Code for
       for(i = Store[level].argnr; i < Places[0]->cnt; i++)
         perm[i] = temp_perm[i];
    */
    register unsigned int *permp = perm + Store[level].argnr;
    register unsigned int *temp_permp = temp_perm + Store[level].argnr;
    for(i = Places[0]->cnt - Store[level].argnr; i > 0; ) {
      register unsigned int temp = *temp_permp;
      i--;
      temp_permp++;
      *permp = temp;
      permp++;
    }
  }
}

static void TJ_unpermute(const int level, const int current)
{
  int i;
  /*
   * unpermute  h_{1} * ... * h_{l-1} * h_{l,c} back to h_{1} * ... * h_{l-1}
   * perm(x) = (h_{1}(... (h_{l-1}(h_{l,c}(x)))...) ->
   * perm'(h_{l,c}(x)) = perm(x) ->
   * perm'(x) = (h_{1} * ... * h_{l-1})(x)
   */
  {
    /* Code for:
     * for(i = Store[level].argnr; i < Places[0]->cnt; i++)
     *   temp_perm[Store[level].image[current].vector[i-Store[level].argnr]] = perm[i];
    */
    register unsigned int *vec =
      Store[level].image[current].vector;
    register unsigned int *permp = perm + Store[level].argnr;
    for(i = Places[0]->cnt - Store[level].argnr; i > 0; ) {
      TJ_DEBUG_ASSERT(*vec >= Store[level].argnr);
      TJ_DEBUG_ASSERT(*vec < Places[0]->cnt);
      i--;
      temp_perm[*vec] = *permp;
      vec++;
      permp++;
    }
  }
  {
    /* Code for:
     * for(i = Store[level].argnr; i < Places[0]->cnt; i++)
     *   perm[i] = temp_perm[i];
    */
    register unsigned int *permp = perm + Store[level].argnr;
    register unsigned int *temp_permp = temp_perm + Store[level].argnr;
    for(i = Places[0]->cnt - Store[level].argnr; i > 0; ) {
      register unsigned int temp = *temp_permp;
      i--;
      temp_permp++;
      *permp = temp;
      permp++;
    }
  }
}

static void TJ_set_kanrep()
{
  int i;
  /* Code for:
   * for(i = 0; i < Places[0]->cnt; i++)
   *   kanrep[i] = Places[perm[i]]->current_marking;
   */
  register unsigned int *kanrepp = kanrep;
  register unsigned int *permp = perm;
  for(i = Places[0]->cnt; i > 0; ) {
    i--;
    *kanrepp = Places[*permp]->current_marking;
    permp++;
    kanrepp++;
  }
}

#define TJ_MSSELECTOR
//#define TJ_MIN_MSSELECTOR
//#define TJ_MAX_MSSELECTOR
//#define TJ_MIN_MINFREQ_MSSELECTOR
#define TJ_MAX_MINFREQ_MSSELECTOR

/*
 * A temp array for the maxminfreq multi-set selector
 */
unsigned int *TJ_minfreq_msselector_array = 0;

/*
 * The place valuation array
 */
unsigned int *TJ_pval = 0;

#if defined(TJ_DEAD_NODE_LIMIT)
static bool TJ_dead_node_exit;
#endif


#if defined(SYMMETRY) && (SYMMINTEGRATION == 7 || SYMMINTEGRATION == 8)

/*
 * An auxiliary function used by the function below
 */
static void TJ_orbit_search(const unsigned int place,
			    const unsigned int first_place,
			    int *first_in_orbit) {
  if(first_in_orbit[place] >= 0) {
    assert((unsigned int)first_in_orbit[place] == first_place);
    return;
  }
  first_in_orbit[place] = first_place;
  for(unsigned int level = 0; level < CardStore; level++) {
    if(Store[level].argnr > place)
      continue;
    for(unsigned int permno = 0; permno < Store[level].card; permno++) {
      TJ_orbit_search(Store[level].image[permno].vector[place -  Store[level].argnr], first_place, first_in_orbit);
    }
  }
}
/*
 * Find orbit representatives for places
 */
static int *TJ_first_in_orbits() {
  int *first_in_orbit = (int*)malloc(Places[0]->cnt * sizeof(int));

  for(unsigned int i = 0; i < Places[0]->cnt; i++)
    first_in_orbit[i] = -1;

  for(unsigned int i = 0; i < Places[0]->cnt; i++) {
    if(first_in_orbit[i] >= 0) {
      TJ_DEBUG_ASSERT((unsigned int)first_in_orbit[i] < i);
      continue;
    }
    TJ_orbit_search(i, i, first_in_orbit);
  }

  return first_in_orbit;
}
#endif


#if defined(SYMMETRY) && (SYMMINTEGRATION == 7)
/*
 * Partition refinement algorithms for the partition guided Schreier-Sims
 * search
 */

bool TJ_partition_initialized = false;
TJ_Partition TJ_p;

int *TJ_first_in_orbit = 0;
static unsigned int TJ_presetsize_invariant(unsigned int i) {
  if(i < Places[0]->cnt)
    return Places[i]->NrOfArriving;
  return Transitions[i - Places[0]->cnt]->NrOfArriving;
}
static unsigned int TJ_postsetsize_invariant(unsigned int i) {
  if(i < Places[0]->cnt)
    return Places[i]->NrOfLeaving;
  return Transitions[i - Places[0]->cnt]->NrOfLeaving;
}
static unsigned int TJ_orbit_num_invariant(unsigned int i) {
  if(i < Places[0]->cnt)
    return (unsigned int)TJ_first_in_orbit[i];
  return Places[0]->cnt;
}
static unsigned int TJ_marking_invariant(unsigned int i) {
  if(i < Places[0]->cnt)
    return Places[i]->current_marking;
  return 0;
}


static void TJ_initialize_partition() {
  unsigned int i;
  assert(!TJ_partition_initialized);
  TJ_partition_initialized = true;
  
  /*
   * Number places and transitions
   */
  for(i = 0; i < Places[0]->cnt; i++)
    Places[i]->nr = i;
  for(i = 0; i < Transitions[0]->cnt; i++)
    Transitions[i]->nr = i;

  TJ_p.init();
  
  /*
   * Initialize the partition according to the orbits
   */
  assert(TJ_first_in_orbit == 0);
  TJ_first_in_orbit = TJ_first_in_orbits();
  /* Print orbits...
  for(i = 0; i < Places[0]->cnt; i++) {
    if(TJ_first_in_orbit[i] == i) {
      cerr << "{";
      for(int j = i; j < Places[0]->cnt; j++) {
	if(TJ_first_in_orbit[j] == i)
	  cerr << Places[j]->name << ",";
      }
      cerr << "} ";
    }
  }
  */
  TJ_p.refine(&TJ_orbit_num_invariant);
  //TJ_p.print(stderr); fprintf(stderr, "\n");
  free(TJ_first_in_orbit); TJ_first_in_orbit = 0;

 
  /*
   * Refine the partition according to the partition independent weighted
   * pre- and postset invariants
   */
  
  TJ_p.refine(&TJ_presetsize_invariant);
  TJ_p.refine(&TJ_postsetsize_invariant);
  TJ_p.refine_to_equitable2();
  for(CellEntry *cell = TJ_p.first_cell; cell; cell = cell->next)
    cell->initial = true;
  //TJ_p.print(stderr); fprintf(stderr, "\n");
}

static void TJ_compute_partition() {
  unsigned int i;

  /*
   * Undo to the initial partition
   */
  CellEntry *cell = TJ_p.first_cell;
  while(cell) {
    assert(cell->initial);
    assert(cell->splitted == false);
    if(cell->next && !cell->next->initial) {
      for(unsigned int e = cell->next->first;
	  e < cell->next->first + cell->next->length;
	  e++) {
	TJ_p.elements[e]->TJ_in_cell = cell;
      }
      cell->length += cell->next->length;
      CellEntry * const next_alive = cell->next->next;
      cell->next->next = TJ_p.free_cells;
      TJ_p.free_cells = cell->next;
      cell->next = next_alive;
    }
    else {
      cell = cell->next;
    }
  }
  //TJ_p.refine(&TJ_marking_invariant);
  //TJ_p.refine_to_equitable2();
  TJ_p.refine_according_to_marking();
  //TJ_p.print(stderr); fprintf(stderr, "\n");

  cell = TJ_p.first_cell;
  unsigned int cell_no = 0;
  while(cell->first < Places[0]->cnt) {
    Node **np = TJ_p.elements + cell->first;
    for(i = cell->length; i > 0; i--) {
      TJ_pval[(*np)->nr] = cell_no;
      np++;
    }
    cell = cell->next;
    cell_no++;
  }
  //for(i = 0; i < Places[0]->cnt; i++)
  //  TJ_pval[i] = Places[i]->current_marking;
}

#endif

/*
 * Recursive search in the Schreier-Sims representation
 */
bool TJ_pr_search(bool smaller_than_previous_best, int fixed_up_to, int level)
{
  int i;
  int reprno;
  bool canrep_updated = false;
  bool canrep_updated_in_child = false;

  if(level == (int)CardStore) {
    /*
     * permutation complete, update kanrep if necessary
     */
    if(smaller_than_previous_best) {
      /*
       * Permuted marking is better than the previously found lex-least marking
       * Update kanrep
       */
#if defined(TJ_DEBUG)
      /* check correctness of smaller_than_previous_best variable */
      for(i = 0; i < (int)Places[0]->cnt; i++) {
	assert(Places[perm[i]]->current_marking <= kanrep[i]);
	if(Places[perm[i]]->current_marking < kanrep[i])
	  break;
      }
      assert(i < (int)Places[0]->cnt);
#endif
      TJ_set_kanrep();
      TJ_stats_aut_gens = 1;
      TJ_stats_canrep_updates++;
      for(i = 0; i < (int)CardStore; i++)
	TJ_best_perm_index[i] = TJ_perm_index[i];
      TJ_backtrack_to_level = level - 1;
      return true;
    }
    /*
     * Permuted marking is equal to the previously found lex-least marking
     */
    assert(!smaller_than_previous_best);
#if defined(TJ_DEBUG)
    /* check correctness of smaller_than_previous_best variable */
    for(i = 0; i < (int)Places[0]->cnt; i++)
      assert(Places[perm[i]]->current_marking == kanrep[i]);
#endif
    TJ_stats_aut_gens++;
    /* find level to which to backjump */
    for(i = 0; i < (int)CardStore; i++)
      if(TJ_best_perm_index[i] != TJ_perm_index[i])
	break;
    assert(i < level);
    TJ_backtrack_to_level = i;
    return false;
  }

  assert(fixed_up_to == (int)Store[level].argnr - 1);

#if defined(TJ_DEBUG)
  /* save the current perm for sanity checking */
  unsigned int *debug_perm =
    (unsigned int*)malloc(Places[0]->cnt * sizeof(unsigned int));
  for(i = 0; i < (int)Places[0]->cnt; i++)
    debug_perm[i] = perm[i];
#endif


  /*
   * Apply the multi-set selector 
   */
#if defined(TJ_MSSELECTOR)
  unsigned int selected_pval = UINT_MAX;

#if defined(TJ_MIN_MSSELECTOR)
  /*
   * Minimal element multi-set selector
   */
  selected_pval = TJ_pval[perm[Store[level].argnr]];
  for(reprno = 0; reprno < (int)Store[level].card; reprno++) {
    if(TJ_pval[perm[Store[level].image[reprno].vector[0]]] < selected_pval)
      selected_pval = TJ_pval[perm[Store[level].image[reprno].vector[0]]];
  }
#elif defined(TJ_MAX_MSSELECTOR)
  /*
   * Maximal element multi-set selector
   */
  selected_pval = TJ_pval[perm[Store[level].argnr]];
  for(reprno = 0; reprno < (int)Store[level].card; reprno++) {
    if(TJ_pval[perm[Store[level].image[reprno].vector[0]]] > selected_pval)
      selected_pval = TJ_pval[perm[Store[level].image[reprno].vector[0]]];
  }
#elif defined(TJ_MIN_MINFREQ_MSSELECTOR) || defined(TJ_MAX_MINFREQ_MSSELECTOR)
  /*
   * Minimal/maximal element with minimal frequency multi-set selector
   */
  if(!TJ_minfreq_msselector_array)
    TJ_minfreq_msselector_array =
      (unsigned int*)malloc((Places[0]->cnt + 1) * sizeof(unsigned int));
  int minfreq_index = 0;
  TJ_DEBUG_ASSERT(TJ_pval[perm[Store[level].argnr]] != UINT_MAX);
  TJ_minfreq_msselector_array[minfreq_index++] =
    TJ_pval[perm[Store[level].argnr]];
  for(reprno = 0; reprno < (int)Store[level].card; reprno++) {
    TJ_DEBUG_ASSERT(TJ_pval[perm[Store[level].image[reprno].vector[0]]] !=
		    UINT_MAX);
    TJ_minfreq_msselector_array[minfreq_index++] =
      TJ_pval[perm[Store[level].image[reprno].vector[0]]];
  }
  TJ_minfreq_msselector_array[minfreq_index] = UINT_MAX;
  /*
   * sort TJ_minfreq_msselector_array (inefficient!)
   */
  for(i = 0; i < minfreq_index; i++) {
    unsigned int smallest = UINT_MAX;
    int smallest_index = i;
    for(int j = i; j < minfreq_index; j++){
      if(TJ_minfreq_msselector_array[j] < smallest) {
        smallest = TJ_minfreq_msselector_array[j];
	smallest_index = j;
      }
    }
    assert(smallest < UINT_MAX);
   TJ_minfreq_msselector_array[smallest_index] =
      TJ_minfreq_msselector_array[i];
    TJ_minfreq_msselector_array[i] = smallest;
  }
  /* select minimal/maximal pval with minimal frequency */
  {
    unsigned int *ap = TJ_minfreq_msselector_array;
    unsigned int smallest_freq = UINT_MAX;
    while(*ap != UINT_MAX) {
      unsigned int pval = *ap;
      unsigned int freq = 0;
      while(*ap == pval) {
	freq++;
	ap++;
      }
#if defined(TJ_MIN_MINFREQ_MSSELECTOR)
      if(freq < smallest_freq)
#elif defined(TJ_MAX_MINFREQ_MSSELECTOR)
      if(freq <= smallest_freq)
#else
#error "should not happen"
#endif
      {
	smallest_freq = freq;
	selected_pval = pval;
      }
    }
  }
  TJ_DEBUG_ASSERT(selected_pval != UINT_MAX);
#else

#error "no multi-set selector instance defined"

#endif

#endif


  bool smaller_than_previous_best2;
  bool prefix_check_failed;
  const int new_fixed_up_to =
    (level+1==(int)CardStore)?Places[0]->cnt:Store[level+1].argnr;

  /*
   * Backtracking search on the remaining subgroups
   */
  for(reprno = -1; reprno < (int)Store[level].card; reprno++) {
    
    smaller_than_previous_best2 = smaller_than_previous_best;
    prefix_check_failed = false;

#ifdef TJ_MSSELECTOR
    /*
     * compare to the pval selected by the multi-set selector
     */
    if(reprno >= 0) {
      if(TJ_pval[perm[Store[level].image[reprno].vector[0]]] != selected_pval)
	goto next_representative_perm;
    } else {
      /* implicitly represented identity permutation */
      if(TJ_pval[perm[Store[level].argnr]] != selected_pval)
	goto  next_representative_perm;
    }
#endif

    if(!smaller_than_previous_best) {
      /* Peep ahead */
      if(reprno >= 0) {
	if(Places[perm[Store[level].image[reprno].vector[0]]]->current_marking
	   > kanrep[Store[level].argnr]) {
	  goto next_representative_perm;
	}
      }
      else {
	if(Places[perm[Store[level].argnr]]->current_marking >
	   kanrep[Store[level].argnr]) {
	  goto next_representative_perm;
	}
      }
    }

    /* reprno == -1 => implicitly presented identity permutation */
    if(reprno >= 0) {
      /* permute perm = h_1*...*h_{l-1} to h_1*...*h_{l-1}*h_{l,c} */
      TJ_permute(level, reprno);
    }


    if(!smaller_than_previous_best) {
#ifdef TJ_UNOPTIMIZED
      for(i = fixed_up_to + 1; i < new_fixed_up_to; i++) {
	if(Places[perm[i]]->current_marking > kanrep[i]) {
	  TJ_stats_dead_nodes++;
#if defined(TJ_DEAD_NODE_LIMIT)
#if !(TJ_DEAD_NODE_LIMIT > 0)
#error "illegal dead node limit"
#endif
	  if(TJ_stats_dead_nodes >= TJ_DEAD_NODE_LIMIT) {
	    TJ_dead_node_exit = true;
	    return false;
	  }
#endif
	  prefix_check_failed = true;
	  goto unperm;
	}
	if(Places[perm[i]]->current_marking < kanrep[i]) {
	  smaller_than_previous_best2 = true;
	  break;
	}
      }
#else
      register unsigned int *kanrepp = kanrep + fixed_up_to + 1;
      register unsigned int *permp = perm + fixed_up_to + 1;
      for(i = new_fixed_up_to - (fixed_up_to + 1); i > 0; ) {
	i--;
	if(Places[*permp]->current_marking > *kanrepp) {
	  TJ_stats_dead_nodes++;
#if defined(TJ_DEAD_NODE_LIMIT)
#if !(TJ_DEAD_NODE_LIMIT > 0)
#error "illegal dead node limit"
#endif
	  if(TJ_stats_dead_nodes >= TJ_DEAD_NODE_LIMIT) {
	    TJ_dead_node_exit = true;
	    return false;
	  }
#endif
	  prefix_check_failed = true;
	  goto unperm;
	}
	if(Places[*permp]->current_marking < *kanrepp) {
	  smaller_than_previous_best2 = true;
	  break;
	}
	permp++;
	kanrepp++;
      }
#endif
    }

    TJ_perm_index[level] = reprno;

    canrep_updated_in_child =
      TJ_pr_search(smaller_than_previous_best2, new_fixed_up_to-1, level+1);

#if defined(TJ_DEAD_NODE_LIMIT)
    if(TJ_dead_node_exit)
      return false;
#endif

    if(canrep_updated_in_child) {
      canrep_updated = true;
      smaller_than_previous_best = false;
    }

  unperm:
    /* reprno == -1 => the implicitly presented identity permutation */
    if(reprno >= 0) {
      /* unpermute perm=h_1*...*h_{l-1}*h_{l,c} back to h_1*...*h_{l-1} */
      TJ_unpermute(level, reprno);
    }

    if(prefix_check_failed == false) {
      /*
       * The left coset was actually searched
       */
      assert(TJ_backtrack_to_level <= level);
      if(TJ_backtrack_to_level < level) {
	assert(canrep_updated == false);
	return false;
      }
    }
  next_representative_perm:
    ;
#if defined(TJ_DEBUG)
    /* check sanity of perm and unperm */
    for(i = 0; i < (int)Places[0]->cnt; i++)
      assert(debug_perm[i] == perm[i]);
#endif
  }

#if defined(TJ_DEBUG)
  free(debug_perm);
#endif

  TJ_backtrack_to_level = level - 1;

  //cerr << "B" << backtrack_to_level << "<-" << level << " ";

  return canrep_updated;
}



State *TJ_pr_canonical_representative()
{
  unsigned int i;

  TJ_stats_nof_canonizer_called++;

  if(CardStore == 0 || Places[0]->cnt + Transitions[0]->cnt <= 1) {
    /*
     * No symmetries!
     */

    /* Set kanrep to the current marking */
    for(i = 0; i < Places[0]->cnt; i++)
      kanrep[i] = Places[i]->current_marking;
    
    return kr_search_marking();
  }
    
  /* Reset kanrep to max */
  for(i = 0; i < Places[0]->cnt; i++)
    kanrep[i] = UINT_MAX;

  /* Allocate perm if not already allocated */
  if(!perm)
    perm = new unsigned int[Places[0]->cnt];
  
  /* reset perm to id */
  for(i = 0; i < Places[0]->cnt; i++)
    perm[i] = i;
  
  /* Allocate temp_perm if not already allocated */
  if(!temp_perm)
    temp_perm = new unsigned int[Places[0]->cnt];

  /* Allocate TJ_best_perm_index if not already allocated */
  if(!TJ_best_perm_index)
    TJ_best_perm_index = new int[CardStore];
  
  /* Allocate TJ_perm_index if not already allocated */
  if(!TJ_perm_index)
    TJ_perm_index = new int[CardStore];

  /* Allocate the place valuation array if not already allocated */
  if(!TJ_pval)
    TJ_pval = (unsigned int*)malloc(Places[0]->cnt * sizeof(unsigned int));

#if SYMMINTEGRATION == 6
  /*
   * Place valuation is the current marking
   */
  for(i = 0; i < Places[0]->cnt; i++)
    TJ_pval[i] = Places[i]->current_marking;

#elif SYMMINTEGRATION == 7
  /*
   * Initialize partition stuff
   */
  if(!TJ_partition_initialized)
    TJ_initialize_partition();
  /*
   * Compute partition and place valuation TJ_pval
   */
  TJ_compute_partition();

#else
  assert(false);
#endif

  /* Reset statistics info */
  TJ_stats_dead_nodes = 0;
  TJ_stats_canrep_updates = 0;
#if defined(TJ_DEAD_NODE_LIMIT)
  TJ_dead_node_exit = false;
#endif

  /*
   * Search the representative marking with respect to the place valuation
   */
  TJ_pr_search(true, Store[0].argnr - 1, 0);

#if defined(TJ_DEAD_NODE_LIMIT)
  TJ_DEBUG_ASSERT(TJ_stats_dead_nodes <= TJ_DEAD_NODE_LIMIT);
  assert(TJ_stats_canrep_updates > 0);
#endif

  /*
   * Update statistics
   */
  if(TJ_stats_dead_nodes_max < TJ_stats_dead_nodes)
    TJ_stats_dead_nodes_max = TJ_stats_dead_nodes;
  TJ_stats_dead_nodes_sum += TJ_stats_dead_nodes;
#if (SYMMINTEGRATION == 6)
  if(TJ_stats_canrep_updates == 1 && TJ_stats_dead_nodes == 0) {
    if(TJ_stats_aut_gens == 1)
      TJ_stats_trivial++;
    else
      TJ_stats_easy++;
  }
#endif
#if (SYMMINTEGRATION == 7)
  if(TJ_p.is_discrete())
    TJ_stats_trivial++;
  else if(TJ_stats_canrep_updates == 1 && TJ_stats_dead_nodes == 0)
    TJ_stats_easy++;
#endif

  /*
  cerr << "representative marking: ";
  for(i = 0; i < Places[0]->cnt; i++)
    cerr << Places[i]->name << ":" << kanrep[i] << " ";
  cerr << "\n";
  */

  //if(TJ_stats_dead_nodes > 0)
  //  cerr << "Aut gens:" << TJ_stats_aut_gens
  // << ",dead:" << TJ_stats_dead_nodes
  // << ",cupdates:" << TJ_stats_canrep_updates << "\n";

  return kr_search_marking();
}


void TJ_optimize_base()
{
  unsigned int pnum;
  int level;
  unsigned int permno;

  cerr << "Old base is\n";
  cerr << "Level -1:";
  for(pnum = 0; pnum < Store[0].argnr; pnum++)
      cerr << Places[pnum]->name << " ";
  cerr << "\n";
  for(level = 0; level < (int)CardStore; level++) {
    cerr << "Level " << level << ":";
    for(pnum = Store[level].argnr;
	pnum < ((level < (int)CardStore-1)?Store[level+1].argnr:Places[0]->cnt);
	pnum++)
      cerr << Places[pnum]->name << " ";
    cerr << "\n";
  }
  cerr << "\n";

  int *last_permuting_level = new int[Places[0]->cnt];
  for(pnum = 0; pnum < Places[0]->cnt; pnum++)
    last_permuting_level[pnum] = -1;
  
  for(level = CardStore - 1; level >= 0; level--) {
    for(permno = 0; permno < Store[level].card; permno++) {
      for(pnum = Store[level].argnr; pnum < Places[0]->cnt; pnum++) {
	if(last_permuting_level[pnum] != -1)
	  continue;
	if(Store[level].image[permno].vector[pnum-Store[level].argnr] != pnum)
	  last_permuting_level[pnum] = level;
      }
    }
  }
  /*
  for(pnum = 0; pnum < Places[0]->cnt; pnum++)
    cerr << "last perm level of " << Places[pnum]->name << " is " <<
      last_permuting_level[pnum] << "\n";
  */
  /* compute new base */
  int *new_base = new int[Places[0]->cnt];
  int *new_base_inv = new int[Places[0]->cnt];
  unsigned int base_index = 0;
  for(level = -1; level < (int)CardStore; level++) {
    for(pnum = 0; pnum < Places[0]->cnt; pnum++) {
      if(last_permuting_level[pnum] == level) {
	new_base[base_index] = pnum;
	new_base_inv[pnum] = base_index;
	base_index++;
      }
    }
  }
  assert(base_index == Places[0]->cnt);

  int *new_perm = new int[Places[0]->cnt];

  /* Modify the Schreier-Sims representation */
  pnum = 0;
  while(last_permuting_level[new_base[pnum]] == -1)
    pnum++;
  level = 0;
  while(level < (int)CardStore) {
    assert((int)Store[level].argnr == new_base[pnum]);
    assert(pnum >= Store[level].argnr);
    for(permno = 0; permno < Store[level].card; permno++) {
      for(unsigned int pnum2 = pnum; pnum2 < Places[0]->cnt; pnum2++) {
	assert(new_base[pnum2] >= (int)Store[level].argnr); 
	new_perm[pnum2 - pnum] =
	  new_base_inv[Store[level].image[permno].vector[new_base[pnum2] - Store[level].argnr]];
      }
       for(unsigned int pnum2 = pnum; pnum2 < Places[0]->cnt; pnum2++)
	 Store[level].image[permno].vector[pnum2-pnum] = new_perm[pnum2-pnum];
    }
    Store[level].argnr = pnum;
    while(pnum < Places[0]->cnt &&
	  last_permuting_level[new_base[pnum]] == level)
      pnum++;
    level++;
  }

  delete new_perm;

  Place **new_places = new Place*[Places[0]->cnt];
  for(pnum = 0; pnum < Places[0]->cnt; pnum++)
    new_places[pnum] = Places[new_base[pnum]];
  for(pnum = 0; pnum < Places[0]->cnt; pnum++)
    Places[pnum] = new_places[pnum];
  delete new_places;

  delete new_base;
  delete new_base_inv;
  delete last_permuting_level;
    
  cerr << "New base is\n";
  cerr << "Level -1:";
  for(pnum = 0; pnum < Store[0].argnr; pnum++)
      cerr << Places[pnum]->name << " ";
  cerr << "\n";
  for(level = 0; level < (int)CardStore; level++) {
    cerr << "Level " << level << ":";
    for(pnum = Store[level].argnr;
	pnum < ((level < (int)CardStore-1)?Store[level+1].argnr:Places[0]->cnt);
	pnum++)
      cerr << Places[pnum]->name << " ";
    cerr << "\n";
  }
  cerr << "\n";
}


#if defined(SYMMETRY) && (SYMMINTEGRATION == 8)

DYNALLSTAT(nvector,TJ_lab,TJ_lab_sz);
DYNALLSTAT(nvector,TJ_ptn,TJ_ptn_sz);
DYNALLSTAT(graph,TJ_graph,TJ_graph_sz);
DYNALLSTAT(graph,TJ_cgraph,TJ_cgraph_sz);
DYNALLSTAT(nvector,TJ_orbits,TJ_orbits_sz);
DYNALLSTAT(setword,TJ_workspace,TJ_workspace_sz);

static bool TJ_nauty_initialized = false;
static int TJ_graph_size, TJ_graph_words;
static int *TJ_place_orbits = 0, TJ_nof_place_orbits = 0;

static void TJ_init_nauty() {
  int i, p, a;
  int vnum;
  int current_multiplicity;
  set *gv;

  /*
   * Compute the size of the graph
   */
  TJ_graph_size = Places[0]->cnt;
  TJ_graph_size += Transitions[0]->cnt;
  for(i = 0; i < Places[0]->cnt; i++)
    TJ_graph_size += Places[i]->NrOfArriving + Places[i]->NrOfLeaving;
  TJ_graph_words = ((TJ_graph_size + WORDSIZE - 1) / WORDSIZE);

  /*
   * Allocate nauty structures
   */
  DYNALLOC1(nvector,TJ_lab,TJ_lab_sz,TJ_graph_size,"kuukkeli");
  DYNALLOC1(nvector,TJ_ptn,TJ_ptn_sz,TJ_graph_size,"kuukkeli");
  DYNALLOC1(nvector,TJ_orbits,TJ_orbits_sz,TJ_graph_size,"kuukkeli");
  DYNALLOC1(setword,TJ_workspace,TJ_workspace_sz,50*TJ_graph_words,"kuukkeli");
  DYNALLOC2(graph,TJ_graph,TJ_graph_sz,TJ_graph_size,TJ_graph_words,"kuukkeli");
  DYNALLOC2(graph,TJ_cgraph,TJ_cgraph_sz,TJ_graph_size,TJ_graph_words,"kuukkeli");

  /* Number transitions */
  for(i = 0; i < Transitions[0]->cnt; i++)
    Transitions[i]->nr = i;

  /*
   * Make nauty graph
   */
  /* Initialize labeling */
  for(i = 0; i < TJ_graph_size; i++)
    TJ_lab[i] = i;
  /* Initialize partition */
  vnum = 0;
  for(i = 0; i < Places[0]->cnt - 1; i++)
    TJ_ptn[vnum++] = INFINITY;
  TJ_ptn[vnum++] = 0;
  for(i = 0; i < Transitions[0]->cnt - 1; i++)
    TJ_ptn[vnum++] = INFINITY;
  TJ_ptn[vnum++] = 0;

  assert(TJ_ptn[Places[0]->cnt - 1] == 0);
  assert(TJ_ptn[Places[0]->cnt + Transitions[0]->cnt - 1] == 0);

  /* Make edges in the nauty graph */
  current_multiplicity = 0;
  while(true) {
    int next_multiplicity = INT_MAX;
    for(p = 0; p < Places[0]->cnt; p++) {
      for(a = 0; a < Places[p]->NrOfLeaving; a++) {
	if(Places[p]->LeavingArcs[a]->Multiplicity > current_multiplicity &&
	   Places[p]->LeavingArcs[a]->Multiplicity < next_multiplicity)
	  next_multiplicity = Places[p]->LeavingArcs[a]->Multiplicity;
      }
    }
    if(next_multiplicity == INT_MAX)
      break;
    current_multiplicity = next_multiplicity;
    for(p = 0; p < Places[0]->cnt; p++) {
      for(a = 0; a < Places[p]->NrOfLeaving; a++) {
	if(Places[p]->LeavingArcs[a]->Multiplicity != current_multiplicity)
	  continue;
	TJ_ptn[vnum] = Places[p]->LeavingArcs[a]->Multiplicity;
	Transition *dest_trans = Places[p]->LeavingArcs[a]->tr;
	gv = GRAPHROW(TJ_graph,p,TJ_graph_words);
	ADDELEMENT(gv,vnum);
	gv = GRAPHROW(TJ_graph,vnum,TJ_graph_words);
	ADDELEMENT(gv,p);
	gv = GRAPHROW(TJ_graph,vnum,TJ_graph_words);
	ADDELEMENT(gv,Places[0]->cnt + dest_trans->nr);
	gv = GRAPHROW(TJ_graph,Places[0]->cnt + dest_trans->nr,TJ_graph_words);
	ADDELEMENT(gv,vnum);
	vnum++;
      }
    }
  }
  int last_leaving = vnum;
  /* Sort leaving arcs according to their multiplicities (in TJ_ptn) */
  for(i = Places[0]->cnt + Transitions[0]->cnt; i < last_leaving; i++){
    int smallest = INT_MAX;
    int smallest_index = i;
    for(int j = i; j < last_leaving; j++){
      if(TJ_ptn[j] < smallest) {
        smallest = TJ_ptn[j];
	smallest_index = j;
      }
    }
    assert(smallest < INT_MAX);
    TJ_ptn[smallest_index] = TJ_ptn[i];
    TJ_ptn[i] = smallest;
    int temp = TJ_lab[i];
    TJ_lab[i] = TJ_lab[smallest_index];
    TJ_lab[smallest_index] = temp;
  }
  /* Partition leaving arcs with different multiplicities
     into different cells */
  i = Places[0]->cnt + Transitions[0]->cnt;
  int w = TJ_ptn[i];
  while(i < last_leaving - 1) {
    if(TJ_ptn[i+1] != w) {
      w = TJ_ptn[i+1];
      TJ_ptn[i] = 0;
    } else
      TJ_ptn[i] = INFINITY;
    i++;
  }
  TJ_ptn[last_leaving-1] = 0;


  current_multiplicity = 0;
  while(true) {
    int next_multiplicity = INT_MAX;
    for(p = 0; p < Places[0]->cnt; p++) {
      for(a = 0; a < Places[p]->NrOfArriving; a++) {
	if(Places[p]->ArrivingArcs[a]->Multiplicity > current_multiplicity &&
	   Places[p]->ArrivingArcs[a]->Multiplicity < next_multiplicity)
	  next_multiplicity = Places[p]->ArrivingArcs[a]->Multiplicity;
      }
    }
    if(next_multiplicity == INT_MAX)
      break;
    current_multiplicity = next_multiplicity;
    for(p = 0; p < Places[0]->cnt; p++) {
      for(a = 0; a < Places[p]->NrOfArriving; a++) {
	if(Places[p]->ArrivingArcs[a]->Multiplicity != current_multiplicity)
	  continue;
	TJ_ptn[vnum] = Places[p]->ArrivingArcs[a]->Multiplicity;
	Transition *dest_trans = Places[p]->ArrivingArcs[a]->tr;
	gv = GRAPHROW(TJ_graph,Places[0]->cnt + dest_trans->nr,TJ_graph_words);
	ADDELEMENT(gv,vnum);
	gv = GRAPHROW(TJ_graph,vnum,TJ_graph_words);
	ADDELEMENT(gv,Places[0]->cnt + dest_trans->nr);
	gv = GRAPHROW(TJ_graph,vnum,TJ_graph_words);
	ADDELEMENT(gv,p);
	gv = GRAPHROW(TJ_graph,p,TJ_graph_words);
	ADDELEMENT(gv,vnum);
	vnum++;
      }
    }
  }
  int last_arriving = vnum;
  assert(last_arriving == TJ_graph_size);
  /* Sort arriving arcs according to their multiplicities (in TJ_ptn) */
  for(i = last_leaving; i < last_arriving; i++){
    int smallest = INT_MAX;
    int smallest_index = i;
    for(int j = i; j < last_arriving; j++){
      if(TJ_ptn[j] < smallest) {
        smallest = TJ_ptn[j];
	smallest_index = j;
      }
    }
    assert(smallest < INT_MAX);
    TJ_ptn[smallest_index] = TJ_ptn[i];
    TJ_ptn[i] = smallest;
    int temp = TJ_lab[i];
    TJ_lab[i] = TJ_lab[smallest_index];
    TJ_lab[smallest_index] = temp;
  }
  /* Partition arriving arcs with different multiplicities
     into different cells */
  i = last_leaving;
  w = TJ_ptn[i];
  while(i < last_arriving - 1) {
    if(TJ_ptn[i+1] != w) {
      w = TJ_ptn[i+1];
      TJ_ptn[i] = 0;
    } else
      TJ_ptn[i] = INFINITY;
    i++;
  }
  TJ_ptn[last_arriving-1] = 0;


  int *first_in_orbits = TJ_first_in_orbits();
  TJ_place_orbits = (int*)malloc(Places[0]->cnt * 2 * sizeof(int));
  TJ_nof_place_orbits = 0;
  int index = 0;
  for(i = 0; i < Places[0]->cnt; i++) {
    assert(first_in_orbits[i] <= i);
    if(first_in_orbits[i] < i)
      continue;
    TJ_nof_place_orbits++;
    for(int j = i; j < Places[0]->cnt; j++) {
      if(first_in_orbits[j] == i)
	TJ_place_orbits[index++] = j;
    }
    TJ_place_orbits[index++] = -1;
  }
  free(first_in_orbits);
}

static void print_cg() {
  FILE *fp = fopen("debug_cg.dot", "w");
  fprintf(fp, "digraph muu {\n");
  set *gv;
  for(int i = 0; i < TJ_graph_size; i++) {
    if(i < Places[0]->cnt)
      fprintf(fp, "v%d [shape=ellipse];\n",i);
    else if(i < Places[0]->cnt + Transitions[0]->cnt)
      fprintf(fp, "v%d [shape=box];\n",i);
    else
      fprintf(fp, "v%d [shape=diamond];\n",i);
    gv = GRAPHROW(TJ_graph,i,TJ_graph_words);
    for(int j = i; j < TJ_graph_size; j++) {
      if(ISELEMENT(gv,j))
        fprintf(fp, "\"v%d\" -> \"v%d\" [dir=none];\n", i,j);
    }
  }
  fprintf(fp, "}\n");
  fclose(fp);
}

State *TJ_nauty_canonical_representative()
{
  int level, gen, i;

  static DEFAULTOPTIONS(options);
  statsblk(stats);

  if(CardStore == 0) {
    /*
     * No symmetries!
     */

    /* Set kanrep to the current marking */
    for(i = 0; i < Places[0]->cnt; i++)
      kanrep[i] = Places[i]->current_marking;
    
    return kr_search_marking();
  }
    
  /* Initialize graph if not already done that */
  if(!TJ_nauty_initialized) {
    TJ_init_nauty();
    TJ_nauty_initialized = true;
    //print_cg();
  }

  /*
   * Initial nauty partition
   */
  assert(TJ_place_orbits);
  assert(TJ_nof_place_orbits >= 1);
  int orbit_num = 0;
  int index = 0;
  int *orbit_ptr = TJ_place_orbits;
  while(orbit_num < TJ_nof_place_orbits) {
    int start_index = index;
    while(*orbit_ptr != -1) {
      TJ_lab[index] = *orbit_ptr;
      TJ_ptn[index] = Places[*orbit_ptr]->current_marking;
      orbit_ptr++;
      index++;
    }
    /* sort */
    for(i = start_index; i < index; i++){
      int smallest = INT_MAX;
      int smallest_index = i;
      for(int j = i; j < index; j++){
	if(TJ_ptn[j] < smallest) {
	  smallest = TJ_ptn[j];
	  smallest_index = j;
	}
      }
      assert(smallest < INT_MAX);
      TJ_ptn[smallest_index] = TJ_ptn[i];
      TJ_ptn[i] = smallest;
      int temp = TJ_lab[i];
      TJ_lab[i] = TJ_lab[smallest_index];
      TJ_lab[smallest_index] = temp;
    }
    /* make cell */
    i = start_index;
    int w = TJ_ptn[i];
    while(i < index - 1) {
      if(TJ_ptn[i+1] != w) {
	w = TJ_ptn[i+1];
	TJ_ptn[i] = 0;
      } else
	TJ_ptn[i] = INFINITY;
      i++;
    }
    TJ_ptn[index - 1] = 0;
    /* progress */
    orbit_ptr++;
    orbit_num++;
  }
  assert(index == Places[0]->cnt);
  assert(TJ_ptn[Places[0]->cnt - 1] == 0);
#ifdef IGNORE
  /*
   * Initial nauty partition
   */
  for(i = 0; i < Places[0]->cnt; i++)
    TJ_lab[i] = i;
  for(i = 0; i < Places[0]->cnt; i++)
    TJ_ptn[i] = Places[i]->current_marking;
  for(i = 0; i < Places[0]->cnt; i++){
    int smallest = INT_MAX;
    int smallest_index = i;
    for(int j = i; j < Places[0]->cnt; j++){
      if(TJ_ptn[j] < smallest) {
        smallest = TJ_ptn[j];
	smallest_index = j;
      }
    }
    assert(smallest < INT_MAX);
    TJ_ptn[smallest_index] = TJ_ptn[i];
    TJ_ptn[i] = smallest;
    int temp = TJ_lab[i];
    TJ_lab[i] = TJ_lab[smallest_index];
    TJ_lab[smallest_index] = temp;
  }
  i = 0;
  int w = TJ_ptn[i];
  while(i < Places[0]->cnt - 1) {
    if(TJ_ptn[i+1] != w) {
      w = TJ_ptn[i+1];
      TJ_ptn[i] = 0;
    } else
      TJ_ptn[i] = INFINITY;
    i++;
  }
  TJ_ptn[Places[0]->cnt - 1] = 0;
#endif

  /*
   * Run nauty
   */
  //cerr << TJ_graph_size << " ";
  options.getcanon = TRUE;
  options.defaultptn = FALSE;
  options.writeautoms = FALSE;
  options.writemarkers = FALSE;
  nauty(TJ_graph,TJ_lab,TJ_ptn,NILSET,TJ_orbits,&options,&stats,
	TJ_workspace,50*TJ_graph_words,TJ_graph_words,TJ_graph_size,TJ_cgraph);
  /*
  cout << "auts=" << stats.grpsize1
       << ", nodes=" << stats.numnodes
       << ", depth=" << stats.maxlevel
       << ", canupdates=" << stats.canupdates
       << ", bad=" << stats.numbadleaves << "\n";
  */
  /*
  fprintf(stderr, "(%f %d %d bad=%d) ",
	  stats.grpsize1, stats.numnodes, stats.maxlevel, stats.numbadleaves);
  */

  /*
   * Update statistics
   */
  TJ_stats_nof_canonizer_called++;
  if(stats.numnodes == 1) {
    TJ_stats_trivial++;
  } else {
    if(stats.numnodes > TJ_nauty_search_tree_max)
      TJ_nauty_search_tree_max = stats.numnodes;
    TJ_nauty_search_tree_sum += stats.numnodes;
  }
  
  /* use kanrep[i] to denote the cell number of the place i */
  for(i = 0; i < Places[0]->cnt; i++) {
    assert(TJ_lab[i] >= 0);
    assert(TJ_lab[i] < Places[0]->cnt);
    kanrep[TJ_lab[i]] = i;
  }

  /* Allocate perm if not already allocated */
  if(!perm)
    perm = new unsigned int[Places[0]->cnt];

  /* Allocate temp_perm if not already allocated */
  if(!temp_perm)
    temp_perm = new unsigned int[Places[0]->cnt];

  /* Reset perm to id */
  for(i = 0; i < Places[0]->cnt; i++)
    perm[i] = i;

  /* Select permutation */
  for(level = 0; level < CardStore; level++) {
    int smallest_cell = kanrep[perm[Store[level].argnr]];
    int best_gen = -1; // -1 == the implicit identity perm
    for(gen = 0; gen < Store[level].card; gen++) {
      if(kanrep[perm[Store[level].image[gen].vector[0]]] < smallest_cell) {
	smallest_cell = kanrep[perm[Store[level].image[gen].vector[0]]];
	best_gen = gen;
      }
    }
    if(best_gen >= 0)
      TJ_permute(level, best_gen);
  }

  /* Make kanrep */
  TJ_set_kanrep();

  /*
  for(i = 0; i < Places[0]->cnt; i++)
    cerr << perm[i] << " ";
  cerr << "\n";
  */

  return kr_search_marking();
}

#endif /* Defined(SYMMETRY) && (SYMMINTEGRATION == 8) */
