#include <stdint.h>

#define CHARTYPE unsigned char
#define MAXPAT 51000
#define L 65536
#define L2 4096
#define W 64
#define Q 6

typedef uint64_t bv;

int tr[256], ts[256], tra[256], trb[256];
bv B[L];
uint16_t B1[L], B2[L];

CHARTYPE pattern[MAXPAT];
int patlen, a, b;

void
prep (const CHARTYPE * pat, register int m)
{
  int i, j, r, xx, y, k, x[6], tx[6], ix[6];
  bv ch;

  for (j = 0; j <= 255; ++j)
    tr[j] = 0;
  tr['a'] = 1;
  tr['c'] = 2;
  tr['g'] = 4;
  tr['t'] = 8;
  tr['r'] = 5;
  tr['y'] = 10;
  tr['s'] = 6;
  tr['w'] = 9;
  tr['k'] = 12;
  tr['m'] = 3;
  tr['b'] = 14;
  tr['d'] = 13;
  tr['h'] = 11;
  tr['v'] = 7;
  tr['n'] = 15;

  for (i = 0; i < 256; i++)
    tra[i] = 1;
  tra['a'] = 0;
  tra['c'] = 0;
  tra['g'] = 0;
  tra['t'] = 0;

  for (i = 0; i < 256; i++)
    trb[i] = 0;
  trb['a'] = 0;
  trb['c'] = 1;
  trb['g'] = 2;
  trb['t'] = 3;

  for (i = 'a'; i < 'z'; ++i)
    for (j = 'a'; j < 'z'; ++j)
      B1[(j << 8) + i] = tra[i] + tra[j];

  for (i = 'a'; i < 'z'; ++i)   //(B[j]<<1)&B[i];
    for (j = 'a'; j < 'z'; ++j)
      B2[(j << 8) + i] = (trb[i] << 2) + trb[j];

  memcpy (pattern, pat, m);
  patlen = m;

  for (i = 0; i < L; i++)
    B[i] = 0;

  xx = 0;
  if (m <= 4096)
    xx = 1;
  a = (m - Q + 1 - xx) / W + xx;
  r = (m - Q + 1) / a;
  if (r > W)
    r = W;
  y = W - r;
  b = r * a;

  i = m - Q;
  while (i > m - b - Q)
    {
      for (j = 1; j <= a; j++)
        {

          for (k = 0; k < 6; k++)
            tx[k] = tr[pat[i + k]];

          for (ix[0] = 0; ix[0] < 4; ix[0]++)
            if (tx[0] & (1 << ix[0]))
              {
                x[0] = ix[0];
                for (ix[1] = 0; ix[1] < 4; ix[1]++)
                  if (tx[1] & (1 << ix[1]))
                    {
                      x[1] = ix[1];
                      for (ix[2] = 0; ix[2] < 4; ix[2]++)
                        if (tx[2] & (1 << ix[2]))
                          {
                            x[2] = ix[2];
                            for (ix[3] = 0; ix[3] < 4; ix[3]++)
                              if (tx[3] & (1 << ix[3]))
                                {
                                  x[3] = ix[3];
                                  for (ix[4] = 0; ix[4] < 4; ix[4]++)
                                    if (tx[4] & (1 << ix[4]))
                                      {
                                        x[4] = ix[4];
                                        for (ix[5] = 0; ix[5] < 4; ix[5]++)
                                          if (tx[5] & (1 << ix[5]))
                                            {
                                              x[5] = ix[5];
                                              ch = (((((((((x[0] << 2) +
                                                           x[1]) << 2) +
                                                         x[2]) << 2) +
                                                       x[3]) << 2) +
                                                     x[4]) << 2) + x[5];
                                              B[ch] |= (bv) 1 << y;
                                            }
                                      }
                                }
                          }
                    }
              }

          B[0] |= (bv) 1 << y;
          i--;
        }
      y++;
    }
}

int
exec (CHARTYPE * t, register int n)
{

  bv d, ch;
  int i, j, k, ki, m = patlen, count = 0;

  i = m - 1;
  t[n] = 0;

  while (i < n)
    {
      if (B1[*((uint16_t *) (t + i - 5))] +
          B1[*((uint16_t *) (t + i - 3))] + B1[*((uint16_t *) (t + i - 1))])
        d = B[0];
      else
        d = B[(B2[*((uint16_t *) (t + i - 5))] << 8) +
              (B2[*((uint16_t *) (t + i - 3))] << 4) +
              B2[*((uint16_t *) (t + i - 1))]];
      if (d == 0)
        i += b;
      else
        {
          j = i;
          do
            {
              i -= a;
              if (B1[*((uint16_t *) (t + i - 5))] +
                  B1[*((uint16_t *) (t + i - 3))] +
                  B1[*((uint16_t *) (t + i - 1))])
                d = (d << 1);
              else
                d = (d << 1) & B[(B2[*((uint16_t *) (t + i - 5))] << 8) +
                                 (B2[*((uint16_t *) (t + i - 3))] << 4) +
                                 B2[*((uint16_t *) (t + i - 1))]];
            }
          while (d);
          i += b;
          if (i == j)
            {
              for (k = 0; k < a; k++)
                {
                  ki = 0;
                  while (((tr[t[i + ki - m + 1 + k]] &
                           tr[pattern[ki]]) != 0) && (ki < m))
                    ki++;
                  if (ki == m)
                    count++;
                }
              i += a;
            }
        }
    }
  return count;
}
