#include "sm.h"
#include <stdint.h>

#define LIM 65536
#define W 64

typedef uint64_t bv;

bv B[ASIZE], d3[LIM];
int t[256];
int mm3, mm4, m0 = W;

void
prep (const CHARTYPE * pattern, register int m)
{
  int i, j, c;

  memcpy (pat.pat, pattern, m);
  pat.patlen = m;

  if (m < m0)
    m0 = m;
  mm3 = m0 - 5;
  mm4 = m0 - 6;
  memset (B, 0, ASIZE * sizeof (bv));

  for (j = 0; j <= 255; ++j)
    t[j] = 0;
  t['a'] = 1;
  t['c'] = 2;
  t['g'] = 4;
  t['t'] = 8;
  t['r'] = 5;
  t['y'] = 10;
  t['s'] = 6;
  t['w'] = 9;
  t['k'] = 12;
  t['m'] = 3;
  t['b'] = 14;
  t['d'] = 13;
  t['h'] = 11;
  t['v'] = 7;
  t['n'] = 15;

  for (i = 0; i < m0; ++i)
    {
      c = pattern[m0 - i - 1];

      if (c == 'a')
        {
          B['a'] |= ((bv) 1 << i);
        }
      if (c == 'c')
        {
          B['c'] |= ((bv) 1 << i);
        }
      if (c == 'g')
        {
          B['g'] |= ((bv) 1 << i);
        }
      if (c == 't')
        {
          B['t'] |= ((bv) 1 << i);
        }
      if (c == 'r')
        {
          B['a'] |= ((bv) 1 << i);
          B['g'] |= ((bv) 1 << i);
        }
      if (c == 'y')
        {
          B['c'] |= ((bv) 1 << i);
          B['t'] |= ((bv) 1 << i);
        }
      if (c == 's')
        {
          B['c'] |= ((bv) 1 << i);
          B['g'] |= ((bv) 1 << i);

        }
      if (c == 'w')
        {
          B['a'] |= ((bv) 1 << i);
          B['t'] |= ((bv) 1 << i);
        }
      if (c == 'k')
        {
          B['g'] |= ((bv) 1 << i);
          B['t'] |= ((bv) 1 << i);
        }
      if (c == 'm')
        {
          B['a'] |= ((bv) 1 << i);
          B['c'] |= ((bv) 1 << i);
        }
      if (c == 'b')
        {
          B['c'] |= ((bv) 1 << i);
          B['g'] |= ((bv) 1 << i);
          B['t'] |= ((bv) 1 << i);
        }
      if (c == 'd')
        {
          B['a'] |= ((bv) 1 << i);
          B['g'] |= ((bv) 1 << i);
          B['t'] |= ((bv) 1 << i);
        }
      if (c == 'h')
        {
          B['a'] |= ((bv) 1 << i);

          B['c'] |= ((bv) 1 << i);
          B['t'] |= ((bv) 1 << i);
        }
      if (c == 'v')
        {
          B['a'] |= ((bv) 1 << i);
          B['c'] |= ((bv) 1 << i);
          B['g'] |= ((bv) 1 << i);
        }
      if (c == 'n')
        {
          B['a'] |= ((bv) 1 << i);
          B['c'] |= ((bv) 1 << i);
          B['g'] |= ((bv) 1 << i);
          B['t'] |= ((bv) 1 << i);
        }
    }

  B['r'] = B['a'] | B['g'];
  B['y'] = B['c'] | B['t'];
  B['s'] = B['c'] | B['g'];
  B['w'] = B['a'] | B['t'];
  B['k'] = B['g'] | B['t'];
  B['m'] = B['a'] | B['c'];
  B['b'] = B['c'] | B['g'] | B['t'];
  B['d'] = B['a'] | B['g'] | B['t'];
  B['h'] = B['a'] | B['c'] | B['t'];
  B['v'] = B['a'] | B['c'] | B['g'];
  B['n'] = B['a'] | B['c'] | B['g'] | B['t'];

  for (i = 0; i < LIM; ++i)
    d3[i] = 0;

  for (i = 'a'; i < 'z'; ++i)
    for (j = 'a'; j < 'z'; ++j)
      d3[(j << 8) + i] = (B[j] << 1) & B[i];
}

int
exec (CHARTYPE * y, register int n)
{

  register CHARTYPE *s, *pos, *e;
  bv d;
  int i, j, nmatch = 0, m = pat.patlen;
  j = pat.patlen - 1;
  e = y + n - 1;
  s = y + j - 1;
  memcpy (y + n, pat.pat, pat.patlen);

  while (1)
    {

      d = (d3[*((uint16_t *) (s))] << 4) &
        (d3[*((uint16_t *) (s - 2))] << 2) & d3[*((uint16_t *) (s - 4))];

      while (d == 0)
        {
          s += mm3;
          d = (d3[*((uint16_t *) (s))] << 4) &
            (d3[*((uint16_t *) (s - 2))] << 2) & d3[*((uint16_t *) (s - 4))];
        }

      pos = s;
      while (d = (d << 1) & B[*(s - 5)])
        --s;

      s += mm4;

      if (s == pos)
        {
          if (s >= e)
            return (nmatch);
          if (m <= W)
            nmatch++;
          else
            {
              i = W;
              while (((t[*(s + i - W + 2)] & t[pat.pat[i]]) != 0) && (i < m))
                i++;
              if (i == m)
                nmatch++;
            }
          ++s;
        }
    }
}
