#include <stdint.h>
#define CHARTYPE unsigned char
#define bv uint64_t
#define W 64
#define MAXPAT 51000

CHARTYPE x[MAXPAT];
int patlen;

unsigned short SIGMA = 256;
bv B[256], D, s;
int tr[256];
int i, j, last, count, p_len, k;

void
prep (const CHARTYPE * pat, register int m)
{
  memcpy (x, pat, m);

  p_len = m;
  if (m > W)
    m = W;
  patlen = m;

  /* Preprocessing */
  memset (B, 0, SIGMA * sizeof (int));
  s = (bv) 1;
  for (i = m - 1; i >= 0; i--)
    {
      B[x[i]] |= (bv) s;

      switch (x[i])
        {
        case 'a':

          B['r'] |= (bv) s;
          B['w'] |= (bv) s;
          B['m'] |= (bv) s;
          B['d'] |= (bv) s;
          B['h'] |= (bv) s;
          B['v'] |= (bv) s;
          B['n'] |= (bv) s;
          break;

        case 'c':

          B['y'] |= (bv) s;
          B['s'] |= (bv) s;
          B['m'] |= (bv) s;
          B['b'] |= (bv) s;
          B['h'] |= (bv) s;
          B['v'] |= (bv) s;
          B['n'] |= (bv) s;
          break;

        case 'g':

          B['r'] |= (bv) s;
          B['s'] |= (bv) s;
          B['k'] |= (bv) s;
          B['b'] |= (bv) s;
          B['d'] |= (bv) s;
          B['v'] |= (bv) s;
          B['n'] |= (bv) s;
          break;

        case 't':

          B['y'] |= (bv) s;
          B['w'] |= (bv) s;
          B['k'] |= (bv) s;
          B['b'] |= (bv) s;
          B['d'] |= (bv) s;
          B['h'] |= (bv) s;
          B['n'] |= (bv) s;
          break;

        case 'r':

          B['a'] |= (bv) s;
          B['g'] |= (bv) s;
          B['w'] |= (bv) s;
          B['m'] |= (bv) s;
          B['d'] |= (bv) s;
          B['h'] |= (bv) s;
          B['v'] |= (bv) s;
          B['n'] |= (bv) s;
          B['s'] |= (bv) s;
          B['k'] |= (bv) s;
          B['b'] |= (bv) s;
          break;

        case 'y':

          B['c'] |= (bv) s;
          B['t'] |= (bv) s;
          B['b'] |= (bv) s;
          B['h'] |= (bv) s;
          B['n'] |= (bv) s;
          B['s'] |= (bv) s;
          B['m'] |= (bv) s;
          B['v'] |= (bv) s;
          B['w'] |= (bv) s;
          B['k'] |= (bv) s;
          B['d'] |= (bv) s;
          break;

        case 's':

          B['c'] |= (bv) s;
          B['g'] |= (bv) s;
          B['b'] |= (bv) s;
          B['v'] |= (bv) s;
          B['n'] |= (bv) s;
          B['y'] |= (bv) s;
          B['m'] |= (bv) s;
          B['h'] |= (bv) s;
          B['r'] |= (bv) s;
          B['k'] |= (bv) s;
          B['d'] |= (bv) s;
          break;

        case 'w':

          B['a'] |= (bv) s;
          B['t'] |= (bv) s;
          B['d'] |= (bv) s;
          B['h'] |= (bv) s;
          B['n'] |= (bv) s;
          B['r'] |= (bv) s;
          B['w'] |= (bv) s;
          B['m'] |= (bv) s;
          B['v'] |= (bv) s;
          B['y'] |= (bv) s;
          B['k'] |= (bv) s;
          B['b'] |= (bv) s;

          break;

        case 'k':

          B['g'] |= (bv) s;
          B['t'] |= (bv) s;
          B['b'] |= (bv) s;
          B['d'] |= (bv) s;
          B['n'] |= (bv) s;
          B['y'] |= (bv) s;
          B['w'] |= (bv) s;
          B['h'] |= (bv) s;
          B['y'] |= (bv) s;
          B['w'] |= (bv) s;
          B['h'] |= (bv) s;
          break;

        case 'm':

          B['a'] |= (bv) s;
          B['c'] |= (bv) s;
          B['h'] |= (bv) s;
          B['v'] |= (bv) s;
          B['n'] |= (bv) s;
          B['r'] |= (bv) s;
          B['w'] |= (bv) s;
          B['d'] |= (bv) s;
          B['y'] |= (bv) s;
          B['s'] |= (bv) s;
          B['b'] |= (bv) s;
          break;

        case 'b':

          B['c'] |= (bv) s;
          B['g'] |= (bv) s;
          B['t'] |= (bv) s;
          B['n'] |= (bv) s;
          B['y'] |= (bv) s;
          B['s'] |= (bv) s;
          B['m'] |= (bv) s;
          B['h'] |= (bv) s;
          B['v'] |= (bv) s;
          B['r'] |= (bv) s;
          B['k'] |= (bv) s;
          B['d'] |= (bv) s;
          B['w'] |= (bv) s;
          break;

        case 'd':

          B['a'] |= (bv) s;
          B['g'] |= (bv) s;
          B['t'] |= (bv) s;
          B['n'] |= (bv) s;
          B['y'] |= (bv) s;
          B['s'] |= (bv) s;
          B['m'] |= (bv) s;
          B['h'] |= (bv) s;
          B['v'] |= (bv) s;
          B['r'] |= (bv) s;
          B['k'] |= (bv) s;
          B['b'] |= (bv) s;
          B['w'] |= (bv) s;
          break;

        case 'h':

          B['a'] |= (bv) s;
          B['c'] |= (bv) s;
          B['t'] |= (bv) s;
          B['n'] |= (bv) s;
          B['y'] |= (bv) s;
          B['s'] |= (bv) s;
          B['m'] |= (bv) s;
          B['v'] |= (bv) s;
          B['r'] |= (bv) s;
          B['k'] |= (bv) s;
          B['b'] |= (bv) s;
          B['d'] |= (bv) s;
          B['w'] |= (bv) s;
          break;

        case 'v':

          B['a'] |= (bv) s;
          B['c'] |= (bv) s;
          B['g'] |= (bv) s;
          B['n'] |= (bv) s;
          B['y'] |= (bv) s;
          B['s'] |= (bv) s;
          B['m'] |= (bv) s;
          B['h'] |= (bv) s;
          B['r'] |= (bv) s;
          B['k'] |= (bv) s;
          B['b'] |= (bv) s;
          B['d'] |= (bv) s;
          B['w'] |= (bv) s;
          break;

        case 'n':

          B['a'] |= (bv) s;
          B['c'] |= (bv) s;
          B['g'] |= (bv) s;
          B['t'] |= (bv) s;
          B['y'] |= (bv) s;
          B['s'] |= (bv) s;
          B['m'] |= (bv) s;
          B['h'] |= (bv) s;
          B['v'] |= (bv) s;
          B['r'] |= (bv) s;
          B['k'] |= (bv) s;
          B['b'] |= (bv) s;
          B['d'] |= (bv) s;
          B['w'] |= (bv) s;
          break;
        }

      s <<= 1;
    }
  for (j = 0; j <= 255; ++j)
    tr[j] = 0;
  tr['a'] = 1;
  tr['c'] = 2;
  tr['g'] = 4;
  tr['t'] = 8;
  tr['r'] = 5;
  tr['y'] = 10;
  tr['s'] = 6;
  tr['w'] = 9;
  tr['k'] = 12;
  tr['m'] = 3;
  tr['b'] = 14;
  tr['d'] = 13;
  tr['h'] = 11;
  tr['v'] = 7;
  tr['n'] = 15;

}

int
exec (CHARTYPE * y, register int n)
{
  int m = patlen, count = 0;


  /* Searching */
  j = 0;
  count = 0;
  while (j <= n - m)
    {
      i = m - 1;
      last = m;
      D = ~((bv) 0);
      while ((i >= 0) && (D != 0))
        {
          D &= B[y[j + i]];
          i--;
          if (D != 0)
            {
              if (i >= 0)
                last = i + 1;
              else
                {
                  k = m;
                  while (k < p_len && ((tr[x[k]] & tr[y[j + k]]) != 0))
                    k++;
                  if (k == p_len)
                    count++;
                }
            }
          D <<= 1;
        }
      j += last;
    }
  return count;
}
